(function (global) {
    SystemJS.config({
        transpiler: 'plugin-babel',
        babelOptions: {
            es2015: true
        },
        paths: {
            // paths serve as alias
            'npm:': 'node_modules/'
        },
        packageConfigPaths: [
            './node_modules/*/package.json',
            "./node_modules/@mescius/*/package.json",
            "./node_modules/@babel/*/package.json",
            "./node_modules/@vue/*/package.json"
        ],
        map: {
            'vue': "npm:vue/dist/vue.esm-browser.js",
            'tiny-emitter': 'npm:tiny-emitter/index.js',
            'plugin-babel': 'npm:systemjs-plugin-babel/plugin-babel.js',
            "systemjs-babel-build": "npm:systemjs-plugin-babel/systemjs-babel-browser.js",
            '@mescius/spread-sheets': 'npm:@mescius/spread-sheets/index.js',
            '@mescius/spread-sheets-resources-ko': 'npm:@mescius/spread-sheets-resources-ko/index.js',
            '@mescius/spread-sheets-shapes': 'npm:@mescius/spread-sheets-shapes/index.js',
            '@mescius/spread-sheets-charts': 'npm:@mescius/spread-sheets-charts/index.js',
            '@mescius/spread-sheets-vue': 'npm:@mescius/spread-sheets-vue/index.js'

        },
        meta: {
            '*.css': { loader: 'systemjs-plugin-css' },
            '*.vue': { loader: "../plugin-vue/index.js" }
        }
    });
})(this);


