const { parse, compileScript, compileTemplate } = window.VueSFCCompiler
export function translate(load, opts) {
  return compile(load)
}

function compile(load) {
  const parsedSource = parse(load.source)
  parsedSource.descriptor.styles.forEach(item => {
    injectStyle(item.content)
  })
  const descriptor = parsedSource.descriptor;
  const script = compileScript(descriptor, { sourceMap: false, id: new Date().getTime().toString(), inlineTemplate: true })
  if (descriptor.scriptSetup) {
    return load.source = script.content;
  } else {
    const template = descriptor.template;
    const render = compileTemplate({ id: new Date().getTime().toString(), source: template.content, isProd: true, ssr: false })
    const result = `${script.content.replace("export default", "const __sfc__ = ")}
${render.code.replace("export function render", "function render")}
__sfc__.render = render
__sfc__.__file = "App.vue"
export default __sfc__`;
    return load.source = result
  }
}

function injectStyle(style) {
  var styleTag = document.createElement('style')
  styleTag.textContent = style
  document.head.appendChild(styleTag)
}
