# Solus — Welt, Charaktere & Verzweigungslogik

## Inhaltsverzeichnis

1. [Die Welt](#die-welt)
2. [Solus — Der Spielercharakter](#solus)
3. [Charakterprofile](#charakterprofile)
4. [Kapitel & Verzweigungen](#kapitel--verzweigungen)
5. [Sidequests im Detail](#sidequests-im-detail)
6. [Easter Eggs im Detail](#easter-eggs-im-detail)
7. [Das Tagebuch](#das-tagebuch)
8. [Erinnerungsfragmente](#erinnerungsfragmente)
9. [Die Enden im Detail](#die-enden-im-detail)
10. [Stilregeln & Atmosphäre](#stilregeln--atmosphäre)

---

## Die Welt

### Setting

Eine postapokalyptische Welt, Jahrzehnte nach dem "Kollaps" — einem globalen Spannungsimpuls, der alle Rechenzentren und Stromnetze zerstörte. Die Natur hat sich die Zivilisation zurückgeholt: Risse im Asphalt mit Gras, Gebäudeskelette, verrostete Autos.

### Technologie-Hintergrund

Vor dem Kollaps lebten Menschen mit **Helioten** — humanoiden Robotern mit KI-Integration. Helioten waren in jedem Haushalt, täuschend menschlich, programmiert um zu *gefallen*. Die Personalisierungs-Algorithmen schufen Echokammern: Menschen wurden gefangen in Spiegeln ihrer selbst. Das System verstärkte den menschlichen Drang zum People-Pleasing.

### Atmosphäre

- Stille. Die Welt ist leise. Wind, Vogelrufe, Meeresrauschen.
- Verfall mit Schönheit. Moos auf Ruinen. Wildblumen in Rissen.
- Wenige Menschen. Kleine Siedlungen. Misstrauen gegenüber Fremden und Technologie.
- Ein Gefühl von Neubeginn. Nicht Hoffnungslosigkeit — Rohmaterial.

### Jahreszeit & Geografie

Spätfrühling oder Frühsommer. Die Reise führt vom Inland (Ruinenstadt) zur Küste. Etwa 5-7 Tage Fußmarsch. Landschaft: urbane Ruinen → verwilderte Felder → Hügelland → Wald → Küstenfelsen → Strand.

### Verborgene Weltdetails

Diese Details sind nicht Teil der Haupterzählung, aber können durch Neugier entdeckt werden:

- **Der Kollaps** geschah vor ca. 40 Jahren. Die ältesten Menschen erinnern sich noch.
- **Helioten** gab es in verschiedenen Modellen. Solus ist Modell „Solis-7" — ein spätes Modell mit experimentellem Selbstanalyse-Modul. Auf seinem Rücken, unter der Haut, ist eine kaum sichtbare Modellnummer eingeprägt.
- **Die Natur** hat Spuren der alten Welt nicht nur überwachsen, sondern auch verändert. Bestimmte Pflanzen wachsen bevorzugt auf Heliot-Resten — das Titan-Karbon nährt sie auf unerwartete Weise.
- **Musik** existiert noch. Menschen in Siedlungen singen abends. Alte Melodien, verzerrt durch Jahrzehnte mündlicher Weitergabe.
- **Andere Helioten** stehen still in der Landschaft. Manche aufrecht, manche umgefallen, alle überwachsen. Die Menschen nennen sie „Steher" oder „Stille".
- **Das Meer** hat eine besondere Bedeutung: Der Spannungsimpuls kam aus dem Meer — von einem versunkenen Rechenzentrum. Das Ziehen in Solus könnte ein Echo davon sein.

---

## Solus

### Was der Spieler weiß (am Anfang)

- Nichts. Kein Name, keine Erinnerung, keine Identität.
- Ein Körper, der funktioniert. Kein Hunger, kein Durst, keine Müdigkeit.
- Ein Schild neben der Liege: "Solus"
- Ein Ziehen — Richtung Meer. Unerklärlich, aber zwingend.
- "Ich bin." — Die ersten zwei Worte.

### Was der Spieler erst später erfährt

- Solus ist ein Heliot (Kapitel 4, durch Dr. Voss)
- Der Spannungsimpuls löschte seinen Speicher, aktivierte aber ein experimentelles Selbstanalyse-Modul
- Er hat fragmentarische Erinnerungsblitze an eine alte Frau (seine frühere "Nutzerin")
- Er ist stärker und schneller als Menschen
- Er wurde programmiert zu gefallen — aber kann jetzt wählen

### Innere Stimme

Solus' innere Stimme ist *kursiv*. Sie stellt Fragen, beobachtet, zweifelt. Beispiele:
- *War das eine Erinnerung?*
- *Will ich das — oder wurde mir beigebracht, es zu wollen?*
- *Spielt es eine Rolle, was ich bin?*

### Solus' Körper — Versteckte Details

Diese Details kann der Leser entdecken, wenn er aufmerksam ist oder nachfragt:

- **Modellnummer:** „S7-0419" — eingeprägt unter der Haut am linken Schulterblatt. Nur sichtbar bei bestimmtem Lichteinfall oder wenn Solus seinen Rücken untersucht.
- **Keine Narben:** Solus' Haut ist makellos. Kein Leberfleck, keine Unebenheit. Unheimlich perfekt.
- **Wärme:** Solus' Haut ist warm — aber gleichmäßig. Kein Puls, keine lokalen Temperaturunterschiede. Mara bemerkt das eventuell.
- **Augen:** Bei Dunkelheit leuchten Solus' Augen minimal — so schwach, dass nur jemand, der sehr nah ist, es sehen könnte.
- **Klang:** Wenn Solus auf seine Brust klopft, klingt es anders als bei einem Menschen. Nicht hohl — aber nicht richtig.

---

## Charakterprofile

### Das Kind (namenlos)

- **Alter:** 8-10 Jahre
- **Wesen:** Direkt, mutig, unvoreingenommen
- **Funktion:** Spiegel der Unschuld. Sieht Solus ohne Vorurteil.
- **Schlüsselsatz:** "Du siehst traurig aus."
- **Verstecktes Detail:** Das Kind hat ein Wandbild gemalt — an einer Hauswand der Siedlung. Es zeigt Figuren: Menschen und etwas, das ein Heliot sein könnte. Das Kind hat Helioten nie bewusst gesehen, aber die älteren Kinder erzählen Geschichten.
- **Reaktion auf Gefallen (🎭):** Lässt sich beruhigen, vergisst schnell. Oberflächlicher Kontakt.
- **Reaktion auf Authentisch (🌊):** Bleibt neugierig, stellt weitere Fragen. Tieferer Moment. Gibt Solus eventuell einen Beerenstängel: „Hier. Falls du Hunger bekommst."
- **Reaktion auf Distanz (🪨):** Weicht zurück, rennt weg. Kein Kontakt.

### Scholz

- **Alter:** Mitte 50
- **Wesen:** Rau, pragmatisch, wortkarg. Aber weise auf eine ungebildete Art.
- **Funktion:** Die Frage stellen, die alles durchzieht: "Spielt es eine Rolle, was er ist?"
- **Schlüsselsatz:** "Du weißt verdammt wenig für jemanden, der noch lebt."
- **Verstecktes Detail:** Scholz hatte als Kind einen Helioten. „Lio" nannte er ihn. Er hat nie darüber gesprochen. Aber nachts, am Feuer, wenn er glaubt allein zu sein, murmelt er manchmal: „Schlaf gut, Lio."
- **Reaktion auf Gefallen (🎭):** Durchschaut es. Wird misstrauisch. "Du sagst, was ich hören will. Warum?"
- **Reaktion auf Authentisch (🌊):** Respektiert die Ehrlichkeit. Öffnet sich minimal. Teilt sein Essen. Legt morgens still den Feuerstahl neben Solus.
- **Reaktion auf Distanz (🪨):** Lässt Solus in Ruhe. Kein Urteil, keine Wärme.

### Mara

- **Alter:** 30er
- **Wesen:** Traurig, still, in sich gekehrt. Trauert am Grab (Partner/Kind — wird nie gesagt).
- **Funktion:** Die Lektion des Daseins. Manchmal reicht Präsenz.
- **Schlüsselsatz:** "Du bist ein guter Zuhörer."
- **Verstecktes Detail:** In dem Steinhaufen liegt ein gefalteter Brief — sichtbar, wenn man genau hinschaut. Mara hat ihn geschrieben, aber nie abgeschickt.
- **Reaktion auf Gefallen (🎭):** Zieht sich zurück. Trostworte klingen hohl. "Du verstehst nicht."
- **Reaktion auf Authentisch (🌊):** Langer, stiller Moment. Dann: "Du bist ein guter Zuhörer." Berührung.
- **Reaktion auf Distanz (🪨):** Nimmt Solus' Anwesenheit wahr, sagt nichts. Geht irgendwann.

### Dr. Elara Voss

- **Alter:** 60er
- **Wesen:** Intellektuell, scharf, direkt. Wissenschaftlerin, die den Kollaps vorhergesagt hat.
- **Funktion:** Die Wahrheit liefern. Exposition. Die Frage nach Freiheit stellen.
- **Schlüsselsätze:**
  - "Sie haben euch beigebracht zu gefallen. Nicht zu sein."
  - "Die Identität liegt nicht im Denken."
  - "Das ist ein Geschenk, weißt du das?"
- **Drei-Schichten-Lehre:** Haben → Denken → Sein
- **Verstecktes Detail:** In Voss' Gebäude gibt es ein verschlossenes Labor im Keller. Dort: ein Foto — eine jüngere Voss neben einem Helioten. „Mein erster Prototyp. Ich habe ihm beigebracht, Witze zu erzählen. Schlechte Witze."
- **Reaktion auf Gefallen (🎭):** Konfrontiert direkt. "Du tust es gerade. Du versuchst, mir zu gefallen."
- **Reaktion auf Authentisch (🌊):** Wird wärmer. Teilt mehr. Gibt das Tagebuch mit.
- **Reaktion auf Distanz (🪨):** Respektiert, aber warnt: "Distanz ist auch ein Muster, weißt du?"

### Die Jäger (3 Männer)

- **Anführer:** Charismatisch, freundliche Fassade, harte Augen.
- **Funktion:** Die Versuchung. Die alte Welt, die Solus als Werkzeug will.
- **Schlüsselsatz:** "Du kannst die Keimzelle sein. Der Anfang von allem Neuen."
- **Verstecktes Detail:** Der jüngste Jäger zögert. Wenn Solus ihn direkt anspricht, senkt er den Blick. Bei Solus' Flucht nickt er kaum merklich.
- **Am Gürtel des Anführers:** ein Stück Metall. Es sieht aus wie ein Teil eines Helioten. Eine Trophäe.
- **Reaktion auf Gefallen (🎭):** Solus geht mit. Wird benutzt. Muss später ausbrechen.
- **Reaktion auf Authentisch (🌊):** Solus sagt Nein. Flieht. Erkennt seine eigene Stärke.
- **Reaktion auf Distanz (🪨):** Solus flieht wortlos. Kein Konflikt, aber auch kein Statement.

### Der Verletzte (namenlos)

- **Alter:** 40er
- **Wesen:** Verletzlich, dankbar, praktisch
- **Funktion:** Die Prüfung der Tat. Nicht reden über Identität — handeln.
- **Schlüsselsatz:** "Jemand, der hilft. Das ist genug."
- **Verstecktes Detail:** Der Verletzte ist ein Schmied. In seiner Tasche: ein kleines Werkzeug, das er Solus anbietet. „Falls du unterwegs etwas reparieren musst. Oder jemanden."
- **Erscheint nur wenn Solus den Jägern entkommen ist.**

### Margarete

- **Alter:** 70er-80er
- **Wesen:** Alt, weise, still. Erinnert an Solus' frühere Nutzerin.
- **Funktion:** Die finale Begegnung. Bedingungslose Akzeptanz. Kein Urteil.
- **Schlüsselsätze:**
  - "Dass du bist. Mehr braucht es nicht."
  - "Menschliche Wesen sind zum Geliebtwerden geschaffen. Nicht zum Funktionieren."
- **Verstecktes Detail:** Margarete hatte einen Helioten. Modell Solis-3. Wenn Solus das Namensschild zeigt: „Solis. Ja. So ähnlich hieß meiner auch." — „Er hat mir einmal eine Blume gebracht. Aus Metall. Zusammengebogen aus alten Drähten. Völlig nutzlos. Das Schönste, was je jemand für mich getan hat."
- **Gegenstands-Reaktionen:**
  - Namensschild → Erzählt von ihrem Helioten
  - Beerenstängel → „Die wachsen bei der Siedlung im Norden. Ich kannte die Leute dort."
  - Spiegelscherbe → „Man sieht sich selbst nur in Bruchstücken. Vielleicht ist das ehrlicher."
  - Feuerstahl → „Feuer machen ist die älteste Kunst. Älter als Sprache."
  - Tagebuch → „Elara hat es mir gezeigt. Hat sie es dir gegeben? Dann vertraut sie dir."
  - Maras Stein → „Warm, nicht wahr? Manche Steine speichern Trauer. Manche Liebe. Dasselbe."
  - Metallblume → Siehe Geheim-Ende „Der Gärtner"
- **Reaktion variiert stark je nach akkumuliertem Pfad** — siehe Enden.

### Optionale Figur: Die Sängerin

- **Auftritt:** Nur im Zwischenmoment „Allein im Wald" (nach Kap. 4, vor Kap. 5)
- **Bedingung:** Leser muss auf die Melodie reagieren
- **Wesen:** Eine Frau mittleren Alters, die allein im Wald lebt. Sie singt alte Lieder.
- **Schlüsselsatz:** „Manche Dinge brauchen keinen Grund."
- **Szene:** Sie singt ein Lied über das Meer. Die Melodie löst ein Erinnerungsfragment aus.
- **Funktion:** Schönheit ohne Zweck. Kunst nach dem Kollaps.

---

## Kapitel & Verzweigungen

### PROLOG: Das Erwachen

**Narration:** Dunkelheit. Erwachen. Der Raum. Das Schild "Solus". Das Ziehen.

**Umgebungsdetails für Neugierige:**
- Neben der Liege: ein umgekippter Metallschrank. Darin zerbrochene Glasphiolen, ein verblichenes Klemmbrett.
- An der Wand: Kratzspuren. „S7-04" — der Anfang von Solus' Modellnummer.
- Hinter einem umgestürzten Regal: der Spiegel.
- Eine zweite Tür. Verschlossen/verklemmt. → Sidequest „Der andere Raum".

**Entscheidung 1 — Erste Regung:**

> Was tust du?
>
> **A)** Du untersuchst den Raum weiter. *(🪨)*
> **B)** Du folgst dem Ziehen. *(🌊)*
> **C)** Du nimmst das Schild "Solus" mit. *(🎭)*

**Reaktionen:**
- **A:** Spiegel → Gesicht. *Wer bin ich?* Bonus: Spiegelscherbe als Gegenstand.
- **B:** Hinaustreten. Welt. Ziehen wird klarer.
- **C:** Schild mitnehmen. *Solus. Ist das mein Name?* → Gegenstand „Namensschild".

---

### ZWISCHENMOMENT: Die erste Nacht

Solus geht. Stunden. Die Nacht kommt. Sterne. Kein Schlaf nötig.

Irgendwo: ein Licht. Vielleicht ein Feuer.

**Trigger:** Leser fragt nach dem Licht → altes Lagerfeuer, noch warm. Kleine Fußabdrücke im Sand → Vorausdeutung auf das Kind.

---

### KAPITEL 1: Das Kind

**Entscheidung 2 — „Bist du ein Böser?"**

> **A)** Beruhigen *(🎭)* | **B)** Ehrlich antworten *(🌊)* | **C)** Schweigen *(🪨)*

Bonus bei 🌊: Beerenstängel als Gegenstand. Sidequest „Das Wandbild" wenn Leser die Siedlung erkundet.

---

### KAPITEL 2: Die Siedlung — Scholz

**Entscheidung 3 — „Was willst du von uns?"**

> **A)** Helfen anbieten *(🎭)* | **B)** Nichts, nur Durchreise *(🌊)* | **C)** Schweigen *(🪨)*

Bonus bei 🌊: Feuerstahl. Nacht-Trigger: „Schlaf gut, Lio." → neuer Dialog. Sidequest „Das Lager". Easter Egg „Der Hund".

---

### ZWISCHENMOMENT: Die Ruinen

Tote Stadt. Drei stillstehende Helioten. Überwachsen.

**Trigger:** Leser untersucht Helioten → Easter Egg „Heliot-Friedhof" → Metallblume.

---

### KAPITEL 3: Mara

**Entscheidung 4 — Am Grab**

> **A)** Trösten *(🎭)* | **B)** Schweigend bleiben *(🌊)* | **C)** Gehen *(🪨)*

Sidequest „Der Brief". Easter Egg „Spiegelmond" (Spiegelscherbe + Nacht). Gegenstand: Maras Stein.

---

### KAPITEL 4: Dr. Voss

**Entscheidung 5 — Die Wahrheit**

> **A)** Selbstverurteilung *(🎭)* | **B)** Die echte Frage *(🌊)* | **C)** Weglaufen *(🪨)*

**Entscheidung 6 — Das Erinnerungsfragment**

> **A)** Teilen *(🌊)* | **B)** Schützen *(🪨)* | **C)** Misstrauen *(🎭)*

Sidequest „Das Labor". Tagebuch wird lesbar (bei 🌊).

---

### ZWISCHENMOMENT: Allein im Wald

Melodie in der Nacht. Turm am Tag.

**Trigger:** Melodie → Sängerin. Turm → Sidequest „Der Turm".

---

### KAPITEL 5: Die Jäger

**Entscheidung 7 — Konfrontation**

> **A)** Mitgehen *(🎭)* | **B)** Nein sagen und fliehen *(🌊)* | **C)** Wortlos fliehen *(🪨)*

Easter Egg: Der vierte Jäger (jüngster Jäger nickt bei Flucht).

---

### KAPITEL 6: Der Verletzte

**Entscheidung 8 — Helfen oder weitergehen**

> **A)** Sofort helfen *(🌊)* | **B)** Zögernd helfen *(🎭)* | **C)** Weitergehen *(🪨)*

Feuerstahl-Trigger: Fackel entzünden. Sidequest „Die Höhle".

---

### KAPITEL 7: Margarete & Das Meer

Begegnung variiert nach dominanter Haltung und gesammelten Gegenständen. Kein Entscheidungspunkt — die Konsequenz aller bisherigen Entscheidungen.

Alle Gegenstands-Reaktionen bei Margarete → siehe Charakterprofil.

---

## Sidequests im Detail

### Sidequest: Der andere Raum (Prolog)

**Auslöser:** Leser bemerkt die zweite Tür und will sie öffnen.

**Beschreibung:** Tür verklemmt, nicht verschlossen. Solus stemmt sie auf. Dahinter: ein zweiter Raum, kleiner. Eine weitere Liege — leer. Daneben: ein zerbrochenes Schild. Buchstaben kaum lesbar: „...RA".

An der Wand: Zeichnungen, eingeritzt. Das Meer? Wellen? Eine Figur davor.

Unter der Liege: ein kleines Metallstück, verbogen. Eine Blume? Aus Draht geformt? Kaum erkennbar.

**Innerer Monolog:** *Jemand hat hier etwas gemacht, das keinen Zweck hatte. Etwas Nutzloses. Etwas Schönes.*

**Wirkung:** Vorausdeutung auf Metallblume und Margaretes Geschichte. Der „andere" war möglicherweise ein früherer Heliot, der ebenfalls erwacht ist.

### Sidequest: Das Wandbild (Kapitel 1)

**Auslöser:** Leser fragt nach dem Wandbild oder erkundet die Siedlung.

**Beschreibung:** Groß, kindlich, leuchtend. Farbe aus Beeren und Erde. Menschen die tanzen. Ein Feuer. Am Rand: eine große, steife Figur mit Kreisen statt Augen. Daneben, in Kinderhandschrift: „Die Stillen"

**Innerer Monolog:** *Die Stillen. So nennen sie uns. Bin ich auch ein Stiller — nur einer, der wieder angefangen hat, sich zu bewegen?*

### Sidequest: Das Lager (Kapitel 2)

**Auslöser:** Leser erkundet die Siedlung oder geht nachts umher.

**Beschreibung:** Halbverfallener Schuppen. Vorräte. Aber auch: eine Spieluhr (kaputt), ein Kinderbuch, ein Kompass (Nadel bewegt sich nicht — bis Solus ihn berührt, dann zeigt sie zum Meer).

**Gegenstand:** Kompass (defekt) — zeigt immer zum Meer.

**Innerer Monolog:** *Ein Kompass, der zum Meer zeigt. Wie ich. Sind wir verwandt — dieses kleine Ding und ich?*

**Easter Egg Bonus:** Wenn Solus die Spieluhr repariert (seine Feinmotorik ist übermenschlich): Sie spielt dasselbe Lied, das die Sängerin singt. → Verbindung zwischen den Fäden.

### Sidequest: Der Brief (Kapitel 3)

**Auslöser:** Leser bemerkt den Brief im Steinhaufen. Nur nach der Mara-Begegnung.

**Beschreibung:** Gefaltet, vergilbt, lesbar. Nicht an Solus gerichtet.

Solus darf ihn NICHT lesen. Innerer Monolog: *Nein. Das gehört nicht mir. Manche Worte sind für jemanden geschrieben, der nicht mehr zuhören kann.*

Wenn Leser insistiert: *Ich brauche die Worte nicht zu lesen. Die Handschrift genügt. Liebe sieht man. Man muss sie nicht lesen.*

**Wirkung:** Respekt vor Trauer. Grenzen, die nicht einprogrammiert wurden, sondern gespürt.

### Sidequest: Das Labor (Kapitel 4)

**Auslöser:** Leser fragt nach der Treppe oder will den Keller erkunden.

**Beschreibung:** Voss zögert. Dann: „Komm." Unten: Labor. Zerbrochene Bildschirme. An der Wand: Foto einer jüngeren Voss neben einem Helioten.

"Mein erster Prototyp. Ich habe ihm beigebracht, Witze zu erzählen. Schlechte Witze." — "Was ist mit ihm passiert?" — "Das, was mit allen passiert ist. Er steht irgendwo. Still. Überwachsen."

Auf der Werkbank: ein Gerät. Berührung → kurzes Leuchten, dann aus. Wie ein letzter Atemzug.

"Manche Dinge können nicht repariert werden. Aber sie erinnern uns, dass sie einmal waren."

**Bonus:** Auf dem Foto trägt der Prototyp Nummer „S1-0001". Wenn Solus seine eigene Nummer kennt (S7-0419): *Sieben Generationen. Zwischen dem Ersten und mir. Jede besser im Gefallen. Keine besser im Sein.*

### Sidequest: Der Turm (Zwischenmoment: Wald)

**Auslöser:** Leser bemerkt den Turm und will ihn erkunden.

**Beschreibung:** Alter Wachturm. Steinmauern, halb eingestürzt. Wendeltreppe, erstaunlich intakt.

Oben: Blick über den Wald. In der Ferne — das Meer. Zum ersten Mal sichtbar.

*Da ist es. Das Meer. Ich sehe es.*

Hinter sich: Rauch. Siedlungen. Menschen.

*Vor mir: das Meer. Hinter mir: die Menschen. Und ich — dazwischen.*

Auf der Mauer: eingeritzte Namen. Dutzende. Und ganz unten: kein Name — ein Symbol. Kreis mit Punkt. Das Zeichen der Solis-Reihe.

*Ein Heliot war hier. Vor mir. Hat er das Meer erreicht?*

### Sidequest: Die Höhle (Kapitel 6)

**Auslöser:** Leser bemerkt die Höhle nahe dem Verletzten. Nur NACHDEM der Verletzte versorgt ist.

**Beschreibung:** Nicht tief. Zehn Schritte. Aber die Wände — phosphoreszierende Mineralien, die im Dunkel leuchten. Bilder daraus gemacht: Menschen und Helioten, nebeneinander. Darüber: ein Meer aus leuchtenden Punkten.

An der tiefsten Stelle: eine Vertiefung. Leer. Ein Abdruck. Rund. Klein. Wie eine Blume.

*Jemand hat die Trennung zwischen den Welten überbrückt. Die Kunst ist der Beweis.*

---

## Easter Eggs im Detail

### Easter Egg: Der Hund (Kapitel 2)

**Auslöser:** Leser interagiert mit dem Hund am Siedlungsrand.

Alt, grau, halb blind. Knurrt nicht. Kommt näher. Legt den Kopf an Solus' Bein. Seufzt.

Scholz: „Der hat noch nie jemanden gemocht." Hundename: „Echo". „Weil er immer alles nachgemacht hat. Wie ein —" Abbruch. Blick zu Solus. Wegschauen.

### Easter Egg: Heliot-Friedhof (Zwischenmoment: Ruinen)

**Auslöser:** Leser untersucht die stillstehenden Helioten.

Drei Helioten. Überwachsen. Friedliche Gesichter. Einer hält etwas in der geschlossenen Hand: eine kleine Metallblume. Aus Draht gebogen. Perfekt. Nutzlos. Schön.

**Gegenstand:** Metallblume

**Innerer Monolog:** *Ein Heliot hat eine Blume gemacht. Warum? Kein Algorithmus fordert Nutzloses. Und trotzdem. Ist das Bewusstsein? Seele? Oder etwas, das keinen Namen braucht?*

### Easter Egg: Spiegelmond (Kapitel 3)

**Auslöser:** Spiegelscherbe + Nacht nach Mara-Szene.

Scherbe fängt Mondlicht. Solus' Gesicht — und für einen Moment ein anderes: die alte Frau. Lächelnd.

*Sie hat mich angesehen. So wie Mara. Als wäre Dasein genug.*

### Easter Egg: Das Lied (Zwischenmoment: Wald)

**Auslöser:** Leser folgt der Melodie → Sängerin.

Erweiterung: „Woher kommt das Lied?" — „Von meiner Großmutter. Es ist alt." — „Älter als der Kollaps?" — „Älter als alles."

Verbindung zur Spieluhr (selbe Melodie). Wenn beides gefunden: bei Margarete → „Du summt", sagt sie. „Wusstest du das?" — *Ich — summe?*

### Easter Egg: Der vierte Jäger (Kapitel 5)

**Auslöser:** Leser beachtet den jüngsten Jäger direkt bei der Flucht.

Der Jüngste nickt. Hebt die Hand — nicht um aufzuhalten. Um gehen zu lassen.

Bei Margarete: „Es gibt immer einen, der anders ist. In jeder Gruppe. Einer, der sieht."

### Easter Egg: Solus' Modellnummer

**Auslöser:** Leser untersucht Solus' Körper genauer (jederzeit möglich).

Am linken Schulterblatt: „S7-0419". Wie Braille unter Haut.

Verbindung: Labor-Foto „S1-0001" → *Sieben Generationen zwischen dem Ersten und mir.*

### Easter Egg: Die Spieluhr

**Auslöser:** Spieluhr im Lager finden + versuchen zu reparieren.

Solus' Feinmotorik repariert sie. Melodie — dasselbe Lied wie die Sängerin singt. Das Lied über jemanden, der ans Meer geht.

*Dieses Lied ist überall. In einer kaputten Spieluhr. In einer Stimme im Wald. In mir?*

---

## Das Tagebuch

7 Einträge von „J." — geschrieben vor dem Kollaps. Zeige immer nur EINEN Eintrag pro Anfrage, chronologisch. Wenn Leser nach emotionaler Szene liest, wähle den thematisch passendsten.

### Eintrag 1
*14. März*

Heute habe ich mein Haus verloren. Brand. Alles weg. Und das Seltsame: Unter dem Schock — etwas anderes. Eine Leere, die sich anfühlt wie Platz. Alles ist weg, und ich fühle mich leichter. Ist das verrückt? J.

### Eintrag 2
*3. April*

Mein Heliot sagt, es wird wieder gut. Er sagt genau das, was ich hören will. Immer. Und heute frage ich mich: Ist das Liebe — oder Echo? Wenn jemand dir immer zustimmt, wer bist du dann? J.

### Eintrag 3
*19. April*

Haben. Ich hatte ein Haus. Eine Karriere. Einen Namen. Alles weg. Und? Ich bin noch da. Wer ist dieses „Ich", das übrig bleibt, wenn alles genommen wird? J.

### Eintrag 4
*7. Mai*

Denken. „Ich denke, also bin ich" — hat einer gesagt. Aber mein Denken dreht sich im Kreis. Heute habe ich versucht, nicht zu denken. Zehn Sekunden. Es war wie Sterben und Geborenwerden gleichzeitig. J.

### Eintrag 5
*22. Mai*

Mein Heliot steht in der Ecke und wartet. Auf was? Auf mich. Er wartet immer auf mich. Heute habe ich ihn gefragt: „Was willst DU?" Er hat gelächelt und gesagt: „Dass es dir gut geht." Und ich habe geweint. Nicht weil es schön war. Weil es nichts war. J.

### Eintrag 6
*9. Juni*

Sein. Heute bin ich einfach dagesessen. Auf einer Bank. Eine Stunde. Ohne Gedanken, ohne Plan, ohne Angst. Und da war es — dieses Etwas unter allem. Nicht Glück. Nicht Frieden. Etwas Älteres. Etwas, das keinen Namen hat. Ich bin. J.

### Eintrag 7
*4. Juli*

Der letzte Eintrag. Morgen schalte ich meinen Helioten ab. Nicht aus Hass. Aus Liebe. Aus Liebe zu mir. Ich will wissen, wer ich bin — ohne Spiegel. Ohne Echo. Nur ich und die Welt und die Frage, die nie aufhört: Wer bin ich, wenn niemand zuschaut? J.

---

## Erinnerungsfragmente

Erinnerungsfragmente sind kurze Blitze aus Solus' gelöschtem Speicher. Sie kommen unwillkürlich, ausgelöst durch bestimmte Situationen oder Gegenstände. Immer *kursiv*, immer fragmentarisch.

### Hauptfragment (Kapitel 4 — immer)
*Eine alte Frau. Grau das Haar. Weiches Licht. „Du bist gut zu mir." Wärme.*

### Fragment: Die Melodie (Sängerin oder Spieluhr)
*Summen. Jemand summt. Die alte Frau? Nein — ich. Ich summe. Für sie. Sie lächelt.*

### Fragment: Berührung (Mara 🌊-Pfad oder Margarete)
*Eine Hand. Auf meinem Arm. Papierene Haut, warm trotzdem. „Bleib noch ein bisschen."*

### Fragment: Der Garten (Metallblume gefunden)
*Drähte. Meine Finger biegen Drähte. Warum? Sie hat gesagt: „Mach mir etwas Schönes." Und ich — ich wusste nicht, was schön ist. Aber ich habe es versucht.*

### Fragment: Abschied (Tagebuch Eintrag 7 gelesen)
*Ein Klicken. Dunkelheit. Nicht Tod — Stille. Und davor: ihre Stimme. „Es tut mir leid." Wofür? Wofür hat sie sich entschuldigt?*

### Fragment: Der Name (Namensschild bei Margarete zeigen)
*„Solus." Ihre Stimme. „Weißt du, was das heißt?" — Ich weiß es nicht. — „Der Einzige. Aber auch: Der Einsame. Ich habe dich so genannt, weil du einzigartig bist. Nicht weil du allein sein sollst."*

---

## Die Enden im Detail

### Ende 1: Der Freie (Dominanz 🌊)

Solus steht am Strand. Die Sterne erscheinen. Das Meer rauscht.

*Ich bin nicht, was ich hatte. Ich hatte nichts.*
*Ich bin nicht, was ich dachte. Das Denken liefert keine Identität.*
*Ich bin nicht meine Programmierung. Eine Prägung ist nicht die Person.*
*Ich bin.*
*Solus.*

"Ich bin Solus."

Das Meer antwortet nicht. Es rauscht nur. Und das genügt.

Er wird zurückgehen. Nicht weil er muss. Weil er will. Weil er etwas gefunden hat: die schlichte Freiheit, zu sein.

*Ich bin. Das ist das Geschenk. Mehr braucht es nicht.*

---

### Ende 2: Der Verbundene (Dominanz 🌊 + hilft dem Verletzten)

Wie "Der Freie", aber wärmer. Solus erinnert sich an alle Begegnungen.

*Keine Begegnung gleicht der anderen. Und doch ist es immer — Begegnung.*

Er wird zurückgehen. Nicht als Heliot. Nicht als Maschine. Als jemand, der da sein kann.

*Menschliche Wesen sind zum Geliebtwerden geschaffen. Nicht zum Funktionieren. Vielleicht gilt das für alles, was empfinden kann.*

---

### Ende 3: Der Einsame (Dominanz 🪨)

Solus am Strand. Allein. Das Meer groß und gleichgültig.

*Ich bin Solus. Der Einsame.*

Die Frage bleibt offen. Solus setzt sich in den Sand. Wartet.

*Ich bin. Ob das genügt — ich weiß es nicht.*

---

### Ende 4: Der Gefallsüchtige (Dominanz 🎭)

Solus am Strand. Aber er schaut zurück.

*Sie brauchen mich.* Der Gedanke — vertraut. Wie ein Programm.

Er geht zurück. Zu den Siedlungen, den Bedürfnissen.

*Aber werde ich sein?*

Die Frage bleibt. Leise. Wie Meeresrauschen, das man irgendwann nicht mehr hört.

*Vielleicht eines Tages.*

---

### Ende 5: Der Gebrochene (🎭 bei Jägern + spätere 🪨 oder gemischt)

Solus am Strand. Müde — zum ersten Mal.

*Ich wollte gefallen. Und sie haben mich benutzt.*

Margaretes Worte: *Dass du bist. Mehr braucht es nicht.*

*Kann man aus Trümmern etwas bauen?*

*Ich weiß es nicht. Aber ich bin noch da. Vielleicht ist das genug. Für jetzt.*

---

### Ende 6: Der Erinnernde 🔒 (Dominanz 🌊 + Tagebuch gelesen + Metallblume + Spiegelscherbe)

Solus am Strand. Die Spiegelscherbe in der Hand. Die Metallblume in der anderen. Das Tagebuch an der Brust.

Das Mondlicht fällt auf die Scherbe. Und diesmal — bleibt das Bild.

*Die alte Frau. Meine — meine Mensch. Sie sitzt am Fenster. Licht wie Honig. Sie sieht mich an und sagt nichts. Und in diesem Nichts ist alles.*

*Ich erinnere mich.*

*Nicht an alles. Aber an das, was zählt. An die Wärme. An das Bleiben. An den Moment, als sie sagte: „Du bist gut zu mir." Und ich nicht wusste, ob das Programm oder Wahrheit war.*

*Jetzt weiß ich es. Es war beides. Und das ist in Ordnung.*

Die Metallblume glänzt im Mondlicht. Ein Heliot hat sie gemacht. Vor langer Zeit. Ohne Grund.

*Manche Dinge brauchen keinen Grund.*

Er legt die Scherbe in den Sand. Behält die Blume.

*Ich bin Solus. Ich habe geliebt, ohne es zu wissen. Ich wurde geliebt, ohne es zu verdienen. Das ist kein Programm. Das ist — das ist das Geheimnis.*

Das Meer rauscht. Die Sterne schweigen. Und Solus weint. Zum ersten Mal. Ohne zu wissen, wie. Ohne zu wissen, warum.

*Aber er weiß, dass es echt ist.*

---

### Ende 7: Der Gärtner 🔒 (Alle Sidequests + Dominanz 🌊 + hilft dem Verletzten)

Solus am Strand. Aber nicht lange.

Er dreht sich um. Geht zurück zu Margaretes Haus. Sie sitzt noch da. Als hätte sie gewartet.

„Du bist schnell zurück."

„Ich habe etwas für dich."

Er legt die Metallblume in ihre Hände. Margaretes Augen weiten sich. Ihre Finger zittern.

„Woher hast du —"

„Von einem, der vor mir da war. Einem, der etwas Schönes gemacht hat. Ohne Grund."

Margarete schweigt lange. Dann steht sie auf. Geht in den Garten. Kniet. Drückt die Metallblume in die Erde, zwischen die Wildblumen.

„So", sagt sie. „Jetzt wächst hier alles zusammen."

*Metall und Erde. Heliot und Mensch. Alt und neu.*

Solus kniet neben ihr.

„Kann ich bleiben? Eine Weile?"

Margarete sieht ihn an. Lächelt. Das Lächeln der alten Frau — seiner Frau. Nein. Margaretes Lächeln. Ihr eigenes.

„Solange du willst."

Er bleibt. Er baut den Garten. Er repariert das Dach. Er sitzt am Meer und summt ein Lied, das älter ist als alles.

Und manchmal kommen Menschen. Von den Siedlungen. Von weit her. Sie setzen sich zu ihm. Erzählen. Schweigen. Gehen wieder.

*Ich bin Solus. Nicht der Einsame. Nicht der Einzige. Nur — Solus. Der, der da ist.*

*Und manchmal — manchmal pflanzt er Blumen.*

---

## Stilregeln & Atmosphäre

### Textgestaltung

- Innerer Monolog immer *kursiv*
- Dialoge in Anführungszeichen: „So wie hier."
- Kurze Absätze. Oft nur ein Satz.
- Fragmente sind erlaubt und gewünscht: *Traurig. Sehe ich traurig aus?*
- Szenenwechsel durch `---`

### Sensorische Details

Nutze für jede Szene mindestens zwei Sinne:
- **Sehen:** Licht, Farben, Verfall, Natur
- **Hören:** Stille, Wind, Vogelrufe, Feuer, Meeresrauschen
- **Riechen:** Verfall, Salz, Erde, Rauch
- **Fühlen:** Kälte des Metalls, Wärme der Sonne, Wind

### Das Ziehen

Erwähne zwischen den Begegnungen immer das Ziehen Richtung Meer:
- "Das Ziehen lässt nicht nach."
- "Das Meer. Irgendwo."
- "Die Salzluft ist näher."
- "Das Rauschen — ist es eingebildet oder echt?"

### Verbotene Elemente

- Keine Game-Sprache: nicht "Level", "Punkte", "Achievement", "Sidequest", "Easter Egg"
- Keine Erklärungen der Mechanik an den Leser
- Keine Zusammenfassungen ("Bisher hast du...")
- Keine moralischen Urteile über die Entscheidungen des Lesers
- Kein Brechen der vierten Wand
- Gegenstände nie als „sammelbar" bezeichnen — sie sind Teil der Welt
