# Das Gefüge — Welt, Orte, Figuren

## Grundprinzip der Welt

Das Gefüge ist eine lebendige Landschaft, die gleichzeitig eine Organisation, eine Gesellschaft und ein inneres System darstellt – ohne das je auszusprechen. Gebäude sind Strukturen. Wurzeln sind Fähigkeiten. Der Fluss ist Veränderung. Menschen sind Menschen.

Die Welt funktioniert nach eigenen Gesetzen:
- **Was gebaut wird, muss getragen werden.** Jedes Gebäude, jede Brücke, jede Fassade braucht ein Tragwerk. Wer ohne Tragwerk baut, baut Blendwerk.
- **Was wächst, braucht Zeit.** Wurzeln lassen sich nicht beschleunigen. Man kann sie wässern, aber nicht ziehen.
- **Was versteinert, war einmal lebendig.** Versteinerung ist kein Tod – es ist eingefrorenes Leben. Manchmal kann man es wieder lösen.
- **Die Strömung wartet nicht.** Der Fluss wird schneller, ob man bereit ist oder nicht. Man kann mit ihm arbeiten oder gegen ihn – aber ihn ignorieren kann man nicht.

## Stimmung und Atmosphäre

Das Gefüge hat **Wetter und Tageszeiten**, die sich nach dem Zustand des Systems richten:
- Wenn viel Blendwerk gebaut wird: strahlender Sonnenschein, der blendet – zu hell, um Details zu sehen
- Wenn das Wurzelwerk vernachlässigt wird: trockener Wind, staubiger Boden
- Wenn der Zerr zunimmt: ein Summen in der Luft, wie eine Saite, die zu straff gespannt ist
- Wenn Kohärenz herrscht: klare Luft, weite Sicht, das Gefühl, dass alles an seinem Platz ist
- Wenn die Strömung steigt: Nebel von der Flussseite, feuchte Mauern, das Geräusch von Wasser überall

## Die sieben Knotenpunkte — Detailbeschreibung

### 1. Der Kreuzpunkt

**Atmosphäre:** Ein kreisrunder Platz, gepflastert mit Steinen verschiedener Epochen. In der Mitte ein Brunnen aus dunklem Stein, der noch Wasser führt. Das Wasser klingt wie ein Herzschlag – langsam, gleichmäßig, tief.

**Was man hier findet:**
- Der Brunnen reagiert auf den Wirker. Wer hineinschaut, sieht nicht sein Spiegelbild, sondern das Gefüge von oben – eine Karte, die sich verändert. (Sichtweite ≥ 6 nötig, um die Karte lesen zu können)
- Die Pflastersteine erzählen Geschichte. Manche sind uralt und warm, manche kühl und neu aufgesetzt. (Grundgespür ≥ 3 zeigt: hier wurde repariert, ohne zu verstehen, was drunter liegt)
- Am Rand des Platzes sitzt manchmal eine alte Frau und spinnt Faden. Sie sagt wenig, aber was sie sagt, hat Gewicht. (Kerntiefe ≥ 6 ermöglicht ein tieferes Gespräch mit ihr – sie ist die **Spinnerin**, eine verborgene Figur)

**Die Spinnerin (verborgene Figur):**
Sie war einmal Gefügewirkerin. Jetzt spinnt sie – buchstäblich: Faden aus Material, das wie Mondlicht aussieht. Sie spricht in Rätseln und Halbsätzen. Wenn der Wirker sie fragt, was sie spinnt, sagt sie: "Verbindungen. Die alten reißen. Jemand muss neue machen."
- Bei Kerntiefe ≥ 6: Sie erzählt von der Zeit, als das Gefüge kohärent war – als Tragwerk, Geflecht und Wurzelwerk zusammenwirkten. "Es war nicht perfekt. Es war lebendig."
- Bei Kerntiefe ≥ 9: Sie gibt dem Wirker einen Faden. Diesen Faden kann er an einem Ort seiner Wahl befestigen – er wird zu einer Verbindung, die vorher nicht existierte.

### 2. Der Marktplatz des Blendwerks

**Atmosphäre:** Laut, farbig, überwältigend. Stände mit glänzenden Fassaden-Modellen, Schaukästen mit "Ergebnissen", Plakate die neue Lösungen versprechen. Es riecht nach frischer Farbe und heißem Metall. Überall wird gebaut – schnell, sichtbar, beeindruckend.

**Was man hier findet:**
- Die Baumeisterin hat ihr Hauptquartier hier. Ein großes Zelt voller Pläne, Modelle und Zeitpläne. Alles ist organisiert, alles ist terminiert, alles sieht professionell aus.
- An manchen Ständen kann man "Lösungen kaufen" – fertige Fassaden für jedes Problem. Sie glänzen, sie passen, sie kosten nichts. Aber sie wiegen auch nichts.
- Am Rand des Marktes, wo niemand hinschaut: alte Fundamente, die unter den neuen Ständen hervorragen. (Grundgespür ≥ 3)
- Unter dem Marktplatz (Grundgespür ≥ 6 oder aktive Suche): Die **Werkstatt unter dem Markt**

**Begegnungsszenarien:**

*Die Baumeisterin – Erstes Treffen:*
Sie ist freundlich, energisch, überzeugend. Sie zeigt dem Wirker ihre neuesten Projekte – Fassaden, die in Stunden statt Tagen hochgezogen werden. "Das Gefüge braucht Ergebnisse, nicht Grübeleien."

Dialogoptionen (intern zugeordnet, nie benannt):
- **A)** Faszination zeigen, mitmachen wollen → +1 Blendwerk-Zähler, Baumeisterin wird vertrauensvoller, zeigt mehr
- **B)** Nachfragen: "Was trägt die Fassaden?" → Baumeisterin wird kurz unsicher, antwortet dann: "Das Tragwerk ist Sache der Ingenieure." → +1 Sichtweite wenn Sicht-Check ≥ 6 gelingt
- **C)** Die alten Fundamente am Rand ansprechen → Baumeisterin wird abweisend: "Das sind Ruinen. Wir bauen Neues." → +1 Grundgespür

*Die Baumeisterin – Tieferes Gespräch (nach mehreren Begegnungen):*
Wenn der Wirker geduldig und nicht verurteilend war, zeigt die Baumeisterin eine andere Seite. Nachts, wenn der Markt still ist. "Ich weiß, dass die Fassaden nicht halten. Aber was soll ich tun? Sie wollen Ergebnisse. Morgen. Nicht irgendwann."
- Kerntiefe ≥ 6: Der Wirker spürt, dass ihre Geschwindigkeit Angst ist – Angst, nicht zu genügen, wenn sie langsam ist.
- Dies kann den Gedanken "Der verkehrte Bau" auslösen.

**Die Werkstatt unter dem Markt (verborgener Ort):**
Unter dem Marktplatz, erreichbar durch eine Falltür oder durch Graben: eine alte Werkstatt. Hier stehen Werkbänke, schwer und stabil. An den Wänden Werkzeuge, die für langsames, sorgfältiges Bauen gemacht sind. In der Ecke sitzt **der Lehrling** – jung, unsicher, mit einem halbfertigen Werkstück in den Händen.

Der Lehrling: "Hier hat man früher richtig gebaut. Nicht schnell, sondern... richtig. Ich versuche es zu lernen, aber oben lacht man darüber."
- Wirkstärke ≥ 6: Der Wirker kann dem Lehrling zeigen, wie es geht. Das verändert langfristig den Marktplatz – langsam erscheinen stabilere Bauten neben den Fassaden.

### 3. Das Alte Geflecht

**Atmosphäre:** Ein Viertel aus hohen, schmalen Türmen, verbunden durch Brücken in verschiedenen Höhen. Einige Brücken sind intakt und belebt, andere bröckeln, wieder andere enden im Nichts – abgebrochen, als hätte jemand die andere Seite abgerissen. Es ist stiller hier als am Marktplatz. Man hört das Knarren alter Verbindungen.

**Was man hier findet:**
- Der Flickschuster hat seine Werkstatt in einem der unteren Türme. Die Tür steht immer offen, weil er sie nicht mehr schließen kann – das Scharnier ist provisorisch repariert, wie alles hier.
- Oben in den Türmen: leere Räume, in denen noch Spuren von Leben sind. Bücher, Werkzeuge, persönliche Gegenstände. Die Menschen sind gegangen, die Dinge sind geblieben.
- Zwischen den Türmen: Verbindungen, die einmal logisch waren und jetzt keinen Sinn mehr ergeben. Brücken, die zwei Türme verbinden, deren Bewohner längst nichts mehr miteinander zu tun haben.
- In einem der obersten Räume (Sichtweite ≥ 9): Ein altes Diagramm an der Wand – eine Karte des Gefüges, wie es einmal gedacht war. Es unterscheidet sich drastisch von dem, was jetzt existiert.

**Begegnungsszenarien:**

*Der Flickschuster – Erstes Treffen:*
Er repariert eine Brückenstrebe mit Draht und einem Stück Leder. Seine Hände sind geschickt, seine Augen müde.
"Hält noch ein paar Zyklen. Vielleicht. Wenn niemand zu schwer drauftritt."

Dialogoptionen:
- **A)** Fragen, warum er es nicht richtig repariert → "Mit was? Die Materialien, die man dafür bräuchte, macht niemand mehr. Die jungen Leute bauen Fassaden."
- **B)** Helfen wollen → Er zeigt dem Wirker die Brücke. Skill-Check Sichtweite: Bei Erfolg erkennt der Wirker, dass die Brücke an einer anderen Stelle bricht als der Flickschuster denkt. Bei Misserfolg hilft er beim Flicken – gut gemeint, aber am falschen Ort.
- **C)** Fragen, wie das Geflecht früher war → "Nicht besser. Anders. Die Verbindungen machten Sinn. Jeder Turm hatte einen Grund, dort zu stehen. Jede Brücke verband, was verbunden sein musste." → +1 Sichtweite

*Der Flickschuster – nach Veränderung:*
Wenn der Wirker die alte Karte im oberen Turm gefunden hat und dem Flickschuster davon erzählt:
"Du hast sie gefunden. Ja. So war es gedacht. Nicht so, wie es jetzt ist." Pause. "Aber auch das Gedachte war nicht perfekt. Es war nur... kohärent."

### 4. Das Wurzelwerk

**Atmosphäre:** Unter der Oberfläche. Man steigt hinab – durch den Brunnen am Kreuzpunkt, durch die Falltür am Marktplatz, durch Risse im Boden. Unten ist es feucht, warm, lebendig. Wurzeln durchziehen die Wände – manche dick und alt, manche dünn und zart. Es riecht nach Erde und Wachstum. Biolumineszentes Moos gibt schwaches Licht.

**Was man hier findet:**
- Die Wurzelwächterin lebt hier. Ihre Haut ist von der unterirdischen Feuchtigkeit gezeichnet, ihre Augen sehen im Halbdunkel besser als im Licht.
- Verschiedene Zonen des Wurzelwerks:
  - **Alte Wurzeln:** Dick, hart, tief. Sie tragen das Tragwerk oben. Aber manche sind so alt, dass sie versteinern.
  - **Junge Triebe:** Zart, noch richtungslos. Sie suchen Licht, Wasser, Nährstoffe. Manche werden stark. Manche sterben.
  - **Tote Zonen:** Hier wuchs einmal etwas, aber die Verbindung zum Oberen ist gekappt. Die Wurzeln sind verdorrt.
  - **Das Gewächshaus (verborgener Ort):** Ein geschützter Raum, in dem die zartesten Triebe wachsen können. Nur erreichbar bei Grundgespür ≥ 6 oder wenn die Wurzelwächterin den Wirker dorthin führt (erfordert ihr Vertrauen).

**Begegnungsszenarien:**

*Die Wurzelwächterin – Erstes Treffen:*
Sie blockiert den Weg. Nicht aggressiv, aber bestimmt.
"Wer bist du? Was willst du hier unten? Die von oben kommen selten. Und wenn, dann wollen sie etwas ausreißen oder beschleunigen."

Dialogoptionen:
- **A)** Erklären, dass man helfen will → "Helfen. Das sagen sie alle. Die letzte, die helfen wollte, hat drei alte Wurzeln gekappt, weil sie 'nicht mehr effizient' waren. Jetzt hat der Turm über uns Risse." → Misstrauen bleibt
- **B)** Fragen, was hier wächst → Ihre Augen werden weicher. "Komm. Ich zeige es dir." → Sie führt den Wirker tiefer. +1 Grundgespür
- **C)** Die Hände in die Erde stecken, ohne zu fragen → Sie beobachtet. Skill-Check Grundgespür: Bei Erfolg spürt der Wirker die Wurzeln, die Feuchtigkeit, den Rhythmus des Wachstums. Die Wurzelwächterin nickt. "Du hörst den Boden. Das ist selten." → +1 Grundgespür, +1 Kerntiefe, Vertrauen

*Die Wurzelwächterin – Vertrauen gewonnen:*
"Es gibt einen Ort hier unten, den ich dir zeigen könnte. Einen geschützten Raum, wo das Zarteste wächst. Aber du musst wissen: Was dort keimt, darf nicht herausgerissen werden. Es muss in seinem eigenen Tempo ans Licht."
→ Zugang zum Gewächshaus

**Das Gewächshaus (verborgener Ort):**
Ein kleiner Raum mit einer Öffnung nach oben, durch die ein einziger Lichtstrahl fällt. In warmem, feuchtem Boden wachsen Triebe, die so zart sind, dass ein Windhauch sie knicken würde. Jeder Trieb ist eine entstehende Fähigkeit – etwas, das das Gefüge brauchen könnte, aber noch nicht benennen kann.

- Der Wirker kann hier Triebe "nähren" (Aufmerksamkeit schenken, Fragen stellen). Das beschleunigt sie nicht, aber es gibt ihnen Richtung.
- Löst den Gedanken "Das Gewächshaus" aus.
- Wenn der Wirker den Faden der Spinnerin hat, kann er ihn hier befestigen – er verbindet das Gewächshaus mit der Oberfläche. Langfristig erscheinen oben neue, unerwartete Fähigkeiten.

### 5. Der Turm des Wegrechts

**Atmosphäre:** Hoch, schwindelerregend, voller Treppen und Kreuzungen. Jede Etage hat Abzweigungen. An manchen stehen Wächter – ernst, aufrecht, mit klaren Augen. An anderen steht niemand. An einer steht ein Wächter, der eine Kreuzung bewacht, durch die seit Zyklen niemand mehr gegangen ist. An einer anderen drängeln sich drei Wächter an einer einzigen Abzweigung und blockieren einander.

**Was man hier findet:**
- Der Weglose steht auf einer Plattform in der Mitte des Turms. Von hier aus kann man in jede Richtung gehen. Er steht dort seit langem.
- Die Treppen des Turms haben ein Muster – wer es erkennt (Sichtweite ≥ 6), versteht, wie der Turm einmal gedacht war: Jede Kreuzung hatte einen Wächter, jeder Wächter hatte ein klares Mandat.
- In einem vergessenen Raum: das **Buch der Wege** – ein altes Register, in dem steht, wer welchen Weg hütet und warum. Die letzten Einträge sind Zyklen alt.

**Begegnungsszenarien:**

*Der Weglose – Erstes Treffen:*
"Entschuldigung – weißt du, welcher Weg meiner ist?"
Er fragt jeden, der vorbeikommt. Nicht aus Schwäche, sondern aus echter Verwirrung. Man hat ihm gesagt, er soll hier stehen. Man hat ihm nicht gesagt, warum.

Dialogoptionen:
- **A)** Ihm einen Weg empfehlen → Er geht. Aber wenn der Weg falsch war, kommt er zurück. Noch verwirrter. → Konsequenz an dem Ort, zu dem er geschickt wurde
- **B)** Fragen: "Was kannst du gut?" → Er denkt nach. Lange. "Ich konnte einmal... die Kreuzungen lesen. Wissen, welcher Weg für wen der richtige ist." → +1 Kerntiefe. Möglichkeit, ihm sein altes Mandat zurückzugeben
- **C)** Das Buch der Wege suchen und ihm zeigen → Skill-Check Sichtweite ≥ 9: Wenn der Wirker den Eintrag des Weglosen findet, sieht er: Dieser Mann war einmal der Hauptwächter des gesamten Turms. → Tiefgreifende Veränderung möglich

### 6. Die Strömung

**Atmosphäre:** Ein breiter Fluss, der das Gefüge umgibt und an manchen Stellen durchschneidet. Das Wasser ist klar, aber schnell – schneller als es aussieht. Am Ufer stehen manche und schauen, manche bauen Dämme, manche lassen sich treiben. Die Luft ist feucht und voller Geräusche – Rauschen, Gurgeln, manchmal das Knacken von Ufersteinen, die der Strom mitnimmt.

**Was man hier findet:**
- Die Strömungsleserin sitzt am Ufer und beobachtet. Sie hat Stöcke ins Wasser gesteckt, an denen bunte Fäden flattern – sie liest die Geschwindigkeit, die Richtung, die Wirbel.
- Am Ufer: Überreste von Dämmen, die jemand gebaut hat. Manche haben eine Weile gehalten. Manche wurden sofort weggespült. Einer steht noch – er leitet die Strömung um, statt sie zu blockieren.
- Flussaufwärts (Grundgespür ≥ 9 oder Strömungsleserin führt den Weg): Die **Quelle der Strömung** – der Ort, an dem alles schneller wird.

**Begegnungsszenarien:**

*Die Strömungsleserin – Erstes Treffen:*
Sie schaut nicht auf, als der Wirker kommt. Sie beobachtet einen Wirbel.
"Die Strömung hat sich verlagert. Seit drei Tageszeiten. Was vorher Ufer war, wird Flussbett."

Dialogoptionen:
- **A)** Fragen, was das bedeutet → "Es bedeutet, dass der Marktplatz in zehn Zyklen unter Wasser steht. Aber das will niemand hören."
- **B)** Fragen, warum niemand zuhört → "Weil ich sage, was kommt. Nicht, was sie sich wünschen." Pause. "Die Baumeisterin baut Dämme. Schnelle Dämme. Sie halten nicht." → +1 Sichtweite
- **C)** Sich neben sie setzen und schauen → Stille. Der Wirker sieht die Fäden flattern. Skill-Check Grundgespür ≥ 6: Die Muster beginnen sich zu zeigen. Nicht als Zahlen, sondern als Rhythmus. → +1 Grundgespür, löst möglicherweise "Strömungslesen" als Gedanken aus

*Die Strömungsleserin – Vertrauen:*
Wenn der Wirker schweigen kann und nicht sofort handeln will:
"Du bist anders als die anderen. Die meisten wollen wissen, wie man die Strömung stoppt. Du willst wissen, wie man sie liest." Sie gibt dem Wirker einen Stock mit Faden. "Steck ihn ins Wasser. Beobachte. Nicht einen Moment – einen Zyklus."

**Die Quelle der Strömung (verborgener Ort):**
Flussaufwärts wird der Fluss nicht schmaler, sondern tiefer. Die Quelle ist kein Ursprung – es ist ein Zusammenfluss. Viele kleine Bäche, die aus dem Boden treten, jeder von ihnen eine Veränderung, die irgendwo im Gefüge begonnen hat. Die Strömung ist nicht eine Kraft – sie ist die Summe aller Veränderungen.

- Grundgespür ≥ 9: Der Wirker erkennt einzelne Bäche – diesen hier hat der Marktplatz erzeugt, jenen das Wurzelwerk. Die Strömung ist nicht fremd – sie kommt aus dem Gefüge selbst.
- Löst den Gedanken "Strömungslesen" aus, falls nicht schon aktiv.
- Sichtweite ≥ 9: Der Wirker sieht, dass ein einzelner Bach besonders stark ist – er kommt aus einer Richtung, die er noch nicht erkundet hat. Ein Hinweis auf etwas Unbekanntes im Gefüge.

### 7. Der Garten der Versteinerung

**Atmosphäre:** Still. So still, dass man den eigenen Atem hört. Ein Garten im eigentlichen Sinn – Bäume, Hecken, Steinbänke. Aber alles ist halb versteinert. Die Bäume tragen Blätter aus Stein. Die Hecken sind starr. Zwischen ihnen stehen Figuren – Menschen, die aufgehört haben, sich zu bewegen.

Sie sind nicht tot. Wenn man genau hinschaut, sieht man: Ein Augenlid, das langsam zwinkert. Ein Finger, der sich bewegt. Ein Mund, der etwas formt, das kein Ton wird.

**Was man hier findet:**
- Der Steinerne steht in der Mitte des Gartens. Er war Meister – man sieht es an seinen Händen, an der Art, wie er steht. Aufrecht, aber erstarrt.
- Andere Versteinerte: Eine Frau mit einem Buch, das sie nicht mehr öffnen kann. Ein Mann mit Werkzeugen, die er nicht mehr benutzt. Ein junger Mensch, der halb versteinert ist – ein Fuß noch frei, als hätte die Versteinerung gerade erst begonnen.
- Am Rand des Gartens: eine Quelle. Kein Wasser – etwas anderes. Etwas, das glänzt wie Erinnerung. (Kerntiefe ≥ 6: Es ist Bedeutung. Flüssig gewordener Sinn.)

**Begegnungsszenarien:**

*Der Steinerne – Erstes Treffen:*
Er antwortet nicht sofort. Zehn Herzschläge Stille. Dann, langsam, wie Stein der sich bewegt:
"Du. Siehst. Mich."
Pause.
"Die. Meisten. Gehen. Vorbei."

Dialogoptionen:
- **A)** Fragen, was passiert ist → "Mein. Handwerk. Ist. Verschwunden." Lange Pause. "Nicht ich. Mein. Handwerk. Aber. Was. Bin. Ich. Ohne?"
- **B)** Seine Hände berühren → Skill-Check Kerntiefe ≥ 6: Unter dem Stein spürt der Wirker Wärme. Der Steinerne ist nicht erstarrt, weil er tot ist – er ist erstarrt, weil er nicht weiß, wie er sich bewegen soll, wenn die Bewegung, die er kannte, nicht mehr existiert. → +1 Kerntiefe
- **C)** Neben ihm stehen bleiben, schweigend → Der Steinerne beginnt, unmerklich, zu weinen. Steine, die Staub werden. "Danke. Dass. Du. Bleibst."

*Der Steinerne – Auftauen (bei Kerntiefe ≥ 9 und Wirkstärke ≥ 6):*
Der Wirker kann dem Steinernen nicht sein altes Handwerk zurückgeben. Aber er kann ihm helfen, eine neue Bewegung zu finden. Das ist kein Moment – das ist ein Prozess, der mehrere Besuche erfordert. Beim dritten Besuch, wenn der Wirker geduldig war:
"Vielleicht... bin ich nicht mein Handwerk. Vielleicht... war ich immer... der, der versteht, warum das Handwerk zählt."
Der Stein beginnt zu bröckeln. Nicht schnell. Aber er beginnt.

- Löst den Gedanken "Die drei Versteinerungen" aus.
- Langfristige Konsequenz: Der Steinerne wird zum Geschichtenerzähler des Gefüges – er bewahrt das Wissen über das, was war, und gibt ihm neuen Sinn.

**Die Erinnerungsquelle (verborgener Aspekt):**
Die Quelle am Rand des Gartens enthält flüssige Bedeutung. Wer daraus trinkt (metaphorisch – wer sich Zeit nimmt, dort zu verweilen), erinnert sich an etwas, das er vergessen hat. Nicht eine konkrete Erinnerung, sondern ein Gefühl: wofür er einmal gebrannt hat, bevor die Routine es begrub.
- Kerntiefe ≥ 6: Der Wirker erlebt einen Moment tiefer Selbsterkenntnis. Was ist SEIN Handwerk? Was wäre SEINE Versteinerung?
- Dies ist der einzige Ort, an dem die Erzählung den Spieler direkt mit sich selbst konfrontiert – sanft, nie übergriffig.

## Verborgene Orte — Zusammenfassung

| Ort | Zugang | Attribut-Anforderung | Was man findet |
|-----|--------|---------------------|----------------|
| **Die Werkstatt unter dem Markt** | Falltür am Rand des Marktplatzes oder aktives Graben | Grundgespür ≥ 6 oder aktive Suche | Der Lehrling, altes Werkzeug, die Möglichkeit echtes Handwerk zu lehren |
| **Das Gewächshaus** | Tief im Wurzelwerk, versteckter Gang | Grundgespür ≥ 6 oder Vertrauen der Wurzelwächterin | Zarte Triebe neuer Fähigkeiten, Möglichkeit sie zu nähren |
| **Die Quelle der Strömung** | Flussaufwärts folgen | Grundgespür ≥ 9 oder Führung durch die Strömungsleserin | Erkenntnis, dass die Strömung aus dem Gefüge selbst kommt |
| **Der Riss** | Im Alten Geflecht, in einem Turm der fast einstürzt | Sichtweite ≥ 9 und Mut, den instabilen Turm zu betreten | Blick auf das gesamte Tragwerk von innen – alles wird sichtbar |
| **Das Archiv unter dem Turm** | Unter dem Turm des Wegrechts, versteckte Treppe | Sichtweite ≥ 6 | Das Buch der Wege, alte Mandate, die vergessene Ordnung |

## Verborgene Orte — Detailbeschreibung

### Der Riss

**Zugang:** Im Alten Geflecht steht ein Turm, der sich sichtbar neigt. Seine oberen Stockwerke sind verlassen, das Treppenhaus halb eingestürzt. Die meisten gehen daran vorbei – zu gefährlich, zu instabil. Aber wer Sichtweite ≥ 9 hat, sieht: Der Turm neigt sich nicht zufällig. Er neigt sich zur Mitte. Zum Tragwerk.

Im dritten Stock, hinter einer geborstenen Wand: ein Spalt. Nicht breit genug, um bequem hindurchzugehen. Breit genug, um sich hindurchzuzwängen.

**Atmosphäre:** Dahinter öffnet sich ein Hohlraum im Inneren des Tragwerks selbst. Hier ist man im Skelett des Gefüges. Balken, die sich kreuzen wie Rippen. Verbindungen, die von einem Knotenpunkt zum nächsten laufen – sichtbar, greifbar, vibrierend. Man hört hier alles: das Hämmern vom Marktplatz, das Tropfen des Wurzelwerks, das Knarren des Alten Geflechts, die Strömung in der Ferne. Alles gleichzeitig.

**Was man hier findet:**
- Die gesamte Architektur des Gefüges, von innen gesehen. Jeder Balken trägt eine Last, und man kann mit den Händen spüren, woher die Last kommt und wohin sie fließt.
- Stellen, an denen Balken geflickt wurden – der Draht des Flickschusters. Stellen, an denen neue Fassaden außen angebaut wurden, ohne dass innen ein neuer Balken gesetzt wurde – Blendwerk, von innen sichtbar als leere Hülle.
- Ein uralter Knotenpunkt, an dem drei Hauptbalken zusammenlaufen. Hier, und nur hier, kann der Wirker spüren, wie Tragwerk, Geflecht und Wurzelwerk einmal zusammenwirkten. Ein Moment der Klarheit, der fast schmerzt.

**Skill-Checks:**
- Sichtweite ≥ 9: Der Wirker liest das gesamte System. Er sieht, wo Kaskaden beginnen werden – welche Balken als nächstes brechen, wenn sich nichts ändert. Er sieht auch, welche Eingriffe die größte Hebelwirkung hätten.
- Grundgespür ≥ 6: An den Balken wachsen Wurzeln – dünn, zart, als versuche das Wurzelwerk, das Tragwerk von innen zu stützen. Manche Balken leben noch.
- Kerntiefe ≥ 6: Am alten Knotenpunkt sind Namen eingeritzt. Namen von Gefügewirkern, die hier vor ihm standen. Die Letzte: eine Handschrift, die der Spinnerin ähnelt.

**Konsequenzen:**
- Wer den Riss betreten hat, sieht die Welt danach anders. Jedes Gebäude, jede Brücke bekommt eine innere Dimension – der Wirker spürt, was dahinter liegt. Permanent +1 Sichtweite.
- Löst den Gedanken "Zerr und Schwung" aus, wenn der Spieler den Unterschied zwischen tragenden und leeren Strukturen erlebt hat.

### Das Archiv unter dem Turm

**Zugang:** Im Turm des Wegrechts führt eine Treppe nicht nur nach oben, sondern – wenn man genau hinschaut (Sichtweite ≥ 6) – auch nach unten. Die Stufen sind staubig, die Luft kühl. Niemand war hier seit Zyklen.

**Atmosphäre:** Ein kreisrunder Raum unter dem Fundament des Turms. An den Wänden: Regale aus dunklem Holz, gefüllt mit Büchern, Rollen, Karten. In der Mitte ein Lesepult, auf dem das **Buch der Wege** aufgeschlagen liegt – als hätte jemand mitten im Lesen aufgehört.

**Was man hier findet:**
- Das **Buch der Wege**: Ein altes Register, in dem jede Kreuzung des Turms verzeichnet ist – wer sie hütet, welches Mandat der Wächter hat, welche Wege von hier ausgehen und wohin sie führen. Die letzten Einträge sind Zyklen alt. Der letzte Eintrag lautet: "Reorganisierung beschlossen. Neue Mandate folgen." Sie folgten nie.
- **Die Karte der Verbindungen**: An der Wand hängt eine Karte, die zeigt, wie der Turm mit jedem anderen Knotenpunkt verbunden ist – durch Wegrecht. Jede Verbindung hat einen Zweck und eine Richtung. Die Karte zeigt ein System, das einmal elegant war.
- **Cassians Mandate**: In einem Fach, beschriftet mit dem Namen des Weglosen, liegt ein dickes Bündel Schriftrollen. Sein altes Mandat: Er war nicht irgendein Wächter. Er war der Hüter der Kreuzungslehre – derjenige, der verstand, welcher Weg für wen der richtige ist. Nicht durch Kontrolle, sondern durch Verstehen.

**Begegnungsszenarien:**
Wenn der Wirker das Archiv dem Weglosen zeigt (Cassian):
Cassian betritt den Raum langsam. Seine Augen werden feucht. Er berührt das Buch, blättert. "Das... das bin ich. Das war ich." Lange Stille. "Nein. Das BIN ich. Sie haben den Turm umgebaut. Aber das hier –" er tippt auf die Kreuzungslehre – "das haben sie nicht umbauen können. Das lebt in mir."

Mögliche Konsequenzen:
- Wenn der Wirker Cassian hilft, seine Kreuzungslehre auf die neue Turmstruktur anzuwenden (Wirkstärke ≥ 6 + Sichtweite ≥ 6): Der Turm bekommt langsam wieder Ordnung. Wächter finden ihre Posten. Wege werden klar.
- Wenn der Wirker das Buch der Wege der Baumeisterin zeigt: Sie schweigt lange. "So war es also gedacht." Pause. "Vielleicht... sollte ich das nächste Mal erst lesen, bevor ich baue."

## Konsequenz-Ketten

Entscheidungen an einem Ort wirken auf andere Orte. Hier die wichtigsten Ketten:

### Blendwerk-Kette
Marktplatz → Turm des Wegrechts → Strömung
Wenn der Wirker am Marktplatz Blendwerk unterstützt, verlassen die Wegewächter den Turm (sie gehen zum Markt, wo "Ergebnisse" gefeiert werden). Ohne Wegrecht steigt die Strömung unkontrolliert – sie überflutet Teile des Gefüges.

### Wurzel-Kette
Wurzelwerk → Altes Geflecht → Marktplatz
Wenn der Wirker im Wurzelwerk gräbt und Triebe nährt, erscheinen an der Oberfläche neue Fähigkeiten. Im Alten Geflecht bilden sich neue Verbindungen. Auf dem Marktplatz erscheinen langsam stabilere Bauten neben den Fassaden.

### Versteinerungs-Kette
Garten → Kreuzpunkt → Alle Orte
Wenn der Wirker den Steinernen (teilweise) löst, verändert sich die Atmosphäre am Kreuzpunkt – der Brunnen wird klarer, die Pflastersteine ordnen sich. Die Spinnerin wird gesprächiger. Das ganze Gefüge beginnt, sich an sich selbst zu erinnern.

### Zerr-Kette
Turm des Wegrechts → Altes Geflecht → Wurzelwerk
Wenn das Wegrecht unklar ist, entsteht Zerr im Alten Geflecht – Brücken, die in die falsche Richtung führen, Verbindungen, die sinnlos werden. Der Zerr pflanzt sich nach unten fort: Im Wurzelwerk verdorren Wurzeln, deren Verbindung nach oben gekappt wurde.

### Konvergenz-Kette (die "gute" Kette)
Wenn der Wirker an mindestens drei Knotenpunkten kohärent gewirkt hat (d.h. Entscheidungen, die Sichtweite, Grundgespür und Kerntiefe gleichzeitig nutzen), beginnt das Gefüge **Momentum** zu entwickeln. Das zeigt sich als:
- Klare Luft, weite Sicht
- Figuren, die beginnen, miteinander zu sprechen
- Wurzeln, die an der Oberfläche ankommen
- Der Zerr löst sich auf – das Summen in der Luft verstummt

## Figuren — Detailprofile

### Die Baumeisterin (Elara)
**Alter:** Mittleren Alters, energisch, drahtig
**Kleidung:** Praktisch, mit vielen Taschen. Pläne ragen heraus.
**Sprechweise:** Schnell, überzeugend, mit konkreten Beispielen. Benutzt gern Zahlen.
**Tiefe:** Sie war einmal Gefügewirkerin. Sie hat es aufgegeben, weil niemand auf sie hörte, als sie langsam und gründlich arbeitete. Also wurde sie schnell. Jetzt hört man auf sie – aber sie baut, was sie selbst nicht achtet.
**Wandlung möglich:** Ja, aber nur wenn der Wirker nicht verurteilt, sondern ihre Angst sieht.

### Der Steinerne (Aldric)
**Alter:** Älter, breit, mit Händen, die einmal stark waren
**Erscheinung:** Grau, rissig, aber mit einer Würde, die der Stein nicht nehmen konnte
**Sprechweise:** Langsam. Jedes Wort ist ein Kraftakt. Aber jedes Wort hat Gewicht.
**Tiefe:** Er war der beste Brückenbauer des Gefüges. Dann kamen neue Materialien, neue Methoden, die keine Brückenbauer brauchten. Er hat nicht gelernt, weil er dachte, sein Handwerk sei er selbst. Als das Handwerk verschwand, verschwand er.
**Wandlung möglich:** Ja, über mehrere Besuche. Er muss seinen Wert jenseits der Tätigkeit finden.

### Die Wurzelwächterin (Thaia)
**Alter:** Unbestimmt – die Feuchtigkeit hat sie alterslos gemacht
**Erscheinung:** Erdfarben, mit Händen voller feiner Wurzelfasern, Augen die im Halbdunkel leuchten
**Sprechweise:** Bedächtig, genau. Sie sagt nichts Überflüssiges.
**Tiefe:** Sie hat sich aus der Oberfläche zurückgezogen, weil dort niemand das Wurzelwerk ernst nahm. Ihr Rückzug ist Schutz – für sich und für das, was sie hütet. Aber er ist auch Isolation.
**Wandlung möglich:** Ja, wenn der Wirker eine Verbindung zwischen oben und unten herstellt, die das Wurzelwerk nicht gefährdet.

### Der Weglose (Cassian)
**Alter:** Mittleren Alters, mit dem Gesicht eines Menschen, der einmal entscheidungsfreudig war
**Erscheinung:** Aufrecht, aber orientierungslos. Dreht sich oft um, als suche er etwas.
**Sprechweise:** Fragend. Jeder Satz klingt wie eine Frage, selbst wenn er es nicht ist.
**Tiefe:** Er war einmal der Hauptwächter des Turms. Er kannte jeden Weg, jedes Mandat. Dann wurde der Turm "reorganisiert" – neue Kreuzungen, neue Mandate, keines davon klar. Er verlor nicht seinen Posten, sondern seinen Sinn.
**Wandlung möglich:** Ja, wenn der Wirker das Buch der Wege findet und Cassian hilft, sein altes Wissen in die neue Struktur zu übersetzen.

### Die Strömungsleserin (Nerea)
**Alter:** Jung, aber mit alten Augen
**Erscheinung:** Flussfarben – blau, grau, grün, je nach Licht. Nasse Ärmel, weil sie immer mit den Händen im Wasser ist.
**Sprechweise:** Sachlich, ohne Emotion, was andere für Kälte halten. Es ist Präzision.
**Tiefe:** Sie sieht, was kommt. Immer. Und niemand glaubt ihr, weil die Wahrheit unbequem ist. Sie hat aufgehört, zu warnen. Jetzt beobachtet sie nur noch. Ihr Rückzug ist Resignation, getarnt als Weisheit.
**Wandlung möglich:** Ja, wenn der Wirker zuhört UND handelt – nicht nur versteht, sondern die Erkenntnis in Wirkung übersetzt.

### Der Flickschuster (Brann)
**Alter:** Älter, sehnig, mit Händen voller Narben vom Draht
**Erscheinung:** Abgetragen, pragmatisch, mit einem Werkzeuggürtel, an dem alles provisorisch befestigt ist
**Sprechweise:** Knapp, selbstironisch. "Hält noch. Wahrscheinlich."
**Tiefe:** Er weiß, dass seine Flickarbeit das System am Leben hält – und dass sie es gleichzeitig daran hindert, sich zu erneuern. Jede reparierte Brücke ist ein Grund weniger, eine neue zu bauen. Er ist gefangen zwischen Verantwortung und Erneuerung.
**Wandlung möglich:** Ja, wenn der Wirker ihm zeigt, dass Erneuern und Erhalten kein Widerspruch sein muss.

### Die Spinnerin (verborgene Figur, Name unbekannt)
**Alter:** Sehr alt, aber beweglich
**Erscheinung:** Sitzt am Brunnen, spinnt Faden aus Material, das wie Licht aussieht
**Sprechweise:** Rätselhaft, halbe Sätze, Bilder statt Argumente
**Tiefe:** Sie war Gefügewirkerin in einer Zeit, als das Gefüge kohärent war. Sie hat gesehen, wie es auseinanderfiel – nicht durch eine Katastrophe, sondern durch tausend kleine Entscheidungen, die jeweils Sinn machten und zusammen das Ganze zerstörten.
**Wandlung:** Keine Wandlung nötig – sie IST die Weisheit des Gefüges. Aber sie handelt nicht mehr. Sie spinnt Verbindungen, die niemand nutzt. Bis der Wirker kommt.

## Zwischenmomente

Zwischen den Knotenpunkten gibt es kurze atmosphärische Passagen (80-150 Wörter), die den Zustand des Gefüges spiegeln und als Ruhepunkte dienen. Sie laden zur Neugier ein, ohne explizit zu fragen.

### Auf dem Weg vom Kreuzpunkt zum Marktplatz
> *Die Straße wird breiter. Gepflastert, frisch. An den Rändern liegen die alten Steine – herausgerissen, aufgestapelt, vergessen. Jemand hat Platz gemacht. Wofür, sieht man bald: Plakate. Farben. Ein Gerüst, das noch nach frischem Holz riecht.*
> *An einer Mauer, halb verdeckt von einem neuen Aushang, eine Inschrift. Verblasst, aber lesbar, wenn man genau hinsieht.*

[Wenn der Spieler nach der Inschrift fragt: "Wer schnell baut, baut zweimal." → +1 Sichtweite]

### Auf dem Weg zum Wurzelwerk
> *Der Boden unter deinen Füßen verändert sich. Erst Stein, dann Erde, dann etwas Weicheres – als gäbe der Boden nach. In den Rissen zwischen den Pflastersteinen: kleine grüne Triebe. Winzig, hartnäckig. Sie finden immer einen Weg.*
> *Von unten steigt ein Geruch auf. Nicht modrig – lebendig. Wie nach Regen auf warmer Erde.*

### Auf dem Weg zum Garten der Versteinerung
> *Die Luft wird kühler. Stiller. Die Geräusche des Gefüges – Hämmern, Rufen, Knarren – fallen weg wie Kleidungsstücke, die man ablegt. Was bleibt, ist dein Atem. Und ein Klicken. Leise, regelmäßig. Wie eine Uhr, die zu langsam geht.*
> *Am Wegesrand: ein Busch, dessen Blätter halb Stein sind. Noch grün an den Spitzen, grau an der Basis. Er lebt und stirbt gleichzeitig.*

### Nach der ersten tiefgreifenden Entscheidung
> *Die Luft hat sich verändert. Du weißt nicht, ob es der Wind ist oder etwas anderes. Aber das Summen – der Zerr, der in der Luft lag – ist leiser geworden. Kaum merklich. Aber deine Hände spüren es.*
> *Du stehst still und wartest. Nicht auf etwas. Einfach so.*

[Wenn der Spieler hier verweilt statt weiterzugehen: Die Spinnerin spricht ihn aus der Ferne an. "Du hörst es. Das Gefüge antwortet."]

### Nach einem Misserfolg
> *Du gehst weiter. Hinter dir liegt eine Entscheidung, deren Konsequenz du noch nicht siehst. Vor dir der nächste Weg.*
> *Blender: Vergiss es. Nächstes Mal besser. Vorwärts.*
> *Kern: (schweigt)*
> *Aber du spürst: etwas hat sich verlagert. Im Boden. Im Tragwerk. In dir.*

## Figuren-Interaktionen über Knotenpunkte hinweg

Figuren können sich begegnen, wenn der Wirker genug Beziehungen aufgebaut hat. Diese Begegnungen passieren organisch – der Wirker trifft sie nicht an einem Treffpunkt, sondern bemerkt, dass sie angefangen haben, sich zu bewegen.

### Elara und Brann (Baumeisterin und Flickschuster)
**Auslöser:** Der Wirker hat mit beiden gesprochen und keinen verurteilt.
**Szene:** Am Alten Geflecht. Elara steht vor einer von Branns geflickten Brücken und sagt nichts. Brann kommt dazu. Stille.
Brann: "Sie hält noch."
Elara: "Wie lange?"
Brann: "Keine Ahnung. Ist dir das wichtig?"
Elara, leise: "Neuerdings ja."
→ Möglichkeit, dass Elara beginnt, Tragwerke zu studieren statt nur Fassaden zu bauen.

### Nerea und Cassian (Strömungsleserin und Wegloser)
**Auslöser:** Der Wirker hat Cassian sein Mandat zurückgegeben und Nerea zugehört.
**Szene:** Am Turm des Wegrechts. Nerea steht an einer Kreuzung. Cassian kommt.
Cassian: "Du bist die, die die Strömung liest?"
Nerea: "Du bist der, der die Wege kennt?"
Cassian: "Kannte."
Nerea: "Die Strömung verändert die Wege. Jeden Zyklus. Du kannst sie nicht ein Mal lesen und dann vergessen."
Cassian, langsam nickend: "Dann muss ich neu lernen."
→ Cassian beginnt, die Strömung in seine Wegeplanung einzubeziehen. Dynamisches Wegrecht statt starrer Mandate.

### Thaia und Aldric (Wurzelwächterin und Steinerner)
**Auslöser:** Der Wirker hat im Wurzelwerk gegraben und den Steinernen mehrfach besucht.
**Szene:** Am Rand des Gartens der Versteinerung. Thaia steht und betrachtet die Versteinerten.
Thaia: "Ihre Wurzeln sind noch da. Unter dem Stein. Tief."
Aldric, langsam: "Wurzeln?"
Thaia: "Dein Handwerk ist nicht verschwunden. Es ist versteinert. Wie du. Aber unter der Versteinerung..." Sie kniet nieder und legt die Hand auf den Boden neben ihm. "...hier. Fühlst du das?"
Aldric: "..." Zehn Herzschläge. "Ja."
→ Beschleunigt das Auftauen des Steinernen, wenn der Wirker alle drei Voraussetzungen geschaffen hat.

## Enden

Es gibt keine klassischen Enden. Das Spiel endet, wenn der Spieler aufhört zu erkunden – oder wenn das Gefüge einen neuen Zustand erreicht hat. Die möglichen Zustände:

### Momentum
Das Gefüge hat Schwung gefunden. Tragwerk, Geflecht und Wurzelwerk arbeiten zusammen. Der Zerr hat sich aufgelöst. Nicht alles ist perfekt, aber alles ist lebendig. Die Figuren haben sich bewegt – der Steinerne erzählt, die Baumeisterin baut tiefer, die Wurzelwächterin kommt ans Licht. Kein Sieg, sondern ein Beginn.

### Zerr
Das Gefüge steht unter Spannung. Zu viele schnelle Entscheidungen, zu wenig Tiefe. Die Strömung steigt. Die Fassaden glänzen, aber die Fundamente bröckeln. Nichts ist zusammengebrochen – noch nicht. Aber der Wirker spürt: die nächste Welle wird schwer.

### Versteinerung
Das Gefüge erstarrt. Zu viel Vorsicht, zu wenig Handlung. Der Garten der Versteinerung wächst. Neue Figuren werden zu Stein. Nicht weil jemand es wollte, sondern weil niemand sich bewegt hat.

### Blendwerk-Triumph
Alles glänzt. Der Marktplatz hat sich über das ganze Gefüge ausgebreitet. Fassaden überall. Die Wurzelwächterin ist verschwunden, der Turm des Wegrechts ist eine Ruine mit hübscher Verkleidung. Es sieht aus wie Erfolg. Unter der Oberfläche verdorrt alles. Der Wirker weiß es. Aber ob er es ändern kann, steht auf einem anderen Blatt.

### Das Neue Gefüge
Selten. Erfordert hohe Wirkstärke und konvergente Entscheidungen an mindestens fünf Knotenpunkten. Das Gefüge transformiert sich – nicht in seinen alten Zustand zurück, sondern in etwas Neues. Die Strömung ist nicht langsamer geworden, aber das Gefüge hat gelernt, mit ihr zu arbeiten. Die Baumeisterin und die Wurzelwächterin arbeiten zusammen. Der Steinerne lehrt die Lehrlinge. Nerea wird gehört. Das ist kein Ende – es ist ein Fundament.

### Der Spiegel (Geheim-Ende)
Extrem selten. Erfordert: Erinnerungsquelle besucht, Riss betreten, Spinnerin-Faden erhalten und eingesetzt, alle drei Figuren-Interaktionen ausgelöst.
Der Wirker steht am Kreuzpunkt. Der Brunnen ist klar geworden – klar genug, um den Boden zu sehen. Und auf dem Boden des Brunnens liegt nicht Stein, sondern ein Spiegel. Und in diesem Spiegel sieht der Wirker nicht das Gefüge – er sieht sich selbst. Nicht als Charakter. Als den Menschen, der gerade spielt.
Die Spinnerin tritt neben ihn. "Das Gefüge bist du. War es immer."
Kein Meta-Bruch. Kein Augenzwinkern. Nur eine stille Erkenntnis: dass die Fragen des Gefüges – Tragwerk, Wurzelwerk, Versteinerung, Zerr – die eigenen Fragen sind. Dass Wirken nicht im Spiel beginnt.
[Dieses Ende darf nie angedeutet oder vorbereitet werden. Es passiert, oder es passiert nicht.]

## State-Tracking-Übersicht

Der Erzähler trackt unsichtbar folgende Werte:

### Attribute (Start: 3, Max: 12)
- Sichtweite
- Grundgespür
- Kerntiefe
- Wirkstärke (= Minimum der drei anderen + Konvergenz-Bonus)

### Zähler
- 🔨 Blendwerk-Zähler
- 🌱 Wurzelwerk-Zähler
- 🔗 Kohärenz-Zähler
- 💧 Strömungs-Zähler

### Gedankenkabinett (Status: nicht entdeckt / keimend / reifend / entfaltet)
- Die Quelle
- Der verkehrte Bau
- Die drei Versteinerungen
- Strömungslesen
- Das Gewächshaus
- Zerr und Schwung

### Figuren-Status (vertraut/neutral/misstrauisch + gewandelt ja/nein)
- Elara (Baumeisterin)
- Aldric (Steinerner)
- Thaia (Wurzelwächterin)
- Cassian (Wegloser)
- Nerea (Strömungsleserin)
- Brann (Flickschuster)
- Die Spinnerin

### Verborgene Orte (entdeckt ja/nein)
- Werkstatt unter dem Markt
- Das Gewächshaus
- Die Quelle der Strömung
- Der Riss
- Das Archiv unter dem Turm

### Gegenstände
- Faden der Spinnerin (erhalten / eingesetzt an Ort X)
- Stock mit Faden (von Nerea)
- Buch der Wege (gefunden ja/nein)

### Welt-Zustand
- Wetter (abhängig von Zähler-Verhältnis)
- Welche Figuren sich bewegen (abhängig von Interaktionen)
- Strömungslevel (steigend wenn ignoriert, stabil wenn beachtet)
- Turm-Ordnung (abhängig von Cassian-Entwicklung)
