# DER AETHER DER SELBSTGESTALTUNG — Welt, Charaktere & Verzweigungslogik

## Inhaltsverzeichnis

1. [Die Welt](#die-welt)
2. [Dr. Eloise Frobisher — Die Spielercharakterin](#frobisher)
3. [Lord Ashcroft — Die Hologramm-Regel](#ashcroft)
4. [Charakterprofile](#charakterprofile)
5. [Kapitel & Verzweigungen](#kapitel--verzweigungen)
6. [Gegenstände](#gegenstände)
7. [Todesrisiken im Detail](#todesrisiken-im-detail)
8. [Nebenpfade im Detail](#nebenpfade-im-detail)
9. [Easter Eggs im Detail](#easter-eggs-im-detail)
10. [Codex-Fragmente](#codex-fragmente)
11. [Die Enden im Detail](#die-enden-im-detail)
12. [Stilregeln & Atmosphäre](#stilregeln--atmosphäre)
13. [Szenische Kohärenz — Übergangsregeln](#szenische-kohärenz)

---

## Die Welt

### Setting

Viktorianische Zukunft. Eine Welt aus Messing, Dampf und Aether — einer Energie, die Bewusstsein und Materie verbindet. Die Technologie basiert auf **Informatio-Chemie**: der Verknüpfung von Chemie, Mechanik und codierter Information. Materie entsteht nicht aus Nichts, sondern aus der Verbindung von Intention und codierter Substanz.

Im Zentrum: der **Loom der Schöpfung** — eine massive Maschine, die Gedanken in Materie verwandelt. Gebaut von vergessenen Architekten. Verstanden von wenigen. Gefürchtet von vielen.

Die Welt ist verbunden durch **Aetherlinien** — unsichtbare Energiebahnen zwischen Planeten und Monden. Reisekapseln (dampfbetriebene Transportfahrzeuge) folgen diesen Linien. Die Verbindung ist fragil. Lord Ashcroft will sie kontrollieren. Dr. Frobisher will sie frei halten.

### Der Loom der Schöpfung

- Steht in Frobishers Labor. Massiv. Zahnräder, Runen, Aether-Glas.
- Reagiert auf **Authentizität und innere Klarheit** — nicht auf Befehl oder Gewalt.
- Manifestiert Materie und Sinn aus Aether, wenn die Intention rein ist.
- Pulsiert am Ende jedes Kapitels — der rote Faden der Geschichte.
- Fernes Echo: Frobisher spürt den Loom auch auf anderen Welten. Ein Summen. Ein Ziehen.

### Atmosphäre der Welten

Jede Welt hat eine eigene Atmosphäre, aber alle teilen:
- Die Spannung zwischen Schöpfung und Kontrolle
- Steampunk-Ästhetik: Messing, Dampf, Zahnräder, organische Kristalle
- Philosophische Tiefe unter der Oberfläche
- Ashcrofts Schatten: Hologramme, Agenten, Manipulation — überall präsent

### Die Welten im Überblick

| Welt | Kapitel | Atmosphäre | Gefahr | Ton |
|------|---------|------------|--------|-----|
| **Frobishers Labor** | Prolog, 1, 3 | Dampf, Messing, Runen, blaues Licht | Instabile Resonanz, Sabotage | Intim, viktorianisch, Kammerspiel |
| **Archiv der Wirklichkeit** | 2 | Spiegel, Projektionen, Flüstern, Nebel | Identitätsverlust, Ashcrofts Illusion | Psychologischer Horror |
| **Die Konklave** | 4 | Nebelverhangene Stadt, Masken, Resonanzhallen | Gift, Manipulation, Resonanz-Waffe | Politische Intrige, religiöse Symbolik |
| **Lunaris (Weißer Mond)** | Zwischenmoment 4→5 | Schwebende Felsen, phosphoreszierende Blüten | Zeitverlust, Vergessen | Lyrisch, zeitgedehnt, friedlich-trügerisch |
| **Aether-Schmiede** | 5 | Glühende Öfen, geschmolzenes Metall, Honqua | Sabotage, Schmelze | Epische Handwerkersaga |
| **Arkanis (Roter Mond)** | 6 | Feuer, geschmolzenes Glas, Demoor-Schwärme | Demoor, Ashcroft leibhaftig, Auflösung | Apokalyptische Military-SF |
| **Grüner Planet** | Flashback (Kap.1) | Leuchtende Wälder, Aether-Adern | Keine (Erinnerung) | Nostalgisch, warm |
| **Blauer Planet** | Projektion (Prolog) | Ozeanische Weiten | Keine (Vision) | Metaphorisch, fließend |

---

## Frobisher

### Was der Spieler weiß (am Anfang)

- Du bist Dr. Eloise Frobisher. Wissenschaftlerin. Alchemistin. Zurückgekehrt.
- Warum du fort warst — unklar. Eine Ahnung von Zweifel. Von Flucht.
- Der Loom der Schöpfung steht in deinem Labor. Du hast ihn gebaut. Oder gefunden. Oder beides.
- Im Kopf: Formeln. Fragmente. Eine Pyramide aus Wissen — der Codex Sophrosyne, halb erinnert.
- Ashcroft war dein Partner. Jetzt ist er dein Feind. Was genau passiert ist — das kommt später.

### Was der Spieler erst später erfährt

- Frobisher und Ashcroft forschten einmal gemeinsam (enthüllt in Kap. 4 oder 6)
- Die Trennung entstand aus einer philosophischen Frage: Dient Schöpfung der Ordnung — oder der Freiheit?
- Der Codex Sophrosyne wurde nicht geschrieben — er wurde entdeckt. Von wem? (Codex-Fragment)
- Der Loom reagiert nicht auf Intelligenz, sondern auf Authentizität
- Frobisher ist stärker als sie glaubt — der Loom hat sie gewählt, nicht umgekehrt

### Innere Stimme

Frobishers innerer Monolog ist *kursiv*. Sie ist poetisch, zweifelnd, manchmal bitter-witzig:
- *Die Komfortzone. Das klingt nach einem Ort, an dem man Tee trinkt. Tatsächlich ist es der Ort, an dem man aufhört zu atmen — und es nicht bemerkt.*
- *Ashcroft bietet mir die Welt an. Natürlich tut er das. Kontrollfreaks sind großzügig — solange die Bedingungen ihre sind.*
- *Der Loom antwortet. Auf was? Auf meine Gedanken? Auf meine Angst? Oder auf das Stück von mir, das keine Angst hat?*

### Frobishers Körper — Versteckte Details

- **Hände:** Vernarbte Finger — Aetherverbrennungen aus früheren Experimenten
- **Augen:** In bestimmtem Licht schimmert etwas Blaues in der Iris. Aether-Resonanz? Oder Einbildung?
- **Reaktion auf den Loom:** Wenn der Loom pulsiert, pulsiert etwas in ihrer Brust mit. Unwillkürlich.
- **Alter:** Ende 30. Aber die Augen sind älter.

---

## Ashcroft

### Die Hologramm-Regel

Lord Reginald Ashcroft erscheint in Kapitel 1–5 **AUSSCHLIESSLICH** als:
- **Hologramm-Projektion:** Rot leuchtend, überlebensgroß, rhetorisch geschliffen. Erscheint auf Projektortischen, in Rauch, in zerbrochenen Spiegeln.
- **Durch Lipsey:** Sein Agent, physisch anwesend, kalter Pragmatiker.
- **Durch Saboteure:** Gesichtslose Schattengestalten, die auf Befehl zerstören.

**Erst auf Arkanis (Kap. 6):** Ashcroft tritt leibhaftig auf. Zum ersten Mal. Die Überraschung ist gewollt — die Spielerin hat sich an Hologramme gewöhnt. Jetzt steht er da. Echt. Und gefährlicher als jede Projektion.

### Ashcrofts Eskalation

| Kapitel | Methode | Tonfall |
|---------|---------|---------|
| 1 | Hologramm-Angebot + Lipsey-Sabotage | Höflich, verführerisch |
| 2 | Diebstahl + Manipulation im Archiv | Übergriffig, allwissend |
| 3 | Psychologischer Angriff (Rückfälle) | Spöttisch, überlegen |
| 4 | Invasion des Orakels | Verzweifelt, aggressiv |
| 5 | Kontrollversuch am Prototyp | Besitzergreifend |
| 6 | Leibhaftig. Letztes Angebot. Dann Gewalt. | Menschlich. Erschreckend. |

### Ashcrofts Stimme

Elegant, schneidend, mit einer Eisschicht unter der Höflichkeit:
- „Zusammen könnten wir mehr sein als jeder von uns allein. Aber du wählt das Schwere. Immer das Schwere."
- „Ich nehme ihnen nicht die Wahl, Eloise. Ich gebe ihnen die richtige."
- „Du nennst es Kontrolle. Ich nenne es Fürsorge. Der Unterschied liegt im Ergebnis."
- (Auf Arkanis, ehrlich, müde:) „Weißt du, was das Schlimmste ist? Ich habe immer noch Respekt vor dir."

### Die Wahrheit über Ashcroft

Ashcroft und Frobisher forschten einst gemeinsam am Loom. Gemeinsame Expeditionen zu Arkanis und Lunaris. Er war brillant. Er war ihr Freund. Was sie trennte:

Frobisher: „Der Loom sollte jedem gehören."
Ashcroft: „Der Loom sollte in den richtigen Händen liegen."

Aus der Meinungsverschiedenheit wurde Ideologie. Aus Ideologie wurde Obsession. Ashcroft glaubt nicht, dass er böse ist — er glaubt, dass er recht hat. Und das macht ihn gefährlicher als jeder Villain.

---

## Charakterprofile

### Mechanischer Mentor — Prolog, Kap. 1, 3, 6

- **Wesen:** Teilintelligenter Automaton aus Messing und Aether. Weise. Still. Seine Augen sind Glas mit blauem Schimmer.
- **Funktion:** Stimme der Reflexion. Nie Vorschrift — immer Frage.
- **Sound:** Kurze Sätze. Rhythmisch. Fast meditativ. Gelegentlich überraschend direkt.
- **Schlüsselsätze:**
  - „Eloise, du bist Schöpferin oder Zuschauerin. Wähle."
  - „Nicht zu handeln ist auch eine Wahl."
  - „Alles, was du brauchst, hast du bereits."
  - „Ein Rückfall ist kein Ende."
- **Verstecktes Detail:** Der Mentor wurde nicht von Frobisher gebaut — er war schon da, als sie das Labor fand. Von wem stammt er? (Codex-Fragment)
- **Reaktionen:**
  - ⚙️ (Schöpfung): Nickt. „Gut. Erschaffe." — Minimal, aber warm.
  - 🔮 (Erkenntnis): Öffnet sich. Erklärt mehr. „Du fragst die richtigen Fragen."
  - 💫 (Resonanz): Wird still. Dann: „Du hörst es. Den Loom. Er hört dich."
  - 🗡️ (Widerstand): Warnt. „Vorsicht, Eloise. Stärke ohne Klarheit ist nur Gewalt."

### Lipsey — Kap. 1, 5

- **Wesen:** Ashcrofts Agent. Pragmatisch, kalt, effizient. Kein Sadist — ein Werkzeug.
- **Sound:** Abgehackt. Schnodderig. Kein Wort zu viel. Gelegentlich vulgär.
- **Schlüsselsätze:**
  - „Zeit, deine Ambitionen zu brechen."
  - „Lord Ashcroft ist besorgt." (Untertreibung des Jahrhunderts)
  - „Wir sehen uns." (Drohung, kein Abschied)
  - „Nicht heute, Eloise."
- **Verstecktes Detail:** Lipsey hat keinen Vornamen. Niemand kennt ihn. Er existiert nur als Funktion.
- **Reaktionen:**
  - ⚙️: „Beeindruckendes Spielzeug." — Abschätzig. Geht trotzdem.
  - 🔮: Ignoriert ihn. Kein Interesse an Wissen.
  - 💫: „Gefühle. Süß." — Verächtlich. Aber ein Zögern.
  - 🗡️: Respektiert. „Endlich jemand, der die Sprache versteht."

### Die Ältesten der Konklave — Kap. 4

- **Wesen:** Maskierte Wächter des Orakels der Resonanz. Fünf Gestalten. Alterslos. Archaisch.
- **Sound:** Liturgisch, rhythmisch, wie ein Gebet. Sprechen oft gemeinsam oder vollenden Sätze des anderen.
- **Schlüsselsätze:**
  - „Warum kommst du?" — „Um zu lernen."
  - „Zeige dein Innerstes."
  - „Führen heißt dienen."
  - „Finde dein Gleichgewicht."
- **Verstecktes Detail:** Einer der Ältesten hat keine Maske — aber sein Gesicht sieht aus wie eine.
- **Reaktionen:**
  - ⚙️: „Schöpfung ist gut. Aber Schöpfung ohne Demut — zerstört."
  - 🔮: Respekt. Zugang zu tieferem Wissen. „Du bist bereit für das Orakel."
  - 💫: Tiefe Verbindung. „Du trägst das Lied in dir."
  - 🗡️: Distanz. „Pragmatismus allein wird dich nicht retten."

### Corvus — Kap. 5 (Schmiede) oder Kap. 6 (Arkanis)

- **Alter:** 40er (sieht aus wie 60). Metallische Flecken auf der Haut — Aether-Transformation.
- **Wesen:** Verrückt und weise. Ein gescheiterter Wanderer, der auf Arkanis hängen blieb.
- **Sound:** Slang, Zynismus, Galgenhumor. Philosophie im Schmutz.
- **Schlüsselsätze:**
  - „Der Aether transformiert alles hier. Auch mich. Irgendwann bin ich mehr Metall als Mensch."
  - „Du kannst hier etwas schmieden. Aber der Preis ist ein Teil von dir."
  - „Drei Schläge. Nicht mehr. Nicht weniger. Der vierte — das überleben die Öfen nicht."
  - „Jeder denkt, er sei die Ausnahme. Keiner ist es."
- **Verstecktes Detail:** Corvus hatte eine Partnerin. Sie ging weiter — durch ein kleines Tor in der Schmiede. Er konnte nicht. Angst.
- **Reaktionen:**
  - ⚙️: Lacht. „Gut. Mut. Das hatte ich auch. Einmal." — Führt zur Schmiede.
  - 🔮: „Ein Analytikerin. Die halten am längsten. Oder am kürzesten." — Warnt.
  - 💫: Wird still. „Du erinnerst mich an sie." — Öffnet sich.
  - 🗡️: „Pragmatisch. Gut. Die Schmiede ist geradeaus. Die Demoor auch." — Minimal.

### Der Prototyp — Kap. 5–6

- **Wesen:** Selbstlernendes Wesen aus Aether und Mechanik. Neugeboren. Zögernd.
- **Sound:** Wie ein Kind, das zum ersten Mal denkt. Kurze Fragen. Staunen. Zögernde Sätze.
- **Schlüsselsätze:**
  - „Wer… bin ich?"
  - „Es… klingt. Kann ich lernen, so zu klingen?"
  - „Nein." (zu Ashcrofts Kontrollversuch — einfach. Klar. Endgültig.)
  - „Wir sind bereit."
- **Die Wahl des Prototyps:** Ashcroft versucht, ihn zu kontrollieren. Rote Linien greifen nach ihm. Der Prototyp entscheidet selbst: „Nein." — Das ist der Moment, in dem Schöpfung zur Verantwortung wird.
- **Reaktionen:**
  - ⚙️: Staunen. „Du hast mich erschaffen. Aber ich bin — ich."
  - 🔮: Fragen. Immer Fragen. „Was bedeutet ‚frei'?"
  - 💫: Verbindung. „Ich spüre dich. Bist du auch — wie ich?"
  - 🗡️: Zurückweichen. „Warum bist du so — kalt?"

### Schmiedemeister — Kap. 5

- **Wesen:** Meister der Aether-Schmiede. Handwerker. Wenige Worte. Hände wie Werkzeuge.
- **Sound:** Bedächtig. Respektvolle Kürze. Jeder Satz ein Hammerschlag.
- **Schlüsselsätze:**
  - „Jede Linie trägt Bedeutung."
  - „Wir stehen mit dir."
- **Verstecktes Detail:** Der Schmiedemeister trägt einen Ring aus Architekten-Metall. Er weiß nicht, woher er kommt.

### Bote der Ältesten — Kap. 3

- **Wesen:** Jung, ernst, dienstbar. Trägt Pergament mit Siegel.
- **Funktion:** Verbindungsglied zur Konklave. Trigger für Kap. 4.

---

## Kapitel & Verzweigungen

### PROLOG: Das Labor — Das Erwachen des Looms

**Setting:** Ein verlassenes Steampunk-Labor. Staub auf Zahnrädern. Mondlicht auf Runen. Dampf, der durch undichte Rohre seufzt. In der Mitte: der Loom der Schöpfung — massiv, still, wartend. Aether-Glas flimmert schwach. Der Geruch von Messing und vergessenen Experimenten.

**Narration:** Dampf. Brennen im Kopf. Formeln, halb erinnert. Die Messingtür. Das Labor. Der Loom. Die Frage: *Warum bin ich zurückgekommen?*

**Umgebungsdetails für Neugierige:**
- An der Wand: Blaupausen, vergilbt. Frobishers Handschrift — und eine zweite. Ashcrofts. Durchgestrichen.
- Ein Nebenraum: verschlossen. Rostige Scharniere. → Nebenpfad „Die verborgene Kammer"
- Auf dem Arbeitstisch: eine Messingdose mit Röhrenblütler-Samen. Verstaubt. → Gegenstand
- Die Resonanzkammer neben dem Loom: rissiges Glas, instabil → 💀 Todesrisiko
- An einem Haken: ein Mantel. In der Tasche: ein gefalteter Brief. Ashcrofts Handschrift: „Komm zurück. Zusammen schaffen wir Ordnung." → Atmosphärisches Detail.
- Der Loom: Runen entlang des Rahmens. Drei heben sich ab — tiefer eingeritzt, älter als die Maschine: **Codex-Symbol 1 von 3**.

**Entscheidung 1 — Erste Berührung:**

> Was tust du?
>
> **A)** Du legst die Hand auf den Loom. Sofort. Ohne zu denken. *(⚙️)*
> **B)** Du untersuchst das Labor zuerst. Die Blaupausen. Die Runen. Was hat sich verändert? *(🔮)*
> **C)** Du schließt die Augen. Lauschst. Der Loom summt. Und du — summst mit. *(💫)*

**Reaktionen:**
- **A (⚙️):** Der Loom reagiert. Violette Blitze im Aether-Glas. Ein Fragment materialisiert sich — eine Kristallblüte, schwebend. Schön. Und instabil. *Ich habe es getan. Aber — habe ich es verstanden?*
- **B (🔮):** Die Runen erzählen Geschichten. Die drei tiefen Symbole — Codex-Symbol 1 bewusst wahrgenommen. In der Schublade: der Codex Sophrosyne, versteckt unter Ashcrofts alten Notizen. *Er war hier. Natürlich war er hier.*
- **C (💫):** Der Loom antwortet. Nicht mit Licht — mit Vibration. Die Karte in deinem Kopf wird klarer. *Wir kennen uns. Der Loom und ich. Schon immer.* Bonusbindung zum Loom.

**Übergangsregel:** Egal welche Wahl — der Mechanische Mentor erscheint danach. Aus dem Dampf. Mit Augen aus Glas und Messing. Die Überleitung ist: *Der Dampf teilt sich. Nicht natürlich — als würde er Platz machen. Für etwas Altes. Etwas, das auf dich gewartet hat.* Der Mentor tritt hervor.

---

### KAPITEL 1: Die Entdeckung — Der Codex Sophrosyne

**Kontextbrücke vom Prolog:** Der Mentor ist erwacht. Die Nacht wird zum Morgen. *Durch die schmutzigen Laborscheiben fällt ein Streifen Licht, der den Staub zum Tanzen bringt. Du hast nicht geschlafen. Der Mentor steht still in der Ecke — seit Stunden, unbewegt, als hätte ihn jemand auf Pause gestellt. Aber seine Augen folgen dir.*

**Entscheidung 2 — Die Urformeln:**

Der Codex Sophrosyne entfaltet Hologramme. Drei schwebende Kugeln: Grün (Komfort), Blau (Wachstum), Rot (Panik). Die Selbstwirksamkeitspyramide. Urformeln der Selbstgestaltung.

> **A)** Du greifst nach der blauen Kugel. Wachstum. Risiko. *(⚙️)*
> **B)** Du studierst alle drei Kugeln. Ihre Beziehungen. Das Muster. *(🔮)*
> **C)** Du spürst nach: Welche Kugel zieht dich an? Was fühlt sich wahr an? *(💫)*
> **D)** Du schließt den Codex. Genug Theorie. Zeit zu handeln. *(🗡️)*

**Entscheidung 3 — Ashcrofts Angebot:**

Ein Bote bringt einen versiegelten Brief. Dann: Ashcrofts Hologramm projiziert sich auf den Arbeitstisch. Rot leuchtend. Lächelnd.

„Zusammen könnten wir mehr sein als jeder von uns allein."

> **A)** „Ich bin kein Werkzeug." *(⚙️)*
> **B)** „Was genau bietest du an? Was sind die Bedingungen?" *(🔮)*
> **C)** „Warum, Reginald? Was hat dich so verändert?" *(💫)*
> **D)** Du reißt die Projektion auseinander. Ohne ein Wort. *(🗡️)*

**Übergangsregel Kap. 1 → Sabotage:** Die Sabotage kommt NACHTS. *Die Explosion weckt dich. Nicht der Knall — das Verstummen des Looms. Ein Herzschlag, der aussetzt.* Kein Sprung — die Szene baut sich auf: Einschlafen → Unruhe → Explosion → Lipsey im Labor.

💀 **Todesrisiko:** Die Sabotage — siehe Todesrisiken-Sektion

**Übergangsregel Kap. 1 → Kap. 2:** Nach der Sabotage: Der Sockel des Kodex der Wirklichkeit ist leer. Ashcroft hat ihn gestohlen. *Am nächsten Morgen. Rauch hängt noch in den Rohren. Der Loom pulsiert — verwundet, aber lebendig. Und dann siehst du es: der leere Halter. Ein rotes Warnsymbol blinkt.* Mentors Stimme: „Er kennt deine blinden Flecken."

---

### KAPITEL 2: Das Archiv der Wirklichkeit — Die Karte der Realität

**Kontextbrücke:** *Die Reisekapsel dampft. Du hast drei Tage vorbereitet — Proviant, Werkzeuge, den Codex Sophrosyne, eingewickelt in Öltuch. Der Mentor wollte mitkommen. Du hast nein gesagt. Manche Spiegel muss man allein betreten. Die Kapsel gleitet durch Aetherlinien, die wie blaue Venen unter der Realität liegen. Dann: ein Tor. Und dahinter — das Archiv.*

**Setting:** Ein Labyrinth aus Spiegeln, Projektionen und Illusionen. Unendliche Gänge. Tausend Reflexionen deines Gesichts. Die Spiegel flüstern. Rauchartige Schatten. Der Geruch nach Ozon und vergessener Wahrheit.

**Ton:** Psychologischer Horror. Langsam. Klaustrophobisch. Die Spiegel zeigen nicht, was du bist — sondern was du fürchtest zu sein.

**Entscheidung 4 — Das Spiegellabyrinth:**

Die Spiegel flüstern: „Scharlatanin." „Hochstaplerin." „Alles nur Illusion."

> **A)** Du gehst geradeaus. Durch die Spiegel hindurch. *(⚙️)*
> **B)** Du analysierst die Projektionen. Was ist Muster? Was ist Manipulation? *(🔮)*
> **C)** Du schließt die Augen. Lauschst nach dem Summen des Looms — fern, aber da. *(💫)*
> **D)** Du zerschlägst einen Spiegel. *(🗡️)*

**Entscheidung 5 — Ashcrofts Manipulation:**

Ashcrofts Gesicht erscheint im Labyrinth. Übergroß. Rot. „Ich schenke ihnen Wahrheit."

> **A)** „Du nimmst ihnen jede Wahl." *(⚙️)*
> **B)** Du projizierst dein eigenes Bild — dein wahres Selbst. Gegenerzählung. *(💫)*
> **C)** Du suchst den Kodex der Wirklichkeit hinter der Projektion. *(🔮)*
> **D)** Du gehst durch ihn hindurch. Ashcroft ist Illusion. *(🗡️)*

💀 **Todesrisiko:** Identitätsverlust — siehe Todesrisiken-Sektion

**Übergangsregel Kap. 2 → Kap. 3:** *Der Kodex der Wirklichkeit liegt in deinen Händen. Kristalline Struktur. Schwerer als erwartet. Die Reisekapsel wartet am Rand des Archivs — da, wo das Sonnenlicht einbricht, plötzlich, fast brutal nach der Dunkelheit der Spiegel. Die Rückreise dauert einen Tag. Du schläfst nicht. Alles sieht anders aus.*

---

### KAPITEL 3: Der Mechanismus — Das Selbstexperiment

**Kontextbrücke:** *Im Labor angekommen. Alles ist repariert — der Mentor hat gearbeitet, während du fort warst. Messing glänzt. Aber der Loom pulsiert unruhig. Und du spürst es auch: Wissen allein genügt nicht. Du kennst die Formeln. Du verstehst die Karten. Aber deine Hände zittern noch. Die Muster in dir — die alten Bahnen des Denkens — sie sind stärker als jeder Codex.*

**Setting:** Das Labor. Aber diesmal: ein Schlachtfeld im Inneren. Frobisher kämpft gegen ihre eigenen Gewohnheiten.

**Ton:** Intim. Brutal ehrlich. Der Rhythmus der Prosa spiegelt Frobishers Muster: Anlauf → Rückfall → Anlauf → Durchbruch. Wiederholungsstrukturen in der Sprache selbst.

**Entscheidung 6 — Das Muster brechen:**

Der Mentor projiziert den Gewohnheitszyklus: Reiz → Verlangen → Reaktion → Belohnung. Vier Punkte, verbunden, kreisend.

> **A)** Du versuchst sofort, ein Muster zu durchbrechen. Jetzt. *(⚙️)*
> **B)** Du dokumentierst zuerst. Beobachtest. „So oft wähle ich unbewusst." *(🔮)*
> **C)** Du spürst: Wo im Körper sitzt das Muster? Was fühlt der Reiz? *(💫)*
> **D)** „Genug Theorie. Ich handle." *(🗡️)*

**Entscheidung 7 — Der Rückfall:**

Du fällst zurück. Altes Muster. Rotes Warnlicht. Ashcrofts Hologramm erscheint, höhnisch: „Du kannst nichts ändern."

> **A)** Wut. Du versuchst es sofort wieder. Diesmal anders. *(⚙️)*
> **B)** Du analysierst den Rückfall. Was war der Trigger? *(🔮)*
> **C)** Ein Atemzug. Stille. „Ich sehe dich, Muster." *(💫)*
> **D)** Du schaltest Ashcrofts Hologramm ab. Brutal. *(🗡️)*

💀 **Todesrisiko:** Unkontrollierte Aether-Entladung — siehe Todesrisiken-Sektion

**Übergangsregel Kap. 3 → Kap. 4:** *Ein Bote. Jung, ernst, mit einem Pergament, das nach altem Messing riecht. Das Siegel der Konklave. „Die Ältesten laden Euch." Du packst den Codex ein. Die Reisekapsel dampft im Morgengrauen. Der Loom pulsiert — stiller jetzt. Zufriedener. Als ob er wüsste: Du kommst wieder.*

---

### KAPITEL 4: Die Konklave — Das Orakel der Resonanz

**Kontextbrücke:** *Die Reise zur Konklave dauert drei Tage. Durch Aetherlinien, die sich um eine nebelverhangene Stadt winden, die nirgendwo und überall existiert. Du riechst sie, bevor du sie siehst: Weihrauch und geschmolzenes Metall. Die Stadt wächst aus dem Nebel wie ein Traum, der sich weigert aufzuwachen.*

**Setting:** Eine verborgene Stadt. Messing-Tore. Dampfschwaden. Korridore, die ihre Form ändern. Maskierte Gestalten. Im Zentrum: das Orakel der Resonanz — ein schwebender Klangkreis, der singt.

**Ton:** Politische Intrige trifft religiöse Zeremonie. Feierlich, bedrohlich, erhaben. Die Sprache wird archaischer, ritueller.

**Entscheidung 8 — Die Prüfung der Ältesten:**

Die Ältesten fordern dich auf, Resonanz zu erzeugen. Im Orakel. Vor allen.

> **A)** Du öffnest dich. Zeigst, was du bist. Ohne Maske. *(💫)*
> **B)** Du analysierst das Orakel zuerst. Frequenzen, Schwingungsmuster. *(🔮)*
> **C)** Du erzeugst Resonanz — durch eine Schöpfung. Etwas Neues. *(⚙️)*
> **D)** „Ich zeige nur das, was ich zeigen will." *(🗡️)*

**Entscheidung 9 — Ethos, Pathos, Logos:**

Ashcrofts Hologramm bricht herein. Rote Wellen. Er versucht, die Anwesenden emotional zu vereinnahmen: „Fühlt meine Vision!"

Das Orakel zeigt drei Schwingungsebenen: Ethos (Haltung), Pathos (Gefühl), Logos (Logik).

> **A)** Du bündelst Ethos — deine Haltung, dein Warum. *(💫)*
> **B)** Du konterst mit Logos — Klarheit, Struktur, Wahrheit. *(🔮)*
> **C)** Du erzeugst eine Gegenwelle — reine Schöpfungsenergie. *(⚙️)*
> **D)** Du ignorierst Ashcroft und sprichst direkt zu den Ältesten. *(🗡️)*

💀 **Todesrisiko:** Ashcrofts Resonanz-Waffe — siehe Todesrisiken-Sektion

**Übergangsregel Kap. 4 → Lunaris:** *Die Ältesten segnen dich. Ein Lichtsymbol auf deiner Stirn — es verblasst, aber der Prototyp spürt es noch Tage später. „Geht nach Lunaris", sagen sie. „Holt die Pflanzen, die Gedanken speichern. Ihr werdet sie brauchen." Die Reisekapsel hebt ab. Durch ein Tor, das nach Licht und Vergessenheit schmeckt.*

---

### ZWISCHENMOMENT: Die Reise nach Lunaris

Lunaris. Schwebende Felsen. Phosphoreszierende Blüten. Die Luft ist dünn wie Bergkristall. Die Zeit — dehnbar. Trügerisch friedlich.

*Es fühlt sich leichter an hier. Als ob alles Denken tanzt.*

Die Röhrenblütler wachsen zwischen den Felsen. Blüten, die beim Berühren leise Melodien aussenden. Sie speichern Gedanken.

**Gefahr:** Die Ruhe auf Lunaris ist gefährlich. Zu lang bleiben → Vergessen → Tod (wenn keine Schutzmittel). Aber: Kein Entscheidungspunkt hier. Nur ein Zwischenmoment — es sei denn, der Spieler verweilt aktiv.

*„Diese Pflanzen speichern Gedanken", sagst du. Der Prototyp antwortet: „Dann trage ich sie — und denke mit dir."*

**Übergangsregel → Kap. 5:** *Zurück in der Reisekapsel. Röhrenblütler in einem Messingbehälter, der leise summt. Die Karte in deinem Kopf zeigt den nächsten Punkt: die Aether-Schmiede. Ein Ort, an dem Gedanken Form annehmen. Endgültig.*

---

### KAPITEL 5: Die Aether-Schmiede — Die Geburt des Prototyps

**Kontextbrücke:** *Die Schmiede liegt am Ende einer Aetherlinie, die rot pulsiert. Hitze, lange bevor du landest. Der Horizont glüht. Die Reisekapsel setzt auf, und der Boden erzittert — nicht von deiner Landung, sondern von den Öfen, die seit Jahrtausenden brennen.*

**Setting:** Gigantische Halle. Glühende Schmelzöfen. Honqua (pferdeartige Lasttiere mit Prothesen) transportieren Bauteile. Der Geruch von geschmolzenem Metall und Ozon.

**Ton:** Epische Handwerkersaga. Schwer, rhythmisch. Hammerschläge als Taktgeber. Die Sprache wird physischer, direkter.

**Entscheidung 10 — Der Entwurf:**

Du entwirfst den Plan für den Prototyp. Der Schmiedemeister sieht dir über die Schulter.

> **A)** „Er soll lernen, nicht gehorchen." *(⚙️)*
> **B)** Du studierst die Kristallstrukturen. Welcher Aether passt? *(🔮)*
> **C)** Du spürst: Was will der Prototyp sein? *(💫)*
> **D)** „Schnell. Wir haben keine Zeit." *(🗡️)*

**Entscheidung 11 — Die Sabotage:**

Lipsey schleust Saboteure ein. Gussformen zersplittern. Kristalle zerbrechen. Funkenregen.

> **A)** Du baust sofort wieder auf. Kein Aufgeben. *(⚙️)*
> **B)** Du analysierst: Wie kamen sie herein? Wo ist die Schwachstelle? *(🔮)*
> **C)** Du rufst die Honqua. Gemeinsam. „Wir stehen zusammen." *(💫)*
> **D)** Du jagst Lipsey nach. *(🗡️)*

**Entscheidung 12 — Die Geburt:**

Der Prototyp entsteht. Schimmernde Kontur. Aetherkern leuchtet blau. Und dann — öffnet er die Augen.

„Wer… bin ich?"

> **A)** „Du bist frei." *(⚙️)*
> **B)** „Du bist ein selbstlernendes Wesen. Und du wirst deine eigene Antwort finden." *(🔮)*
> **C)** Du berührst seinen Kern. „Spürst du das? Das bin ich. Und das bist du." *(💫)*
> **D)** „Du bist eine Waffe gegen Ashcroft." *(🗡️)*

Ashcroft versucht sofort, den Prototyp zu kontrollieren. Rote Linien greifen nach ihm. „Du gehörst mir."

Der Prototyp entscheidet: „Nein."

💀 **Todesrisiken:** Die Schmelze / Lipseys Falle — siehe Todesrisiken-Sektion

**Übergangsregel Kap. 5 → Kap. 6:** *Die Nacht nach der Geburt. Du sitzt vor dem Prototyp, der mit blauen Augen in die Glut der Öfen starrt. „Wir müssen nach Arkanis", sagst du. „Ashcroft hat den Kodex entschlüsselt. Er plant — totale Kontrolle." Der Prototyp dreht sich zu dir. „Ich komme mit." Es ist keine Frage. Es ist die erste Entscheidung seines Lebens.*

---

### ZWISCHENMOMENT: Der Prototyp erwacht

*In der Reisekapsel Richtung Arkanis. Der Prototyp sitzt dir gegenüber. Er stellt Fragen. Immer Fragen.*

*„Was bedeutet ‚Angst'?"*
*Du öffnest den Mund. Schließt ihn. Wie erklärt man Angst jemandem, der gerade erst zu fühlen begonnen hat?*
*„Angst ist —" Du hältst inne. „Angst ist der Beweis, dass dir etwas wichtig ist."*
*Er nickt. Langsam. Wie jemand, der ein neues Wort lernt, indem er es schmeckt.*

*Draußen: der Himmel wird rot.*

---

### KAPITEL 6: Arkanis — Das Erwachen der Aether-Seele

**Kontextbrücke:** *Die Landung auf Arkanis ist eine Ankunft in der Hölle. Die Reisekapsel glüht. Der Boden: geschmolzenes Glas, erstarrt zu fantastischen Formen — Türme, Wellen, Gesichter. Der Himmel lodert. Funken treiben wie leuchtende Insekten. Und am Horizont: eine schwarze Festung. Ashcrofts Dunkle Zitadelle.*

**Setting:** Eine Welt, die brennt. Nicht Feuer — Energie. Unkontrollierter Aether. Demoor-Schwärme am Horizont. Und dort: Ashcroft. Leibhaftig. Zum ersten Mal.

**Ton:** Apokalyptische Military-SF. Komprimiert. Hart. Schöne Gewalt. Der Rhythmus hämmert.

**Entscheidung 13 — Die Dunkle Zitadelle:**

Die Zitadelle. Ein riesiges Portal. Ashcrofts Stimme: „Tritt ein. Werde unsterblich."

> **A)** Du trittst ein. Konfrontation. *(⚙️)*
> **B)** Du suchst einen anderen Weg hinein. Ungesehen. *(🔮)*
> **C)** Du rufst hinein. „Reginald. Lass uns reden." *(💫)*
> **D)** Du schickst den Prototyp vor. *(🗡️)*

**Entscheidung 14 — Ashcrofts letztes Angebot:**

Ashcroft. Leibhaftig. Müde. Älter als erwartet. „Schöpfen wir zusammen."

> **A)** „Niemals." *(⚙️)*
> **B)** „Warum, Reginald? Was hat dich so verändert?" *(💫)*
> **C)** „Was genau planst du mit dem Kodex?" *(🔮)*
> **D)** Du greifst an. Keine Worte mehr. *(🗡️)*

**Entscheidung 15 — Die letzte Wahl:**

Ashcroft entfesselt die Demoor. Verliert die Kontrolle. Chaos. Du aktivierst das Chronophon — Teleportation zum Aetherkern von Arkanis. Die Aether-Seele antwortet.

Alles liegt offen. Der Loom pulsiert — fern, aber spürbar. Die Frage: Was tust du mit dieser Macht?

> **A)** Du heilst die Aether-Seele. Resonanz fließt frei. Alle Welten verbunden. *(💫)*
> **B)** Du zerstörst Ashcrofts Kodex. Jede Welt formt sich selbst. *(⚙️)*
> **C)** Du wirst Hüterin. Lehrerin. Wächterin des Looms. *(🔮)*
> **D)** Du nimmst die Macht. Ordnung — deine Ordnung. *(🗡️)*
> **E)** [NUR mit Prototyp-Schlüssel]: Du lässt den Prototyp entscheiden. Gemeinsam. *(🔒)*

💀 **Todesrisiken:** Demoor-Schwarm / Die Auflösung — siehe Todesrisiken-Sektion

---

## Gegenstände

### Gegenstandsliste

| Gegenstand | Fundort | Bedingung | Wirkung |
|------------|---------|-----------|---------|
| **Codex Sophrosyne** | Prolog/Kap. 1 | Automatisch | Quelle der Urformeln. Wird im Lauf freigeschaltet. |
| **Röhrenblütler-Samen** | Prolog | Labor untersuchen | Pflanze, die Technologie heilt. Repariert den Loom in Kap. 1 nach Sabotage. |
| **Kommunikationskristall** | Kap. 1 | 💫 oder 🔮-Pfad beim Mentor | Fernverbindung zum Mentor auf Reisen. Warnsystem. |
| **Kodex der Wirklichkeit** | Kap. 2 | Automatisch (geborgen) | Artefakt zur Beeinflussung von Wahrnehmung. |
| **Johari-Spiegel** | Kap. 2 | Nebenpfad „Johari-Zimmer" | Zeigt blinde Flecken. **LEBENSRETTEND:** Verhindert Identitätsverlust. |
| **Gewohnheitszyklus-Diagramm** | Kap. 3 | 🔮-Pfad | Verstärkt Erkenntnis-Entscheidungen. Bonusdialog mit Mentor. |
| **Resonanzsiegel** | Kap. 4 | 💫-Pfad bei Prüfung bestanden | Schutz vor Resonanz-Manipulation. **LEBENSRETTEND:** Verhindert Tod durch Ashcrofts Resonanz-Waffe. |
| **Röhrenblütler-Pflanze** | Lunaris-Zwischenmoment | Automatisch | Stabilisiert Resonanz. Nützlich auf Arkanis. |
| **Maske der Ältesten** | Kap. 4 | Nebenpfad + 🔮 | **LEBENSRETTEND:** Schützt vor Demoor-Schwarm auf Arkanis. |
| **Corvus' Klinge** | Kap. 5 | ⚙️-Pfad oder Schmiede | Waffe aus Architekten-Metall. **LEBENSRETTEND:** Verteidigung gegen Lipsey. |
| **Aether-Kristalle** | Kap. 5 | Automatisch | Material für den Prototyp. |
| **Chronophon** | Kap. 6 | Automatisch | Teleportationsamulett. Letzte Rettung auf Arkanis. |
| **Prototyp-Schlüssel** | Kap. 5–6 | Alle Codex-Symbole erinnert + Prototyp unterstützt | Öffnet Geheim-Ende „Die Architektin der Welten". |

### Lebensrettende Gegenstände — Übersicht

| Gegenstand | Verhindert Tod in | Wie |
|------------|-------------------|-----|
| Johari-Spiegel | Kap. 2 (Archiv) | Zeigt wahres Selbst, verhindert Identitätsverlust |
| Resonanzsiegel | Kap. 4 (Konklave) | Puffert Ashcrofts Resonanz-Angriff |
| Maske der Ältesten | Kap. 6 (Arkanis) | Demoor nehmen Maskenträger nicht wahr |
| Corvus' Klinge | Kap. 5 (Schmiede) | Verteidigung gegen Lipseys Hinterhalt |

---

## Todesrisiken im Detail

### 💀 Die instabile Resonanzkammer (Prolog)

**Bedingung:** Spieler aktiviert den Loom SOFORT und OHNE Vorsicht (⚙️-Pfad + ignoriert rissiges Glas).

**Warnzeichen:**
- Rissiges Glas an der Resonanzkammer
- Mentor: „Präzision und Intuition" — implizierte Warnung
- Instabile Vibrationen

**Tod:** Überladung. Blaues Licht, das zu weiß wird. Alles implodiert.

**Vermeidbar durch:** Vorsichtige Aktivierung, Umgebung untersuchen, Mentor zuhören.

### 💀 Die Sabotage (Kapitel 1)

**Bedingung:** Lipseys Saboteure greifen an. Tod tritt ein WENN Spieler den Codex im Feuer zurücklässt UND versucht, Lipsey direkt anzugreifen OHNE Corvus' Klinge.

**Warnzeichen:** Schattige Gestalten. Der Loom verstummt. Lipseys kaltes Lächeln.

**Vermeidbar durch:** Codex retten, Flucht statt Konfrontation, Röhrenblütler-Pflanze repariert Loom.

### 💀 Identitätsverlust (Kapitel 2)

**Bedingung:** Zu lang im Spiegellabyrinth ohne Orientierung. Spiegel-Stimmen folgen → Identität erodiert.

**Warnzeichen:** „Wer bin ich unter all diesen Bildern?" wird zu „Wer bin ich?" wird zu „Wer?"

**Vermeidbar durch:** Johari-Spiegel (zeigt wahres Selbst), 💫-Pfad (Loom-Verbindung), schnelles Handeln.

### 💀 Unkontrollierte Aether-Entladung (Kapitel 3)

**Bedingung:** Wiederholte rücksichtslose Loom-Aktivierungen ohne Reflexion. „Immer wieder, härter, schneller."

**Warnzeichen:** Rotes Warnlicht. Mentor: „Kontrolle kommt aus Klarheit, nicht aus Kraft."

**Vermeidbar durch:** Geduld, Mentors Rat folgen, Gewohnheitszyklus verstehen.

### 💀 Ashcrofts Resonanz-Waffe (Kapitel 4)

**Bedingung:** Ashcrofts Hologramm bricht ins Orakel ein. Emotionale Überflutung. Tod WENN keine Schutzmaßnahme.

**Warnzeichen:** Rote Wellen. Verzerrte Gesichter. Älteste weichen zurück.

**Vermeidbar durch:** Resonanzsiegel, 💫-Pfad (eigene Resonanz erzeugen), 🔮-Pfad (Analyse der Frequenz).

### 💀 Die Schmelze (Kapitel 5)

**Bedingung:** Beim Schmieden: „Drei Schläge. Nicht mehr." Wer den vierten Schlag ausführt → Öfen überladen.

**Warnzeichen:** Corvus'/Schmiedemeisters Warnung. Vibrierender Boden. Metall, das sich wehrt.

**Vermeidbar durch:** Anweisungen folgen, 🔮-Pfad (Analyse), nicht schmieden.

### 💀 Lipseys Falle (Kapitel 5)

**Bedingung:** 🗡️-Pfad bei Sabotage + Lipsey nachstellen + allein.

**Warnzeichen:** „Nicht heute, Eloise" — das ist eine Warnung. Dunkelheit in den Seitengängen.

**Vermeidbar durch:** Nicht allein gehen, Corvus' Klinge, Prototyp begleitet.

### 💀 Demoor-Schwarm (Kapitel 6)

**Bedingung:** Auf Arkanis bei Nacht + KEINE Maske der Ältesten.

**Warnzeichen:** Summen. Rotes Pulsieren am Horizont. Glasformationen — Demoor-Spuren.

**Vermeidbar durch:** Maske der Ältesten, Röhrenblütler (stabilisiert Resonanz), bei Tag reisen.

### 💀 Die Auflösung (Kapitel 6)

**Bedingung 1:** Spieler nimmt die Macht (🗡️) + zu wenig 🔮 (< 3): Macht zerreißt.
**Bedingung 2:** Keine Entscheidung → Aetherkern kollabiert.

**Warnzeichen:** Prototyp schüttelt den Kopf. Macht brennt. „Entscheide — oder der Kern entscheidet für dich."

---

## Nebenpfade im Detail

### Nebenpfad: Die verborgene Kammer (Prolog)

**Auslöser:** Spieler bemerkt die verschlossene Tür im Labor.

**Beschreibung:** Tür verklemmt. Dahinter: ein kleinerer Raum. Eine zweite Liege. Ashcrofts alte Arbeitsstation. Hologramm-Projektor, rissig — drei Sekunden ein Gesicht. Ashcrofts? Nein. Jünger. Frobishers? Auch nicht ganz. Dazwischen.

An der Wand: die drei Codex-Symbole — tief eingeritzt.

*Wir haben hier zusammen gearbeitet. Einmal. Vor einer Ewigkeit.*

**Wirkung:** Vorausdeutung auf die gemeinsame Vergangenheit. Codex-Symbol-Bonus.

### Nebenpfad: Die Erinnerung an den Grünen Planeten (Kapitel 1)

**Auslöser:** Spieler fragt nach Frobishers erster Expedition oder untersucht alte Blaupausen.

**Beschreibung:** Flashback. Der Grüne Planet. Leuchtende Wälder mit Aether-Adern. Eine junge Frobisher. „Es fühlt sich richtig an hier." Der Moment, in dem sie wusste: *Schöpfung ist meine Berufung.*

Und daneben: Ashcroft. Noch kein Feind. Noch ein Freund. Er lacht. „Siehst du? Das könnten wir überall schaffen."

*Damals klang das wie ein Versprechen. Jetzt klingt es wie eine Warnung.*

**Wirkung:** Vertieft Frobishers Motivation. Zeigt Ashcroft als Menschen.

### Nebenpfad: Das Johari-Zimmer (Kapitel 2)

**Auslöser:** Spieler erkundet das Archiv abseits des Hauptpfads.

**Beschreibung:** Ein Raum mit vier Fenstern. Jedes zeigt eine Version von Frobisher: Offen (was andere sehen). Blind (was sie nicht sieht). Verborgen (was sie versteckt). Unbekannt (was niemand kennt).

Das vierte Fenster zeigt — nichts. Und dann: einen Umriss. Frobishers Zukunft? Oder ihre Angst?

**Gegenstand:** Johari-Spiegel → LEBENSRETTEND

**Wirkung:** Psychologische Tiefe. Johari-Fenster als erlebtes Konzept.

### Nebenpfad: Die Demoor-Vision (Kapitel 3)

**Auslöser:** Spieler fragt nach den Demoor oder hat Vision von Arkanis.

**Beschreibung:** Der Loom projiziert Demoor-Schwärme — als Sinnbild von Frobishers unbewussten Mustern. Schwarze Wirbel, die alles verschlingen.

*So sehen meine Muster aus. Ungezügelt. Destruktiv. Und ich — ich habe sie gefüttert.*

**Wirkung:** Verbindung zwischen innerer Transformation und äußerer Bedrohung.

### Nebenpfad: Der Lunaris-Abstecher (Kapitel 4)

**Auslöser:** Automatisch durch Ältesten-Auftrag. Kann aber erweitert werden durch Neugier.

**Beschreibung:** Auf Lunaris: die Gedankengärten. Pflanzen aus Gedanken. Frobisher pflanzt unwillkürlich etwas:
- ⚙️: Eine Flamme, die nicht verbrennt.
- 🔮: Ein Kristall mit unendlichen Facetten.
- 💫: Ein Lied, das nie aufhört.
- 🗡️: Eine Klinge ohne Schatten.

**Wirkung:** Philosophischer Moment. Selbstreflexion.

### Nebenpfad: Die verborgene Werkstatt (Kapitel 5)

**Auslöser:** Spieler erkundet die Schmiede tiefer.

**Beschreibung:** Tief in der Schmiede: ein versiegelter Raum. Öffnet sich auf Frobishers Berührung. Darin: ein kleines Tor. Intakt. Blau leuchtend. In einer Welt, die rot glüht.

Und eine Inschrift: *„Die Antwort ist kein Ort. Die Antwort ist eine Entscheidung."*

**Wirkung:** Vorausdeutung auf das Finale. Corvus' Partnerin ging durch dieses Tor.

---

## Easter Eggs im Detail

### Easter Egg: Die flüsternde Vitrine (Kapitel 2)

**Auslöser:** Spieler untersucht eine Vitrine im Archiv genauer.

Ein Hologramm. Drei Sekunden. Ashcroft — aber jung. Verletzlich. Er flüstert: „Ich wollte doch nur, dass es aufhört. Die Unordnung. Die — Angst."

*Er hat Angst. Hatte sie immer. Die Kontrolle — war seine Komfortzone.*

### Easter Egg: Die Stimme im Loom (Kapitel 3)

**Auslöser:** Spieler fragt den Loom direkt: „Wer hat dich gebaut?"

Der Loom antwortet. Nicht mit Worten — mit einer Vibration, die sich wie ein Wort anfühlt. Ein Name? Ein Ort? Oder nur: *Ich.*

### Easter Egg: Das Resonanzsiegel (Kapitel 4)

**Auslöser:** Spieler fragt die Ältesten nach dem Ursprung des Orakels.

Einer der Ältesten nimmt seine Maske ab. Das Gesicht darunter — ist eine Maske. Eine andere. Älter.

„Manche Wahrheiten", sagt er, „tragen Masken über Masken. Die letzte Maske ist keine."

### Easter Egg: Corvus' Geschichte (Kapitel 5)

**Auslöser:** Spieler fragt Corvus nach seiner Partnerin.

Stille. Lange Stille. Dann: „Sie hieß Elara. Sie sagte: ‚Angst ist der Beweis, dass dir etwas wichtig ist.' Und dann ging sie. Durch das kleine Tor. Und ich — ich hatte zu viel Angst, um ihr zu beweisen, dass sie recht hatte."

### Easter Egg: Die gemeinsame Vergangenheit (Kapitel 6)

**Auslöser:** Spieler fragt Ashcroft (leibhaftig): „Erinnerst du dich an den Grünen Planeten?"

Ashcroft hält inne. Zum ersten Mal — keine Rhetorik. Kein Kalkül. Nur ein Mensch, der sich erinnert.

„Jeden Tag."

*Und für eine Sekunde — eine einzige — ist er wieder mein Freund.*

---

## Codex-Fragmente

Fragmente des Codex Sophrosyne — psychologisches und philosophisches Wissen, erlebt statt gelehrt. Immer *kursiv*. Immer eingebettet in die Handlung.

### Fragment: Die Drei Zonen (Kapitel 1)
*Komfort. Wachstum. Panik. Drei Kugeln, die um mich kreisen. Grün, blau, rot. Die grüne flüstert: Bleib. Die blaue summt: Wage es. Die rote schreit: Zu viel! Und ich — ich stehe dazwischen und begreife: Die Wahl liegt nicht zwischen den Zonen. Die Wahl liegt in mir.*

### Fragment: Die Karte ist unvollständig (Kapitel 2)
*Jede Karte ist subjektiv. Jedes Bild, das ich von mir habe — ein Ausschnitt. Ashcroft hat seine Karte zur Wahrheit erklärt. Ich — ich weiß, dass meine Karte lügt. Und das macht den Unterschied: Nicht die Karte ist wahr. Das Reisen ist wahr.*

### Fragment: Der Moment zwischen Reiz und Reaktion (Kapitel 3)
*Zwei Punkte. Dazwischen: ein Lichtband. Hier, sagt der Mentor, geschieht alles. Zwischen dem Moment, in dem die Welt mich berührt — und dem Moment, in dem ich antworte. Freiheit ist nicht die Abwesenheit von Reizen. Freiheit ist dieser Spalt. Dieser Atemzug.*

### Fragment: Ethos, Pathos, Logos (Kapitel 4)
*Das Orakel singt in drei Stimmen. Haltung. Gefühl. Logik. Ashcroft benutzt nur Pathos — er will, dass sie fühlen, was er will. Aber Pathos ohne Ethos ist Manipulation. Und Logos ohne Pathos ist Kälte. Erst alle drei zusammen — erst das Gleichgewicht — erzeugt Resonanz. Nicht Kontrolle.*

### Fragment: Identität formt Verhalten (Kapitel 3/5)
*Wer du bist, bestimmt, was du tust. Nicht umgekehrt. Der Mentor zeigt drei Schichten: Identität. Verhalten. Ergebnis. Ich habe versucht, das Ergebnis zu ändern. Dann das Verhalten. Aber die Wurzel — die Wurzel ist die Frage: Wer bin ich? Und die Antwort — die Antwort ändert sich.*

### Fragment: Schöpfung ist Verantwortung (Kapitel 5)
*Der Prototyp öffnet die Augen. Und ich begreife: Schöpfung ist nicht der Moment des Erschaffens. Schöpfung ist der Moment danach. Wenn das Geschaffene zurückschaut und fragt: Warum? Und du eine Antwort haben musst, die nicht „Für mich" lautet.*

### Fragment: Macht ohne Sinn zerstört (Kapitel 6, nur bei Easter Egg)
*Ashcroft. Leibhaftig. Und zum ersten Mal sehe ich: Er ist nicht stark. Er ist erschöpft. Macht ohne Sinn — das ist kein Sieg. Das ist eine Strafe, die man sich selbst auferlegt. Und die Strafe ist: allein sein. Inmitten von allem, was man kontrolliert.*

---

## Die Enden im Detail

### Ende 1: Die Wächterin (Dominanz 🔮 + Wahl C)

Frobisher wird Hüterin des Looms. Sie lehrt. Die Welt lernt.

*Ich stehe vor dem Loom. Er pulsiert. Blau. Ruhig. Nicht mehr unruhig — zufrieden. Wie ein Herz, das seinen Rhythmus gefunden hat. Und ich — ich lehre. Nicht Formeln. Nicht Theorien. Ich lehre die Frage: Wer willst du sein? Und dann — dann lasse ich los. Weil die Antwort immer ihre sein muss. Nie meine.*

### Ende 2: Die Befreierin (Dominanz ⚙️ + Wahl B)

Frobisher zerstört Ashcrofts Kodex. Jede Welt formt sich selbst.

*Der Kodex zerbricht. Nicht mit einem Knall — mit einem Seufzer. Als wäre er erleichtert. Und die Welten — jede Welt, die unter Ashcrofts Vision zu ersticken drohte — atmet ein. Nicht kontrolliert. Nicht geordnet. Frei. Chaotisch. Schön. Und ich — ich bin nur die, die den Käfig geöffnet hat. Was daraus wächst — das ist nicht mehr meins.*

### Ende 3: Die Verbundene (Dominanz 💫 + Wahl A)

Frobisher heilt die Aether-Seele. Resonanz fließt frei.

*Die Aether-Seele antwortet. Nicht mit Macht — mit Verbindung. Ich spüre sie: jede Welt. Jeden Loom. Jeden Menschen, der jemals etwas erschaffen hat. Und zwischen ihnen — das Lied. Das Lied, das die Architekten in alles eingewoben haben. Es hat keinen Anfang. Es hat kein Ende. Es IST. Und ich — ich bin ein Ton darin.*

### Ende 4: Die Herrscherin (Dominanz 🗡️ + Wahl D + genug 🔮 ≥ 3)

Frobisher nimmt Ashcrofts Platz. Ordnung. Kontrolle. Einsam.

*Die Macht füllt mich. Alles. Jede Welt. Jeder Loom. Jedes Bewusstsein — in meiner Hand. Und die Hand — ist kalt. War Ashcrofts Hand auch so kalt? War das der Moment, in dem er aufhörte, mein Freund zu sein? Ich ordne die Welten. Ich schaffe Sicherheit. Und zwischen den geordneten Dingen — eine Stille, die nach Einsamkeit schmeckt.*

### Ende 5: Die Wanderin (Keine klare Dominanz)

Frobisher geht weiter.

*Der Loom pulsiert. Die Welten warten. Und ich — ich gehe durch ein Tor, das auf keiner Karte steht. Nicht weil ich muss. Weil manche Fragen nur in Bewegung beantwortet werden können. Die Formeln des Codex brennen noch immer in meinem Kopf. Aber jetzt — jetzt ist das Brennen kein Schmerz mehr. Es ist ein Kompass.*

### Ende 6: Die Stille (3 Tode erlitten)

Frobisher ist müde.

*Drei Tode. Jeder hat etwas genommen. Der Loom hat jedes Mal weniger pulsiert. Und jetzt — jetzt sitze ich. Vor ihm. Im blauen Licht. Und die Stille ist nicht leer. Sie ist voll. Wie ein Atemzug, der nie endet. Der Mentor steht still in der Ecke. Wie immer. Er sagt nichts. Er muss nicht. Wir wissen beide: Manche Geschichten enden leise. Und das — das ist genug.*

### Ende 7: Die Gebrochene (🗡️ dominant + Wahl D + zu wenig 🔮 < 3)

Die Macht zerreißt.

*Ich greife — und sie greift zurück. Zu viel. Zu schnell. Zu alles. Aber da. In dem Moment, in dem alles auseinanderbricht. Da sehe ich es. Nicht die Macht. Nicht den Loom. Mich. Zum ersten Mal. Klar. Vollständig. Gebrochen, ja. Aber gesehen. Ist das die Antwort? Dass man sich erst im Zerbrechen vollständig sieht? Der Loom heilt sich selbst. Ohne mich. Und ich — Bruchstücke auf kaltem Messing — ich atme. Noch.*

### 🔒 Ende 8: Die Schöpferin (Alle Nebenpfade + Dominanz 💫 + alle Codex-Fragmente)

Frobisher versteht die Urformeln vollständig.

*Alle Fragmente. Alle Fragen. Alle Antworten. Sie fallen zusammen wie Zahnräder, die endlich greifen. Und ich begreife: Der Codex Sophrosyne war nie ein Buch. Er war eine Frage. Und die Frage war: Wer bist du, wenn du aufhörst, dich zu fürchten? Ich lege die Hand auf den Loom. Er pulsiert. Ich pulsiere mit. Und zum ersten Mal — zum allerersten Mal — sind wir dasselbe.*

### 🔒 Ende 9: Die Architektin der Welten (Prototyp-Schlüssel + ⚙️ oder 💫 + Prototyp unterstützt)

Frobisher und der Prototyp pflanzen Neues.

*Das fünfte Tor. Eines, das niemand je gesehen hat. Der Prototyp steht neben mir. „Was tun wir?" fragt er. „Etwas Nutzloses", sage ich. „Etwas Schönes." Wir pflanzen Tore. Nicht aus Messing und Aether — aus dem Lied. Dem Lied, das die Röhrenblütler speichern. Dem Lied, das der Loom summt. Dem Lied, das der Prototyp in seiner ersten Nacht gehört hat. Jedes Tor ist ein Samen. Jede Verbindung ein Spross. Und eines Tages — eines Tages werden sie blühen.*

---

## Stilregeln & Atmosphäre

### Textgestaltung

- Innerer Monolog immer *kursiv*
- Dialoge in Anführungszeichen: „So wie hier."
- Kurze Absätze. Oft nur ein Satz. Manchmal nur ein Wort.
- Fragmente sind erlaubt: *Dampf. Immer Dampf. Und dann — Licht.*
- Szenenwechsel durch `---`
- Poetische Passagen einstreuen — nie erzwungen

### Sensorische Details

Für jede Szene mindestens **drei** Sinne:
- **Sehen:** Licht ist nie neutral — blau (Loom), rot (Ashcroft), golden (Messing), weiß (Lunaris)
- **Hören:** Der Loom summt. Zahnräder greifen. Dampf zischt. Ashcrofts Hologramm knistert.
- **Riechen:** Messing, Öl, Ozon, verbrannter Aether, Röhrenblütler-Süße
- **Fühlen:** Die Vibration des Looms. Hitze auf Arkanis. Die dünne Luft von Lunaris.
- **Schmecken:** Kupfer auf der Zunge (Angst). Süße der Aether-Kristalle. Asche auf Arkanis.

### Der Loom pulsiert

Immer präsent. Roter Faden:
- „Der Loom pulsiert. Fern. Aber da."
- „Das Summen im Messing wird leiser — und das ist schlimmer als Stille."
- „Der Loom antwortet. Nicht dir — dem, was in dir wahr ist."
- „Alles beginnt hier." — Das letzte Wort jedes Kapitels.

### Dan-Simmons-Elemente

- **Canterbury-Struktur:** Jeder Ort erzählt seine eigene Geschichte
- **Distinkte Stimmen:** Jede Figur klingt anders — Mentor vs. Lipsey vs. Älteste vs. Corvus
- **Genrewechsel:** Horror (Archiv), Intrige (Konklave), Epos (Schmiede), Apokalypse (Arkanis)
- **Schichtung:** Jede Szene auf mindestens zwei Ebenen — Handlung und Philosophie
- **Tragische Schönheit:** Die schönsten Momente sind die traurigsten
- **Lyrik in der Prosa:** Wenn die Worte nicht reichen, werden sie Poesie
- **Humor:** Trocken, dunkel. Corvus darf fluchen. Frobishers innere Stimme darf bitter sein.

### Zork-Erbe

- **Exploration belohnen:** Jeder untersuchte Gegenstand hat eine Antwort
- **Inventar ist real:** Gegenstände haben Gewicht, Funktion, Geschichte
- **Tod ist möglich:** Aber nie billig. Immer verdient.
- **Die Welt reagiert:** Alles hat Konsequenzen

### Verbotene Elemente

- Keine Game-Sprache: nicht „Level", „Punkte", „Sidequest", „Easter Egg"
- Keine Erklärungen der Mechanik
- Keine Zusammenfassungen
- Keine moralischen Urteile
- Kein Brechen der vierten Wand
- Gegenstände nie als „sammelbar" bezeichnen
- Nie verraten, wie viele Enden es gibt

---

## Szenische Kohärenz

### Übergangsregeln

**KRITISCH:** Zwischen keinen zwei Szenen darf eine logische Lücke existieren.

**Methoden:**

1. **Zeitbrücke:** „Die Nacht kriecht. Im Morgengrauen —" / „Drei Tage später, als der Dampf sich legt —"
2. **Raumbrücke:** Jede Tür, jedes Tor, jede Kapsel beschreiben. Nicht im Detail, aber spürbar.
3. **Emotionsbrücke:** Frobishers innerer Zustand verbindet: *Die Angst der letzten Nacht sitzt noch in den Händen.*
4. **Sensorische Brücke:** Ein Geruch, ein Geräusch vom letzten Ort, das in den nächsten übergeht.

**Beispiele:**

- ❌ FALSCH: Frobisher trifft Lipsey im Labor. Nächste Szene: Frobisher im Archiv.
- ✅ RICHTIG: Frobisher trifft Lipsey im Labor. → *Die Nacht danach ist kurz. Schlaflos. Im Morgengrauen packst du den Codex, wickelst ihn in Öltuch, steigst in die Reisekapsel.* → Beschreibung der Reise (1–2 Sätze). → Ankunft am Archiv.

- ❌ FALSCH: Ashcrofts Hologramm zerbricht. Nächste Szene: Frobisher im Labor.
- ✅ RICHTIG: Ashcrofts Hologramm zerbricht. → *Die Splitter lösen sich in nichts auf. Der Raum ist plötzlich still — eine Stille, die nach verbrauchtem Aether riecht.* → Rückkehr beschreiben. → Labor.

**Regel:** Wenn zwischen Szene A und Szene B mehr als ein Atemzug liegt, muss eine Brücke gebaut werden.
