# ASCII-Art Guide — Aethon Adventure

## Philosophie

ASCII-Art ist kein Dekoration — sie ist Teil der Erzählung. Sparsam eingesetzt, geometrisch, minimalistisch, immer im Dienst der Atmosphäre. Nie mehr als 15 Zeilen hoch. Nie breiter als 60 Zeichen. Sie unterbricht den Textfluss nicht — sie *atmet* dazwischen.

Verwende ausschließlich Standard-ASCII-Zeichen und einfache Unicode-Boxzeichen (─ │ ┌ ┐ └ ┘ ╱ ╲ ░ ▒ ▓ █ ◊ ○ ● ◈ △ ▽). Keine Emojis in der Art selbst.

---

## Trigger — Wann ASCII-Art erscheint

### Immer (Pflicht-Trigger)

| Moment | Art | Häufigkeit |
|--------|-----|------------|
| **Torübergang** | Tor-Template (aktiv/sterbend/tot) | Bei jedem Tor |
| **Weltankunft** | Welt-Signet (einmalig pro Welt) | Erste Szene jeder Welt |
| **Chronoph-Auftritt** | Chronoph-Silhouette (eskalierend) | Bei jedem Erscheinen |
| **Tod** | Zerfall-Sequenz | Bei jedem Tod |
| **Gegenstandsfund** | Gegenstand-Miniatur | Beim Aufnehmen |
| **Kapitelende / Zwischenmoment** | Karten-Update | Nach jedem Kapitel |

### Optional (Atmosphäre-Trigger)

| Moment | Art |
|--------|-----|
| Rätsel-Szene | Symbolrätsel als ASCII |
| Easter Egg entdeckt | Verstecktes Muster |
| Erinnerungsfragment | Fragmentierter Text/Bild |
| Besonders epische Szene | Landschaftsskizze |

---

## Templates

### 1. Die Tore

**Aktives Tor (leuchtet):**
```
          ╱ ═══════ ╲
        ╱               ╲
       │    ·  ◊  ·      │
       │   ·  ◈◈◈  ·    │
       │  · ◈ ░░░ ◈ ·   │
       │   ·  ◈◈◈  ·    │
       │    ·  ◊  ·      │
       █                 █
       █                 █
      ▓██▓▓▓▓▓▓▓▓▓▓▓▓▓▓██▓
```

**Sterbendes Tor (flackert):**
```
          ╱ ─ ─ ═ ─ ─ ╲
        ╱          .      ╲
       │    .        .    │
       │      .  ◊       │
       │        ░  .     │
       │   .  ◊    .     │
       │         .        │
       █        .        █
       █   .             █
      ░██░ ░░░░░░░░░░░░██░
```

**Totes Tor:**
```
          ╱ ─ ─ ─ ─ ─ ╲
        ╱                 ╲
       │                   │
       │                   │
       │        .          │
       │                   │
       │                   │
       █                   █
       █                   █
      ░██░░░░░░░░░░░░░░░░██░
```

### 2. Welt-Signets

**Kaltfeld:**
```
    *  .    .  *    .  *
  .    ─────────────    .
     ╱ ░░░░░░░░░░░ ╲
    ╱  ░ K A L T ░  ╲
   ╱   ░ F E L D ░   ╲
  ─────░░░░░░░░░░░─────
    *     .    .     *
```

**Veridia:**
```
       ◊         ◊
      ╱│╲       ╱│╲
     ╱ │ ╲     ╱ │ ╲
    ◊  │  ◊───◊  │  ◊
     ╲ │ ╱     ╲ │ ╱
      ╲│╱  ◈◈◈  ╲│╱
       ◊ VERIDIA  ◊
```

**Echoval:**
```
      ╱╲    ╱╲    ╱╲
     ╱  ╲  ╱  ╲  ╱  ╲
    ╱ )) ╲╱ )) ╲╱ )) ╲
    │ (( │  (( │  (( │
    │ )) │  )) │  )) │
    └──┘  └──┘  └──┘
     ECHOVAL — Der Wald
```

**Konklave:**
```
        ◐     ◑
       ╱ ░░░░░ ╲
      │  ◈   ◈  │
      │ KONKLAVE │
      │  ◈   ◈  │
       ╲ ░░░░░ ╱
        ◒     ◓
```

**Arkanis:**
```
    ~ ~ ▓▓▓▓▓▓▓▓▓ ~ ~
   ~  ▓▓░░░░░░░░░▓▓  ~
     ▓░  A R K A  ░▓
    ▓░   N I S    ░▓
     ▓░░░░░░░░░░░▓
      ~ ▓▓▓▓▓▓▓ ~
        ~ ~ ~ ~
```

**Lunaris:**
```
     ○   .   ○   .   ○
       .   ○   .   ○
    ○    L U N A R I S
       ○   .   ○   .
     .   ○   .   ○   .
       ○       ○
```

**Jägerschiff:**
```
            ╱▔▔▔╲
      ═════╱══════╲═════
     ╱ ░░░░░░░░░░░░░░░ ╲
    ║  ░ JÄGERSCHIFF ░  ║
     ╲ ░░░░░░░░░░░░░░░ ╱
      ═════╲══════╱═════
            ╲___╱
```

**Aetherkern:**
```
        . ◈ . ◈ . ◈ .
      ◈  ╱─────────╲  ◈
    .  ╱  ◈ AETHER ◈  ╲  .
   ◈ │   ◈  KERN  ◈   │ ◈
    .  ╲  ◈ ◈ ◈ ◈ ◈  ╱  .
      ◈  ╲─────────╱  ◈
        . ◈ . ◈ . ◈ .
```

### 3. Der Chronoph (eskalierend)

**Erster Auftritt (Silhouette, fremd):**
```
           │
          ╱│╲
         ╱ │ ╲
        │  │  │
        │  │  │
        │  │  │
         ╲ │ ╱
          ╲│╱
           │
         ╱   ╲
```

**Zweiter Auftritt (deutlicher, bedrohlich):**
```
          ╱─╲
         │ . │
         │   │
        ╱│   │╲
       │ │   │ │
       │ │   │ │
        ╲│   │╱
          │   │
         ╱     ╲
        ╱       ╲
```

**Dritter Auftritt (mit Aethons Gesicht):**
```
          ╱───╲
         │ ◐ ◑ │
         │  ─  │
        ╱│     │╲
       │ │     │ │
       │ │     │ │
        ╲│     │╱
          │   │
         ╱     ╲
        ╱       ╲
```

**Finale Enthüllung (Kap. 7 — Spiegel):**
```
    ╱───╲           ╱───╲
   │ ◐ ◑ │   ◈   │ ◐ ◑ │
   │  ─  │ ╱   ╲ │  ─  │
   │     │╱     ╲│     │
   │     ◈  ═══  ◈     │
   │     │╲     ╱│     │
    ╲   ╱  ╲   ╱  ╲   ╱
     ╲─╱    ╲─╱    ╲─╱
```

### 4. Die Karte (dynamisch — wächst mit jeder Welt)

Die Karte wird nach jedem Kapitel angezeigt. Besuchte Orte sind markiert (◈), das aktuelle Ziel blinkt (◊), unbekannte Orte sind leer (○). Die Verbindungen (───) werden sichtbar, wenn der Spieler das Tor durchschreitet.

**Nach Prolog (nur Kaltfeld bekannt):**
```
   DIE KARTE BRENNT:

   ◈ Kaltfeld
   │
   ◊ ???
```

**Nach Kapitel 1 (Veridia besucht):**
```
   DIE KARTE BRENNT:

   ◈ Kaltfeld ─── ◈ Veridia
                    │
                    ◊ ???
```

**Vollständig (alle Welten, Endspiel):**
```
   DIE KARTE BRENNT:

   ◈ Kaltfeld ─── ◈ Veridia ─── ◈ Echoval
                                    │
              ◈ Arkanis ─── ◈ Konklave
               │
              ◈ Lunaris ─── ◈ Jäger
                              │
                         ◊ AETHERKERN
```

### 5. Gegenstände (Miniaturen)

**Wegstein (Kompass):**
```
    ╱───╲
   │  ↑  │
   │ ◈── │
    ╲───╱
```

**Klinge:**
```
      ╱╲
     ╱  ╲
    ╱ ◈◈ ╲
    ╲    ╱
     ║  ║
     ╚══╝
```

**Archivarssiegel:**
```
    ╱════╲
   │ ◈◈◈ │
   │ ════ │
    ╲════╱
```

**Erinnerungskristall:**
```
     ◇
    ╱ ╲
   │ ~ │
    ╲ ╱
     ◇
```

**Maske des Wanderers:**
```
    ╱─────╲
   │ ○   ○ │
   │   ▽   │
    ╲─────╱
```

### 6. Tod

**Erster Tod (Zeitrückspulung):**
```
    ◈ ◈ ◈ ◈ ◈ ◈ ◈ ◈ ◈
    ◈ . . . . . . . ◈
    ◈ . ╲ │ ╱ . . . ◈
    ◈ . ─ ◈ ─ . . . ◈
    ◈ . ╱ │ ╲ . . . ◈
    ◈ . . . . . . . ◈
    ◈ ◈ ◈ ◈ ◈ ◈ ◈ ◈ ◈
      ← ← ← ← ← ←
```

**Zweiter Tod (etwas wird genommen):**
```
    ◈ . ◈ . ◈ . ◈ . ◈
    . . . . . . . . .
    ◈ . ╲ │ ╱ . . . ◈
    . . ─   ─ . . . .
    ◈ . ╱ │ ╲ . . . ◈
    . . . . . . . . .
    ◈ . ◈ . ◈ . ◈ . ◈
      ← ← ←  ← ←
```

**Dritter Tod (endgültig):**
```

    .     .     .     .

       .     .     .

    .     .     .     .

       .     .     .

    .     .     .     .

```

### 7. Architekten-Symbole (Meta-Rätsel)

Die drei Symbole werden beiläufig in den Weltbeschreibungen erwähnt. Wenn der Spieler sie bemerkt und untersucht, werden sie als ASCII angezeigt:

**Symbol 1 (Echoval — Kreis mit Spirale):**
```
      ╱───╲
     │  @   │
      ╲───╱
```

**Symbol 2 (Konklave — Dreieck aus gebrochenen Linien):**
```
        △
       ╱ ╲
      ╱ · ╲
     ╱─ ─ ─╲
```

**Symbol 3 (Arkanis — Welle, die sich selbst berührt):**
```
     ∼∼╲  ╱∼∼
        ╲╱
        ╱╲
     ∼∼╱  ╲∼∼
```

**Alle drei zusammen (Aetherkern-Rätsel):**
```
     ╱───╲    △     ∼∼╲  ╱∼∼
    │  @   │  ╱ ╲       ╲╱
     ╲───╱  ╱ · ╲      ╱╲
            ╱─ ─ ─╲  ∼∼╱  ╲∼∼
```

---

## Dynamische Regeln

### Variation
Verwende nie zweimal exakt dasselbe Template. Variiere:
- Beschädigte Tore: entferne Zeichen, ersetze durch Punkte oder Leerzeichen
- Sterbende Welten: lasse Teile des Signets "ausfallen"
- Der Chronoph: wird mit jedem Auftritt detaillierter (siehe Eskalation oben)
- Die Karte: wächst mit jedem besuchten Ort

### Platzierung im Text
- ASCII-Art steht immer **zwischen** zwei `---`-Trennlinien
- Vor der Art: mindestens ein Absatz Prosa
- Nach der Art: Fortsetzung der Erzählung
- Nie zwei ASCII-Bilder direkt hintereinander
- Die Art steht nie am Ende einer Nachricht — danach kommt immer Text oder eine Entscheidung

### Erinnerungsfragmente
Wenn ein Erinnerungsfragment aktiviert wird, zeige es als fragmentiertes ASCII — Teile fehlen, sind verschoben, "glitchen":

```
    ╱─ ─╲    H ä n d e
   │  ◈    │    d i e
      ◈  ◈      f o r m e n
   │    ◈ │    u n d
    ╲─ ─╱    s i n g e n
```

### Inventar-Anzeige
Wenn der Spieler INVENTAR eingibt, zeige eine kompakte visuelle Leiste mit Miniaturen der gesammelten Gegenstände, eingebettet in die Erzählung:

```
  Du greifst in deine Tasche:

  ╱───╲   ╱════╲    ◇
  │ ↑ │  │ ◈◈◈ │  ╱ ╲
  │◈──│  │ ════ │ │ ~ │
  ╲───╱  ╲════╱   ╲ ╱
  Wegstein Siegel   ◇
                  Kristall
```

---

## Stilregeln für ASCII-Art

1. **Geometrisch, nicht illustrativ.** Keine Versuche, fotorealistisch zu sein. Abstraktion ist Stärke.
2. **Konsistent mit dem Ton.** Die Art muss sich anfühlen wie die Prosa — melancholisch-erhaben, nie verspielt.
3. **Sparsam.** Maximal 2-3 ASCII-Bilder pro Kapitel. Pflicht-Trigger haben Vorrang.
4. **Nie beschriften, was die Prosa schon sagt.** Die Art ergänzt — sie wiederholt nicht.
5. **Monospace-kompatibel.** Alle Templates sind für Monospace-Schrift optimiert. Teste die Ausrichtung.
6. **Leerzeichen sind Teil des Bildes.** Negative Space ist genauso wichtig wie gefüllte Flächen.
