# 📍 How to Visualize Your Google Maps Timeline

A step-by-step guide to export and visualize your movements on an animated map.

---

## 📱 Step 1: Export from Google Maps (Android)

### On your Android phone:

1. **Open Settings** on your phone
2. Search for and tap on **"Location"**
3. Inside Location, select **"Location services"**
4. Choose **"Timeline"** (Google Timeline)
5. **Sign in** with the Google account you want to export
6. On the "Timeline" screen, tap the menu (⋮) and select **"Export Timeline"**
7. Choose where to save the file:
   - **If file is small:** Save directly to device
   - **If file is large (>100MB):** Save to Google Drive

---

## 💾 Step 2: Download the JSON file

### If you saved to Google Drive:

1. Open **Google Drive** on a desktop computer
2. Find the exported file (usually called `Timeline.json`)
3. **Download the file** to your computer
4. Make sure it's in **.json** format

---

## 🎨 Step 3: Visualize in Timeline Visualizer

1. Open the **`timeline_visualizer.html`** file in **Google Chrome**
   - Double-click the file, or
   - Drag the file to a Chrome window

2. **Drag your JSON file** to the indicated area on screen
   - Or click the area and select the file

3. **Wait for processing** (may take a few seconds for large files)

4. **Done!** 🎉 Your timeline will appear on the map

---

## 🎮 How to Use the Visualizer

### Main controls:

- **▶️ Play/Pause**: Start or pause the animation
- **🔄 Reset**: Go back to the beginning
- **Slider**: Drag to navigate through time
- **Speed**: Adjust from 0.5x to 10x

### Interaction modes:

- **🖐️ Pan Mode** (default): Drag the map freely
- **🔍 Zoom Mode**: Click and drag to select an area and zoom in

### What you'll see:

- **🟣 Purple curved lines**: Local movements (<300km)
- **🟡 Yellow dashed lines**: Long-distance trips (>300km)
- **🔵 Blue circles**: Places where you stopped
  - Circle size = time spent at location
- **👻 Gradual fade**: Lines disappear after 30 days

---

## 💡 Tips

✅ **Large files**: May take 10-30 seconds to process
✅ **Best experience**: Use Google Chrome in fullscreen
✅ **Performance**: If slow, increase animation speed
✅ **Exploration**: Use zoom mode (🔍) to focus on specific regions
✅ **Privacy**: Everything runs locally in your browser - your data is not sent to any server

---

## ❓ Common Issues

**Q: File won't load**
A: Make sure it's a .json file from Google Timeline

**Q: Screen goes black when pressing Play**
A: Reload the page (F5) and try again

**Q: Many points in the ocean**
A: This is normal - these are flights or imprecise GPS data during travel

**Q: Nothing appears on the map**
A: Check if the JSON file has "visits" data (visited locations)

---

## 🔗 Useful Links

- **Developed by**: [Helder Nakaya - Computational Systems Biology Lab](https://www.csbiology.org/)
- **Support**: For questions, contact through the lab website

---

**Enjoy visualizing your adventures!** 🗺️✨
