/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.SparkException;
import org.apache.spark.SparkException$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.shuffle.checksum.Cause;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.CorruptionCause;
import org.apache.spark.network.shuffle.protocol.DiagnoseCorruption;
import org.apache.spark.network.shuffle.protocol.FetchShuffleBlocks;
import org.apache.spark.network.shuffle.protocol.GetLocalDirsForExecutors;
import org.apache.spark.network.shuffle.protocol.LocalDirsForExecutors;
import org.apache.spark.network.shuffle.protocol.OpenBlocks;
import org.apache.spark.network.shuffle.protocol.StreamHandle;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.shuffle.protocol.UploadBlockStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.StorageLevel;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001B\u0006\r\u0001]A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\te\u0001\u0011\t\u0011)A\u0005g!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003>\u0001\u0011\u0005a\bC\u0004E\u0001\t\u0007I\u0011B#\t\r%\u0003\u0001\u0015!\u0003G\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015y\u0007\u0001\"\u0003q\u0011\u001d\tI\u0003\u0001C!\u0003W\u00111CT3uif\u0014En\\2l%B\u001c7+\u001a:wKJT!!\u0004\b\u0002\u000b9,G\u000f^=\u000b\u0005=\u0001\u0012a\u00028fi^|'o\u001b\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011c\u0001\u0001\u0019=A\u0011\u0011\u0004H\u0007\u00025)\u00111DD\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005uQ\"A\u0003*qG\"\u000bg\u000e\u001a7feB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005E\u0001\tS:$XM\u001d8bY&\u00111\u0005\t\u0002\b\u0019><w-\u001b8h\u0003\u0015\t\u0007\u000f]%e!\t1sF\u0004\u0002([A\u0011\u0001fK\u0007\u0002S)\u0011!FF\u0001\u0007yI|w\u000e\u001e \u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0014G\u0001\u0004TiJLgn\u001a\u0006\u0003]-\n!b]3sS\u0006d\u0017N_3s!\t!d'D\u00016\u0015\t\u0011\u0004#\u0003\u00028k\tQ1+\u001a:jC2L'0\u001a:\u0002\u0019\tdwnY6NC:\fw-\u001a:\u0011\u0005iZT\"\u0001\b\n\u0005qr!\u0001\u0005\"m_\u000e\\G)\u0019;b\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q!q(\u0011\"D!\t\u0001\u0005!D\u0001\r\u0011\u0015!C\u00011\u0001&\u0011\u0015\u0011D\u00011\u00014\u0011\u0015AD\u00011\u0001:\u00035\u0019HO]3b[6\u000bg.Y4feV\ta\t\u0005\u0002\u001a\u000f&\u0011\u0001J\u0007\u0002\u0017\u001f:,gi\u001c:P]\u0016\u001cFO]3b[6\u000bg.Y4fe\u0006q1\u000f\u001e:fC6l\u0015M\\1hKJ\u0004\u0013a\u0002:fG\u0016Lg/\u001a\u000b\u0005\u0019B;\u0016\r\u0005\u0002N\u001d6\t1&\u0003\u0002PW\t!QK\\5u\u0011\u0015\tv\u00011\u0001S\u0003\u0019\u0019G.[3oiB\u00111+V\u0007\u0002)*\u0011\u0011KD\u0005\u0003-R\u0013q\u0002\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e\u0005\u00061\u001e\u0001\r!W\u0001\u000beB\u001cW*Z:tC\u001e,\u0007C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\rq\u0017n\u001c\u0006\u0002=\u0006!!.\u0019<b\u0013\t\u00017L\u0001\u0006CsR,')\u001e4gKJDQAY\u0004A\u0002\r\fqB]3ta>t7/Z\"p]R,\u0007\u0010\u001e\t\u0003'\u0012L!!\u001a+\u0003'I\u00038MU3ta>t7/Z\"bY2\u0014\u0017mY6\u0002\u001bI,7-Z5wKN#(/Z1n)\u0011A7\u000e\u001c8\u0011\u0005MK\u0017B\u00016U\u0005Q\u0019FO]3b[\u000e\u000bG\u000e\u001c2bG.<\u0016\u000e\u001e5J\t\")\u0011\u000b\u0003a\u0001%\")Q\u000e\u0003a\u00013\u0006iQ.Z:tC\u001e,\u0007*Z1eKJDQA\u0019\u0005A\u0002\r\f1\u0003Z3tKJL\u0017\r\\5{K6+G/\u00193bi\u0006,2!]A\u0004)\r\u0011\u0018\u0011\u0004\t\u0005\u001bN,80\u0003\u0002uW\t1A+\u001e9mKJ\u0002\"A^=\u000e\u0003]T!\u0001\u001f\t\u0002\u000fM$xN]1hK&\u0011!p\u001e\u0002\r'R|'/Y4f\u0019\u00164X\r\u001c\t\u0005y~\f\u0019!D\u0001~\u0015\tq8&A\u0004sK\u001adWm\u0019;\n\u0007\u0005\u0005QP\u0001\u0005DY\u0006\u001c8\u000fV1h!\u0011\t)!a\u0002\r\u0001\u00119\u0011\u0011B\u0005C\u0002\u0005-!!\u0001+\u0012\t\u00055\u00111\u0003\t\u0004\u001b\u0006=\u0011bAA\tW\t9aj\u001c;iS:<\u0007cA'\u0002\u0016%\u0019\u0011qC\u0016\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u001c%\u0001\r!!\b\u0002\u00115,G/\u00193bi\u0006\u0004R!TA\u0010\u0003GI1!!\t,\u0005\u0015\t%O]1z!\ri\u0015QE\u0005\u0004\u0003OY#\u0001\u0002\"zi\u0016\f\u0001cZ3u'R\u0014X-Y7NC:\fw-\u001a:\u0015\u0005\u00055\u0002cA\r\u00020%\u0019\u0011\u0011\u0007\u000e\u0003\u001bM#(/Z1n\u001b\u0006t\u0017mZ3s\u0001")
public class NettyBlockRpcServer
extends RpcHandler
implements Logging {
    private final String appId;
    private final Serializer serializer;
    private final BlockDataManager blockManager;
    private final OneForOneStreamManager streamManager;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private OneForOneStreamManager streamManager() {
        return this.streamManager;
    }

    public void receive(TransportClient client, ByteBuffer rpcMessage, RpcResponseCallback responseContext) {
        BlockTransferMessage blockTransferMessage;
        try {
            blockTransferMessage = BlockTransferMessage.Decoder.fromByteBuffer((ByteBuffer)rpcMessage);
        }
        catch (Throwable throwable) {
            IllegalArgumentException illegalArgumentException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalArgumentException && (illegalArgumentException = (IllegalArgumentException)throwable2).getMessage().startsWith("Unknown message type")) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"This could be a corrupted RPC message (capacity: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ") "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.RPC_MESSAGE_CAPACITY$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)rpcMessage.capacity()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"from ", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SOCKET_ADDRESS$.MODULE$, (Object)client.getSocketAddress())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Please use `spark.authenticate.*` configurations "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"in case of security incidents."}))).log((Seq)Nil$.MODULE$))));
                throw illegalArgumentException;
            }
            if (throwable2 instanceof IndexOutOfBoundsException ? true : throwable2 instanceof NegativeArraySizeException) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored a corrupted RPC message (capacity: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ") "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.RPC_MESSAGE_CAPACITY$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)rpcMessage.capacity()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"from ", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SOCKET_ADDRESS$.MODULE$, (Object)client.getSocketAddress())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Please use `spark.authenticate.*` configurations "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"in case of security incidents."}))).log((Seq)Nil$.MODULE$))));
                return;
            }
            throw throwable;
        }
        BlockTransferMessage message = blockTransferMessage;
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Received request: " + message);
        BlockTransferMessage blockTransferMessage2 = message;
        if (blockTransferMessage2 instanceof OpenBlocks) {
            OpenBlocks openBlocks = (OpenBlocks)blockTransferMessage2;
            int blocksNum = openBlocks.blockIds.length;
            IndexedSeq blocks = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), blocksNum).map((Function1 & Serializable)i -> NettyBlockRpcServer.$anonfun$receive$4(this, openBlocks, BoxesRunTime.unboxToInt((Object)i)));
            long streamId = this.streamManager().registerStream(this.appId, CollectionConverters$.MODULE$.IteratorHasAsJava(blocks.iterator()).asJava(), client.getChannel());
            this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Registered streamId " + streamId + " with " + blocksNum + " buffers");
            responseContext.onSuccess(new StreamHandle(streamId, blocksNum).toByteBuffer());
            return;
        }
        if (blockTransferMessage2 instanceof FetchShuffleBlocks) {
            FetchShuffleBlocks fetchShuffleBlocks = (FetchShuffleBlocks)blockTransferMessage2;
            ManagedBuffer[] blocks = (ManagedBuffer[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.longArrayOps(fetchShuffleBlocks.mapIds))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    long mapId = tuple2._1$mcJ$sp();
                    int index = tuple2._2$mcI$sp();
                    if (!x3$1.batchFetchEnabled) {
                        return (ManagedBuffer[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(x3$1.reduceIds[index]), (Function1 & Serializable)reduceId -> this.blockManager.getLocalBlockData(new ShuffleBlockId(fetchShuffleBlocks.shuffleId, mapId, BoxesRunTime.unboxToInt((Object)reduceId))), ClassTag$.MODULE$.apply(ManagedBuffer.class));
                    }
                    int[] startAndEndId = x3$1.reduceIds[index];
                    if (startAndEndId.length != 2) {
                        throw SparkException$.MODULE$.internalError("Invalid shuffle fetch request when batch mode is enabled: " + fetchShuffleBlocks, "NETWORK");
                    }
                    return (ManagedBuffer[])((Object[])new ManagedBuffer[]{$this.blockManager.getLocalBlockData(new ShuffleBlockBatchId(x3$1.shuffleId, mapId, startAndEndId[0], startAndEndId[1]))});
                }
                throw new MatchError((Object)tuple2);
            }, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(ManagedBuffer.class));
            int numBlockIds = fetchShuffleBlocks.batchFetchEnabled ? fetchShuffleBlocks.mapIds.length : BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fetchShuffleBlocks.reduceIds), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)NettyBlockRpcServer.$anonfun$receive$10(x$1)), (ClassTag)ClassTag$.MODULE$.Int())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            long streamId = this.streamManager().registerStream(this.appId, CollectionConverters$.MODULE$.IteratorHasAsJava(ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])blocks))).asJava(), client.getChannel());
            this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Registered streamId " + streamId + " with " + numBlockIds + " buffers");
            responseContext.onSuccess(new StreamHandle(streamId, numBlockIds).toByteBuffer());
            return;
        }
        if (blockTransferMessage2 instanceof UploadBlock) {
            UploadBlock uploadBlock = (UploadBlock)blockTransferMessage2;
            Tuple2 tuple2 = this.deserializeMetadata(uploadBlock.metadata);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            StorageLevel level = (StorageLevel)tuple2._1();
            ClassTag classTag = (ClassTag)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)level, (Object)classTag);
            StorageLevel level2 = (StorageLevel)tuple22._1();
            ClassTag classTag2 = (ClassTag)tuple22._2();
            NioManagedBuffer data = new NioManagedBuffer(ByteBuffer.wrap(uploadBlock.blockData));
            BlockId blockId = BlockId$.MODULE$.apply(uploadBlock.blockId);
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Receiving replicated block " + blockId + " with level " + level2 + " from " + client.getSocketAddress());
            boolean blockStored = this.blockManager.putBlockData(blockId, (ManagedBuffer)data, level2, classTag2);
            if (blockStored) {
                responseContext.onSuccess(ByteBuffer.allocate(0));
                return;
            }
            SparkException exception = SparkException$.MODULE$.internalError("Upload block for " + blockId + " failed. This mostly happens when there is not sufficient space available to store the block.", "NETWORK");
            responseContext.onFailure((Throwable)exception);
            return;
        }
        if (blockTransferMessage2 instanceof GetLocalDirsForExecutors) {
            String actualExecId;
            GetLocalDirsForExecutors getLocalDirsForExecutors = (GetLocalDirsForExecutors)blockTransferMessage2;
            String string = getLocalDirsForExecutors.appId;
            String string2 = this.appId;
            boolean isIncorrectAppId = string == null ? string2 != null : !string.equals(string2);
            int execNum = getLocalDirsForExecutors.execIds.length;
            if (isIncorrectAppId || execNum != 1) {
                String errorMsg = "Invalid GetLocalDirsForExecutors request: " + (isIncorrectAppId ? "incorrect application id: " + getLocalDirsForExecutors.appId + ";" : BoxedUnit.UNIT) + (execNum != 1 ? "incorrect executor number: " + execNum + " (expected 1);" : BoxedUnit.UNIT);
                responseContext.onFailure((Throwable)SparkException$.MODULE$.internalError(errorMsg, "NETWORK"));
                return;
            }
            String expectedExecId = ((BlockManager)this.blockManager).executorId();
            String string3 = actualExecId = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])getLocalDirsForExecutors.execIds));
            String string4 = expectedExecId;
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                responseContext.onFailure((Throwable)SparkException$.MODULE$.internalError("Invalid executor id: " + actualExecId + ", expected " + expectedExecId + ".", "NETWORK"));
                return;
            }
            responseContext.onSuccess(new LocalDirsForExecutors(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)actualExecId), (Object)this.blockManager.getLocalDiskDirs())}))).asJava()).toByteBuffer());
            return;
        }
        if (blockTransferMessage2 instanceof DiagnoseCorruption) {
            DiagnoseCorruption diagnoseCorruption = (DiagnoseCorruption)blockTransferMessage2;
            Cause cause = this.blockManager.diagnoseShuffleBlockCorruption(new ShuffleBlockId(diagnoseCorruption.shuffleId, diagnoseCorruption.mapId, diagnoseCorruption.reduceId), diagnoseCorruption.checksum, diagnoseCorruption.algorithm);
            responseContext.onSuccess(new CorruptionCause(cause).toByteBuffer());
            return;
        }
        throw new MatchError((Object)blockTransferMessage2);
    }

    public StreamCallbackWithID receiveStream(TransportClient client, ByteBuffer messageHeader, RpcResponseCallback responseContext) {
        UploadBlockStream message = (UploadBlockStream)BlockTransferMessage.Decoder.fromByteBuffer((ByteBuffer)messageHeader);
        Tuple2 tuple2 = this.deserializeMetadata(message.metadata);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        StorageLevel level = (StorageLevel)tuple2._1();
        ClassTag classTag = (ClassTag)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)level, (Object)classTag);
        StorageLevel level2 = (StorageLevel)tuple22._1();
        ClassTag classTag2 = (ClassTag)tuple22._2();
        BlockId blockId = BlockId$.MODULE$.apply(message.blockId);
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Receiving replicated block " + blockId + " with level " + level2 + " as stream from " + client.getSocketAddress());
        return this.blockManager.putBlockDataAsStream(blockId, level2, classTag2);
    }

    private <T> Tuple2<StorageLevel, ClassTag<T>> deserializeMetadata(byte[] metadata) {
        return (Tuple2)this.serializer.newInstance().deserialize(ByteBuffer.wrap(metadata), ClassTag$.MODULE$.Nothing());
    }

    public StreamManager getStreamManager() {
        return this.streamManager();
    }

    public static final /* synthetic */ ManagedBuffer $anonfun$receive$4(NettyBlockRpcServer $this, OpenBlocks x2$1, int i) {
        BlockId blockId = BlockId$.MODULE$.apply(x2$1.blockIds[i]);
        Predef$.MODULE$.assert(!(blockId instanceof ShuffleBlockBatchId), (Function0 & Serializable)() -> "Continuous shuffle block fetching only works for new fetch protocol.");
        return $this.blockManager.getLocalBlockData(blockId);
    }

    public static final /* synthetic */ int $anonfun$receive$10(int[] x$1) {
        return x$1.length;
    }

    public NettyBlockRpcServer(String appId, Serializer serializer, BlockDataManager blockManager) {
        this.appId = appId;
        this.serializer = serializer;
        this.blockManager = blockManager;
        Logging.$init$((Logging)this);
        this.streamManager = new OneForOneStreamManager();
    }
}

