/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadata;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadataKey;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadataValue;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.ModuleSerializationProxy;

public final class StateSchemaMetadata$
implements Serializable {
    public static final StateSchemaMetadata$ MODULE$ = new StateSchemaMetadata$();

    public StateSchemaMetadata createStateSchemaMetadata(String checkpointLocation, Configuration hadoopConf, List<String> stateSchemaFiles) {
        CheckpointFileManager fm = CheckpointFileManager$.MODULE$.create(new Path(checkpointLocation), hadoopConf);
        Map activeSchemas = (Map)((LinearSeqOps)stateSchemaFiles.zipWithIndex()).foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Map schemas = (Map)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String stateSchemaFile = (String)tuple22._1();
                    FSDataInputStream fsDataInputStream = fm.open(new Path(stateSchemaFile));
                    List<StateStoreColFamilySchema> colFamilySchemas = StateSchemaCompatibilityChecker$.MODULE$.readSchemaFile(fsDataInputStream);
                    List schemaEntries = colFamilySchemas.flatMap((Function1 & Serializable)colFamilySchema -> {
                        Schema keyAvroSchema = SchemaConverters$.MODULE$.toAvroTypeWithDefaults(colFamilySchema.keySchema());
                        Tuple2 keyEntry = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StateSchemaMetadataKey(colFamilySchema.colFamilyName(), colFamilySchema.keySchemaId(), true)), (Object)new StateSchemaMetadataValue(colFamilySchema.keySchema(), keyAvroSchema));
                        Schema valueAvroSchema = SchemaConverters$.MODULE$.toAvroTypeWithDefaults(colFamilySchema.valueSchema());
                        Tuple2 valueEntry = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StateSchemaMetadataKey(colFamilySchema.colFamilyName(), colFamilySchema.valueSchemaId(), false)), (Object)new StateSchemaMetadataValue(colFamilySchema.valueSchema(), valueAvroSchema));
                        return new .colon.colon((Object)keyEntry, (List)new .colon.colon((Object)valueEntry, (List)Nil$.MODULE$));
                    });
                    return (Map)schemas.$plus$plus((IterableOnce)schemaEntries.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return new StateSchemaMetadata((Map<StateSchemaMetadataKey, StateSchemaMetadataValue>)activeSchemas);
    }

    public StateSchemaMetadata apply(Map<StateSchemaMetadataKey, StateSchemaMetadataValue> activeSchemas) {
        return new StateSchemaMetadata(activeSchemas);
    }

    public Option<Map<StateSchemaMetadataKey, StateSchemaMetadataValue>> unapply(StateSchemaMetadata x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some(x$0.activeSchemas());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StateSchemaMetadata$.class);
    }

    private StateSchemaMetadata$() {
    }
}

