/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.UUID;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\r\u001a\u0001\u0019B\u0001b\r\u0001\u0003\u0006\u0004%I\u0001\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005k!AA\b\u0001BC\u0002\u0013%Q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003?\u0011!)\u0005A!b\u0001\n\u00031\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u000bU\u0003A\u0011\u0001,\t\u000fq\u0003\u0001\u0019!C\u0001;\"9\u0011\r\u0001a\u0001\n\u0003\u0011\u0007B\u00025\u0001A\u0003&a\fC\u0004j\u0001\t\u0007I\u0011\u00026\t\ra\u0004\u0001\u0015!\u0003l\u0011\u001dI\bA1A\u0005\u0002uCaA\u001f\u0001!\u0002\u0013q\u0006bB>\u0001\u0005\u0004%I\u0001 \u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003~\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!a\u0007\u0001\t\u0003\ti\u0002C\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA%\u0001\u0011%\u00111\n\u0005\b\u0003?\u0002A\u0011AA1\u0005A\u0001&o\\4sKN\u001c(+\u001a9peR,'O\u0003\u0002\u001b7\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u00039u\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005yy\u0012aA:rY*\u0011\u0001%I\u0001\u0006gB\f'o\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]Ej\u0011a\f\u0006\u0003a}\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003e=\u0012q\u0001T8hO&tw-\u0001\u0007ta\u0006\u00148nU3tg&|g.F\u00016!\t1\u0014(D\u00018\u0015\tAT$A\u0004dY\u0006\u001c8/[2\n\u0005i:$\u0001D*qCJ\\7+Z:tS>t\u0017!D:qCJ\\7+Z:tS>t\u0007%\u0001\u0007ue&<w-\u001a:DY>\u001c7.F\u0001?!\ty$)D\u0001A\u0015\t\tu$\u0001\u0003vi&d\u0017BA\"A\u0005\u0015\u0019En\\2l\u00035!(/[4hKJ\u001cEn\\2lA\u0005YAn\\4jG\u0006d\u0007\u000b\\1o+\u00059\u0005c\u0001\u0015I\u0015&\u0011\u0011*\u000b\u0002\n\rVt7\r^5p]B\u0002\"a\u0013*\u000e\u00031S!!\u0014(\u0002\u000f1|w-[2bY*\u0011q\nU\u0001\u0006a2\fgn\u001d\u0006\u0003#v\t\u0001bY1uC2L8\u000f^\u0005\u0003'2\u00131\u0002T8hS\u000e\fG\u000e\u00157b]\u0006aAn\\4jG\u0006d\u0007\u000b\\1oA\u00051A(\u001b8jiz\"BaV-[7B\u0011\u0001\fA\u0007\u00023!)1g\u0002a\u0001k!)Ah\u0002a\u0001}!)Qi\u0002a\u0001\u000f\u0006\u0001C.Y:u\u001d>,\u00050Z2vi&|g\u000e\u0015:pOJ,7o]#wK:$H+[7f+\u0005q\u0006C\u0001\u0015`\u0013\t\u0001\u0017F\u0001\u0003M_:<\u0017\u0001\n7bgRtu.\u0012=fGV$\u0018n\u001c8Qe><'/Z:t\u000bZ,g\u000e\u001e+j[\u0016|F%Z9\u0015\u0005\r4\u0007C\u0001\u0015e\u0013\t)\u0017F\u0001\u0003V]&$\bbB4\n\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\n\u0014!\t7bgRtu.\u0012=fGV$\u0018n\u001c8Qe><'/Z:t\u000bZ,g\u000e\u001e+j[\u0016\u0004\u0013A\u00049s_\u001e\u0014Xm]:Ck\u001a4WM]\u000b\u0002WB\u0019A.]:\u000e\u00035T!A\\8\u0002\u000f5,H/\u00192mK*\u0011\u0001/K\u0001\u000bG>dG.Z2uS>t\u0017B\u0001:n\u0005\u0015\tV/Z;f!\t!h/D\u0001v\u0015\tQR$\u0003\u0002xk\n12\u000b\u001e:fC6LgnZ)vKJL\bK]8he\u0016\u001c8/A\bqe><'/Z:t\u0005V4g-\u001a:!\u0003mqw\u000eR1uCB\u0013xn\u001a:fgN,e/\u001a8u\u0013:$XM\u001d<bY\u0006abn\u001c#bi\u0006\u0004&o\\4sKN\u001cXI^3oi&sG/\u001a:wC2\u0004\u0013a\u0004;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;\u0016\u0003u\u00042A`A\u0006\u001b\u0005y(\u0002BA\u0001\u0003\u0007\taAZ8s[\u0006$(\u0002BA\u0003\u0003\u000f\tA\u0001^5nK*\u0011\u0011\u0011B\u0001\u0005U\u00064\u0018-C\u0002\u0002\u000e}\u0014\u0011\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u0003A!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$\b%\u0001\bsK\u000e,g\u000e\u001e)s_\u001e\u0014Xm]:\u0016\u0005\u0005U\u0001\u0003\u0002\u0015\u0002\u0018ML1!!\u0007*\u0005\u0015\t%O]1z\u00031a\u0017m\u001d;Qe><'/Z:t+\u0005\u0019\u0018AD;qI\u0006$X\r\u0015:pOJ,7o\u001d\u000b\u0004G\u0006\r\u0002BBA\u0013'\u0001\u00071/A\u0006oK^\u0004&o\\4sKN\u001c\u0018AD1eI:+w\u000f\u0015:pOJ,7o\u001d\u000b\u0004G\u0006-\u0002BBA\u0013)\u0001\u00071/\u0001\bva\u0012\fG/Z%eY\u0016tWm]:\u0015\u0013\r\f\t$a\u0010\u0002D\u0005\u001d\u0003bBA\u001a+\u0001\u0007\u0011QG\u0001\u0003S\u0012\u0004B!a\u000e\u0002<5\u0011\u0011\u0011\b\u0006\u0004\u0003\u0006\u001d\u0011\u0002BA\u001f\u0003s\u0011A!V+J\t\"9\u0011\u0011I\u000bA\u0002\u0005U\u0012!\u0002:v]&#\u0007BBA#+\u0001\u0007a,\u0001\u000fdkJ\u0014XM\u001c;Ue&<w-\u001a:Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9\t\r\u0005\u0015R\u00031\u0001t\u0003%\u0001xn\u001d;Fm\u0016tG\u000fF\u0002d\u0003\u001bBq!a\u0014\u0017\u0001\u0004\t\t&A\u0003fm\u0016tG\u000f\u0005\u0003\u0002T\u0005ecb\u0001;\u0002V%\u0019\u0011qK;\u0002-M#(/Z1nS:<\u0017+^3ss2K7\u000f^3oKJLA!a\u0017\u0002^\t)QI^3oi*\u0019\u0011qK;\u0002\u001f\u0019|'/\\1u)&lWm\u001d;b[B$B!a\u0019\u0002zA!\u0011QMA:\u001d\u0011\t9'a\u001c\u0011\u0007\u0005%\u0014&\u0004\u0002\u0002l)\u0019\u0011QN\u0013\u0002\rq\u0012xn\u001c;?\u0013\r\t\t(K\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0014q\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005E\u0014\u0006\u0003\u0004\u0002|]\u0001\rAX\u0001\u0007[&dG.[:")
public class ProgressReporter
implements Logging {
    private final SparkSession sparkSession;
    private final Clock triggerClock;
    private final Function0<LogicalPlan> logicalPlan;
    private long lastNoExecutionProgressEventTime;
    private final Queue<StreamingQueryProgress> progressBuffer;
    private final long noDataProgressEventInterval;
    private final DateTimeFormatter timestampFormat;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkSession sparkSession() {
        return this.sparkSession;
    }

    private Clock triggerClock() {
        return this.triggerClock;
    }

    public Function0<LogicalPlan> logicalPlan() {
        return this.logicalPlan;
    }

    public long lastNoExecutionProgressEventTime() {
        return this.lastNoExecutionProgressEventTime;
    }

    public void lastNoExecutionProgressEventTime_$eq(long x$1) {
        this.lastNoExecutionProgressEventTime = x$1;
    }

    private Queue<StreamingQueryProgress> progressBuffer() {
        return this.progressBuffer;
    }

    public long noDataProgressEventInterval() {
        return this.noDataProgressEventInterval;
    }

    private DateTimeFormatter timestampFormat() {
        return this.timestampFormat;
    }

    public StreamingQueryProgress[] recentProgress() {
        StreamingQueryProgress[] streamingQueryProgressArray;
        Queue<StreamingQueryProgress> queue = this.progressBuffer();
        synchronized (queue) {
            streamingQueryProgressArray = (StreamingQueryProgress[])this.progressBuffer().toArray(ClassTag$.MODULE$.apply(StreamingQueryProgress.class));
        }
        return streamingQueryProgressArray;
    }

    public StreamingQueryProgress lastProgress() {
        StreamingQueryProgress streamingQueryProgress;
        Queue<StreamingQueryProgress> queue = this.progressBuffer();
        synchronized (queue) {
            streamingQueryProgress = (StreamingQueryProgress)this.progressBuffer().lastOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return streamingQueryProgress;
    }

    public void updateProgress(StreamingQueryProgress newProgress) {
        this.lastNoExecutionProgressEventTime_$eq(this.triggerClock().getTimeMillis());
        this.addNewProgress(newProgress);
        this.postEvent((StreamingQueryListener.Event)new StreamingQueryListener.QueryProgressEvent(newProgress));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming query made progress: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STREAMING_QUERY_PROGRESS$.MODULE$, (Object)newProgress)}))));
    }

    private void addNewProgress(StreamingQueryProgress newProgress) {
        Queue<StreamingQueryProgress> queue = this.progressBuffer();
        synchronized (queue) {
            this.progressBuffer().$plus$eq((Object)newProgress);
            while (this.progressBuffer().length() >= this.sparkSession().sessionState().conf().streamingProgressRetention()) {
                this.progressBuffer().dequeue();
            }
        }
    }

    public void updateIdleness(UUID id, UUID runId, long currentTriggerStartTimestamp, StreamingQueryProgress newProgress) {
        long now = this.triggerClock().getTimeMillis();
        if (now - this.noDataProgressEventInterval() >= this.lastNoExecutionProgressEventTime()) {
            this.addNewProgress(newProgress);
            if (this.lastNoExecutionProgressEventTime() > Long.MIN_VALUE) {
                this.postEvent((StreamingQueryListener.Event)new StreamingQueryListener.QueryIdleEvent(id, runId, this.formatTimestamp(currentTriggerStartTimestamp)));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming query has been idle and waiting for new data more than "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TIME_UNITS$.MODULE$, (Object)BoxesRunTime.boxToLong((long)this.noDataProgressEventInterval()))})))));
            }
            this.lastNoExecutionProgressEventTime_$eq(now);
            return;
        }
    }

    private void postEvent(StreamingQueryListener.Event event) {
        this.sparkSession().streams().postListenerEvent(event);
    }

    public String formatTimestamp(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneId.of("Z")).format(this.timestampFormat());
    }

    public ProgressReporter(SparkSession sparkSession, Clock triggerClock, Function0<LogicalPlan> logicalPlan2) {
        this.sparkSession = sparkSession;
        this.triggerClock = triggerClock;
        this.logicalPlan = logicalPlan2;
        Logging.$init$((Logging)this);
        this.lastNoExecutionProgressEventTime = Long.MIN_VALUE;
        this.progressBuffer = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        this.noDataProgressEventInterval = sparkSession.sessionState().conf().streamingNoDataProgressEventInterval();
        this.timestampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(DateTimeUtils$.MODULE$.getZoneId("UTC"));
    }
}

