/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.sql.Date;
import java.util.concurrent.TimeUnit;
import org.apache.spark.api.java.Optional;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeTimeout$;
import org.apache.spark.sql.catalyst.plans.logical.ProcessingTimeTimeout$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.GroupStateImpl$;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.sql.streaming.TestGroupState;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import org.json4s.JBool$;
import org.json4s.JLong;
import org.json4s.JNull$;
import org.json4s.JObject;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.jackson.JsonMethods$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tMa!B\u001b7\u0001i\u0012\u0005\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011}\u0003!\u0011!Q\u0001\n\u0001D\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"A\u0001\u000e\u0001BC\u0002\u0013\u0005\u0013\u000e\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003k\u0011!q\u0007A!A!\u0002\u0013Q\u0007\"B8\u0001\t\u0013\u0001\bbB=\u0001\u0001\u0004%IA\u001f\u0005\bw\u0002\u0001\r\u0011\"\u0003}\u0011\u001d\t)\u0001\u0001Q!\n=C\u0001\"a\u0002\u0001\u0001\u0004%I!\u001b\u0005\n\u0003\u0013\u0001\u0001\u0019!C\u0005\u0003\u0017Aq!a\u0004\u0001A\u0003&!\u000e\u0003\u0005\u0002\u0012\u0001\u0001\r\u0011\"\u0003j\u0011%\t\u0019\u0002\u0001a\u0001\n\u0013\t)\u0002C\u0004\u0002\u001a\u0001\u0001\u000b\u0015\u00026\t\u0011\u0005m\u0001\u00011A\u0005\n%D\u0011\"!\b\u0001\u0001\u0004%I!a\b\t\u000f\u0005\r\u0002\u0001)Q\u0005U\"I\u0011Q\u0005\u0001A\u0002\u0013%\u0011q\u0005\u0005\n\u0003S\u0001\u0001\u0019!C\u0005\u0003WAq!a\f\u0001A\u0003&\u0001\r\u0003\u0004\u00022\u0001!\t%\u001b\u0005\u0007\u0003g\u0001A\u0011\t>\t\u000f\u0005U\u0002\u0001\"\u0011\u00028!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA!\u0001\u0011\u0005\u00131\t\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\t)\u0005\u0001C!\u0003\u001bBq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002j\u0001!\t%!\u001d\t\u000f\u0005%\u0004\u0001\"\u0011\u0002z!9\u0011\u0011\u000e\u0001\u0005B\u00055\u0005bBAJ\u0001\u0011\u0005\u0013Q\u0013\u0005\b\u0003/\u0003A\u0011IAK\u0011\u001d\tI\n\u0001C!\u00037Ca!!(\u0001\t\u0003J\u0007BBAP\u0001\u0011\u0005\u0013\u000eC\u0004\u0002\"\u0002!\t%a)\t\u000f\u0005M\u0006\u0001\"\u0003\u00026\"9\u0011\u0011\u0018\u0001\u0005\n\u0005\r\u0003\u0002CA^\u0001\u0011\u0005!(a'\b\u0011\u0005uf\u0007#\u0001;\u0003\u007f3q!\u000e\u001c\t\u0002i\n\t\r\u0003\u0004p[\u0011\u0005\u00111\u0019\u0005\n\u0003\u000bl#\u0019!C\u0001\u0003OAq!a2.A\u0003%\u0001\rC\u0004\u0002J6\"\t!a3\t\u000f\u0005\rX\u0006\"\u0001\u0002f\"9\u0011Q^\u0017\u0005\u0002\u0005=\bbBA{[\u0011\u0005\u0011q\u001f\u0002\u000f\u000fJ|W\u000f]*uCR,\u0017*\u001c9m\u0015\t9\u0004(A\u0005tiJ,\u0017-\\5oO*\u0011\u0011HO\u0001\nKb,7-\u001e;j_:T!a\u000f\u001f\u0002\u0007M\fHN\u0003\u0002>}\u0005)1\u000f]1sW*\u0011q\bQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\u000b1a\u001c:h+\t\u0019\u0015kE\u0002\u0001\t*\u0003\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u0013a!\u00118z%\u00164\u0007cA&N\u001f6\tAJ\u0003\u00028u%\u0011a\n\u0014\u0002\u000f)\u0016\u001cHo\u0012:pkB\u001cF/\u0019;f!\t\u0001\u0016\u000b\u0004\u0001\u0005\u000bI\u0003!\u0019\u0001+\u0003\u0003M\u001b\u0001!\u0005\u0002V1B\u0011QIV\u0005\u0003/\u001a\u0013qAT8uQ&tw\r\u0005\u0002F3&\u0011!L\u0012\u0002\u0004\u0003:L\u0018!D8qi&|g.\u00197WC2,X\rE\u0002F;>K!A\u0018$\u0003\r=\u0003H/[8o\u0003U\u0011\u0017\r^2i!J|7-Z:tS:<G+[7f\u001bN\u0004\"!R1\n\u0005\t4%\u0001\u0002'p]\u001e\fA#\u001a<f]R$\u0016.\\3XCR,'/\\1sW6\u001b\u0018a\u0003;j[\u0016|W\u000f^\"p]\u001a\u0004\"a\u00134\n\u0005\u001dd%!E$s_V\u00048\u000b^1uKRKW.Z8vi\u0006Y\u0001.Y:US6,GmT;u+\u0005Q\u0007CA#l\u0013\tagIA\u0004C_>dW-\u00198\u0002\u0019!\f7\u000fV5nK\u0012|U\u000f\u001e\u0011\u0002!]\fG/\u001a:nCJ\\\u0007K]3tK:$\u0018A\u0002\u001fj]&$h\bF\u0004rgR,ho\u001e=\u0011\u0007I\u0004q*D\u00017\u0011\u0015Y\u0006\u00021\u0001]\u0011\u0015y\u0006\u00021\u0001a\u0011\u0015\u0019\u0007\u00021\u0001a\u0011\u0015!\u0007\u00021\u0001f\u0011\u0015A\u0007\u00021\u0001k\u0011\u0015q\u0007\u00021\u0001k\u0003\u00151\u0018\r\\;f+\u0005y\u0015!\u0003<bYV,w\fJ3r)\ri\u0018\u0011\u0001\t\u0003\u000bzL!a $\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0007Q\u0011\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010J\u0019\u0002\rY\fG.^3!\u0003\u001d!WMZ5oK\u0012\f1\u0002Z3gS:,Gm\u0018\u0013fcR\u0019Q0!\u0004\t\u0011\u0005\rQ\"!AA\u0002)\f\u0001\u0002Z3gS:,G\rI\u0001\bkB$\u0017\r^3e\u0003-)\b\u000fZ1uK\u0012|F%Z9\u0015\u0007u\f9\u0002\u0003\u0005\u0002\u0004A\t\t\u00111\u0001k\u0003!)\b\u000fZ1uK\u0012\u0004\u0013a\u0002:f[>4X\rZ\u0001\fe\u0016lwN^3e?\u0012*\u0017\u000fF\u0002~\u0003CA\u0001\"a\u0001\u0014\u0003\u0003\u0005\rA[\u0001\te\u0016lwN^3eA\u0005\u0001B/[7f_V$H+[7fgR\fW\u000e]\u000b\u0002A\u0006!B/[7f_V$H+[7fgR\fW\u000e]0%KF$2!`A\u0017\u0011!\t\u0019AFA\u0001\u0002\u0004\u0001\u0017!\u0005;j[\u0016|W\u000f\u001e+j[\u0016\u001cH/Y7qA\u00051Q\r_5tiN\f1aZ3u\u0003%9W\r^(qi&|g.F\u0001]\u0003\u0019)\b\u000fZ1uKR\u0019Q0!\u0010\t\r\u0005}2\u00041\u0001P\u0003!qWm\u001e,bYV,\u0017A\u0002:f[>4X\rF\u0001~\u0003I\u0019X\r\u001e+j[\u0016|W\u000f\u001e#ve\u0006$\u0018n\u001c8\u0015\u0007u\fI\u0005\u0003\u0004\u0002Lu\u0001\r\u0001Y\u0001\u000bIV\u0014\u0018\r^5p]6\u001bHcA?\u0002P!9\u0011\u0011\u000b\u0010A\u0002\u0005M\u0013\u0001\u00033ve\u0006$\u0018n\u001c8\u0011\t\u0005U\u00131\r\b\u0005\u0003/\ny\u0006E\u0002\u0002Z\u0019k!!a\u0017\u000b\u0007\u0005u3+\u0001\u0004=e>|GOP\u0005\u0004\u0003C2\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002f\u0005\u001d$AB*ue&twMC\u0002\u0002b\u0019\u000b1c]3u)&lWm\\;u)&lWm\u001d;b[B$2!`A7\u0011\u0019\tyg\ba\u0001A\u0006YA/[7fgR\fW\u000e]'t)\u0015i\u00181OA;\u0011\u0019\ty\u0007\ta\u0001A\"9\u0011q\u000f\u0011A\u0002\u0005M\u0013AE1eI&$\u0018n\u001c8bY\u0012+(/\u0019;j_:$2!`A>\u0011\u001d\ti(\ta\u0001\u0003\u007f\n\u0011\u0002^5nKN$\u0018-\u001c9\u0011\t\u0005\u0005\u0015\u0011R\u0007\u0003\u0003\u0007S1aOAC\u0015\t\t9)\u0001\u0003kCZ\f\u0017\u0002BAF\u0003\u0007\u0013A\u0001R1uKR)Q0a$\u0002\u0012\"9\u0011Q\u0010\u0012A\u0002\u0005}\u0004bBA<E\u0001\u0007\u00111K\u0001\u0016O\u0016$8)\u001e:sK:$x+\u0019;fe6\f'o['t)\u0005\u0001\u0017AG4fi\u000e+(O]3oiB\u0013xnY3tg&tw\rV5nK6\u001b\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0013!C5t%\u0016lwN^3e\u0003%I7/\u00169eCR,G-A\u000bhKR$\u0016.\\3pkR$\u0016.\\3ti\u0006l\u0007/T:\u0016\u0005\u0005\u0015\u0006#BAT\u0003_\u0003WBAAU\u0015\u0011\t9)a+\u000b\u0007\u00055F(A\u0002ba&LA!!-\u0002*\nAq\n\u001d;j_:\fG.A\u0007qCJ\u001cX\rR;sCRLwN\u001c\u000b\u0004A\u0006]\u0006bBA)S\u0001\u0007\u00111K\u0001\u001dG\",7m\u001b+j[\u0016|W\u000f\u001e+j[\u0016\u001cH/Y7q\u00032dwn^3e\u0003\u0011Q7o\u001c8\u0002\u001d\u001d\u0013x.\u001e9Ti\u0006$X-S7qYB\u0011!/L\n\u0003[\u0011#\"!a0\u0002\u00199{u\fV%N\u000bN#\u0016)\u0014)\u0002\u001b9{u\fV%N\u000bN#\u0016)\u0014)!\u0003I\u0019'/Z1uK\u001a{'o\u0015;sK\u0006l\u0017N\\4\u0016\t\u00055\u00171\u001b\u000b\u000f\u0003\u001f\f).!7\u0002\\\u0006u\u0017q\\Aq!\u0011\u0011\b!!5\u0011\u0007A\u000b\u0019\u000eB\u0003Sc\t\u0007A\u000b\u0003\u0004\\c\u0001\u0007\u0011q\u001b\t\u0005\u000bv\u000b\t\u000eC\u0003`c\u0001\u0007\u0001\rC\u0003dc\u0001\u0007\u0001\rC\u0003ec\u0001\u0007Q\rC\u0003ic\u0001\u0007!\u000eC\u0003oc\u0001\u0007!.\u0001\bde\u0016\fG/\u001a$pe\n\u000bGo\u00195\u0015\r\u0005\u001d\u0018\u0011^Av!\r\u0011\b\u0001\u0017\u0005\u0006IJ\u0002\r!\u001a\u0005\u0006]J\u0002\rA[\u0001\u001cOJ|W\u000f]*uCR,G+[7f_V$hI]8n'R\u0014\u0018N\\4\u0015\u0007\u0015\f\t\u0010C\u0004\u0002tN\u0002\r!a\u0015\u0002\u000b\rd\u0017M\u001f>\u0002\u0011\u0019\u0014x.\u001c&t_:,B!!?\u0002\u0000R1\u00111 B\u0001\u0005\u000b\u0001BA\u001d\u0001\u0002~B\u0019\u0001+a@\u0005\u000bI#$\u0019\u0001+\t\re$\u0004\u0019\u0001B\u0002!\u0011)U,!@\t\u000f\u0005mF\u00071\u0001\u0003\bA!!\u0011\u0002B\b\u001b\t\u0011YAC\u0002\u0003\u000e\u0001\u000baA[:p]R\u001a\u0018\u0002\u0002B\t\u0005\u0017\u0011aA\u0013,bYV,\u0007")
public class GroupStateImpl<S>
implements TestGroupState<S> {
    private final long batchProcessingTimeMs;
    private final long eventTimeWatermarkMs;
    private final GroupStateTimeout timeoutConf;
    private final boolean hasTimedOut;
    private final boolean watermarkPresent;
    private S value;
    private boolean org$apache$spark$sql$execution$streaming$GroupStateImpl$$defined;
    private boolean org$apache$spark$sql$execution$streaming$GroupStateImpl$$updated;
    private boolean org$apache$spark$sql$execution$streaming$GroupStateImpl$$removed;
    private long org$apache$spark$sql$execution$streaming$GroupStateImpl$$timeoutTimestamp;

    public static <S> GroupStateImpl<S> fromJson(Option<S> value, JValue json) {
        return GroupStateImpl$.MODULE$.fromJson(value, json);
    }

    public static GroupStateTimeout groupStateTimeoutFromString(String clazz) {
        return GroupStateImpl$.MODULE$.groupStateTimeoutFromString(clazz);
    }

    public static GroupStateImpl<Object> createForBatch(GroupStateTimeout timeoutConf, boolean watermarkPresent) {
        return GroupStateImpl$.MODULE$.createForBatch(timeoutConf, watermarkPresent);
    }

    public static <S> GroupStateImpl<S> createForStreaming(Option<S> optionalValue, long batchProcessingTimeMs, long eventTimeWatermarkMs, GroupStateTimeout timeoutConf, boolean hasTimedOut, boolean watermarkPresent) {
        return GroupStateImpl$.MODULE$.createForStreaming(optionalValue, batchProcessingTimeMs, eventTimeWatermarkMs, timeoutConf, hasTimedOut, watermarkPresent);
    }

    public static long NO_TIMESTAMP() {
        return GroupStateImpl$.MODULE$.NO_TIMESTAMP();
    }

    public boolean hasTimedOut() {
        return this.hasTimedOut;
    }

    private S value() {
        return this.value;
    }

    private void value_$eq(S x$1) {
        this.value = x$1;
    }

    private boolean defined() {
        return this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$defined;
    }

    public void org$apache$spark$sql$execution$streaming$GroupStateImpl$$defined_$eq(boolean x$1) {
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$defined = x$1;
    }

    private boolean updated() {
        return this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$updated;
    }

    public void org$apache$spark$sql$execution$streaming$GroupStateImpl$$updated_$eq(boolean x$1) {
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$updated = x$1;
    }

    private boolean removed() {
        return this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$removed;
    }

    public void org$apache$spark$sql$execution$streaming$GroupStateImpl$$removed_$eq(boolean x$1) {
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$removed = x$1;
    }

    private long timeoutTimestamp() {
        return this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$timeoutTimestamp;
    }

    public void org$apache$spark$sql$execution$streaming$GroupStateImpl$$timeoutTimestamp_$eq(long x$1) {
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$timeoutTimestamp = x$1;
    }

    public boolean exists() {
        return this.defined();
    }

    public S get() {
        if (this.defined()) {
            return this.value();
        }
        throw QueryExecutionErrors$.MODULE$.stateNotDefinedOrAlreadyRemovedError();
    }

    public Option<S> getOption() {
        if (this.defined()) {
            return new Some(this.value());
        }
        return None$.MODULE$;
    }

    public void update(S newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("'null' is not a valid state value");
        }
        this.value_$eq(newValue);
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$defined_$eq(true);
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$updated_$eq(true);
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$removed_$eq(false);
    }

    public void remove() {
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$defined_$eq(false);
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$updated_$eq(false);
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$removed_$eq(true);
    }

    public void setTimeoutDuration(long durationMs) {
        GroupStateTimeout groupStateTimeout = this.timeoutConf;
        ProcessingTimeTimeout$ processingTimeTimeout$ = ProcessingTimeTimeout$.MODULE$;
        if (groupStateTimeout == null ? processingTimeTimeout$ != null : !groupStateTimeout.equals(processingTimeTimeout$)) {
            throw QueryExecutionErrors$.MODULE$.cannotSetTimeoutDurationError();
        }
        if (durationMs <= 0L) {
            throw new IllegalArgumentException("Timeout duration must be positive");
        }
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$timeoutTimestamp_$eq(durationMs + this.batchProcessingTimeMs);
    }

    public void setTimeoutDuration(String duration) {
        this.setTimeoutDuration(this.parseDuration(duration));
    }

    public void setTimeoutTimestamp(long timestampMs) {
        this.checkTimeoutTimestampAllowed();
        if (timestampMs <= 0L) {
            throw new IllegalArgumentException("Timeout timestamp must be positive");
        }
        if (this.eventTimeWatermarkMs != GroupStateImpl$.MODULE$.NO_TIMESTAMP() && timestampMs < this.eventTimeWatermarkMs) {
            throw new IllegalArgumentException("Timeout timestamp (" + timestampMs + ") cannot be earlier than the current watermark (" + this.eventTimeWatermarkMs + ")");
        }
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$timeoutTimestamp_$eq(timestampMs);
    }

    public void setTimeoutTimestamp(long timestampMs, String additionalDuration) {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(this.parseDuration(additionalDuration) + timestampMs);
    }

    public void setTimeoutTimestamp(Date timestamp) {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(timestamp.getTime());
    }

    public void setTimeoutTimestamp(Date timestamp, String additionalDuration) {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(timestamp.getTime() + this.parseDuration(additionalDuration));
    }

    public long getCurrentWatermarkMs() {
        if (!this.watermarkPresent) {
            throw QueryExecutionErrors$.MODULE$.cannotGetEventTimeWatermarkError();
        }
        return this.eventTimeWatermarkMs;
    }

    public long getCurrentProcessingTimeMs() {
        return this.batchProcessingTimeMs;
    }

    public String toString() {
        return "GroupState(" + this.getOption().map((Function1 & Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable)() -> "<undefined>") + ")";
    }

    @Override
    public boolean isRemoved() {
        return this.removed();
    }

    @Override
    public boolean isUpdated() {
        return this.updated();
    }

    @Override
    public Optional<Object> getTimeoutTimestampMs() {
        if (this.timeoutTimestamp() != GroupStateImpl$.MODULE$.NO_TIMESTAMP()) {
            return Optional.of((Object)BoxesRunTime.boxToLong((long)this.timeoutTimestamp()));
        }
        return Optional.empty();
    }

    private long parseDuration(String duration) {
        CalendarInterval cal = IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)duration));
        if (IntervalUtils$.MODULE$.isNegative(cal, IntervalUtils$.MODULE$.isNegative$default$2())) {
            throw new IllegalArgumentException("Provided duration (" + duration + ") is negative");
        }
        return IntervalUtils$.MODULE$.getDuration(cal, TimeUnit.MILLISECONDS, IntervalUtils$.MODULE$.getDuration$default$3());
    }

    private void checkTimeoutTimestampAllowed() {
        GroupStateTimeout groupStateTimeout = this.timeoutConf;
        EventTimeTimeout$ eventTimeTimeout$ = EventTimeTimeout$.MODULE$;
        if (groupStateTimeout == null ? eventTimeTimeout$ != null : !groupStateTimeout.equals(eventTimeTimeout$)) {
            throw QueryExecutionErrors$.MODULE$.cannotSetTimeoutTimestampError();
        }
    }

    public String json() {
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"optionalValue"), (Object)JNull$.MODULE$);
        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"batchProcessingTimeMs"), (Object)new JLong(this.batchProcessingTimeMs));
        Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"eventTimeWatermarkMs"), (Object)new JLong(this.eventTimeWatermarkMs));
        Tuple2 tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timeoutConf"), (Object)new JString(Utils$.MODULE$.stripDollars(Utils$.MODULE$.getSimpleName(this.timeoutConf.getClass()))));
        Tuple2 tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hasTimedOut"), (Object)JBool$.MODULE$.apply(this.hasTimedOut()));
        Tuple2 tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"watermarkPresent"), (Object)JBool$.MODULE$.apply(this.watermarkPresent));
        Tuple2 tuple27 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defined"), (Object)JBool$.MODULE$.apply(this.defined()));
        Tuple2 tuple28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"updated"), (Object)JBool$.MODULE$.apply(this.updated()));
        Tuple2 tuple29 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"removed"), (Object)JBool$.MODULE$.apply(this.removed()));
        Tuple2 tuple210 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timeoutTimestamp"), (Object)new JLong(this.timeoutTimestamp()));
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JValue)new JObject(Nil$.MODULE$.$colon$colon((Object)tuple210).$colon$colon((Object)tuple29).$colon$colon((Object)tuple28).$colon$colon((Object)tuple27).$colon$colon((Object)tuple26).$colon$colon((Object)tuple25).$colon$colon((Object)tuple24).$colon$colon((Object)tuple23).$colon$colon((Object)tuple22).$colon$colon((Object)tuple2)), JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3()));
    }

    public GroupStateImpl(Option<S> optionalValue, long batchProcessingTimeMs, long eventTimeWatermarkMs, GroupStateTimeout timeoutConf, boolean hasTimedOut, boolean watermarkPresent) {
        this.batchProcessingTimeMs = batchProcessingTimeMs;
        this.eventTimeWatermarkMs = eventTimeWatermarkMs;
        this.timeoutConf = timeoutConf;
        this.hasTimedOut = hasTimedOut;
        this.watermarkPresent = watermarkPresent;
        this.value = optionalValue.getOrElse((Function0 & Serializable)() -> null);
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$defined = optionalValue.isDefined();
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$updated = false;
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$removed = false;
        this.org$apache$spark$sql$execution$streaming$GroupStateImpl$$timeoutTimestamp = GroupStateImpl$.MODULE$.NO_TIMESTAMP();
    }
}

