/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.joins;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.broadcast.BroadcastLifeCycleListener;
import org.apache.spark.broadcast.BroadcastManager;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerInterface;

public abstract class AbstractBroadcastReaperManager
extends SparkListener
implements BroadcastLifeCycleListener {
    private volatile BroadcastManager bcmInUse;
    private volatile boolean isRegistered = false;
    private volatile boolean isDriverSide = false;

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        this.clearAll();
    }

    public void onBroadcastManagerStop() {
        this.clearAll();
    }

    public void customCleanupOnApplicationEnd() {
    }

    public boolean isDriverSide() {
        return this.isDriverSide;
    }

    private void clearAll() {
        this.isRegistered = false;
        this.customCleanupOnApplicationEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkInstanceInitialized() {
        if (!this.isRegistered) {
            AbstractBroadcastReaperManager abstractBroadcastReaperManager = this;
            synchronized (abstractBroadcastReaperManager) {
                SparkEnv sparkEnv;
                if (!this.isRegistered && (sparkEnv = SparkEnv.get()) != null) {
                    if (SparkContext.DRIVER_IDENTIFIER().equals(sparkEnv.executorId())) {
                        this.isDriverSide = true;
                        SparkContext.getOrCreate().addSparkListener((SparkListenerInterface)this);
                    }
                    this.bcmInUse = sparkEnv.broadcastManager();
                    this.bcmInUse.registerBroadcastLifeCycleListener((BroadcastLifeCycleListener)this);
                    this.isRegistered = true;
                }
            }
        }
    }
}

