/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.v2.state.FromSnapshotOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StatePartitionReaderBase;
import org.apache.spark.sql.execution.datasources.v2.state.StateStoreInputPartition;
import org.apache.spark.sql.execution.datasources.v2.state.utils.SchemaUtil$;
import org.apache.spark.sql.execution.streaming.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.ReadStateStore;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.SupportsFineGrainedReplay;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001B\u0007\u000f\u0001}A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011!q\u0004A!A!\u0002\u0013y\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u00115\u0003!\u0011!Q\u0001\n9C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u0006/\u0002!\t\u0001\u0017\u0005\tE\u0002A)\u0019!C\u0005G\"Aq\r\u0001EC\u0002\u0013\u0005\u0003\u000eC\u0003|\u0001\u0011\u0005CP\u0001\u000bTi\u0006$X\rU1si&$\u0018n\u001c8SK\u0006$WM\u001d\u0006\u0003\u001fA\tQa\u001d;bi\u0016T!!\u0005\n\u0002\u0005Y\u0014$BA\n\u0015\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005U1\u0012!C3yK\u000e,H/[8o\u0015\t9\u0002$A\u0002tc2T!!\u0007\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005ma\u0012AB1qC\u000eDWMC\u0001\u001e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"E5\ta\"\u0003\u0002$\u001d\tA2\u000b^1uKB\u000b'\u000f^5uS>t'+Z1eKJ\u0014\u0015m]3\u0002\u0013M$xN]3D_:4\u0007C\u0001\u0014+\u001b\u00059#BA\b)\u0015\tIC#A\u0005tiJ,\u0017-\\5oO&\u00111f\n\u0002\u000f'R\fG/Z*u_J,7i\u001c8g\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003]Ej\u0011a\f\u0006\u0003aa\tA!\u001e;jY&\u0011!g\f\u0002\u001a'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\"p]\u001aLw-\u001e:bi&|g.A\u0005qCJ$\u0018\u000e^5p]B\u0011\u0011%N\u0005\u0003m9\u0011\u0001d\u0015;bi\u0016\u001cFo\u001c:f\u0013:\u0004X\u000f\u001e)beRLG/[8o\u0003\u0019\u00198\r[3nCB\u0011\u0011\bP\u0007\u0002u)\u00111HF\u0001\u0006if\u0004Xm]\u0005\u0003{i\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003MYW-_*uCR,WI\\2pI\u0016\u00148\u000b]3d!\t1\u0003)\u0003\u0002BO\t\u00192*Z=Ti\u0006$X-\u00128d_\u0012,'o\u00159fG\u0006!2\u000f^1uKZ\u000b'/[1cY\u0016LeNZ8PaR\u00042\u0001R$J\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%AB(qi&|g\u000e\u0005\u0002K\u00176\t\u0001&\u0003\u0002MQ\tqBK]1og\u001a|'/\\,ji\"\u001cF/\u0019;f-\u0006\u0014\u0018.\u00192mK&sgm\\\u0001\u001dgR\fG/Z*u_J,7i\u001c7GC6LG._*dQ\u0016l\u0017m\u00149u!\r!ui\u0014\t\u0003MAK!!U\u0014\u00033M#\u0018\r^3Ti>\u0014XmQ8m\r\u0006l\u0017\u000e\\=TG\",W.Y\u0001\u0017gR\fG/Z*dQ\u0016l\u0017\r\u0015:pm&$WM](qiB\u0019Ai\u0012+\u0011\u0005\u0019*\u0016B\u0001,(\u0005M\u0019F/\u0019;f'\u000eDW-\\1Qe>4\u0018\u000eZ3s\u0003\u0019a\u0014N\\5u}QI\u0011LW.];z{\u0006-\u0019\t\u0003C\u0001AQ\u0001J\u0005A\u0002\u0015BQ\u0001L\u0005A\u00025BQaM\u0005A\u0002QBQaN\u0005A\u0002aBQAP\u0005A\u0002}BQAQ\u0005A\u0002\rCQ!T\u0005A\u00029CQAU\u0005A\u0002M\u000bQa\u001d;pe\u0016,\u0012\u0001\u001a\t\u0003M\u0015L!AZ\u0014\u0003\u001dI+\u0017\rZ*uCR,7\u000b^8sK\u0006!\u0011\u000e^3s+\u0005I\u0007c\u00016sk:\u00111\u000e\u001d\b\u0003Y>l\u0011!\u001c\u0006\u0003]z\ta\u0001\u0010:p_Rt\u0014\"\u0001$\n\u0005E,\u0015a\u00029bG.\fw-Z\u0005\u0003gR\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003c\u0016\u0003\"A^=\u000e\u0003]T!\u0001\u001f\f\u0002\u0011\r\fG/\u00197zgRL!A_<\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0006G2|7/\u001a\u000b\u0002{B\u0011AI`\u0005\u0003\u007f\u0016\u0013A!\u00168ji\u0002")
public class StatePartitionReader
extends StatePartitionReaderBase {
    private ReadStateStore store;
    private Iterator<InternalRow> iter;
    private final StateStoreInputPartition partition;
    private final Option<TransformWithStateVariableInfo> stateVariableInfoOpt;
    private volatile byte bitmap$0;

    private ReadStateStore store$lzycompute() {
        StatePartitionReader statePartitionReader = this;
        synchronized (statePartitionReader) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                ReadStateStore readStateStore;
                Option<FromSnapshotOptions> option = this.partition.sourceOptions().fromSnapshotOptions();
                if (None$.MODULE$.equals(option)) {
                    readStateStore = this.provider().getReadStore(this.partition.sourceOptions().batchId() + 1L, this.provider().getReadStore$default$2());
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    FromSnapshotOptions fromSnapshotOptions = (FromSnapshotOptions)some.value();
                    if (!(this.provider() instanceof SupportsFineGrainedReplay)) {
                        throw StateStoreErrors$.MODULE$.stateStoreProviderDoesNotSupportFineGrainedReplay(this.provider().getClass().toString());
                    }
                    readStateStore = ((SupportsFineGrainedReplay)((Object)this.provider())).replayReadStateFromSnapshot(fromSnapshotOptions.snapshotStartBatchId() + 1L, this.partition.sourceOptions().batchId() + 1L);
                } else {
                    throw new MatchError(option);
                }
                this.store = readStateStore;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.store;
    }

    private ReadStateStore store() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.store$lzycompute();
        }
        return this.store;
    }

    private Iterator<InternalRow> iter$lzycompute() {
        StatePartitionReader statePartitionReader = this;
        synchronized (statePartitionReader) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Object object;
                String stateVarName = (String)this.stateVariableInfoOpt.map((Function1 & Serializable)x$2 -> x$2.stateName()).getOrElse((Function0 & Serializable)() -> StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME());
                if (this.stateVariableInfoOpt.isDefined()) {
                    TransformWithStateVariableInfo stateVariableInfo = (TransformWithStateVariableInfo)this.stateVariableInfoOpt.get();
                    Enumeration.Value stateVarType = stateVariableInfo.stateVariableType();
                    object = SchemaUtil$.MODULE$.processStateEntries(stateVarType, stateVarName, this.store(), this.keySchema(), this.partition.partition(), this.partition.sourceOptions());
                } else {
                    object = this.store().iterator(stateVarName).map((Function1 & Serializable)pair -> SchemaUtil$.MODULE$.unifyStateRowPair((Tuple2<UnsafeRow, UnsafeRow>)new Tuple2((Object)pair.key(), (Object)pair.value()), $this.partition.partition()));
                }
                this.iter = object;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.iter;
    }

    @Override
    public Iterator<InternalRow> iter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.iter$lzycompute();
        }
        return this.iter;
    }

    @Override
    public void close() {
        this.store().abort();
        super.close();
    }

    public StatePartitionReader(StateStoreConf storeConf, SerializableConfiguration hadoopConf, StateStoreInputPartition partition, StructType schema, KeyStateEncoderSpec keyStateEncoderSpec, Option<TransformWithStateVariableInfo> stateVariableInfoOpt, Option<StateStoreColFamilySchema> stateStoreColFamilySchemaOpt, Option<StateSchemaProvider> stateSchemaProviderOpt) {
        this.partition = partition;
        this.stateVariableInfoOpt = stateVariableInfoOpt;
        super(storeConf, hadoopConf, partition, schema, keyStateEncoderSpec, stateVariableInfoOpt, stateStoreColFamilySchemaOpt, stateSchemaProviderOpt);
    }
}

