/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.TimeTravelSpec$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SessionConfigSupport;
import org.apache.spark.sql.connector.catalog.StagedTable;
import org.apache.spark.sql.connector.catalog.StagingTableCatalog;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class DataSourceV2Utils$
implements Logging {
    public static final DataSourceV2Utils$ MODULE$ = new DataSourceV2Utils$();
    private static ObjectMapper objectMapper;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public scala.collection.immutable.Map<String, String> extractSessionConfigs(TableProvider source, SQLConf conf) {
        TableProvider tableProvider = source;
        if (tableProvider instanceof SessionConfigSupport) {
            SessionConfigSupport sessionConfigSupport = (SessionConfigSupport)tableProvider;
            String keyPrefix = sessionConfigSupport.keyPrefix();
            Predef$.MODULE$.require(keyPrefix != null, (Function0 & Serializable)() -> "The data source config key prefix can't be null.");
            Pattern pattern = Pattern.compile("^spark\\.datasource\\." + keyPrefix + "\\.(.+)");
            return (scala.collection.immutable.Map)conf.getAllConfs().flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    Matcher m = pattern.matcher(key);
                    if (m.matches() && m.groupCount() > 0) {
                        return new .colon.colon((Object)new Tuple2((Object)m.group(1), (Object)value), (List)Nil$.MODULE$);
                    }
                    return package$.MODULE$.Seq().empty();
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return Predef$.MODULE$.Map().empty();
    }

    public Table getTableFromProvider(TableProvider provider, CaseInsensitiveStringMap options, Option<StructType> userSpecifiedSchema) {
        Option<StructType> option = userSpecifiedSchema;
        if (option instanceof Some) {
            Some some = (Some)option;
            StructType schema = (StructType)some.value();
            if (provider.supportsExternalMetadata()) {
                return provider.getTable(schema, provider.inferPartitioning(options), options.asCaseSensitiveMap());
            }
            throw QueryExecutionErrors$.MODULE$.userSpecifiedSchemaUnsupportedByDataSourceError(provider);
        }
        if (None$.MODULE$.equals(option)) {
            return provider.getTable(provider.inferSchema(options), provider.inferPartitioning(options), options.asCaseSensitiveMap());
        }
        throw new MatchError(option);
    }

    public Option<LogicalPlan> loadV2Source(SparkSession sparkSession, TableProvider provider, Option<StructType> userSpecifiedSchema, CaseInsensitiveMap<String> extraOptions, String source, Seq<String> paths) {
        Tuple3 tuple3;
        CatalogManager catalogManager = sparkSession.sessionState().catalogManager();
        SQLConf conf = sparkSession.sessionState().conf();
        scala.collection.immutable.Map<String, String> sessionOptions = this.extractSessionConfigs(provider, conf);
        CaseInsensitiveMap<String> optionsWithPath = this.getOptionsWithPaths(extraOptions, paths);
        scala.collection.immutable.Map finalOptions = (scala.collection.immutable.Map)((MapOps)sessionOptions.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2Utils$.$anonfun$loadV2Source$1(optionsWithPath, x0$1)))).$plus$plus((IterableOnce)optionsWithPath.originalMap());
        CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)finalOptions).asJava());
        boolean bl = false;
        SupportsCatalogOptions supportsCatalogOptions = null;
        TableProvider tableProvider = provider;
        if (tableProvider instanceof SupportsCatalogOptions) {
            bl = true;
            supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
            if (userSpecifiedSchema.nonEmpty()) {
                throw new IllegalArgumentException(source + " does not support user specified schema. Please don't specify the schema.");
            }
        }
        if (bl) {
            None$ timeTravelVersion;
            Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
            TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
            Optional version = supportsCatalogOptions.extractTimeTravelVersion(dsOptions);
            Optional timestamp = supportsCatalogOptions.extractTimeTravelTimestamp(dsOptions);
            Object object = timeTravelVersion = version.isPresent() ? new Some(version.get()) : None$.MODULE$;
            None$ timeTravelTimestamp = timestamp.isPresent() ? (StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString((String)timestamp.get()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$1))))) ? new Some((Object)new Literal((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)timestamp.get()))), (DataType)LongType$.MODULE$)) : new Some((Object)Literal$.MODULE$.apply(timestamp.get()))) : None$.MODULE$;
            Option timeTravel = TimeTravelSpec$.MODULE$.create((Option)timeTravelTimestamp, (Option)timeTravelVersion, conf.sessionLocalTimeZone());
            v1 = new Tuple3((Object)CatalogV2Util$.MODULE$.getTable((CatalogPlugin)catalog, ident, timeTravel, CatalogV2Util$.MODULE$.getTable$default$4()), (Object)new Some((Object)catalog), (Object)new Some((Object)ident));
        } else {
            Table tbl = this.getTableFromProvider(provider, dsOptions, userSpecifiedSchema);
            v1 = tuple3 = new Tuple3((Object)tbl, (Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Table table = (Table)tuple3._1();
        Option catalog = (Option)tuple3._2();
        Option ident = (Option)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)table, (Object)catalog, (Object)ident);
        Table table2 = (Table)tuple32._1();
        Option catalog2 = (Option)tuple32._2();
        Option ident2 = (Option)tuple32._3();
        Set withRelations = Predef$.MODULE$.Set().empty();
        Table table3 = table2;
        if (table3 instanceof SupportsRead && DataSourceV2Implicits$.MODULE$.TableHelper(table2).supports(TableCapability.BATCH_READ)) {
            return Option$.MODULE$.apply((Object)DataSourceV2Relation$.MODULE$.create(table2, catalog2, ident2, dsOptions));
        }
        return None$.MODULE$;
    }

    public Option<TableProvider> getTableProvider(String provider, SQLConf conf) {
        Some some;
        TableProvider p;
        if (DDLUtils$.MODULE$.isHiveTable((Option<String>)new Some((Object)provider))) {
            return None$.MODULE$;
        }
        Option<TableProvider> option = DataSource$.MODULE$.lookupDataSourceV2(provider, conf);
        if (option instanceof Some && !((p = (TableProvider)(some = (Some)option).value()) instanceof FileDataSourceV2)) {
            return new Some((Object)p);
        }
        return None$.MODULE$;
    }

    private ObjectMapper objectMapper$lzycompute() {
        DataSourceV2Utils$ dataSourceV2Utils$ = this;
        synchronized (dataSourceV2Utils$) {
            if (!bitmap$0) {
                objectMapper = new ObjectMapper();
                bitmap$0 = true;
            }
        }
        return objectMapper;
    }

    private ObjectMapper objectMapper() {
        if (!bitmap$0) {
            return this.objectMapper$lzycompute();
        }
        return objectMapper;
    }

    public CaseInsensitiveMap<String> getOptionsWithPaths(CaseInsensitiveMap<String> extraOptions, Seq<String> paths) {
        if (paths.isEmpty()) {
            return extraOptions;
        }
        if (paths.length() == 1) {
            return extraOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), paths.head()));
        }
        return extraOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paths"), (Object)this.objectMapper().writeValueAsString(paths.toArray(ClassTag$.MODULE$.apply(String.class)))));
    }

    public void commitStagedChanges(SparkContext sparkContext, Table table, scala.collection.immutable.Map<String, SQLMetric> metrics) {
        Table table2 = table;
        if (table2 instanceof StagedTable) {
            StagedTable stagedTable = (StagedTable)table2;
            stagedTable.commitStagedChanges();
            CustomTaskMetric[] driverMetrics = stagedTable.reportDriverMetrics();
            if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])driverMetrics))) {
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])driverMetrics), (Function1 & Serializable)taskMetric -> {
                    DataSourceV2Utils$.$anonfun$commitStagedChanges$1(metrics, taskMetric);
                    return BoxedUnit.UNIT;
                });
                String executionId = sparkContext.getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
                SQLMetrics$.MODULE$.postDriverMetricUpdates(sparkContext, executionId, (Seq<SQLMetric>)metrics.values().toSeq());
                return;
            }
            return;
        }
    }

    public scala.collection.immutable.Map<String, SQLMetric> commitMetrics(SparkContext sparkContext, StagingTableCatalog tableCatalog) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])tableCatalog.supportedCustomMetrics()), (Function1 & Serializable)metric -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)metric.name()), (Object)SQLMetrics$.MODULE$.createV2CustomMetric(sparkContext, (CustomMetric)metric)), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$loadV2Source$1(CaseInsensitiveMap optionsWithPath$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return !optionsWithPath$1.contains(k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$commitStagedChanges$1(scala.collection.immutable.Map metrics$1, CustomTaskMetric taskMetric) {
        metrics$1.get((Object)taskMetric.name()).foreach((Function1 & Serializable)x$3 -> {
            x$3.set(taskMetric.value());
            return BoxedUnit.UNIT;
        });
    }

    private DataSourceV2Utils$() {
    }
}

