/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet.bcvar;

import java.util.Comparator;
import java.util.NavigableSet;
import scala.Function0;

public final class RangeInPredUtil$ {
    public static final RangeInPredUtil$ MODULE$ = new RangeInPredUtil$();
    private static final boolean KEEP = true;
    private static final boolean DISCARD = false;

    private boolean KEEP() {
        return KEEP;
    }

    private boolean DISCARD() {
        return DISCARD;
    }

    public <T> boolean isInRange(Function0<T> lowerBoundSupplier, Function0<T> upperBoundSupplier, NavigableSet<T> rangeSet, boolean keepIfBoundsNull, Comparator<T> comparator) {
        if (rangeSet.isEmpty()) {
            return this.DISCARD();
        }
        Object lower = lowerBoundSupplier.apply();
        Object upper = upperBoundSupplier.apply();
        if (lower != null && upper != null) {
            Object leastElementGELower = rangeSet.ceiling(lower);
            if (leastElementGELower == null) {
                return this.DISCARD();
            }
            if (comparator.compare(leastElementGELower, lower) == 0) {
                return this.KEEP();
            }
            if (comparator.compare(leastElementGELower, upper) > 0) {
                return this.DISCARD();
            }
            return this.KEEP();
        }
        if (upper != null) {
            if (rangeSet.floor(upper) != null) {
                return this.KEEP();
            }
            return this.DISCARD();
        }
        if (lower != null) {
            if (rangeSet.ceiling(lower) != null) {
                return this.KEEP();
            }
            return this.DISCARD();
        }
        if (keepIfBoundsNull) {
            return this.KEEP();
        }
        return this.DISCARD();
    }

    public <T> boolean isStrictlyInRange(Function0<T> lowerBoundSupplier, Function0<T> upperBoundSupplier, NavigableSet<T> rangeSet, boolean keepIfBoundsNull, Comparator<T> comparator) {
        if (rangeSet.isEmpty()) {
            return this.DISCARD();
        }
        Object lower = lowerBoundSupplier.apply();
        Object upper = upperBoundSupplier.apply();
        if (rangeSet.contains(lower) && rangeSet.contains(upper) && comparator.compare(lower, upper) == 0) {
            return this.KEEP();
        }
        return this.DISCARD();
    }

    private RangeInPredUtil$() {
    }
}

