/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import org.apache.parquet.io.api.Binary;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class ParquetFilters$ {
    public static final ParquetFilters$ MODULE$ = new ParquetFilters$();

    public Integer toIntValue(Object v) {
        return (Integer)Option$.MODULE$.apply(v).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ParquetFilters$.$anonfun$toIntValue$1(x0$1))).map((Function1 & Serializable)x$22 -> ParquetFilters$.$anonfun$toIntValue$2(BoxesRunTime.unboxToInt((Object)x$22))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Long toLongValue(Object v) {
        Object object = v;
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return Predef$.MODULE$.long2Long(IntervalUtils$.MODULE$.durationToMicros(duration));
        }
        return (Long)object;
    }

    public int dateToDays(Object date, RebaseDateTime.RebaseSpec datetimeRebaseSpec) {
        int n;
        Object object = date;
        if (object instanceof Date) {
            Date date2 = (Date)object;
            n = DateTimeUtils$.MODULE$.fromJavaDate(date2);
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            n = DateTimeUtils$.MODULE$.localDateToDays(localDate);
        } else {
            throw new MatchError(object);
        }
        int gregorianDays = n;
        Enumeration.Value value = datetimeRebaseSpec.mode();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return RebaseDateTime$.MODULE$.rebaseGregorianToJulianDays(gregorianDays);
        }
        return gregorianDays;
    }

    public Long timestampToMicros(Object v, RebaseDateTime.RebaseSpec datetimeRebaseSpec) {
        long l;
        Object object = v;
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            l = DateTimeUtils$.MODULE$.instantToMicros(instant);
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            l = DateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp);
        } else {
            throw new MatchError(object);
        }
        long gregorianMicros = l;
        Enumeration.Value value = datetimeRebaseSpec.mode();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return Predef$.MODULE$.long2Long(RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(datetimeRebaseSpec.timeZone(), gregorianMicros));
        }
        return Predef$.MODULE$.long2Long(gregorianMicros);
    }

    public Long timestampToMillis(Object v, RebaseDateTime.RebaseSpec datetimeRebaseSpec) {
        Long micros = this.timestampToMicros(v, datetimeRebaseSpec);
        long millis = DateTimeUtils$.MODULE$.microsToMillis(Predef$.MODULE$.Long2long(micros));
        return BoxesRunTime.boxToLong((long)millis);
    }

    public Binary toBinary(Object v) {
        Object object = v;
        if (object instanceof String) {
            String string = (String)object;
            return Binary.fromString((String)string);
        }
        throw new MatchError(object);
    }

    public static final /* synthetic */ int $anonfun$toIntValue$1(Object x0$1) {
        Object object = x0$1;
        if (object instanceof Period) {
            Period period = (Period)object;
            return IntervalUtils$.MODULE$.periodToMonths(period);
        }
        return ((Number)object).intValue();
    }

    public static final /* synthetic */ Integer $anonfun$toIntValue$2(int x$22) {
        return BoxesRunTime.boxToInteger((int)x$22);
    }

    private ParquetFilters$() {
    }
}

