/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.bcvar.BroadcastedJoinKeysWrapper;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.ConstantColumnVector;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t5d\u0001B\u000f\u001f\u00015BQ\u0001\u0015\u0001\u0005\u0002ECQ\u0001\u0016\u0001\u0005BUCQA\u0018\u0001\u0005BUCQa\u0018\u0001\u0005B\u0001DQ\u0001\u001a\u0001\u0005B\u0015DQA\u001c\u0001\u0005B=Dq!!\t\u0001\t\u0003\n\u0019\u0003C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBAA\u0001\u0011\u0005\u00131\u0011\u0005\b\u0003\u001b\u0004A\u0011IAh\u0011\u001d\tY\u000e\u0001C!\u0003;<q!a:\u001f\u0011\u0003\tIO\u0002\u0004\u001e=!\u0005\u00111\u001e\u0005\u0007!>!\t!a?\t\u0013\u0005uxB1A\u0005\u0002\u0005}\b\u0002\u0003B\u0006\u001f\u0001\u0006IA!\u0001\t\u0013\t5qB1A\u0005\u0002\u0005}\b\u0002\u0003B\b\u001f\u0001\u0006IA!\u0001\t\u0013\tEqB1A\u0005\u0002\tM\u0001\u0002\u0003B\u000b\u001f\u0001\u0006I!!9\t\u0011\t]q\u0002\"\u0001\u001f\u00053A\u0001Ba\f\u0010\t\u0003q\"\u0011\u0007\u0005\b\u0005{yA\u0011\u0001B \u0011\u001d\u0011Ie\u0004C\u0001\u0005\u0017BqAa\u0017\u0010\t\u0013\u0011i\u0006C\u0005\u0003d=\t\t\u0011\"\u0003\u0003f\t\t\u0002+\u0019:rk\u0016$h)\u001b7f\r>\u0014X.\u0019;\u000b\u0005}\u0001\u0013a\u00029beF,X\r\u001e\u0006\u0003C\t\n1\u0002Z1uCN|WO]2fg*\u00111\u0005J\u0001\nKb,7-\u001e;j_:T!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u00185qy\"\u0005CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g\r\u0005\u00026m5\t\u0001%\u0003\u00028A\tQa)\u001b7f\r>\u0014X.\u0019;\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m\"\u0013aB:pkJ\u001cWm]\u0005\u0003{i\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IJ\u0001\tS:$XM\u001d8bY&\u00111\t\u0011\u0002\b\u0019><w-\u001b8h!\t)UJ\u0004\u0002G\u0017:\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nL\u0001\u0007yI|w\u000e\u001e \n\u0003EJ!\u0001\u0014\u0019\u0002\u000fA\f7m[1hK&\u0011aj\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0019B\na\u0001P5oSRtD#\u0001*\u0011\u0005M\u0003Q\"\u0001\u0010\u0002\u0013MDwN\u001d;OC6,G#\u0001,\u0011\u0005][fB\u0001-Z!\t9\u0005'\u0003\u0002[a\u00051\u0001K]3eK\u001aL!\u0001X/\u0003\rM#(/\u001b8h\u0015\tQ\u0006'\u0001\u0005u_N#(/\u001b8h\u0003!A\u0017m\u001d5D_\u0012,G#A1\u0011\u0005=\u0012\u0017BA21\u0005\rIe\u000e^\u0001\u0007KF,\u0018\r\\:\u0015\u0005\u0019L\u0007CA\u0018h\u0013\tA\u0007GA\u0004C_>dW-\u00198\t\u000b),\u0001\u0019A6\u0002\u000b=$\b.\u001a:\u0011\u0005=b\u0017BA71\u0005\r\te._\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\baNL\u0018qAA\t!\t)\u0014/\u0003\u0002sA\t\u0019r*\u001e;qkR<&/\u001b;fe\u001a\u000b7\r^8ss\")AO\u0002a\u0001k\u0006a1\u000f]1sWN+7o]5p]B\u0011ao^\u0007\u0002I%\u0011\u0001\u0010\n\u0002\r'B\f'o[*fgNLwN\u001c\u0005\u0006u\u001a\u0001\ra_\u0001\u0004U>\u0014\u0007c\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006IQ.\u00199sK\u0012,8-\u001a\u0006\u0004\u0003\u0003A\u0013A\u00025bI>|\u0007/C\u0002\u0002\u0006u\u00141AS8c\u0011\u001d\tIA\u0002a\u0001\u0003\u0017\tqa\u001c9uS>t7\u000fE\u0003X\u0003\u001b1f+C\u0002\u0002\u0010u\u00131!T1q\u0011\u001d\t\u0019B\u0002a\u0001\u0003+\t!\u0002Z1uCN\u001b\u0007.Z7b!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000eI\u0005)A/\u001f9fg&!\u0011qDA\r\u0005)\u0019FO];diRK\b/Z\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0005\u0002&\u0005-\u0012QFA\u0019!\u0015y\u0013qEA\u000b\u0013\r\tI\u0003\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bQ<\u0001\u0019A;\t\u000f\u0005=r\u00011\u0001\u0002\f\u0005Q\u0001/\u0019:b[\u0016$XM]:\t\u000f\u0005Mr\u00011\u0001\u00026\u0005)a-\u001b7fgB)Q)a\u000e\u0002<%\u0019\u0011\u0011H(\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\te`\u0001\u0003MNLA!!\u0012\u0002@\tQa)\u001b7f'R\fG/^:\u0002\u0019M,\b\u000f]8si\n\u000bGo\u00195\u0015\u000b\u0019\fY%!\u0014\t\u000bQD\u0001\u0019A;\t\u000f\u0005=\u0003\u00021\u0001\u0002\u0016\u000511o\u00195f[\u0006\f1B^3di>\u0014H+\u001f9fgRA\u0011QKA-\u0003;\n\t\u0007E\u00030\u0003O\t9\u0006\u0005\u0003F\u0003o1\u0006bBA.\u0013\u0001\u0007\u0011QC\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0011\u001d\ty&\u0003a\u0001\u0003+\tq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\b\u0003GJ\u0001\u0019AA3\u0003\u001d\u0019\u0018\u000f\\\"p]\u001a\u0004B!a\u001a\u0002l5\u0011\u0011\u0011\u000e\u0006\u0003\u0003\u0012JA!!\u001c\u0002j\t91+\u0015'D_:4\u0017aC5t'Bd\u0017\u000e^1cY\u0016$rAZA:\u0003k\n9\bC\u0003u\u0015\u0001\u0007Q\u000fC\u0004\u0002\n)\u0001\r!a\u0003\t\u000f\u0005e$\u00021\u0001\u0002|\u0005!\u0001/\u0019;i!\u0011\ti$! \n\t\u0005}\u0014q\b\u0002\u0005!\u0006$\b.\u0001\u0010ck&dGMU3bI\u0016\u0014x+\u001b;i!\u0006\u0014H/\u001b;j_:4\u0016\r\\;fgR\u0011\u0012QQAR\u0003K\u000b9+!+\u0002,\u0006]\u0016\u0011XAe!\u001dy\u0013qQAF\u0003#K1!!#1\u0005%1UO\\2uS>t\u0017\u0007E\u00026\u0003\u001bK1!a$!\u0005=\u0001\u0016M\u001d;ji&|g.\u001a3GS2,\u0007#B#\u0002\u0014\u0006]\u0015bAAK\u001f\nA\u0011\n^3sCR|'\u000f\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\r\ti\nJ\u0001\tG\u0006$\u0018\r\\=ti&!\u0011\u0011UAN\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000bQ\\\u0001\u0019A;\t\u000f\u0005M1\u00021\u0001\u0002\u0016!9\u0011qL\u0006A\u0002\u0005U\u0001bBA.\u0017\u0001\u0007\u0011Q\u0003\u0005\b\u0003[[\u0001\u0019AAX\u0003\u001d1\u0017\u000e\u001c;feN\u0004R!RA\u001c\u0003c\u00032!OAZ\u0013\r\t)L\u000f\u0002\u0007\r&dG/\u001a:\t\u000f\u0005%1\u00021\u0001\u0002\f!9\u00111X\u0006A\u0002\u0005u\u0016A\u00035bI>|\u0007oQ8oMB!\u0011qXAc\u001b\t\t\tMC\u0002\u0002D~\fAaY8oM&!\u0011qYAa\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"1\u00111Z\u0006A\u0002\u0005\f!#\u001a=qK\u000e$X\r\u001a\"D-\u0006\u00148i\\;oi\u0006y1/\u001e9q_J$H)\u0019;b)f\u0004X\rF\u0002g\u0003#Dq!a5\r\u0001\u0004\t).\u0001\u0005eCR\fG+\u001f9f!\u0011\t9\"a6\n\t\u0005e\u0017\u0011\u0004\u0002\t\t\u0006$\u0018\rV=qK\u0006!R.\u001a;bI\u0006$\u0018mU2iK6\fg)[3mIN,\"!a8\u0011\u000b\u0015\u000b9$!9\u0011\t\u0005]\u00111]\u0005\u0005\u0003K\fIBA\u0006TiJ,8\r\u001e$jK2$\u0017!\u0005)beF,X\r\u001e$jY\u00164uN]7biB\u00111kD\n\u0006\u001f9r\u0014Q\u001e\t\u0005\u0003_\fI0\u0004\u0002\u0002r*!\u00111_A{\u0003\tIwN\u0003\u0002\u0002x\u0006!!.\u0019<b\u0013\rq\u0015\u0011\u001f\u000b\u0003\u0003S\f\u0011BU(X?&sE)\u0012-\u0016\u0005\t\u0005\u0001\u0003\u0002B\u0002\u0005\u0013i!A!\u0002\u000b\t\t\u001d\u0011Q_\u0001\u0005Y\u0006tw-C\u0002]\u0005\u000b\t!BU(X?&sE)\u0012-!\u0003}\u0011vjV0J\u001d\u0012+\u0005l\u0018+F\u001bB{%+\u0011*Z?\u000e{E*V'O?:\u000bU*R\u0001!%>;v,\u0013(E\u000bb{F+R'Q\u001fJ\u000b%+W0D\u001f2+VJT0O\u00036+\u0005%A\bS\u001f^{\u0016J\u0014#F1~3\u0015*\u0012'E+\t\t\t/\u0001\tS\u001f^{\u0016J\u0014#F1~3\u0015*\u0012'EA\u0005Q!/Z1e'\u000eDW-\\1\u0015\r\u0005\u0015\"1\u0004B\u0017\u0011\u001d\u0011ib\u0006a\u0001\u0005?\tqAZ8pi\u0016\u00148\u000fE\u0003F\u0003o\u0011\t\u0003\u0005\u0003\u0003$\t%RB\u0001B\u0013\u0015\u0011\t\tAa\n\u000b\u0005}A\u0013\u0002\u0002B\u0016\u0005K\u0011aAR8pi\u0016\u0014\b\"\u0002;\u0018\u0001\u0004)\u0018\u0001\b:fC\u0012\u0004\u0016M]9vKR4un\u001c;feNLe\u000eU1sC2dW\r\u001c\u000b\t\u0005?\u0011\u0019D!\u000e\u0003:!9\u00111\u0019\rA\u0002\u0005u\u0006b\u0002B\u001c1\u0001\u0007\u0011QG\u0001\na\u0006\u0014HOR5mKNDaAa\u000f\u0019\u0001\u00041\u0017AE5h]>\u0014XmQ8seV\u0004HOR5mKN\fa#\\3sO\u0016\u001c6\r[3nCNLe\u000eU1sC2dW\r\u001c\u000b\t\u0003K\u0011\tEa\u0011\u0003H!9\u0011qF\rA\u0002\u0005-\u0001b\u0002B#3\u0001\u0007\u0011QG\u0001\rM&dWm\u001d+p)>,8\r\u001b\u0005\u0006if\u0001\r!^\u0001\u0015e\u0016\fGmU2iK6\fgI]8n\r>|G/\u001a:\u0015\r\u0005U!Q\nB)\u0011\u001d\u0011yE\u0007a\u0001\u0005C\taAZ8pi\u0016\u0014\bb\u0002B*5\u0001\u0007!QK\u0001\nG>tg/\u001a:uKJ\u00042a\u0015B,\u0013\r\u0011IF\b\u0002\u001e!\u0006\u0014\u0018/^3u)>\u001c\u0006/\u0019:l'\u000eDW-\\1D_:4XM\u001d;fe\u00069B-Z:fe&\fG.\u001b>f'\u000eDW-\\1TiJLgn\u001a\u000b\u0005\u0003K\u0011y\u0006\u0003\u0004\u0003bm\u0001\rAV\u0001\rg\u000eDW-\\1TiJLgnZ\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005O\u0002BAa\u0001\u0003j%!!1\u000eB\u0003\u0005\u0019y%M[3di\u0002")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter converter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, converter);
    }

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, filesToTouch, sparkSession);
    }

    public static StructField ROW_INDEX_FIELD() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX_FIELD();
    }

    public static String ROW_INDEX_TEMPORARY_COLUMN_NAME() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME();
    }

    public static String ROW_INDEX() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public AttributeReference createFileMetadataCol() {
        return FileFormat.createFileMetadataCol$(this);
    }

    @Override
    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$(this, name);
    }

    @Override
    public boolean allowDuplicatedColumnNames() {
        return FileFormat.allowDuplicatedColumnNames$(this);
    }

    @Override
    public scala.collection.immutable.Map<String, Function1<PartitionedFile, Object>> fileConstantMetadataExtractors() {
        return FileFormat.fileConstantMetadataExtractors$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "Parquet";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        SQLConf sqlConf = sparkSession.sessionState().conf();
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        return ParquetUtils$.MODULE$.prepareWrite(sqlConf, job, dataSchema, parquetOptions);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return ParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return ParquetUtils$.MODULE$.isBatchReadSupportedForSchema(conf, schema);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return Option$.MODULE$.apply(((IterableOps)package$.MODULE$.Seq().fill(requiredSchema.fields().length, (Function0 & Serializable)() -> {
            if (!sqlConf.offHeapColumnVectorEnabled()) {
                return OnHeapColumnVector.class.getName();
            }
            return OffHeapColumnVector.class.getName();
        })).$plus$plus((IterableOnce)package$.MODULE$.Seq().fill(partitionSchema.fields().length, (Function0 & Serializable)() -> ConstantColumnVector.class.getName())));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, scala.collection.immutable.Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf, int expectedBCVarCount) {
        boolean returningBatch;
        String int96RebaseModeInRead;
        String datetimeRebaseModeInRead;
        boolean isCaseSensitive;
        int pushDownInFilterThreshold;
        boolean pushDownStringPredicate;
        boolean pushDownDecimal;
        boolean pushDownTimestamp;
        boolean pushDownDate;
        boolean enableParquetFilterPushDown;
        int capacity;
        boolean timestampConversion;
        boolean enableRecordFilter;
        boolean enableVectorizedReader;
        boolean enableOffHeapColumnVector;
        Broadcast broadcastedHadoopConf;
        block0: {
            hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
            hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
            hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
            hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
            hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
            hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), sparkSession.sessionState().conf().parquetInferTimestampNTZEnabled());
            hadoopConf.setBoolean(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), sparkSession.sessionState().conf().legacyParquetNanosAsLong());
            broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
            StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Object)requiredSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
            SQLConf sqlConf = sparkSession.sessionState().conf();
            enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
            enableVectorizedReader = ParquetUtils$.MODULE$.isBatchReadSupportedForSchema(sqlConf, resultSchema);
            enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
            timestampConversion = sqlConf.isParquetINT96TimestampConversion();
            capacity = sqlConf.parquetVectorizedReaderBatchSize();
            enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
            pushDownDate = sqlConf.parquetFilterPushDownDate();
            pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
            pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
            pushDownStringPredicate = sqlConf.parquetFilterPushDownStringPredicate();
            pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
            isCaseSensitive = sqlConf.caseSensitiveAnalysis();
            ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
            datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
            int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
            boolean bl = returningBatch = sparkSession.sessionState().conf().parquetVectorizedReaderEnabled() && ((String)options.getOrElse((Object)FileFormat$.MODULE$.OPTION_RETURNING_BATCH(), (Function0 & Serializable)() -> {
                throw new IllegalArgumentException("OPTION_RETURNING_BATCH should always be set for ParquetFileFormat. To workaround this issue, set spark.sql.parquet.enableVectorizedReader=false.");
            })).equals("true");
            if (!returningBatch) break block0;
            Predef$.MODULE$.assert(this.supportBatch(sparkSession, resultSchema));
        }
        return (Function1 & Serializable)file -> {
            Iterator iterator;
            ParquetRecordReader parquetRecordReader;
            None$ none$;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            int actualBCVarCnt = filters.count((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$buildReaderWithPartitionValues$3(x0$1)));
            Predef$.MODULE$.assert(expectedBCVarCount == actualBCVarCnt, (Function0 & Serializable)() -> "expected bcvar cnt = " + expectedBCVarCount + ", actual filters cnt = " + actualBCVarCnt);
            if (expectedBCVarCount != actualBCVarCnt) {
                throw new IllegalStateException("ass..what the heck");
            }
            Path filePath = file.toPath();
            FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            ParquetMetadata fileFooter = enableVectorizedReader ? ParquetFooterReader.readFooter(sharedConf, file, false) : ParquetFooterReader.readFooter(sharedConf, file, true);
            FileMetaData footerFileMetaData = fileFooter.getFileMetaData();
            Map map = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
            Map map2 = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = footerFileMetaData.getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringPredicate, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseSpec);
                none$ = ((IterableOnceOps)filters.flatMap((Function1 & Serializable)x$1 -> parquetFilters.createFilter((Filter)x$1))).reduceOption((Function2 & Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            None$ convertTz = timestampConversion && !ParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
            if (enableVectorizedReader) {
                RecordReaderIterator<Object> recordReaderIterator;
                VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((ZoneId)convertTz.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), datetimeRebaseSpec.mode().toString(), datetimeRebaseSpec.timeZone(), int96RebaseSpec.mode().toString(), int96RebaseSpec.timeZone(), enableOffHeapColumnVector && taskContext.isDefined(), capacity);
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
                try {
                    vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext, (Option<ParquetMetadata>)Option$.MODULE$.apply((Object)fileFooter));
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Appending " + partitionSchema + " " + file.partitionValues());
                    vectorizedReader.initBatch(partitionSchema, file.partitionValues());
                    if (returningBatch) {
                        vectorizedReader.enableReturningBatches();
                    }
                    recordReaderIterator = iter;
                }
                catch (Throwable e) {
                    iter.close();
                    throw e;
                }
                return recordReaderIterator;
            }
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Falling back to parquet-mr");
            ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseSpec, int96RebaseSpec);
            if (pushed.isDefined() && enableRecordFilter) {
                FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
            } else {
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
            }
            ParquetRecordReader reader = parquetRecordReader;
            RecordReader<Void, InternalRow> readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded((ParquetRecordReader<InternalRow>)reader, requiredSchema);
            RecordReaderIterator<InternalRow> iter = new RecordReaderIterator<InternalRow>(readerWithRowIndexes);
            try {
                readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus((IterableOnce)DataTypeUtils$.MODULE$.toAttributes(partitionSchema));
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    iterator = iter.map(unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    iterator = iter.map((Function1 & Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            catch (Throwable e) {
                iter.close();
                throw e;
            }
            return iterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            return true;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            return structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            return this.supportDataType(elementType);
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            return this.supportDataType(keyType) && this.supportDataType(valueType);
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return this.supportDataType(userDefinedType.sqlType());
        }
        return false;
    }

    @Override
    public Seq<StructField> metadataSchemaFields() {
        return (Seq)FileFormat.metadataSchemaFields$(this).$colon$plus((Object)ParquetFileFormat$.MODULE$.ROW_INDEX_FIELD());
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$3(Filter x0$1) {
        Filter filter = x0$1;
        if (filter instanceof In) {
            In in = (In)filter;
            Object[] arr = in.values();
            return ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.genericArrayOps((Object)arr)) instanceof BroadcastedJoinKeysWrapper;
        }
        return false;
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public ParquetFileFormat() {
        FileFormat.$init$(this);
        Logging.$init$((Logging)this);
    }
}

