/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.RelationWrapper;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.classic.ClassicConversions$;
import org.apache.spark.sql.execution.CacheManager$;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.command.AlterTableRenameCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.storage.StorageLevel;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001B\u000e\u001d\u0001&B\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t!\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0011\u000b\u0001BK\u0002\u0013\u00051\n\u0003\u0005S\u0001\tE\t\u0015!\u0003M\u0011!\u0019\u0006A!f\u0001\n\u0003!\u0006\u0002\u0003-\u0001\u0005#\u0005\u000b\u0011B+\t\u000be\u0003A\u0011\u0001.\t\u000b}\u0003A\u0011\t1\t\u000f5\u0004\u0011\u0011!C\u0001]\"9!\u000fAI\u0001\n\u0003\u0019\bb\u0002@\u0001#\u0003%\ta\u001d\u0005\t\u007f\u0002\t\n\u0011\"\u0001\u0002\u0002!I\u0011Q\u0001\u0001\u0002\u0002\u0013\u0005\u0013q\u0001\u0005\n\u00033\u0001\u0011\u0011!C\u0001\u00037A\u0011\"a\t\u0001\u0003\u0003%\t!!\n\t\u0013\u0005E\u0002!!A\u0005B\u0005M\u0002\"CA!\u0001\u0005\u0005I\u0011AA\"\u0011%\t9\u0005AA\u0001\n\u0003\nI\u0005C\u0005\u0002N\u0001\t\t\u0011\"\u0011\u0002P\u001dI\u00111\u000b\u000f\u0002\u0002#\u0005\u0011Q\u000b\u0004\t7q\t\t\u0011#\u0001\u0002X!1\u0011,\u0006C\u0001\u0003_B\u0011\"!\u001d\u0016\u0003\u0003%)%a\u001d\t\u0013\u0005UT#!A\u0005\u0002\u0006]\u0004\"CA@+\u0005\u0005I\u0011QAA\u0011%\t\u0019*FA\u0001\n\u0013\t)JA\fBYR,'\u000fV1cY\u0016\u0014VM\\1nK\u000e{W.\\1oI*\u0011QDH\u0001\bG>lW.\u00198e\u0015\ty\u0002%A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M)\u0001A\u000b\u001b9}A\u00111FM\u0007\u0002Y)\u0011QFL\u0001\bY><\u0017nY1m\u0015\ty\u0003'A\u0003qY\u0006t7O\u0003\u00022A\u0005A1-\u0019;bYf\u001cH/\u0003\u00024Y\tYAj\\4jG\u0006d\u0007\u000b\\1o!\t)d'D\u0001\u001d\u0013\t9DDA\nMK\u00064'+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$HA\u0004Qe>$Wo\u0019;\u0011\u0005}:eB\u0001!F\u001d\t\tE)D\u0001C\u0015\t\u0019\u0005&\u0001\u0004=e>|GOP\u0005\u0002w%\u0011aIO\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0015J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Gu\u00059q\u000e\u001c3OC6,W#\u0001'\u0011\u00055sU\"\u0001\u0019\n\u0005=\u0003$a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002\u0011=dGMT1nK\u0002\nqA\\3x\u001d\u0006lW-\u0001\u0005oK^t\u0015-\\3!\u0003\u0019I7OV5foV\tQ\u000b\u0005\u0002:-&\u0011qK\u000f\u0002\b\u0005>|G.Z1o\u0003\u001dI7OV5fo\u0002\na\u0001P5oSRtD\u0003B.];z\u0003\"!\u000e\u0001\t\u000b);\u0001\u0019\u0001'\t\u000bE;\u0001\u0019\u0001'\t\u000bM;\u0001\u0019A+\u0002\u0007I,h\u000e\u0006\u0002bQB\u0019qH\u00193\n\u0005\rL%aA*fcB\u0011QMZ\u0007\u0002A%\u0011q\r\t\u0002\u0004%><\b\"B5\t\u0001\u0004Q\u0017\u0001D:qCJ\\7+Z:tS>t\u0007CA3l\u0013\ta\u0007E\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0003d_BLH\u0003B.paFDqAS\u0005\u0011\u0002\u0003\u0007A\nC\u0004R\u0013A\u0005\t\u0019\u0001'\t\u000fMK\u0001\u0013!a\u0001+\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001;+\u00051+8&\u0001<\u0011\u0005]dX\"\u0001=\u000b\u0005eT\u0018!C;oG\",7m[3e\u0015\tY((\u0001\u0006b]:|G/\u0019;j_:L!! =\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0001\u0016\u0003+V\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0005!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\tA\u0001\\1oO*\u0011\u00111C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0018\u00055!AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u001eA\u0019\u0011(a\b\n\u0007\u0005\u0005\"HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002(\u00055\u0002cA\u001d\u0002*%\u0019\u00111\u0006\u001e\u0003\u0007\u0005s\u0017\u0010C\u0005\u00020=\t\t\u00111\u0001\u0002\u001e\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u000e\u0011\r\u0005]\u0012QHA\u0014\u001b\t\tIDC\u0002\u0002<i\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty$!\u000f\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004+\u0006\u0015\u0003\"CA\u0018#\u0005\u0005\t\u0019AA\u0014\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005%\u00111\n\u0005\n\u0003_\u0011\u0012\u0011!a\u0001\u0003;\ta!Z9vC2\u001cHcA+\u0002R!I\u0011qF\n\u0002\u0002\u0003\u0007\u0011qE\u0001\u0018\u00032$XM\u001d+bE2,'+\u001a8b[\u0016\u001cu.\\7b]\u0012\u0004\"!N\u000b\u0014\u000bU\tI&!\u001a\u0011\u0011\u0005m\u0013\u0011\r'M+nk!!!\u0018\u000b\u0007\u0005}#(A\u0004sk:$\u0018.\\3\n\t\u0005\r\u0014Q\f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003BA4\u0003[j!!!\u001b\u000b\t\u0005-\u0014\u0011C\u0001\u0003S>L1\u0001SA5)\t\t)&\u0001\u0005u_N#(/\u001b8h)\t\tI!A\u0003baBd\u0017\u0010F\u0004\\\u0003s\nY(! \t\u000b)C\u0002\u0019\u0001'\t\u000bEC\u0002\u0019\u0001'\t\u000bMC\u0002\u0019A+\u0002\u000fUt\u0017\r\u001d9msR!\u00111QAH!\u0015I\u0014QQAE\u0013\r\t9I\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\re\nY\t\u0014'V\u0013\r\tiI\u000f\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005E\u0015$!AA\u0002m\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t9\n\u0005\u0003\u0002\f\u0005e\u0015\u0002BAN\u0003\u001b\u0011aa\u00142kK\u000e$\b")
public class AlterTableRenameCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier oldName;
    private final TableIdentifier newName;
    private final boolean isView;
    private Map<String, SQLMetric> metrics;
    private Set<RelationWrapper> withRelations;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, TableIdentifier, Object>> unapply(AlterTableRenameCommand x$0) {
        return AlterTableRenameCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<TableIdentifier, TableIdentifier, Object>, AlterTableRenameCommand> tupled() {
        return AlterTableRenameCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<TableIdentifier, Function1<Object, AlterTableRenameCommand>>> curried() {
        return AlterTableRenameCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableRenameCommand alterTableRenameCommand = this;
        synchronized (alterTableRenameCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public Set<RelationWrapper> withRelations() {
        return this.withRelations;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$withRelations_$eq(Set<RelationWrapper> x$1) {
        this.withRelations = x$1;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier oldName() {
        return this.oldName;
    }

    public TableIdentifier newName() {
        return this.newName;
    }

    public boolean isView() {
        return this.isView;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        if (catalog.isTempView(this.oldName())) {
            catalog.renameTable(this.oldName(), this.newName());
        } else {
            CatalogTable table = catalog.getTableMetadata(this.oldName());
            DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, this.isView());
            Option<CachedData> optCachedData = sparkSession.sharedState().cacheManager().lookupCachedData(ClassicConversions$.MODULE$.castToImpl(sparkSession.table(this.oldName().unquotedString())));
            Option optStorageLevel = optCachedData.map((Function1 & Serializable)x$1 -> ((InMemoryRelation)x$1.cachedRepresentation().fold(CacheManager$.MODULE$.inMemoryRelationExtractor(), (Function1 & Serializable)x -> (InMemoryRelation)Predef$.MODULE$.identity(x))).cacheBuilder().storageLevel());
            if (optStorageLevel.isDefined()) {
                CommandUtils$.MODULE$.uncacheTableOrView(ClassicConversions$.MODULE$.castToImpl(sparkSession), this.oldName());
            }
            catalog.refreshTable(this.oldName());
            catalog.renameTable(this.oldName(), this.newName());
            optStorageLevel.foreach((Function1 & Serializable)storageLevel -> {
                AlterTableRenameCommand.$anonfun$run$3(this, sparkSession, storageLevel);
                return BoxedUnit.UNIT;
            });
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public AlterTableRenameCommand copy(TableIdentifier oldName, TableIdentifier newName, boolean isView) {
        return new AlterTableRenameCommand(oldName, newName, isView);
    }

    public TableIdentifier copy$default$1() {
        return this.oldName();
    }

    public TableIdentifier copy$default$2() {
        return this.newName();
    }

    public boolean copy$default$3() {
        return this.isView();
    }

    public String productPrefix() {
        return "AlterTableRenameCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.oldName();
            }
            case 1: {
                return this.newName();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.isView());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableRenameCommand;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "oldName";
            }
            case 1: {
                return "newName";
            }
            case 2: {
                return "isView";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableRenameCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableRenameCommand alterTableRenameCommand = (AlterTableRenameCommand)x$1;
        if (this.isView() != alterTableRenameCommand.isView()) return false;
        TableIdentifier tableIdentifier = this.oldName();
        TableIdentifier tableIdentifier2 = alterTableRenameCommand.oldName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        TableIdentifier tableIdentifier3 = this.newName();
        TableIdentifier tableIdentifier4 = alterTableRenameCommand.newName();
        if (tableIdentifier3 == null) {
            if (tableIdentifier4 != null) {
                return false;
            }
        } else if (!tableIdentifier3.equals(tableIdentifier4)) return false;
        if (!alterTableRenameCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$run$3(AlterTableRenameCommand $this, SparkSession sparkSession$1, StorageLevel storageLevel) {
        sparkSession$1.catalog().cacheTable($this.newName().unquotedString(), storageLevel);
    }

    public AlterTableRenameCommand(TableIdentifier oldName, TableIdentifier newName, boolean isView) {
        this.oldName = oldName;
        this.newName = newName;
        this.isView = isView;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        Statics.releaseFence();
    }
}

