/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.guava.graph;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.sparkproject.connect.guava.collect.BiMap;
import org.sparkproject.connect.guava.collect.HashBiMap;
import org.sparkproject.connect.guava.collect.ImmutableBiMap;
import org.sparkproject.connect.guava.graph.AbstractDirectedNetworkConnections;
import org.sparkproject.connect.guava.graph.EdgesConnecting;
import org.sparkproject.connect.guava.graph.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
final class DirectedNetworkConnections<N, E>
extends AbstractDirectedNetworkConnections<N, E> {
    DirectedNetworkConnections(Map<E, N> inEdgeMap, Map<E, N> outEdgeMap, int selfLoopCount) {
        super(inEdgeMap, outEdgeMap, selfLoopCount);
    }

    static <N, E> DirectedNetworkConnections<N, E> of() {
        return new DirectedNetworkConnections(HashBiMap.create(2), HashBiMap.create(2), 0);
    }

    static <N, E> DirectedNetworkConnections<N, E> ofImmutable(Map<E, N> inEdges, Map<E, N> outEdges, int selfLoopCount) {
        return new DirectedNetworkConnections<N, E>(ImmutableBiMap.copyOf(inEdges), ImmutableBiMap.copyOf(outEdges), selfLoopCount);
    }

    @Override
    public Set<N> predecessors() {
        return Collections.unmodifiableSet(((BiMap)this.inEdgeMap).values());
    }

    @Override
    public Set<N> successors() {
        return Collections.unmodifiableSet(((BiMap)this.outEdgeMap).values());
    }

    @Override
    public Set<E> edgesConnecting(N node) {
        return new EdgesConnecting(((BiMap)this.outEdgeMap).inverse(), node);
    }
}

