/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.types.StructType;

@DeveloperApi
public class ViewInfo {
    private final Identifier ident;
    private final String sql;
    private final String currentCatalog;
    private final String[] currentNamespace;
    private final StructType schema;
    private final String[] queryColumnNames;
    private final String[] columnAliases;
    private final String[] columnComments;
    private final Map<String, String> properties;

    public ViewInfo(Identifier ident, String sql2, String currentCatalog, String[] currentNamespace, StructType schema, String[] queryColumnNames, String[] columnAliases, String[] columnComments, Map<String, String> properties) {
        this.ident = ident;
        this.sql = sql2;
        this.currentCatalog = currentCatalog;
        this.currentNamespace = currentNamespace;
        this.schema = schema;
        this.queryColumnNames = queryColumnNames;
        this.columnAliases = columnAliases;
        this.columnComments = columnComments;
        this.properties = properties;
    }

    @Nonnull
    public Identifier ident() {
        return this.ident;
    }

    @Nonnull
    public String sql() {
        return this.sql;
    }

    @Nonnull
    public String currentCatalog() {
        return this.currentCatalog;
    }

    @Nonnull
    public String[] currentNamespace() {
        return this.currentNamespace;
    }

    @Nonnull
    public StructType schema() {
        return this.schema;
    }

    @Nonnull
    public String[] queryColumnNames() {
        return this.queryColumnNames;
    }

    @Nonnull
    public String[] columnAliases() {
        return this.columnAliases;
    }

    @Nonnull
    public String[] columnComments() {
        return this.columnComments;
    }

    @Nonnull
    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewInfo viewInfo = (ViewInfo)o;
        return this.ident.equals((Object)viewInfo.ident) && this.sql.equals(viewInfo.sql) && this.currentCatalog.equals(viewInfo.currentCatalog) && Arrays.equals(this.currentNamespace, viewInfo.currentNamespace) && this.schema.equals((Object)viewInfo.schema) && Arrays.equals(this.queryColumnNames, viewInfo.queryColumnNames) && Arrays.equals(this.columnAliases, viewInfo.columnAliases) && Arrays.equals(this.columnComments, viewInfo.columnComments) && this.properties.equals(viewInfo.properties);
    }

    public int hashCode() {
        int result = Objects.hash(this.ident, this.sql, this.currentCatalog, this.schema, this.properties);
        result = 31 * result + Arrays.hashCode(this.currentNamespace);
        result = 31 * result + Arrays.hashCode(this.queryColumnNames);
        result = 31 * result + Arrays.hashCode(this.columnAliases);
        result = 31 * result + Arrays.hashCode(this.columnComments);
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", ViewInfo.class.getSimpleName() + "[", "]").add("ident=" + String.valueOf(this.ident)).add("sql='" + this.sql + "'").add("currentCatalog='" + this.currentCatalog + "'").add("currentNamespace=" + Arrays.toString(this.currentNamespace)).add("schema=" + String.valueOf(this.schema)).add("queryColumnNames=" + Arrays.toString(this.queryColumnNames)).add("columnAliases=" + Arrays.toString(this.columnAliases)).add("columnComments=" + Arrays.toString(this.columnComments)).add("properties=" + String.valueOf(this.properties)).toString();
    }
}

