/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.BinaryPredicate$;
import org.apache.spark.sql.catalyst.expressions.Exists;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.ListQuery;
import org.apache.spark.sql.catalyst.expressions.MultiLikeBase;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.PythonUDF;
import org.apache.spark.sql.catalyst.expressions.StringPredicate;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005UbaB\u0007\u000f!\u0003\r\ta\u0007\u0005\u0006Y\u0001!\t!\f\u0005\u0006c\u0001!\tB\r\u0005\u0006\t\u0002!\t!\u0012\u0005\u00061\u0002!\t\"\u0017\u0005\u00067\u0002!\t\u0002\u0018\u0005\u0006G\u0002!\t\u0002\u001a\u0005\u0006W\u0002!\t\u0002\u001c\u0005\u0006]\u0002!\tb\u001c\u0005\u0006o\u0002!\t\u0002\u001f\u0005\u0006u\u0002!\tb\u001f\u0005\b\u0003#\u0001A\u0011AA\n\u0011%\ti\u0002AI\u0001\n\u0003\tyBA\bQe\u0016$\u0017nY1uK\"+G\u000e]3s\u0015\ty\u0001#A\u0006fqB\u0014Xm]:j_:\u001c(BA\t\u0013\u0003!\u0019\u0017\r^1msN$(BA\n\u0015\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003+Y\tQa\u001d9be.T!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u001dE\u0019\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012%\u001b\u0005q\u0011BA\u0013\u000f\u0005-\tE.[1t\u0011\u0016d\u0007/\u001a:\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%\"\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005-B#a\u0002'pO\u001eLgnZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u00039\u0002\"!H\u0018\n\u0005Ar\"\u0001B+oSR\f!d\u001d9mSR\u001cuN\u001c6v]\u000e$\u0018N^3Qe\u0016$\u0017nY1uKN$\"a\r\"\u0011\u0007QbtH\u0004\u00026u9\u0011a'O\u0007\u0002o)\u0011\u0001HG\u0001\u0007yI|w\u000e\u001e \n\u0003}I!a\u000f\u0010\u0002\u000fA\f7m[1hK&\u0011QH\u0010\u0002\u0004'\u0016\f(BA\u001e\u001f!\t\u0019\u0003)\u0003\u0002B\u001d\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000b\r\u0013\u0001\u0019A \u0002\u0013\r|g\u000eZ5uS>t\u0017!\t4j]\u0012,\u0005\u0010\u001d:fgNLwN\\!oIR\u0013\u0018mY6MS:,\u0017mZ3E_^tGc\u0001$U-B\u0019QdR%\n\u0005!s\"AB(qi&|g\u000e\u0005\u0003\u001e\u0015~b\u0015BA&\u001f\u0005\u0019!V\u000f\u001d7feA\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\bY><\u0017nY1m\u0015\t\t\u0006#A\u0003qY\u0006t7/\u0003\u0002T\u001d\nYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u0015)6\u00011\u0001@\u0003\r)\u0007\u0010\u001d\u0005\u0006/\u000e\u0001\r\u0001T\u0001\u0005a2\fg.\u0001\u000eta2LG\u000fR5tUVt7\r^5wKB\u0013X\rZ5dCR,7\u000f\u0006\u000245\")1\t\u0002a\u0001\u007f\u00051\"-^5mI\n\u000bG.\u00198dK\u0012\u0004&/\u001a3jG\u0006$X\rF\u0002@;zCQaD\u0003A\u0002MBQaX\u0003A\u0002\u0001\f!a\u001c9\u0011\u000bu\twhP \n\u0005\tt\"!\u0003$v]\u000e$\u0018n\u001c83\u0003-\u0019\u0017M\\#wC2,\u0018\r^3\u0015\u0007\u0015D'\u000e\u0005\u0002\u001eM&\u0011qM\b\u0002\b\u0005>|G.Z1o\u0011\u0015Ig\u00011\u0001@\u0003\u0011)\u0007\u0010\u001d:\t\u000b]3\u0001\u0019\u0001'\u0002+\r\fg.\u0012<bYV\fG/Z,ji\"LgNS8j]R\u0011Q-\u001c\u0005\u0006S\u001e\u0001\raP\u0001!Kb$(/Y2u!J,G-[2bi\u0016\u001cx+\u001b;iS:|U\u000f\u001e9viN+G\u000fF\u0002qcJ\u00042!H$@\u0011\u0015\u0019\u0005\u00021\u0001@\u0011\u0015\u0019\b\u00021\u0001u\u0003%yW\u000f\u001e9viN+G\u000f\u0005\u0002$k&\u0011aO\u0004\u0002\r\u0003R$(/\u001b2vi\u0016\u001cV\r^\u0001\u0011SNtU\u000f\u001c7J]R|G.\u001a:b]R$\"!Z=\t\u000b%L\u0001\u0019A \u0002+=,H\u000f];u/&$\bNT;mY\u0006\u0014\u0017\u000e\\5usR)A0!\u0001\u0002\u0006A\u0019A\u0007P?\u0011\u0005\rr\u0018BA@\u000f\u0005%\tE\u000f\u001e:jEV$X\r\u0003\u0004\u0002\u0004)\u0001\r\u0001`\u0001\u0007_V$\b/\u001e;\t\u000f\u0005\u001d!\u00021\u0001\u0002\n\u0005\u0011bn\u001c8Ok2d\u0017\t\u001e;s\u000bb\u0004(/\u00133t!\u0011!D(a\u0003\u0011\u0007\r\ni!C\u0002\u0002\u00109\u0011a!\u0012=qe&#\u0017!E5t\u0019&\\W\r\\=TK2,7\r^5wKR)Q-!\u0006\u0002\u001a!1\u0011qC\u0006A\u0002}\n\u0011!\u001a\u0005\t\u00037Y\u0001\u0013!a\u0001K\u0006)Ro]3Ok2d\u0017MY5mSRLhi\u001c:QeVt\u0017aG5t\u0019&\\W\r\\=TK2,7\r^5wK\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\")\u001aQ-a\t,\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003ci!!!\u000b\u000b\t\u0005-\u0012QF\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\f\u001f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\tICA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public interface PredicateHelper
extends AliasHelper,
Logging {
    public static /* synthetic */ Seq splitConjunctivePredicates$(PredicateHelper $this, Expression condition) {
        return $this.splitConjunctivePredicates(condition);
    }

    default public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        Expression expression = condition;
        if (expression instanceof And) {
            And and = (And)expression;
            Expression cond1 = and.left();
            Expression cond2 = and.right();
            return (Seq)this.splitConjunctivePredicates(cond1).$plus$plus(this.splitConjunctivePredicates(cond2));
        }
        Expression expression2 = expression;
        return Nil$.MODULE$.$colon$colon((Object)expression2);
    }

    public static /* synthetic */ Option findExpressionAndTrackLineageDown$(PredicateHelper $this, Expression exp, LogicalPlan plan2) {
        return $this.findExpressionAndTrackLineageDown(exp, plan2);
    }

    default public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan2) {
        if (exp.references().isEmpty()) {
            return None$.MODULE$;
        }
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            AttributeMap<Alias> aliases = this.getAliasMap(project);
            return this.findExpressionAndTrackLineageDown(this.replaceAlias(exp, aliases), project.child());
        }
        if (logicalPlan instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)logicalPlan;
            AttributeMap<Alias> aliasMap = this.getAliasMap(aggregate);
            return this.findExpressionAndTrackLineageDown(this.replaceAlias(exp, aliasMap), aggregate.child());
        }
        if (logicalPlan instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)((Object)logicalPlan);
            if (exp.references().subsetOf(((QueryPlan)((Object)leafNode)).outputSet())) {
                return new Some((Object)new Tuple2((Object)exp, (Object)leafNode));
            }
        }
        if (logicalPlan instanceof Union) {
            Union union = (Union)logicalPlan;
            int index = union.output().indexWhere((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.semanticEquals(exp)));
            if (index > -1) {
                return ((IterableOps)union.children().flatMap((Function1 & Serializable)child -> this.findExpressionAndTrackLineageDown((Expression)child.output().apply(index), (LogicalPlan)child))).headOption();
            }
            return None$.MODULE$;
        }
        return ((IterableOps)logicalPlan.children().flatMap((Function1 & Serializable)child -> {
            if (exp.references().subsetOf(child.outputSet())) {
                return this.findExpressionAndTrackLineageDown(exp, (LogicalPlan)child);
            }
            return None$.MODULE$;
        })).headOption();
    }

    public static /* synthetic */ Seq splitDisjunctivePredicates$(PredicateHelper $this, Expression condition) {
        return $this.splitDisjunctivePredicates(condition);
    }

    default public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        Expression expression = condition;
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression cond1 = or.left();
            Expression cond2 = or.right();
            return (Seq)this.splitDisjunctivePredicates(cond1).$plus$plus(this.splitDisjunctivePredicates(cond2));
        }
        Expression expression2 = expression;
        return Nil$.MODULE$.$colon$colon((Object)expression2);
    }

    public static /* synthetic */ Expression buildBalancedPredicate$(PredicateHelper $this, Seq expressions, Function2 op) {
        return $this.buildBalancedPredicate((Seq<Expression>)expressions, (Function2<Expression, Expression, Expression>)op);
    }

    default public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        Predef$.MODULE$.assert(expressions.nonEmpty());
        ArraySeq currentResult = expressions;
        while (currentResult.size() != 1) {
            Expression[] nextResult = new Expression[currentResult.size() / 2 + currentResult.size() % 2];
            for (int i = 0; i < currentResult.size(); i += 2) {
                nextResult[i / 2] = i + 1 == currentResult.size() ? (Expression)currentResult.apply(i) : (Expression)op.apply(currentResult.apply(i), currentResult.apply(i + 1));
            }
            currentResult = ArrayImplicits$.MODULE$.SparkArrayOps((Object)nextResult).toImmutableArraySeq();
        }
        return (Expression)currentResult.head();
    }

    public static /* synthetic */ boolean canEvaluate$(PredicateHelper $this, Expression expr, LogicalPlan plan2) {
        return $this.canEvaluate(expr, plan2);
    }

    default public boolean canEvaluate(Expression expr, LogicalPlan plan2) {
        return expr.references().subsetOf(plan2.outputSet());
    }

    public static /* synthetic */ boolean canEvaluateWithinJoin$(PredicateHelper $this, Expression expr) {
        return $this.canEvaluateWithinJoin(expr);
    }

    default public boolean canEvaluateWithinJoin(Expression expr2) {
        Expression expression = expr2;
        if (!expression.deterministic()) {
            return false;
        }
        if (expression instanceof ListQuery ? true : expression instanceof Exists) {
            return false;
        }
        if (expression instanceof SubqueryExpression) {
            SubqueryExpression subqueryExpression = (SubqueryExpression)expression;
            return subqueryExpression.children().isEmpty();
        }
        if (expression instanceof AttributeReference) {
            return true;
        }
        if (expression instanceof PythonUDF) {
            return true;
        }
        if (expression instanceof Unevaluable) {
            return false;
        }
        return expression.children().forall((Function1 & Serializable)expr -> BoxesRunTime.boxToBoolean((boolean)this.canEvaluateWithinJoin(expr)));
    }

    public static /* synthetic */ Option extractPredicatesWithinOutputSet$(PredicateHelper $this, Expression condition, AttributeSet outputSet) {
        return $this.extractPredicatesWithinOutputSet(condition, outputSet);
    }

    default public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        Expression expression = condition;
        if (expression instanceof And) {
            Option<Expression> rightResultOptional;
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            Option<Expression> leftResultOptional = this.extractPredicatesWithinOutputSet(left, outputSet);
            Tuple2 tuple2 = new Tuple2(leftResultOptional, rightResultOptional = this.extractPredicatesWithinOutputSet(right, outputSet));
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Expression leftResult = (Expression)some.value();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Expression rightResult = (Expression)some2.value();
                        return new Some((Object)new And(leftResult, rightResult));
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Expression leftResult = (Expression)some.value();
                    if (None$.MODULE$.equals(option3)) {
                        return new Some((Object)leftResult);
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                    Some some = (Some)option4;
                    Expression rightResult = (Expression)some.value();
                    return new Some((Object)rightResult);
                }
            }
            return None$.MODULE$;
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            return this.extractPredicatesWithinOutputSet(left, outputSet).flatMap((Function1 & Serializable)lhs -> this.extractPredicatesWithinOutputSet(right, outputSet).map((Function1 & Serializable)rhs -> new Or((Expression)lhs, (Expression)rhs)));
        }
        if (expression.references().subsetOf(outputSet)) {
            return new Some((Object)expression);
        }
        return None$.MODULE$;
    }

    public static /* synthetic */ boolean isNullIntolerant$(PredicateHelper $this, Expression expr) {
        return $this.isNullIntolerant(expr);
    }

    default public boolean isNullIntolerant(Expression expr2) {
        return expr2.nullIntolerant() && expr2.children().forall((Function1 & Serializable)expr -> BoxesRunTime.boxToBoolean((boolean)this.isNullIntolerant(expr)));
    }

    public static /* synthetic */ Seq outputWithNullability$(PredicateHelper $this, Seq output, Seq nonNullAttrExprIds) {
        return $this.outputWithNullability((Seq<Attribute>)output, (Seq<ExprId>)nonNullAttrExprIds);
    }

    default public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return (Seq)output.map((Function1 & Serializable)a -> {
            if (a.nullable() && nonNullAttrExprIds.contains((Object)a.exprId())) {
                return a.withNullability(false);
            }
            return a;
        });
    }

    public static /* synthetic */ boolean isLikelySelective$(PredicateHelper $this, Expression e, boolean useNullabilityForPrun) {
        return $this.isLikelySelective(e, useNullabilityForPrun);
    }

    default public boolean isLikelySelective(Expression e, boolean useNullabilityForPrun) {
        Option<StaticInvoke> option;
        Expression expression = e;
        if (expression instanceof Not) {
            Not not = (Not)expression;
            Expression expr = not.child();
            return this.isLikelySelective(expr, useNullabilityForPrun);
        }
        if (expression instanceof And) {
            And and = (And)expression;
            Expression l = and.left();
            Expression r = and.right();
            return this.isLikelySelective(l, useNullabilityForPrun) || this.isLikelySelective(r, useNullabilityForPrun);
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression l = or.left();
            Expression r = or.right();
            return this.isLikelySelective(l, useNullabilityForPrun) && this.isLikelySelective(r, useNullabilityForPrun);
        }
        if ((expression instanceof IsNull ? true : expression instanceof IsNotNull) && useNullabilityForPrun) {
            return true;
        }
        if (expression instanceof StringRegexExpression) {
            return true;
        }
        if (expression instanceof BinaryComparison) {
            return true;
        }
        if (expression instanceof In ? true : expression instanceof InSet) {
            return true;
        }
        if (expression instanceof StringPredicate) {
            return true;
        }
        if (expression != null && !(option = BinaryPredicate$.MODULE$.unapply(expression)).isEmpty()) {
            return true;
        }
        return expression instanceof MultiLikeBase;
    }

    public static /* synthetic */ boolean isLikelySelective$default$2$(PredicateHelper $this) {
        return $this.isLikelySelective$default$2();
    }

    default public boolean isLikelySelective$default$2() {
        return false;
    }

    public static void $init$(PredicateHelper $this) {
    }
}

