/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ConditionalExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NaNvl$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr1, expr2) - Returns `expr1` if it's not NaN, or `expr2` otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(cast('NaN' as double), 123);\n       123.0\n  ", since="1.5.0", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001B\u0010!\u00016B\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u00051\n\u0003\u0005R\u0001\tE\t\u0015!\u0003M\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\t)\u0002\u0001C)\u0003/A\u0011\"!\t\u0001\u0003\u0003%\t!a\t\t\u0013\u0005%\u0002!%A\u0005\u0002\u0005-\u0002\"CA!\u0001E\u0005I\u0011AA\u0016\u0011%\t\u0019\u0005AA\u0001\n\u0003\n)\u0005C\u0005\u0002X\u0001\t\t\u0011\"\u0001\u0002Z!I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00111\r\u0005\n\u0003S\u0002\u0011\u0011!C!\u0003WB\u0011\"!\u001f\u0001\u0003\u0003%\t!a\u001f\t\u0013\u0005\u0015\u0005!!A\u0005B\u0005\u001d\u0005\"CAF\u0001\u0005\u0005I\u0011IAG\u000f%\t\t\fIA\u0001\u0012\u0003\t\u0019L\u0002\u0005 A\u0005\u0005\t\u0012AA[\u0011\u0019\u0011\u0016\u0004\"\u0001\u0002N\"I\u0011qZ\r\u0002\u0002\u0013\u0015\u0013\u0011\u001b\u0005\n\u0003'L\u0012\u0011!CA\u0003+D\u0011\"a7\u001a\u0003\u0003%\t)!8\t\u0013\u0005=\u0018$!A\u0005\n\u0005E(!\u0002(b\u001dZd'BA\u0011#\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\r\"\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u00152\u0013aA:rY*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001q#'\u000e\u001d?!\ty\u0003'D\u0001!\u0013\t\t\u0004E\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011qfM\u0005\u0003i\u0001\u0012QcQ8oI&$\u0018n\u001c8bY\u0016C\bO]3tg&|g\u000e\u0005\u00020m%\u0011q\u0007\t\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t9\u0001K]8ek\u000e$\bCA H\u001d\t\u0001UI\u0004\u0002B\t6\t!I\u0003\u0002DY\u00051AH]8pizJ\u0011aO\u0005\u0003\rj\nq\u0001]1dW\u0006<W-\u0003\u0002I\u0013\na1+\u001a:jC2L'0\u00192mK*\u0011aIO\u0001\u0005Y\u00164G/F\u0001M!\tyS*\u0003\u0002OA\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019A+\u0016,\u0011\u0005=\u0002\u0001\"\u0002&\u0006\u0001\u0004a\u0005\"\u0002)\u0006\u0001\u0004a\u0015\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003e\u0003\"AW/\u000e\u0003mS!\u0001\u0018\u0013\u0002\u000bQL\b/Z:\n\u0005y[&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001b!\ry$\rZ\u0005\u0003G&\u00131aU3r!\tQV-\u0003\u0002g7\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0016C2<\u0018-_:Fm\u0006dW/\u0019;fI&s\u0007/\u001e;t+\u0005I\u0007cA c\u0019\u0006ar/\u001b;i\u001d\u0016<\u0018\t\\<bsN,e/\u00197vCR,G-\u00138qkR\u001cHC\u0001+m\u0011\u00159\u0017\u00021\u0001j\u00031\u0011'/\u00198dQ\u001e\u0013x.\u001e9t+\u0005y\u0007cA cS\u0006!QM^1m)\t\u0011X\u000f\u0005\u0002:g&\u0011AO\u000f\u0002\u0004\u0003:L\bb\u0002<\f!\u0003\u0005\ra^\u0001\u0006S:\u0004X\u000f\u001e\t\u0003qfl\u0011AI\u0005\u0003u\n\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0006{\u0006\u001d\u0011\u0011\u0003\t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005\u0001%A\u0004d_\u0012,w-\u001a8\n\u0007\u0005\u0015qP\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tI\u0001\u0004a\u0001\u0003\u0017\t1a\u0019;y!\rq\u0018QB\u0005\u0004\u0003\u001fy(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003'a\u0001\u0019A?\u0002\u0005\u00154\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015!\u0016\u0011DA\u000f\u0011\u0019\tY\"\u0004a\u0001\u0019\u00069a.Z<MK\u001a$\bBBA\u0010\u001b\u0001\u0007A*\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000bQ\u000b)#a\n\t\u000f)s\u0001\u0013!a\u0001\u0019\"9\u0001K\u0004I\u0001\u0002\u0004a\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003[Q3\u0001TA\u0018W\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001eu\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0012Q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003'j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\u0005Y\u0006twM\u0003\u0002\u0002R\u0005!!.\u0019<b\u0013\u0011\t)&a\u0013\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\u0006E\u0002:\u0003;J1!a\u0018;\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\u0011\u0018Q\r\u0005\n\u0003O\u001a\u0012\u0011!a\u0001\u00037\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA7!\u0015\ty'!\u001es\u001b\t\t\tHC\u0002\u0002ti\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9(!\u001d\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003{\n\u0019\tE\u0002:\u0003\u007fJ1!!!;\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u001a\u0016\u0003\u0003\u0005\rA]\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002H\u0005%\u0005\"CA4-\u0005\u0005\t\u0019AA.\u0003\u0019)\u0017/^1mgR!\u0011QPAH\u0011!\t9gFA\u0001\u0002\u0004\u0011\bf\u0005\u0001\u0002\u0014\u0006e\u00151TAP\u0003C\u000b)+a*\u0002,\u00065\u0006cA\u0018\u0002\u0016&\u0019\u0011q\u0013\u0011\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QT\u0001N?\u001a+fjQ0)Kb\u0004(/\r\u0017!Kb\u0004(OM\u0015![\u0001\u0012V\r^;s]N\u0004\u0003-\u001a=qeF\u0002\u0007%\u001b4!SR<3\u000f\t8pi\u0002r\u0015M\u0014\u0017!_J\u0004\u0003-\u001a=qeJ\u0002\u0007e\u001c;iKJ<\u0018n]3/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAR\u0003ES\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY1ti\":c*\u0019((A\u0005\u001c\b\u0005Z8vE2,\u0017\u0006\f\u00112eMJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00193g9\u0002$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005%\u0016!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAAX\u0003E\u0019wN\u001c3ji&|g.\u00197`MVt7m]\u0001\u0006\u001d\u0006te\u000f\u001c\t\u0003_e\u0019R!GA\\\u0003\u0007\u0004r!!/\u0002@2cE+\u0004\u0002\u0002<*\u0019\u0011Q\u0018\u001e\u0002\u000fI,h\u000e^5nK&!\u0011\u0011YA^\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*!\u0011\u0011ZA(\u0003\tIw.C\u0002I\u0003\u000f$\"!a-\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bQ\u000b9.!7\t\u000b)c\u0002\u0019\u0001'\t\u000bAc\u0002\u0019\u0001'\u0002\u000fUt\u0017\r\u001d9msR!\u0011q\\Av!\u0015I\u0014\u0011]As\u0013\r\t\u0019O\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000be\n9\u000f\u0014'\n\u0007\u0005%(H\u0001\u0004UkBdWM\r\u0005\t\u0003[l\u0012\u0011!a\u0001)\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005M\b\u0003BA%\u0003kLA!a>\u0002L\t1qJ\u00196fGR\u0004")
public class NaNvl
extends BinaryExpression
implements ConditionalExpression,
ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(NaNvl x$0) {
        return NaNvl$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, NaNvl> tupled() {
        return NaNvl$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, NaNvl>> curried() {
        return NaNvl$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final boolean foldable() {
        return ConditionalExpression.foldable$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<Expression> alwaysEvaluatedInputs() {
        Expression expression = this.left();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public NaNvl withNewAlwaysEvaluatedInputs(Seq<Expression> alwaysEvaluatedInputs) {
        return this.copy((Expression)alwaysEvaluatedInputs.head(), this.copy$default$2());
    }

    @Override
    public Seq<Seq<Expression>> branchGroups() {
        return new .colon.colon(this.children(), (List)Nil$.MODULE$);
    }

    @Override
    public Object eval(InternalRow input) {
        Object value = this.left().eval(input);
        if (value == null) {
            return null;
        }
        DataType dataType = this.left().dataType();
        if (DoubleType$.MODULE$.equals(dataType)) {
            if (!Double.isNaN(BoxesRunTime.unboxToDouble((Object)value))) {
                return value;
            }
            return this.right().eval(input);
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            if (!Float.isNaN(BoxesRunTime.unboxToFloat((Object)value))) {
                return value;
            }
            return this.right().eval(input);
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        DataType dataType = this.left().dataType();
        if (DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType)) {
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = false;\n          ", " ", " = ", ";\n          if (", ") {\n            ", " = true;\n          } else {\n            if (!Double.isNaN(", ")) {\n              ", " = ", ";\n            } else {\n              ", "\n              if (", ") {\n                ", " = true;\n              } else {\n                ", " = ", ";\n              }\n            }\n          }"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), leftGen.isNull(), ev.isNull(), leftGen.value(), ev.value(), leftGen.value(), rightGen.code(), rightGen.isNull(), ev.isNull(), ev.value(), rightGen.value()})), ev.copy$default$2(), ev.copy$default$3());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public NaNvl withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public NaNvl copy(Expression left, Expression right) {
        return new NaNvl(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "NaNvl";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NaNvl;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NaNvl)) return false;
        boolean bl = true;
        if (!bl) return false;
        NaNvl naNvl = (NaNvl)x$1;
        Expression expression = this.left();
        Expression expression2 = naNvl.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = naNvl.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!naNvl.canEqual(this)) return false;
        return true;
    }

    public NaNvl(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ConditionalExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

