/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BitmapConstructAgg$;
import org.apache.spark.sql.catalyst.expressions.BitmapExpressionUtils;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="\n    _FUNC_(child) - Returns a bitmap with the positions of the bits set from all the values from\n    the child expression. The child expression will most likely be bitmap_bit_position().\n  ", examples="\n    Examples:\n      > SELECT substring(hex(_FUNC_(bitmap_bit_position(col))), 0, 6) FROM VALUES (1), (2), (3) AS tab(col);\n       070000\n      > SELECT substring(hex(_FUNC_(bitmap_bit_position(col))), 0, 6) FROM VALUES (1), (1), (1) AS tab(col);\n       010000\n  ", since="3.5.0", group="agg_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015e\u0001B\u00193\u0001~B\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tO\u0002\u0011\t\u0012)A\u0005!\"A\u0001\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005n\u0001\tE\t\u0015!\u0003k\u0011!q\u0007A!f\u0001\n\u0003I\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011\u00026\t\u000bA\u0004A\u0011A9\t\u000bA\u0004A\u0011\u0001<\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\u0013\u0001\u0011E\u0013q\u0005\u0005\b\u0003[\u0001A\u0011IA\u0018\u0011\u001d\t)\u0004\u0001C!\u0003oAq!!\u0010\u0001\t\u0003\ny\u0004C\u0004\u0002H\u0001!\t%!\u0013\t\u0013\u0005E\u0003A1A\u0005\n\u0005M\u0003\u0002CA.\u0001\u0001\u0006I!!\u0016\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`!9\u00111\r\u0001\u0005B\u0005\u0015\u0004\"CA:\u0001\t\u0007I\u0011IA0\u0011!\t)\b\u0001Q\u0001\n\u0005\u0005\u0004bBA<\u0001\u0011\u0005\u0013\u0011\u0010\u0005\b\u0003\u001b\u0003A\u0011IAH\u0011\u001d\t9\n\u0001C!\u00033Cq!a)\u0001\t\u0003\n)\u000bC\u0005\u00020\u0002\t\t\u0011\"\u0001\u00022\"I\u0011\u0011\u0018\u0001\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003#\u0004\u0011\u0013!C\u0001\u0003'D\u0011\"a6\u0001#\u0003%\t!a5\t\u0013\u0005e\u0007!!A\u0005B\u0005m\u0007\u0002CAv\u0001\u0005\u0005I\u0011A5\t\u0013\u00055\b!!A\u0005\u0002\u0005=\b\"CA{\u0001\u0005\u0005I\u0011IA|\u0011%\u0011)\u0001AA\u0001\n\u0003\u00119\u0001C\u0005\u0003\f\u0001\t\t\u0011\"\u0011\u0003\u000e!I!\u0011\u0003\u0001\u0002\u0002\u0013\u0005#1C\u0004\n\u0005o\u0011\u0014\u0011!E\u0001\u0005s1\u0001\"\r\u001a\u0002\u0002#\u0005!1\b\u0005\u0007a\u001e\"\tAa\u0015\t\u0013\tUs%!A\u0005F\t]\u0003\"\u0003B-O\u0005\u0005I\u0011\u0011B.\u0011%\u0011\u0019gJI\u0001\n\u0003\t\u0019\u000eC\u0005\u0003f\u001d\n\n\u0011\"\u0001\u0002T\"I!qM\u0014\u0002\u0002\u0013\u0005%\u0011\u000e\u0005\n\u0005o:\u0013\u0013!C\u0001\u0003'D\u0011B!\u001f(#\u0003%\t!a5\t\u0013\tmt%!A\u0005\n\tu$A\u0005\"ji6\f\u0007oQ8ogR\u0014Xo\u0019;BO\u001eT!a\r\u001b\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003kY\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003oa\n1a]9m\u0015\tI$(A\u0003ta\u0006\u00148N\u0003\u0002<y\u00051\u0011\r]1dQ\u0016T\u0011!P\u0001\u0004_J<7\u0001A\n\u0007\u0001\u00013%jU-\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r\u0013\u0014!C1hOJ,w-\u0019;f\u0013\t)%IA\nJ[B,'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\r\u0005\u0002H\u00116\t!'\u0003\u0002Je\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000fE\u0002L\u001dBk\u0011\u0001\u0014\u0006\u0003\u001bR\nQ\u0001\u001e:fKNL!a\u0014'\u0003\u0013Us\u0017M]=MS.,\u0007CA$R\u0013\t\u0011&G\u0001\u0006FqB\u0014Xm]:j_:\u0004\"\u0001V,\u000e\u0003US\u0011AV\u0001\u0006g\u000e\fG.Y\u0005\u00031V\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002[E:\u00111\f\u0019\b\u00039~k\u0011!\u0018\u0006\u0003=z\na\u0001\u0010:p_Rt\u0014\"\u0001,\n\u0005\u0005,\u0016a\u00029bG.\fw-Z\u0005\u0003G\u0012\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!!Y+\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003A\u000baa\u00195jY\u0012\u0004\u0013AF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0016\u0003)\u0004\"\u0001V6\n\u00051,&aA%oi\u00069R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA\u00051A(\u001b8jiz\"BA]:ukB\u0011q\t\u0001\u0005\u0006K\u001e\u0001\r\u0001\u0015\u0005\bQ\u001e\u0001\n\u00111\u0001k\u0011\u001dqw\u0001%AA\u0002)$\"A]<\t\u000b\u0015D\u0001\u0019\u0001)\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001{!\rQ60`\u0005\u0003y\u0012\u00141aU3r!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u0001\u001c\u0002\u000bQL\b/Z:\n\u0007\u0005\u0015qP\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\fA\u0019a0!\u0004\n\u0007\u0005=qP\u0001\u0005ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003+\u0001B!a\u0006\u0002 9!\u0011\u0011DA\u000e!\taV+C\u0002\u0002\u001eU\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0011\u0003G\u0011aa\u0015;sS:<'bAA\u000f+\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2A]A\u0015\u0011\u0019\tY\u0003\u0004a\u0001!\u0006Aa.Z<DQ&dG-A\u000fxSRDg*Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u)\r\u0001\u0015\u0011\u0007\u0005\u0007\u0003gi\u0001\u0019\u00016\u000239,w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u001co&$\bNT3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\u0007\u0001\u000bI\u0004\u0003\u0004\u0002<9\u0001\rA[\u0001\u0018]\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0003\u0003\u0003\u00022\u0001VA\"\u0013\r\t)%\u0016\u0002\b\u0005>|G.Z1o\u0003=\twm\u001a\"vM\u001a,'oU2iK6\fWCAA&!\rq\u0018QJ\u0005\u0004\u0003\u001fz(AC*ueV\u001cG\u000fV=qK\u0006Q!-\u001b;nCB\fE\u000f\u001e:\u0016\u0005\u0005U\u0003cA$\u0002X%\u0019\u0011\u0011\f\u001a\u0003%\u0005#HO]5ckR,'+\u001a4fe\u0016t7-Z\u0001\fE&$X.\u00199BiR\u0014\b%A\nbO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7/\u0006\u0002\u0002bA!!l_A+\u00035!WMZ1vYR\u0014Vm];miV\u0011\u0011q\r\t\u0006)\u0006%\u0014QN\u0005\u0004\u0003W*&AB(qi&|g\u000eE\u0002H\u0003_J1!!\u001d3\u0005\u001da\u0015\u000e^3sC2\f\u0001$\u001b8qkR\fum\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3t\u0003eIg\u000e];u\u0003\u001e<')\u001e4gKJ\fE\u000f\u001e:jEV$Xm\u001d\u0011\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0003\u0002|\u0005\u0005\u0005c\u0001+\u0002~%\u0019\u0011qP+\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0007;\u0002\u0019AAC\u0003\u0019\u0011WO\u001a4feB!\u0011qQAE\u001b\u0005!\u0014bAAFi\tY\u0011J\u001c;fe:\fGNU8x\u0003\u0019)\b\u000fZ1uKR1\u00111PAI\u0003'Cq!a!\u0019\u0001\u0004\t)\tC\u0004\u0002\u0016b\u0001\r!!\"\u0002\u000b%t\u0007/\u001e;\u0002\u000b5,'oZ3\u0015\r\u0005m\u00141TAP\u0011\u001d\ti*\u0007a\u0001\u0003\u000b\u000bqAY;gM\u0016\u0014\u0018\u0007C\u0004\u0002\"f\u0001\r!!\"\u0002\u000f\t,hMZ3se\u0005!QM^1m)\u0011\t9+!,\u0011\u0007Q\u000bI+C\u0002\u0002,V\u00131!\u00118z\u0011%\t\u0019I\u0007I\u0001\u0002\u0004\t))\u0001\u0003d_BLHc\u0002:\u00024\u0006U\u0016q\u0017\u0005\bKn\u0001\n\u00111\u0001Q\u0011\u001dA7\u0004%AA\u0002)DqA\\\u000e\u0011\u0002\u0003\u0007!.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005u&f\u0001)\u0002@.\u0012\u0011\u0011\u0019\t\u0005\u0003\u0007\fi-\u0004\u0002\u0002F*!\u0011qYAe\u0003%)hn\u00195fG.,GMC\u0002\u0002LV\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty-!2\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005U'f\u00016\u0002@\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002^B!\u0011q\\Au\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018\u0001\u00027b]\u001eT!!a:\u0002\t)\fg/Y\u0005\u0005\u0003C\t\t/\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0016\u0011\u001f\u0005\t\u0003g\f\u0013\u0011!a\u0001U\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!?\u0011\r\u0005m(\u0011AAT\u001b\t\tiPC\u0002\u0002\u0000V\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019!!@\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0003\u0012I\u0001C\u0005\u0002t\u000e\n\t\u00111\u0001\u0002(\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tiNa\u0004\t\u0011\u0005MH%!AA\u0002)\fa!Z9vC2\u001cH\u0003BA!\u0005+A\u0011\"a=&\u0003\u0003\u0005\r!a*)'\u0001\u0011IBa\b\u0003\"\t\u0015\"q\u0005B\u0016\u0005[\u0011\tDa\r\u0011\u0007\u001d\u0013Y\"C\u0002\u0003\u001eI\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003$\u0005\tiH\u0003\u0011!A\u0001zf)\u0016(D?\"\u001a\u0007.\u001b7eS\u0001j\u0003EU3ukJt7\u000fI1!E&$X.\u00199!o&$\b\u000e\t;iK\u0002\u0002xn]5uS>t7\u000fI8gAQDW\r\t2jiN\u00043/\u001a;!MJ|W\u000eI1mY\u0002\"\b.\u001a\u0011wC2,Xm\u001d\u0011ge>l'\u0002\t\u0011!AQDW\rI2iS2$\u0007%\u001a=qe\u0016\u001c8/[8o]\u0001\"\u0006.\u001a\u0011dQ&dG\rI3yaJ,7o]5p]\u0002:\u0018\u000e\u001c7![>\u001cH\u000f\t7jW\u0016d\u0017\u0010\t2fA\tLG/\\1q?\nLGo\u00189pg&$\u0018n\u001c8)S9R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!\u0011F\u0001\u0003\u0010)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u00033/\u001e2tiJLgn\u001a\u0015iKbDsLR+O\u0007~C#-\u001b;nCB|&-\u001b;`a>\u001c\u0018\u000e^5p]\"\u001aw\u000e\\\u0015*S1\u0002\u0003\u0007\f\u00117S\u00012%kT'!-\u0006cU+R*!QEJC\u0006\t\u00153S1\u0002\u0003fM\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00111oA\u0002\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!gV\u00147\u000f\u001e:j]\u001eD\u0003.\u001a=)?\u001a+fjQ0)E&$X.\u00199`E&$x\f]8tSRLwN\u001c\u0015d_2L\u0013&\u000b\u0017!a1\u0002c'\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0019*Y\u0001B\u0013'\u000b\u0017!QEJ\u0003%Q*!i\u0006\u0014\u0007fY8mSmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003'\r\u00191aAR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0005_\tQa\r\u00186]A\nQa\u001a:pkB\f#A!\u000e\u0002\u0013\u0005<wm\u00184v]\u000e\u001c\u0018A\u0005\"ji6\f\u0007oQ8ogR\u0014Xo\u0019;BO\u001e\u0004\"aR\u0014\u0014\u000b\u001d\u0012iD!\u0013\u0011\u0011\t}\"Q\t)kUJl!A!\u0011\u000b\u0007\t\rS+A\u0004sk:$\u0018.\\3\n\t\t\u001d#\u0011\t\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003\u0002B&\u0005#j!A!\u0014\u000b\t\t=\u0013Q]\u0001\u0003S>L1a\u0019B')\t\u0011I$\u0001\u0005u_N#(/\u001b8h)\t\ti.A\u0003baBd\u0017\u0010F\u0004s\u0005;\u0012yF!\u0019\t\u000b\u0015T\u0003\u0019\u0001)\t\u000f!T\u0003\u0013!a\u0001U\"9aN\u000bI\u0001\u0002\u0004Q\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003l\tM\u0004#\u0002+\u0002j\t5\u0004C\u0002+\u0003pAS'.C\u0002\u0003rU\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B;[\u0005\u0005\t\u0019\u0001:\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t}\u0004\u0003BAp\u0005\u0003KAAa!\u0002b\n1qJ\u00196fGR\u0004")
public class BitmapConstructAgg
extends ImperativeAggregate
implements ImplicitCastInputTypes,
UnaryLike<Expression>,
Serializable {
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final AttributeReference bitmapAttr;
    private final Seq<AttributeReference> inputAggBufferAttributes;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$3() {
        return BitmapConstructAgg$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return BitmapConstructAgg$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(BitmapConstructAgg x$0) {
        return BitmapConstructAgg$.MODULE$.unapply(x$0);
    }

    public static int apply$default$3() {
        return BitmapConstructAgg$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return BitmapConstructAgg$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, BitmapConstructAgg> tupled() {
        return BitmapConstructAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, BitmapConstructAgg>>> curried() {
        return BitmapConstructAgg$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        BitmapConstructAgg bitmapConstructAgg = this;
        synchronized (bitmapConstructAgg) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)LongType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "bitmap_construct_agg";
    }

    @Override
    public BitmapConstructAgg withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public StructType aggBufferSchema() {
        return DataTypeUtils$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    private AttributeReference bitmapAttr() {
        return this.bitmapAttr;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        AttributeReference attributeReference = this.bitmapAttr();
        return Nil$.MODULE$.$colon$colon((Object)attributeReference);
    }

    @Override
    public Option<Literal> defaultResult() {
        return Option$.MODULE$.apply((Object)Literal$.MODULE$.apply(Array$.MODULE$.fill(BitmapExpressionUtils.NUM_BYTES, (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte())));
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return this.inputAggBufferAttributes;
    }

    @Override
    public void initialize(InternalRow buffer) {
        buffer.update(this.mutableAggBufferOffset(), Array$.MODULE$.fill(BitmapExpressionUtils.NUM_BYTES, (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte()));
    }

    @Override
    public void update(InternalRow buffer, InternalRow input) {
        Object position = this.child().eval(input);
        if (position != null) {
            byte[] bitmap = buffer.getBinary(this.mutableAggBufferOffset());
            long bitPosition = BoxesRunTime.unboxToLong((Object)position);
            if (bitPosition < 0L || bitPosition >= (long)(8 * bitmap.length)) {
                throw QueryExecutionErrors$.MODULE$.invalidBitmapPositionError(bitPosition, bitmap.length);
            }
            int bytePosition = (int)(bitPosition / 8L);
            int bit = (int)(bitPosition % 8L);
            bitmap[bytePosition] = (byte)(bitmap[bytePosition] | 1 << bit);
            return;
        }
    }

    @Override
    public void merge(InternalRow buffer1, InternalRow buffer2) {
        byte[] bitmap1 = buffer1.getBinary(this.mutableAggBufferOffset());
        byte[] bitmap2 = buffer2.getBinary(this.inputAggBufferOffset());
        BitmapExpressionUtils.bitmapMerge(bitmap1, bitmap2);
    }

    @Override
    public Object eval(InternalRow buffer) {
        return buffer.getBinary(this.mutableAggBufferOffset());
    }

    public BitmapConstructAgg copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new BitmapConstructAgg(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "BitmapConstructAgg";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitmapConstructAgg;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "mutableAggBufferOffset";
            }
            case 2: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitmapConstructAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitmapConstructAgg bitmapConstructAgg = (BitmapConstructAgg)x$1;
        if (this.mutableAggBufferOffset() != bitmapConstructAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != bitmapConstructAgg.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = bitmapConstructAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitmapConstructAgg.canEqual(this)) return false;
        return true;
    }

    public BitmapConstructAgg(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        UnaryLike.$init$(this);
        String x$12 = "bitmap";
        BinaryType$ x$2 = BinaryType$.MODULE$;
        boolean x$3 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("bitmap", (DataType)x$2, false, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("bitmap", (DataType)x$2, false, x$4);
        boolean x$7 = AttributeReference$.MODULE$.apply$default$7("bitmap", (DataType)x$2, false, x$4);
        this.bitmapAttr = new AttributeReference("bitmap", (DataType)x$2, false, x$4, x$5, x$6, x$7);
        this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1 & Serializable)x$1 -> x$1.newInstance());
    }

    public BitmapConstructAgg(Expression child) {
        this(child, 0, 0);
    }
}

