/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.joins;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.catalyst.CatalystTypeConverters;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.bcvar.ArrayWrapper;
import org.apache.spark.sql.catalyst.bcvar.BroadcastedJoinKeysWrapper;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.joins.BroadcastJoinKeysReaper;
import org.apache.spark.sql.execution.joins.HashedRelation;
import org.apache.spark.sql.execution.joins.KeyIdempotForHashedRelationDeser;
import org.apache.spark.sql.execution.joins.LongHashedRelation;
import org.apache.spark.sql.execution.joins.SetWrapper;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.sparkproject.guava.base.Objects;
import org.sparkproject.guava.cache.CacheBuilder;
import org.sparkproject.guava.cache.CacheLoader;
import org.sparkproject.guava.cache.LoadingCache;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.jdk.CollectionConverters;

public class BroadcastedJoinKeysWrapperImpl
implements BroadcastedJoinKeysWrapper {
    private Broadcast<HashedRelation> bcVar;
    private DataType[] totalKeyDataTypes;
    private int index = 0;
    private volatile transient WeakReference<Object> keysArray = null;
    private int totalJoinKeys = 0;
    private static final LoadingCache<BroadcastedJoinKeysWrapperImpl, Set<Object>> idempotentializerForSet = CacheBuilder.newBuilder().expireAfterWrite(CACHE_EXPIRY, TimeUnit.SECONDS).maximumSize((long)CACHE_SIZE).build((CacheLoader)new CacheLoader<BroadcastedJoinKeysWrapperImpl, Set<Object>>(){

        public Set<Object> load(BroadcastedJoinKeysWrapperImpl bcjk) {
            BroadcastJoinKeysReaper.checkInitialized();
            ArrayWrapper<? extends Object> keys = bcjk.getKeysArray();
            int len = keys.getLength();
            HashSet<Object> set = new HashSet<Object>();
            for (int i = 0; i < len; ++i) {
                set.add(keys.get(i));
            }
            return set;
        }
    });
    private static final LoadingCache<KeyIdempotForHashedRelationDeser, Object> idempotentializerForHashedRelationDeser = CacheBuilder.newBuilder().expireAfterWrite(CACHE_EXPIRY, TimeUnit.SECONDS).maximumSize((long)CACHE_SIZE).build((CacheLoader)new CacheLoader<KeyIdempotForHashedRelationDeser, Object>(){

        public Object load(KeyIdempotForHashedRelationDeser key) {
            BroadcastJoinKeysReaper.checkInitialized();
            Broadcast<HashedRelation> bcVar = key.bcjk.bcVar;
            if (bcVar.getValue() instanceof LongHashedRelation) {
                LongHashedRelation lhr = (LongHashedRelation)bcVar.getValue();
                if (key.bcjk.totalJoinKeys == 1) {
                    if (key.bcjk.totalKeyDataTypes[0].equals(LongType$.MODULE$)) {
                        return CollectionConverters.SeqHasAsJava((Seq)lhr.keys().map(f -> f.get(0, (DataType)LongType$.MODULE$)).toList()).asJava().toArray();
                    }
                    if (key.bcjk.totalKeyDataTypes[0].equals(IntegerType$.MODULE$)) {
                        return CollectionConverters.SeqHasAsJava((Seq)lhr.keys().map(f -> ((Long)f.get(0, (DataType)LongType$.MODULE$)).intValue()).toList()).asJava().toArray();
                    }
                    if (key.bcjk.totalKeyDataTypes[0].equals(ShortType$.MODULE$)) {
                        return CollectionConverters.SeqHasAsJava((Seq)lhr.keys().map(f -> ((Long)f.get(0, (DataType)LongType$.MODULE$)).shortValue()).toList()).asJava().toArray();
                    }
                    if (key.bcjk.totalKeyDataTypes[0].equals(ByteType$.MODULE$)) {
                        return CollectionConverters.SeqHasAsJava((Seq)lhr.keys().map(f -> ((Long)f.get(0, (DataType)LongType$.MODULE$)).byteValue()).toList()).asJava().toArray();
                    }
                    Function1 keyScalaConverter = CatalystTypeConverters.createToScalaConverter((DataType)key.bcjk.totalKeyDataTypes[0]);
                    if (key.bcjk.totalKeyDataTypes[0].equals(DateType$.MODULE$)) {
                        return CollectionConverters.SeqHasAsJava((Seq)lhr.keys().map(f -> {
                            Integer dateAsInt = (Integer)f.get(0, (DataType)LongType$.MODULE$);
                            return keyScalaConverter.apply((Object)dateAsInt);
                        }).toList()).asJava().toArray();
                    }
                    return CollectionConverters.SeqHasAsJava((Seq)lhr.keys().map(f -> {
                        Long valAsLong = (Long)f.get(0, (DataType)LongType$.MODULE$);
                        return keyScalaConverter.apply((Object)valAsLong);
                    }).toList()).asJava().toArray();
                }
                if (key.bcjk.totalJoinKeys == 2) {
                    DataType key1DataType = key.bcjk.totalKeyDataTypes[0];
                    DataType key2DataType = key.bcjk.totalKeyDataTypes[1];
                    Function1 key1ScalaConverter = CatalystTypeConverters.createToScalaConverter((DataType)key1DataType);
                    Function1 key2ScalaConverter = CatalystTypeConverters.createToScalaConverter((DataType)key2DataType);
                    return CollectionConverters.SeqHasAsJava((Seq)lhr.keys().map(ir -> {
                        long hashedKey = ir.getLong(0);
                        Object actualkey1 = key1ScalaConverter.apply((Object)((int)(hashedKey >> 32)));
                        Object actualkey2 = key2ScalaConverter.apply((Object)((int)(hashedKey & 0xFFFFFFFFL)));
                        return new Object[]{actualkey1, actualkey2};
                    }).toList()).asJava().toArray((T[])new Object[0][]);
                }
                throw new UnsupportedOperationException("Case not handled");
            }
            Iterator<InternalRow> keysIter = ((HashedRelation)bcVar.getValue()).keys();
            if (key.bcjk.totalJoinKeys == 1) {
                DataType keyDataType = key.bcjk.totalKeyDataTypes[0];
                Function1 toScalaConverter = CatalystTypeConverters.createToScalaConverter((DataType)keyDataType);
                Iterator keysAsScala = keysIter.map(f -> {
                    Object x = f.get(0, keyDataType);
                    return BroadcastedJoinKeysWrapper.conversionExcludedDataTypes.contains(keyDataType) ? x : toScalaConverter.apply(x);
                });
                return CollectionConverters.SeqHasAsJava((Seq)keysAsScala.toList()).asJava().toArray();
            }
            Function1[] toScalaConverters = new Function1[key.bcjk.totalJoinKeys];
            for (int i = 0; i < key.bcjk.totalJoinKeys; ++i) {
                DataType keyDataType = key.bcjk.totalKeyDataTypes[i];
                toScalaConverters[i] = CatalystTypeConverters.createToScalaConverter((DataType)keyDataType);
            }
            Iterator keysAsScala = keysIter.map(f -> {
                Object[] arr = new Object[key.bcjk.totalJoinKeys];
                for (int i = 0; i < key.bcjk.totalJoinKeys; ++i) {
                    DataType keyDataType = key.bcjk.totalKeyDataTypes[i];
                    Object x = f.get(i, keyDataType);
                    arr[i] = BroadcastedJoinKeysWrapper.conversionExcludedDataTypes.contains(keyDataType) ? x : toScalaConverters[i].apply(x);
                }
                return arr;
            });
            return CollectionConverters.SeqHasAsJava((Seq)keysAsScala.toList()).asJava().toArray((T[])new Object[0][]);
        }
    });

    private static Object[][] getObjects(LongHashedRelation lhr, BroadcastedJoinKeysWrapperImpl bcjk) {
        int totalKeysPresent = bcjk.totalJoinKeys;
        UnsafeRow unsafeRow = new UnsafeRow(totalKeysPresent);
        ByteBuffer buff = ByteBuffer.allocate(8);
        Function1[] toScalaConverters = new Function1[bcjk.totalJoinKeys];
        for (int i = 0; i < bcjk.totalJoinKeys; ++i) {
            DataType keyDataType = bcjk.totalKeyDataTypes[i];
            toScalaConverters[i] = CatalystTypeConverters.createToScalaConverter((DataType)keyDataType);
        }
        return (Object[][])CollectionConverters.SeqHasAsJava((Seq)lhr.keys().map(ir -> {
            long hashedKey = Long.reverse(ir.getLong(0));
            buff.putLong(0, hashedKey);
            byte[] arr = buff.array();
            unsafeRow.pointTo(arr, arr.length);
            Object[] actualkeys = new Object[bcjk.totalJoinKeys];
            for (int i = 0; i < bcjk.totalJoinKeys; ++i) {
                DataType keyDataType = bcjk.totalKeyDataTypes[i];
                Object temp = unsafeRow.get(i, keyDataType);
                actualkeys[i] = toScalaConverters[i].apply(temp);
            }
            return actualkeys;
        }).toList()).asJava().toArray((T[])new Object[0][]);
    }

    public BroadcastedJoinKeysWrapperImpl() {
    }

    public BroadcastedJoinKeysWrapperImpl(Broadcast<HashedRelation> bcVar, DataType[] totalKeyDataTypes, int index, int totalJoinKeys) {
        this.bcVar = bcVar;
        this.totalKeyDataTypes = totalKeyDataTypes;
        this.index = index;
        this.totalJoinKeys = totalJoinKeys;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.bcVar);
        out.writeInt(this.index);
        out.writeInt(this.totalJoinKeys);
        out.writeObject(this.totalKeyDataTypes);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.bcVar = (Broadcast)in.readObject();
        this.index = in.readInt();
        this.totalJoinKeys = in.readInt();
        this.totalKeyDataTypes = (DataType[])in.readObject();
    }

    private Object initKeys() {
        try {
            Object actualArray;
            if (this.keysArray == null || (actualArray = this.keysArray.get()) == null) {
                actualArray = idempotentializerForHashedRelationDeser.get((Object)new KeyIdempotForHashedRelationDeser(this));
                this.keysArray = new WeakReference(actualArray);
            }
            return actualArray;
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
    }

    public DataType getSingleKeyDataType() {
        return this.totalKeyDataTypes[this.index];
    }

    public ArrayWrapper<? extends Object> getKeysArray() {
        Object array = this.initKeys();
        return ArrayWrapper.wrapArray((Object)array, (this.totalJoinKeys == 1 ? 1 : 0) != 0, (int)this.index);
    }

    public Set<Object> getKeysAsSet() {
        try {
            Set keyset = (Set)idempotentializerForSet.get((Object)this);
            if (System.getProperty("debug", "false").equals("true")) {
                return new SetWrapper<Object>(keyset);
            }
            return keyset;
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
    }

    public boolean equals(Object other) {
        if (other != null) {
            return this == other || other instanceof BroadcastedJoinKeysWrapperImpl && this.bcVar.id() == ((BroadcastedJoinKeysWrapperImpl)other).bcVar.id() && this.index == ((BroadcastedJoinKeysWrapperImpl)other).index;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.bcVar.id(), this.index});
    }

    public long getBroadcastVarId() {
        return this.bcVar.id();
    }

    public int getKeyIndex() {
        return this.index;
    }

    public int getTotalJoinKeys() {
        return this.totalJoinKeys;
    }

    public HashedRelation getUnderlyingRelation() {
        return (HashedRelation)this.bcVar.getValue();
    }

    public Broadcast<HashedRelation> getUnderlyingBroadcastVar() {
        return this.bcVar;
    }

    public void invalidateSelf() {
        BroadcastedJoinKeysWrapperImpl.removeBroadcast(this.bcVar.id());
    }

    static void removeBroadcast(long id) {
        idempotentializerForHashedRelationDeser.asMap().keySet().stream().filter(key -> key.bcjk.getBroadcastVarId() == id).forEach(arg_0 -> idempotentializerForHashedRelationDeser.invalidate(arg_0));
        idempotentializerForSet.asMap().keySet().stream().filter(bcVar -> bcVar.getBroadcastVarId() == id).forEach(arg_0 -> idempotentializerForSet.invalidate(arg_0));
    }

    public static long getIdempotentializerForHashedRelationDeserSize() {
        return idempotentializerForHashedRelationDeser.size();
    }

    public static long getIdempotentializerForSetSize() {
        return idempotentializerForSet.size();
    }

    static void invalidateBroadcastCache() {
        idempotentializerForSet.invalidateAll();
        idempotentializerForHashedRelationDeser.invalidateAll();
    }
}

