/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import org.apache.spark.sql.catalyst.expressions.variant.VariantCastArgs;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ArrayReader;
import org.apache.spark.sql.execution.datasources.parquet.MapReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVariantReader;
import org.apache.spark.sql.execution.datasources.parquet.ScalarReader;
import org.apache.spark.sql.execution.datasources.parquet.StructReader;
import org.apache.spark.sql.execution.datasources.parquet.VariantReader;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.types.variant.VariantSchema;

public final class ParquetVariantReader$ {
    public static final ParquetVariantReader$ MODULE$ = new ParquetVariantReader$();

    public ParquetVariantReader apply(VariantSchema schema, DataType targetType, VariantCastArgs castArgs, boolean isTopLevelUnshredded) {
        MapType mapType;
        DataType dataType = targetType;
        if (schema == null) {
            return new ParquetVariantReader(schema, targetType, castArgs);
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return new StructReader(schema, structType, castArgs);
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            return new ArrayReader(schema, arrayType, castArgs);
        }
        if (dataType instanceof MapType && (mapType = (MapType)dataType).keyType() instanceof StringType) {
            return new MapReader(schema, mapType, castArgs);
        }
        if (dataType instanceof VariantType) {
            VariantType variantType = (VariantType)dataType;
            return new VariantReader(schema, (DataType)variantType, castArgs, isTopLevelUnshredded);
        }
        if (dataType instanceof AtomicType) {
            AtomicType atomicType = (AtomicType)dataType;
            return new ScalarReader(schema, (DataType)atomicType, castArgs);
        }
        throw QueryExecutionErrors$.MODULE$.unreachableError("Invalid target type: `" + targetType.sql() + "`");
    }

    public boolean apply$default$4() {
        return false;
    }

    private ParquetVariantReader$() {
    }
}

