/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.binaryfile;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.binaryfile.BinaryFileFormat$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.SerializableConfiguration;
import org.sparkproject.guava.io.ByteStreams;
import org.sparkproject.guava.io.Closeables;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%f\u0001B\f\u0019\u0001\u001dBQ\u0001\u000f\u0001\u0005\u0002eBQ\u0001\u0010\u0001\u0005BuBQ\u0001\u001d\u0001\u0005BEDq!a\u0001\u0001\t\u0003\n)\u0001C\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005}\u0001\u0001\"\u0015\u0002\"\u001d9\u00111\u000e\r\t\u0002\u00055dAB\f\u0019\u0011\u0003\ty\u0007\u0003\u00049\u0011\u0011\u0005\u0011\u0011\u000f\u0005\u000b\u0003gB!\u0019!C\u00011\u0005U\u0004\u0002CAC\u0011\u0001\u0006I!a\u001e\t\u0015\u0005\u001d\u0005B1A\u0005\u0002a\t)\b\u0003\u0005\u0002\n\"\u0001\u000b\u0011BA<\u0011)\tY\t\u0003b\u0001\n\u0003A\u0012Q\u000f\u0005\t\u0003\u001bC\u0001\u0015!\u0003\u0002x!Q\u0011q\u0012\u0005C\u0002\u0013\u0005\u0001$!\u001e\t\u0011\u0005E\u0005\u0002)A\u0005\u0003oB!\"a%\t\u0005\u0004%\t\u0001GA;\u0011!\t)\n\u0003Q\u0001\n\u0005]\u0004\"CAL\u0011\t\u0007I\u0011AAM\u0011\u001d\tY\n\u0003Q\u0001\n\u0005C\u0001\"!(\t\t\u0003A\u0012q\u0014\u0002\u0011\u0005&t\u0017M]=GS2,gi\u001c:nCRT!!\u0007\u000e\u0002\u0015\tLg.\u0019:zM&dWM\u0003\u0002\u001c9\u0005YA-\u0019;bg>,(oY3t\u0015\tib$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0004I\u0001\u0004gFd'BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u000b\u00183!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fMB\u0011q\u0006M\u0007\u00025%\u0011\u0011G\u0007\u0002\u000b\r&dWMR8s[\u0006$\bCA\u001a7\u001b\u0005!$BA\u001b\u001f\u0003\u001d\u0019x.\u001e:dKNL!a\u000e\u001b\u0003%\u0011\u000bG/Y*pkJ\u001cWMU3hSN$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0002\"a\u000f\u0001\u000e\u0003a\t1\"\u001b8gKJ\u001c6\r[3nCR!ahR'^!\rIs(Q\u0005\u0003\u0001*\u0012aa\u00149uS>t\u0007C\u0001\"F\u001b\u0005\u0019%B\u0001#\u001f\u0003\u0015!\u0018\u0010]3t\u0013\t15I\u0001\u0006TiJ,8\r\u001e+za\u0016DQ\u0001\u0013\u0002A\u0002%\u000bAb\u001d9be.\u001cVm]:j_:\u0004\"AS&\u000e\u0003yI!\u0001\u0014\u0010\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000b9\u0013\u0001\u0019A(\u0002\u000f=\u0004H/[8ogB!\u0001k\u0016.[\u001d\t\tV\u000b\u0005\u0002SU5\t1K\u0003\u0002UM\u00051AH]8pizJ!A\u0016\u0016\u0002\rA\u0013X\rZ3g\u0013\tA\u0016LA\u0002NCBT!A\u0016\u0016\u0011\u0005A[\u0016B\u0001/Z\u0005\u0019\u0019FO]5oO\")aL\u0001a\u0001?\u0006)a-\u001b7fgB\u0019\u0001-\u001a5\u000f\u0005\u0005\u001cgB\u0001*c\u0013\u0005Y\u0013B\u00013+\u0003\u001d\u0001\u0018mY6bO\u0016L!AZ4\u0003\u0007M+\u0017O\u0003\u0002eUA\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0003MNT!!\u001c\u0012\u0002\r!\fGm\\8q\u0013\ty'N\u0001\u0006GS2,7\u000b^1ukN\fA\u0002\u001d:fa\u0006\u0014Xm\u0016:ji\u0016$RA];w}~\u0004\"aL:\n\u0005QT\"aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\b\"\u0002%\u0004\u0001\u0004I\u0005\"B<\u0004\u0001\u0004A\u0018a\u00016pEB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010\\\u0001\n[\u0006\u0004(/\u001a3vG\u0016L!! >\u0003\u0007){'\rC\u0003O\u0007\u0001\u0007q\n\u0003\u0004\u0002\u0002\r\u0001\r!Q\u0001\u000bI\u0006$\u0018mU2iK6\f\u0017aC5t'Bd\u0017\u000e^1cY\u0016$\u0002\"a\u0002\u0002\u000e\u0005=\u0011\u0011\u0003\t\u0004S\u0005%\u0011bAA\u0006U\t9!i\\8mK\u0006t\u0007\"\u0002%\u0005\u0001\u0004I\u0005\"\u0002(\u0005\u0001\u0004y\u0005bBA\n\t\u0001\u0007\u0011QC\u0001\u0005a\u0006$\b\u000eE\u0002j\u0003/I1!!\u0007k\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0013MDwN\u001d;OC6,G#\u0001.\u0002\u0017\t,\u0018\u000e\u001c3SK\u0006$WM\u001d\u000b\u0011\u0003G\t\t%a\u0011\u0002F\u0005%\u0013QJA-\u00037\u0002r!KA\u0013\u0003S\ty#C\u0002\u0002()\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007=\nY#C\u0002\u0002.i\u0011q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0006A\u0006E\u0012QG\u0005\u0004\u0003g9'\u0001C%uKJ\fGo\u001c:\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f\u001f\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA \u0003s\u00111\"\u00138uKJt\u0017\r\u001c*po\")\u0001J\u0002a\u0001\u0013\"1\u0011\u0011\u0001\u0004A\u0002\u0005Ca!a\u0012\u0007\u0001\u0004\t\u0015a\u00049beRLG/[8o'\u000eDW-\\1\t\r\u0005-c\u00011\u0001B\u00039\u0011X-];je\u0016$7k\u00195f[\u0006Dq!a\u0014\u0007\u0001\u0004\t\t&A\u0004gS2$XM]:\u0011\t\u0001,\u00171\u000b\t\u0004g\u0005U\u0013bAA,i\t1a)\u001b7uKJDQA\u0014\u0004A\u0002=Cq!!\u0018\u0007\u0001\u0004\ty&\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003Kb\u0017\u0001B2p]\u001aLA!!\u001b\u0002d\ti1i\u001c8gS\u001e,(/\u0019;j_:\f\u0001CQ5oCJLh)\u001b7f\r>\u0014X.\u0019;\u0011\u0005mB1C\u0001\u0005))\t\ti'\u0001\u0003Q\u0003RCUCAA<!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\nA\u0001\\1oO*\u0011\u0011\u0011Q\u0001\u0005U\u00064\u0018-C\u0002]\u0003w\nQ\u0001U!U\u0011\u0002\n\u0011#T(E\u0013\u001aK5)\u0011+J\u001f:{F+S'F\u0003Iiu\nR%G\u0013\u000e\u000bE+S(O?RKU*\u0012\u0011\u0002\r1+ej\u0012+I\u0003\u001daUIT$U\u0011\u0002\nqaQ(O)\u0016sE+\u0001\u0005D\u001f:#VI\u0014+!\u0003-\u0011\u0015JT!S3~3\u0015\nT#\u0002\u0019\tKe*\u0011*Z?\u001aKE*\u0012\u0011\u0002\rM\u001c\u0007.Z7b+\u0005\t\u0015aB:dQ\u0016l\u0017\rI\u0001\u0015GJ,\u0017\r^3GS2$XM\u001d$v]\u000e$\u0018n\u001c8\u0015\t\u0005\u0005\u0016Q\u0015\t\u0005S}\n\u0019\u000b\u0005\u0004*\u0003KA\u0017q\u0001\u0005\b\u0003O3\u0002\u0019AA*\u0003\u00191\u0017\u000e\u001c;fe\u0002")
public class BinaryFileFormat
implements FileFormat,
DataSourceRegister {
    public static StructType schema() {
        return BinaryFileFormat$.MODULE$.schema();
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$(this, sparkSession, dataSchema);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$(this, requiredSchema, partitionSchema, sqlConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf, int expectedBroadcastVarFiltersCount) {
        return FileFormat.buildReaderWithPartitionValues$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf, expectedBroadcastVarFiltersCount);
    }

    @Override
    public AttributeReference createFileMetadataCol() {
        return FileFormat.createFileMetadataCol$(this);
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        return FileFormat.supportDataType$(this, dataType);
    }

    @Override
    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$(this, name);
    }

    @Override
    public boolean allowDuplicatedColumnNames() {
        return FileFormat.allowDuplicatedColumnNames$(this);
    }

    @Override
    public Seq<StructField> metadataSchemaFields() {
        return FileFormat.metadataSchemaFields$(this);
    }

    @Override
    public Map<String, Function1<PartitionedFile, Object>> fileConstantMetadataExtractors() {
        return FileFormat.fileConstantMetadataExtractors$(this);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)BinaryFileFormat$.MODULE$.schema());
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        throw QueryExecutionErrors$.MODULE$.writeUnsupportedForBinaryFileDataSourceError();
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return false;
    }

    @Override
    public String shortName() {
        return BinaryFileFormat$.MODULE$.BINARY_FILE();
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.require(DataTypeUtils$.MODULE$.sameType((DataType)dataSchema, (DataType)BinaryFileFormat$.MODULE$.schema()), (Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |Binary file data source expects dataSchema: " + BinaryFileFormat$.MODULE$.schema() + ",\n         |but got: " + dataSchema + ".\n        ")));
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        Seq filterFuncs = (Seq)filters.flatMap((Function1 & Serializable)filter -> BinaryFileFormat$.MODULE$.createFilterFunction((Filter)filter));
        int maxLength = BoxesRunTime.unboxToInt((Object)sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.SOURCES_BINARY_FILE_MAX_LENGTH()));
        return (Function1 & Serializable)file -> {
            Path path = file.toPath();
            FileSystem fs = path.getFileSystem(((SerializableConfiguration)broadcastedHadoopConf.value()).value());
            FileStatus status = fs.getFileStatus(path);
            if (filterFuncs.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BinaryFileFormat.$anonfun$buildReader$4(status, x$1)))) {
                UnsafeRowWriter writer = new UnsafeRowWriter(requiredSchema.length());
                writer.resetRowWriter();
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fieldNames()))), (Function1 & Serializable)x0$1 -> {
                    BinaryFileFormat.$anonfun$buildReader$5(writer, status, maxLength, fs, x0$1);
                    return BoxedUnit.UNIT;
                });
                return package$.MODULE$.Iterator().single((Object)writer.getRow());
            }
            return package$.MODULE$.Iterator().empty();
        };
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$4(FileStatus status$1, Function1 x$1) {
        return BoxesRunTime.unboxToBoolean((Object)x$1.apply((Object)status$1));
    }

    public static final /* synthetic */ void $anonfun$buildReader$5(UnsafeRowWriter writer$1, FileStatus status$1, int maxLength$1, FileSystem fs$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string2 = BinaryFileFormat$.MODULE$.PATH();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                writer$1.write(i, UTF8String.fromString((String)status$1.getPath().toString()));
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string4 = BinaryFileFormat$.MODULE$.LENGTH();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                writer$1.write(i, status$1.getLen());
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string6 = BinaryFileFormat$.MODULE$.MODIFICATION_TIME();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                writer$1.write(i, DateTimeUtils$.MODULE$.millisToMicros(status$1.getModificationTime()));
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string8 = BinaryFileFormat$.MODULE$.CONTENT();
            String string9 = string;
            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                if (status$1.getLen() > (long)maxLength$1) {
                    throw QueryExecutionErrors$.MODULE$.fileLengthExceedsMaxLengthError(status$1, maxLength$1);
                }
                FSDataInputStream stream = fs$1.open(status$1.getPath());
                try {
                    writer$1.write(i, ByteStreams.toByteArray((InputStream)stream));
                }
                finally {
                    Closeables.close((Closeable)stream, (boolean)true);
                }
                return;
            }
        }
        if (tuple2 != null) {
            String other = (String)tuple2._1();
            throw QueryExecutionErrors$.MODULE$.unsupportedFieldNameError(other);
        }
        throw new MatchError((Object)tuple2);
    }

    public BinaryFileFormat() {
        FileFormat.$init$(this);
    }
}

