/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import org.apache.spark.sql.catalyst.plans.logical.Join$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.PlanChangeLogger;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreeNodeTag;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveExecutionContext;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.adaptive.BroadcastQueryStageExec;
import org.apache.spark.sql.execution.adaptive.QueryStageExec;
import org.apache.spark.sql.execution.joins.BCVarPushNodeType;
import org.apache.spark.sql.execution.joins.BroadcastHashJoinExec;
import org.apache.spark.sql.execution.joins.SELF_PUSH$;
import org.apache.spark.util.ThreadUtils$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class AdaptiveSparkPlanExec$
implements Serializable {
    public static final AdaptiveSparkPlanExec$ MODULE$ = new AdaptiveSparkPlanExec$();
    private static final ExecutionContextExecutorService executionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("QueryStageCreator", 16, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3()));
    private static final TreeNodeTag<LogicalPlan> TEMP_LOGICAL_PLAN_TAG = new TreeNodeTag("temp_logical_plan");

    public boolean $lessinit$greater$default$5() {
        return false;
    }

    public ExecutionContextExecutorService executionContext() {
        return executionContext;
    }

    public TreeNodeTag<LogicalPlan> TEMP_LOGICAL_PLAN_TAG() {
        return TEMP_LOGICAL_PLAN_TAG;
    }

    public SparkPlan applyPhysicalRules(SparkPlan plan, Seq<Rule<SparkPlan>> rules, Option<Tuple2<PlanChangeLogger<SparkPlan>, String>> loggerAndBatchName) {
        if (loggerAndBatchName.isEmpty()) {
            return (SparkPlan)rules.foldLeft((Object)plan, (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    SparkPlan sp2 = (SparkPlan)tuple2._1();
                    Rule rule = (Rule)tuple2._2();
                    return (SparkPlan)rule.apply((TreeNode)sp2);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        Tuple2 tuple2 = (Tuple2)loggerAndBatchName.get();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PlanChangeLogger logger = (PlanChangeLogger)tuple2._1();
        String batchName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)logger, (Object)batchName);
        PlanChangeLogger logger2 = (PlanChangeLogger)tuple22._1();
        String batchName2 = (String)tuple22._2();
        SparkPlan newPlan = (SparkPlan)rules.foldLeft((Object)plan, (Function2 & Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (tuple2 != null) {
                SparkPlan sp2 = (SparkPlan)tuple2._1();
                Rule rule = (Rule)tuple2._2();
                SparkPlan result = (SparkPlan)rule.apply((TreeNode)sp2);
                logger2.logRule(rule.ruleName(), (TreeNode)sp2, (TreeNode)result);
                return result;
            }
            throw new MatchError((Object)tuple2);
        });
        logger2.logBatch(batchName2, (TreeNode)plan, (TreeNode)newPlan);
        return newPlan;
    }

    public Option<Tuple2<PlanChangeLogger<SparkPlan>, String>> applyPhysicalRules$default$3() {
        return None$.MODULE$;
    }

    public void org$apache$spark$sql$execution$adaptive$AdaptiveSparkPlanExec$$assertBroadcastPushPresenceInBHJ(SparkPlan plan) {
        Seq bhjs = AdaptiveSparkPlanExec$.recurseAndCheck$1(plan);
        bhjs.foreach((Function1 & Serializable)bhj -> {
            AdaptiveSparkPlanExec$.$anonfun$assertBroadcastPushPresenceInBHJ$2(bhj);
            return BoxedUnit.UNIT;
        });
    }

    public AdaptiveSparkPlanExec apply(SparkPlan inputPlan, AdaptiveExecutionContext context, Seq<Rule<SparkPlan>> preprocessingRules, boolean isSubquery, boolean supportsColumnar) {
        return new AdaptiveSparkPlanExec(inputPlan, context, preprocessingRules, isSubquery, supportsColumnar);
    }

    public boolean apply$default$5() {
        return false;
    }

    public Option<Tuple5<SparkPlan, AdaptiveExecutionContext, Seq<Rule<SparkPlan>>, Object, Object>> unapply(AdaptiveSparkPlanExec x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)x$0.inputPlan(), (Object)x$0.context(), x$0.preprocessingRules(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isSubquery()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.supportsColumnar())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AdaptiveSparkPlanExec$.class);
    }

    private static final Seq recurseAndCheck$1(SparkPlan plan) {
        Seq bhjs = plan.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof BroadcastHashJoinExec) {
                    BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)A1;
                    return (B1)broadcastHashJoinExec;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                return sparkPlan instanceof BroadcastHashJoinExec;
            }
        });
        Seq stages = plan.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof QueryStageExec) {
                    QueryStageExec queryStageExec = (QueryStageExec)A1;
                    return (B1)queryStageExec;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                SparkPlan sparkPlan = x2;
                return sparkPlan instanceof QueryStageExec;
            }
        });
        Seq otherBhjs = (Seq)stages.flatMap((Function1 & Serializable)stg -> AdaptiveSparkPlanExec$.recurseAndCheck$1(stg.plan()));
        return (Seq)bhjs.$plus$plus((IterableOnce)otherBhjs);
    }

    public static final /* synthetic */ void $anonfun$assertBroadcastPushPresenceInBHJ$2(BroadcastHashJoinExec bhj) {
        BroadcastQueryStageExec bqs;
        if (bhj.right() instanceof BroadcastQueryStageExec && (bqs = (BroadcastQueryStageExec)bhj.right()).hasStreamSidePushdownDependent()) {
            if (((TreeNode)bhj.logicalLink().get()).getTagValue(Join$.MODULE$.PRESERVE_JOIN_WITH_SELF_PUSH_HASH()).isEmpty()) {
                throw new IllegalStateException("No tag");
            }
            BCVarPushNodeType bCVarPushNodeType = bhj.bcVarPushNode();
            SELF_PUSH$ sELF_PUSH$ = SELF_PUSH$.MODULE$;
            if (bCVarPushNodeType == null ? sELF_PUSH$ != null : !bCVarPushNodeType.equals(sELF_PUSH$)) {
                throw new IllegalStateException("No self push");
            }
        }
        if (bhj.left() instanceof BroadcastQueryStageExec) {
            BroadcastQueryStageExec bqs2 = (BroadcastQueryStageExec)bhj.left();
            if (bqs2.hasStreamSidePushdownDependent()) {
                if (((TreeNode)bhj.logicalLink().get()).getTagValue(Join$.MODULE$.PRESERVE_JOIN_WITH_SELF_PUSH_HASH()).isEmpty()) {
                    throw new IllegalStateException("No tag");
                }
                BCVarPushNodeType bCVarPushNodeType = bhj.bcVarPushNode();
                SELF_PUSH$ sELF_PUSH$ = SELF_PUSH$.MODULE$;
                if (bCVarPushNodeType == null ? sELF_PUSH$ != null : !bCVarPushNodeType.equals(sELF_PUSH$)) {
                    throw new IllegalStateException("No self push");
                }
                return;
            }
            return;
        }
    }

    private AdaptiveSparkPlanExec$() {
    }
}

