/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.Serializable;
import org.apache.spark.ExecutorMaxFree$;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class SchedulerBackendUtils$ {
    public static final SchedulerBackendUtils$ MODULE$ = new SchedulerBackendUtils$();
    private static final int DEFAULT_NUMBER_EXECUTORS = 2;

    public int DEFAULT_NUMBER_EXECUTORS() {
        return DEFAULT_NUMBER_EXECUTORS;
    }

    public int getInitialTargetExecutorNumber(SparkConf conf, int numExecutors) {
        if (Utils$.MODULE$.isDynamicAllocationEnabled(conf)) {
            int minNumExecutors = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS()));
            int initialNumExecutors = Utils$.MODULE$.getDynamicAllocationInitialExecutors(conf);
            int maxNumExecutors = ExecutorMaxFree$.MODULE$.maxExecutors();
            Predef$.MODULE$.require(initialNumExecutors >= minNumExecutors && initialNumExecutors <= maxNumExecutors, (Function0 & Serializable)() -> "initial executor number " + initialNumExecutors + " must between min executor number " + minNumExecutors + " and max executor number " + maxNumExecutors);
            return initialNumExecutors;
        }
        return BoxesRunTime.unboxToInt((Object)((Option)conf.get(package$.MODULE$.EXECUTOR_INSTANCES())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> numExecutors));
    }

    public int getInitialTargetExecutorNumber$default$2() {
        return this.DEFAULT_NUMBER_EXECUTORS();
    }

    private SchedulerBackendUtils$() {
    }
}

