/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.CheckOverflowInSum;
import org.apache.spark.sql.catalyst.expressions.DecimalAddNoOverflowCheck;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.KnownNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the sum calculated from values of a group.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (5), (10), (15) AS tab(col);\n       30\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (10), (15) AS tab(col);\n       25\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (NULL) AS tab(col);\n       NULL\n  ", group="agg_funcs", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0005f\u0001\u0002\u00180\u0001zB\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tO\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0001\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005s\u0001\tE\t\u0015!\u0003k\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0015\u0019\b\u0001\"\u0001y\u0011\u0015Q\b\u0001\"\u0003|\u0011\u0015y\b\u0001\"\u0011|\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u0002\"\u0001!\t%a\t\t\u0013\u0005E\u0002A1A\u0005F\u0005M\u0002\u0002CA/\u0001\u0001\u0006i!!\u000e\t\u0015\u0005}\u0003\u0001#b\u0001\n\u0013\t\t\u0007\u0003\u0006\u0002~\u0001A)\u0019!C\u0005\u0003\u007fB!\"a\"\u0001\u0011\u000b\u0007I\u0011BA@\u0011)\tI\t\u0001EC\u0002\u0013%\u00111\u0012\u0005\b\u0003'\u0003A\u0011BAK\u0011)\ty\n\u0001EC\u0002\u0013\u0005\u0013\u0011\u0015\u0005\u000b\u0003K\u0003\u0001R1A\u0005B\u0005\u001d\u0006BCAV\u0001!\u0015\r\u0011\"\u0011\u0002(\"Q\u0011Q\u0016\u0001\t\u0006\u0004%\t%a*\t\u0013\u0005=\u0006\u0001#b\u0001\n\u00032\u0007bBAY\u0001\u0011\u0005\u00131\u0017\u0005\b\u0003\u0003\u0004A\u0011IAb\u0011\u001d\t\u0019\u000e\u0001C)\u0003+D\u0011\"a7\u0001\u0003\u0003%\t!!8\t\u0013\u0005\r\b!%A\u0005\u0002\u0005\u0015\b\"CA~\u0001E\u0005I\u0011AA\u007f\u0011%\u0011\t\u0001AA\u0001\n\u0003\u0012\u0019\u0001C\u0005\u0003\u0012\u0001\t\t\u0011\"\u0001\u0003\u0014!I!1\u0004\u0001\u0002\u0002\u0013\u0005!Q\u0004\u0005\n\u0005G\u0001\u0011\u0011!C!\u0005KA\u0011B!\r\u0001\u0003\u0003%\tAa\r\t\u0013\t]\u0002!!A\u0005B\te\u0002\"\u0003B\u001f\u0001\u0005\u0005I\u0011\tB \u000f%\u0011\u0019gLA\u0001\u0012\u0003\u0011)G\u0002\u0005/_\u0005\u0005\t\u0012\u0001B4\u0011\u0019\u0019h\u0005\"\u0001\u0003v!I!q\u000f\u0014\u0002\u0002\u0013\u0015#\u0011\u0010\u0005\n\u0005w2\u0013\u0011!CA\u0005{B\u0011Ba!'#\u0003%\t!!@\t\u0013\t\u0015e%!A\u0005\u0002\n\u001d\u0005\"\u0003BKME\u0005I\u0011AA\u007f\u0011%\u00119JJA\u0001\n\u0013\u0011IJA\u0002Tk6T!\u0001M\u0019\u0002\u0013\u0005<wM]3hCR,'B\u0001\u001a4\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005Q*\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005Y:\u0014aA:rY*\u0011\u0001(O\u0001\u0006gB\f'o\u001b\u0006\u0003um\na!\u00199bG\",'\"\u0001\u001f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001y4i\u0012)T3B\u0011\u0001)Q\u0007\u0002_%\u0011!i\f\u0002\u0015\t\u0016\u001cG.\u0019:bi&4X-Q4he\u0016<\u0017\r^3\u0011\u0005\u0011+U\"A\u0019\n\u0005\u0019\u000b$AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0007![U*D\u0001J\u0015\tQ5'A\u0003ue\u0016,7/\u0003\u0002M\u0013\nIQK\\1ss2K7.\u001a\t\u0003\t:K!aT\u0019\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002E#&\u0011!+\r\u0002\u0014'V\u0004\bo\u001c:u#V,'/_\"p]R,\u0007\u0010\u001e\t\u0003)^k\u0011!\u0016\u0006\u0002-\u0006)1oY1mC&\u0011\u0001,\u0016\u0002\b!J|G-^2u!\tQ&M\u0004\u0002\\A:\u0011AlX\u0007\u0002;*\u0011a,P\u0001\u0007yI|w\u000e\u001e \n\u0003YK!!Y+\u0002\u000fA\f7m[1hK&\u00111\r\u001a\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003CV\u000bQa\u00195jY\u0012,\u0012!T\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u0011\u00154\u0018\r\\'pI\u0016,\u0012A\u001b\t\u0003W:t!\u0001\u00127\n\u00055\f\u0014\u0001C#wC2lu\u000eZ3\n\u0005=\u0004(!\u0002,bYV,\u0017BA9V\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002\u0013\u00154\u0018\r\\'pI\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0002vm^\u0004\"\u0001\u0011\u0001\t\u000b\u0015,\u0001\u0019A'\t\u000f!,\u0001\u0013!a\u0001UR\u0011Q/\u001f\u0005\u0006K\u001a\u0001\r!T\u0001\u0013g\"|W\u000f\u001c3Ue\u0006\u001c7.S:F[B$\u00180F\u0001}!\t!V0\u0003\u0002\u007f+\n9!i\\8mK\u0006t\u0017\u0001\u00038vY2\f'\r\\3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u0002\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u00036\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ty!!\u0003\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\t\t)\u0002E\u0003[\u0003/\tY\"C\u0002\u0002\u001a\u0011\u00141aU3r!\u0011\t9!!\b\n\t\u0005}\u0011\u0011\u0002\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!!\n\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b4\u0003!\tg.\u00197zg&\u001c\u0018\u0002BA\u0018\u0003S\u0011q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\r]>$W\rU1ui\u0016\u0014hn]\u000b\u0003\u0003k\u0001RAWA\f\u0003o\u0001B!!\u000f\u0002X9!\u00111HA*\u001d\u0011\ti$!\u0015\u000f\t\u0005}\u0012q\n\b\u0005\u0003\u0003\niE\u0004\u0003\u0002D\u0005-c\u0002BA#\u0003\u0013r1\u0001XA$\u0013\u0005a\u0014B\u0001\u001e<\u0013\tA\u0014(\u0003\u00027o%\u0011A'N\u0005\u0003\u0015NJ1!!\u0016J\u0003-!&/Z3QCR$XM\u001d8\n\t\u0005e\u00131\f\u0002\f)J,W\rU1ui\u0016\u0014hNC\u0002\u0002V%\u000bQB\\8eKB\u000bG\u000f^3s]N\u0004\u0013A\u0003:fgVdG\u000fV=qKV\u0011\u00111\r\n\b\u0003K\nIgUA8\r\u0019\t9\u0007\u0001\u0001\u0002d\taAH]3gS:,W.\u001a8u}A!\u0011qAA6\u0013\u0011\ti'!\u0003\u0003\u0015\u0005#x.\\5d)f\u0004X\r\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0005%|'BAA=\u0003\u0011Q\u0017M^1\n\u0007\r\f\u0019(A\u0002tk6,\"!!!\u0011\u0007\u0011\u000b\u0019)C\u0002\u0002\u0006F\u0012!#\u0011;ue&\u0014W\u000f^3SK\u001a,'/\u001a8dK\u00069\u0011n]#naRL\u0018\u0001\u0002>fe>,\"!!$\u0011\u0007\u0011\u000by)C\u0002\u0002\u0012F\u0012q\u0001T5uKJ\fG.A\u0002bI\u0012$R!TAL\u00037Ca!!'\u0013\u0001\u0004i\u0015\u0001\u00027fMRDa!!(\u0013\u0001\u0004i\u0015!\u0002:jO\"$\u0018aE1hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001cXCAAR!\u0015Q\u0016qCAA\u00035Ig.\u001b;jC24\u0016\r\\;fgV\u0011\u0011\u0011\u0016\t\u00055\u0006]Q*A\tva\u0012\fG/Z#yaJ,7o]5p]N\f\u0001#\\3sO\u0016,\u0005\u0010\u001d:fgNLwN\\:\u0002%\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\\\u0001\u000eM2\fG/\u0011:hk6,g\u000e^:\u0016\u0005\u0005U\u0006#\u0002.\u00028\u0006m\u0016bAA]I\nA\u0011\n^3sCR|'\u000fE\u0002U\u0003{K1!a0V\u0005\r\te._\u0001\u0011S:LG/U;fef\u001cuN\u001c;fqR$\"!!2\u0011\u000bQ\u000b9-a3\n\u0007\u0005%WK\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u001b\fy-D\u00018\u0013\r\t\tn\u000e\u0002\r#V,'/_\"p]R,\u0007\u0010^\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u00075\u000b9\u000e\u0003\u0004\u0002Zj\u0001\r!T\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\u0015)\u0018q\\Aq\u0011\u001d)7\u0004%AA\u00025Cq\u0001[\u000e\u0011\u0002\u0003\u0007!.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d(fA'\u0002j.\u0012\u00111\u001e\t\u0005\u0003[\f90\u0004\u0002\u0002p*!\u0011\u0011_Az\u0003%)hn\u00195fG.,GMC\u0002\u0002vV\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI0a<\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005}(f\u00016\u0002j\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0002\u0011\t\t\u001d!QB\u0007\u0003\u0005\u0013QAAa\u0003\u0002x\u0005!A.\u00198h\u0013\u0011\u0011yA!\u0003\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011)\u0002E\u0002U\u0005/I1A!\u0007V\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tYLa\b\t\u0013\t\u0005\u0002%!AA\u0002\tU\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003(A1!\u0011\u0006B\u0018\u0003wk!Aa\u000b\u000b\u0007\t5R+\u0001\u0006d_2dWm\u0019;j_:LA!!/\u0003,\u0005A1-\u00198FcV\fG\u000eF\u0002}\u0005kA\u0011B!\t#\u0003\u0003\u0005\r!a/\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005\u000b\u0011Y\u0004C\u0005\u0003\"\r\n\t\u00111\u0001\u0003\u0016\u00051Q-];bYN$2\u0001 B!\u0011%\u0011\t\u0003JA\u0001\u0002\u0004\tY\fK\n\u0001\u0005\u000b\u0012YE!\u0014\u0003R\tM#q\u000bB-\u0005;\u0012y\u0006E\u0002E\u0005\u000fJ1A!\u00132\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa\u0014\u0002\u0003~3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!gVl\u0007eY1mGVd\u0017\r^3eA\u0019\u0014x.\u001c\u0011wC2,Xm\u001d\u0011pM\u0002\n\u0007e\u001a:pkBt\u0013\u0001C3yC6\u0004H.Z:\"\u0005\tU\u0013!a@\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u001b*Y\u0001B\u0013\u0007M\u0015-A!\nT'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a1\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aw\u000e\\\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u0015O+2c\u0015\u0006\f\u0011)cAJC\u0006\t\u00152k%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012TG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2L\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002Bc*\u0016'MS1\u0002\u0003FT+M\u0019&\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\nQa\u001a:pkB\f#Aa\u0017\u0002\u0013\u0005<wm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B1\u0003\u0015\td\u0006\r\u00181\u0003\r\u0019V/\u001c\t\u0003\u0001\u001a\u001aRA\nB5\u0003_\u0002rAa\u001b\u0003r5SW/\u0004\u0002\u0003n)\u0019!qN+\u0002\u000fI,h\u000e^5nK&!!1\u000fB7\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005K\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u000b\tQ!\u00199qYf$R!\u001eB@\u0005\u0003CQ!Z\u0015A\u00025Cq\u0001[\u0015\u0011\u0002\u0003\u0007!.A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$BA!#\u0003\u0012B)A+a2\u0003\fB)AK!$NU&\u0019!qR+\u0003\rQ+\b\u000f\\33\u0011!\u0011\u0019jKA\u0001\u0002\u0004)\u0018a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa'\u0011\t\t\u001d!QT\u0005\u0005\u0005?\u0013IA\u0001\u0004PE*,7\r\u001e")
public class Sum
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
UnaryLike<Expression>,
SupportQueryContext {
    private AtomicType resultType;
    private AttributeReference sum;
    private AttributeReference isEmpty;
    private Literal zero;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Expression> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private final Expression child;
    private final Enumeration.Value evalMode;
    private final Seq<Enumeration.Value> nodePatterns;
    private Option<QueryContext> queryContext;
    private transient Seq<Expression> children;
    private volatile int bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Enumeration.Value $lessinit$greater$default$2() {
        return Sum$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Enumeration.Value>> unapply(Sum x$0) {
        return Sum$.MODULE$.unapply(x$0);
    }

    public static Enumeration.Value apply$default$2() {
        return Sum$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Enumeration.Value>, Sum> tupled() {
        return Sum$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Enumeration.Value, Sum>> curried() {
        return Sum$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public QueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public Option<QueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<QueryContext> x$1) {
        this.queryContext = x$1;
    }

    private Seq<Expression> children$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Enumeration.Value evalMode() {
        return this.evalMode;
    }

    private boolean shouldTrackIsEmpty() {
        AtomicType atomicType = this.resultType();
        if (atomicType instanceof DecimalType) {
            return true;
        }
        if (atomicType instanceof IntegralType ? true : atomicType instanceof AnsiIntervalType) {
            Enumeration.Value value = this.evalMode();
            Enumeration.Value value2 = EvalMode$.MODULE$.TRY();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.resultType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TypeUtils$.MODULE$.checkForAnsiIntervalOrNumericType(this.child());
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private AtomicType resultType$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 1) == 0) {
                LongType$ longType$;
                DecimalType decimalType;
                Option option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    longType$ = DecimalType$.MODULE$.bounded(precision + 10, scale);
                } else if (dataType instanceof IntegralType) {
                    longType$ = LongType$.MODULE$;
                } else if (dataType instanceof YearMonthIntervalType) {
                    YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
                    longType$ = yearMonthIntervalType;
                } else if (dataType instanceof DayTimeIntervalType) {
                    DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
                    longType$ = dayTimeIntervalType;
                } else {
                    longType$ = DoubleType$.MODULE$;
                }
                this.resultType = longType$;
                this.bitmap$0 |= 1;
            }
        }
        return this.resultType;
    }

    private AtomicType resultType() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.resultType$lzycompute();
        }
        return this.resultType;
    }

    private AttributeReference sum$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 2) == 0) {
                String x$1 = "sum";
                AtomicType x$2 = this.resultType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("sum", (DataType)x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("sum", (DataType)x$2, x$3, x$4);
                boolean x$7 = AttributeReference$.MODULE$.apply$default$7("sum", (DataType)x$2, x$3, x$4);
                this.sum = new AttributeReference("sum", (DataType)x$2, x$3, x$4, x$5, x$6, x$7);
                this.bitmap$0 |= 2;
            }
        }
        return this.sum;
    }

    private AttributeReference sum() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.sum$lzycompute();
        }
        return this.sum;
    }

    private AttributeReference isEmpty$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "isEmpty";
                BooleanType$ x$2 = BooleanType$.MODULE$;
                boolean x$3 = false;
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("isEmpty", (DataType)x$2, false, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("isEmpty", (DataType)x$2, false, x$4);
                boolean x$7 = AttributeReference$.MODULE$.apply$default$7("isEmpty", (DataType)x$2, false, x$4);
                this.isEmpty = new AttributeReference("isEmpty", (DataType)x$2, false, x$4, x$5, x$6, x$7);
                this.bitmap$0 |= 4;
            }
        }
        return this.isEmpty;
    }

    private AttributeReference isEmpty() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.isEmpty$lzycompute();
        }
        return this.isEmpty;
    }

    private Literal zero$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 8) == 0) {
                this.zero = Literal$.MODULE$.default((DataType)this.resultType());
                this.bitmap$0 |= 8;
            }
        }
        return this.zero;
    }

    private Literal zero() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.zero$lzycompute();
        }
        return this.zero;
    }

    private Expression add(Expression left, Expression right) {
        DataType dataType = left.dataType();
        if (dataType instanceof DecimalType) {
            return new DecimalAddNoOverflowCheck(left, right, left.dataType());
        }
        return new Add(left, right, this.evalMode());
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x10) == 0) {
                List list;
                if (this.shouldTrackIsEmpty()) {
                    AttributeReference attributeReference = this.sum();
                    AttributeReference attributeReference2 = this.isEmpty();
                    list = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                } else {
                    AttributeReference attributeReference = this.sum();
                    list = Nil$.MODULE$.$colon$colon((Object)attributeReference);
                }
                this.aggBufferAttributes = list;
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.aggBufferAttributes$lzycompute();
        }
        return this.aggBufferAttributes;
    }

    private Seq<Expression> initialValues$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = this.shouldTrackIsEmpty() ? new .colon.colon((Object)this.zero(), (List)new .colon.colon((Object)new Literal(BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$), (List)Nil$.MODULE$)) : new .colon.colon((Object)new Literal(null, (DataType)this.resultType()), (List)Nil$.MODULE$);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    @Override
    public Seq<Expression> initialValues() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.initialValues$lzycompute();
        }
        return this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x40) == 0) {
                .colon.colon colon2;
                if (this.shouldTrackIsEmpty()) {
                    Expression sumExpr = this.child().nullable() ? new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()), this.sum(), this.add(this.sum(), package$expressions$.MODULE$.DslExpression(new KnownNotNull(this.child())).cast((DataType)this.resultType()))) : this.add(this.sum(), package$expressions$.MODULE$.DslExpression(this.child()).cast((DataType)this.resultType()));
                    Literal isEmptyExpr = this.child().nullable() ? (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.isEmpty()).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()))) : new Literal(BoxesRunTime.boxToBoolean((boolean)false), (DataType)BooleanType$.MODULE$);
                    colon2 = new .colon.colon((Object)sumExpr, (List)new .colon.colon((Object)isEmptyExpr, (List)Nil$.MODULE$));
                } else {
                    colon2 = this.child().nullable() ? new .colon.colon((Object)package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.add(package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()})), package$expressions$.MODULE$.DslExpression(this.child()).cast((DataType)this.resultType())), this.sum()})), (List)Nil$.MODULE$) : new .colon.colon((Object)this.add(package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()})), package$expressions$.MODULE$.DslExpression(this.child()).cast((DataType)this.resultType())), (List)Nil$.MODULE$);
                }
                this.updateExpressions = colon2;
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.updateExpressions$lzycompute();
        }
        return this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x80) == 0) {
                .colon.colon colon2;
                if (this.shouldTrackIsEmpty()) {
                    Predicate bufferOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).left()).isNull()));
                    Predicate inputOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).right()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).right()).isNull()));
                    colon2 = new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression((Expression)((Object)bufferOverflow)).$bar$bar((Expression)((Object)inputOverflow))), Literal$.MODULE$.create(null, (DataType)this.resultType()), this.add(new KnownNotNull(this.RichAttribute(this.sum()).left()), new KnownNotNull(this.RichAttribute(this.sum()).right()))), (List)new .colon.colon((Object)((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).$amp$amp(this.RichAttribute(this.isEmpty()).right()))), (List)Nil$.MODULE$));
                } else {
                    colon2 = new .colon.colon((Object)package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.add(package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.RichAttribute(this.sum()).left(), this.zero()})), this.RichAttribute(this.sum()).right()), this.RichAttribute(this.sum()).left()})), (List)Nil$.MODULE$);
                }
                this.mergeExpressions = colon2;
                this.bitmap$0 |= 0x80;
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.mergeExpressions$lzycompute();
        }
        return this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x100) == 0) {
                Expression expression;
                AtomicType atomicType = this.resultType();
                if (atomicType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)atomicType;
                    Enumeration.Value value = this.evalMode();
                    Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
                    CheckOverflowInSum checkOverflowInSum = new CheckOverflowInSum(this.sum(), decimalType, value == null ? value2 != null : !value.equals(value2), this.getContextOrNull());
                    expression = new If(this.isEmpty(), Literal$.MODULE$.create(null, (DataType)this.resultType()), checkOverflowInSum);
                } else {
                    expression = this.shouldTrackIsEmpty() ? new If(this.isEmpty(), Literal$.MODULE$.create(null, (DataType)this.resultType()), this.sum()) : this.sum();
                }
                this.evaluateExpression = expression;
                this.bitmap$0 |= 0x100;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.evaluateExpression$lzycompute();
        }
        return this.evaluateExpression;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public Option<QueryContext> initQueryContext() {
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            return new Some((Object)this.origin().context());
        }
        return None$.MODULE$;
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Sum copy(Expression child, Enumeration.Value evalMode) {
        return new Sum(child, evalMode);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Enumeration.Value copy$default$2() {
        return this.evalMode();
    }

    @Override
    public String productPrefix() {
        return "Sum";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.evalMode();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sum;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "evalMode";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sum)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sum sum = (Sum)x$1;
        Expression expression = this.child();
        Expression expression2 = sum.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = sum.evalMode();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!sum.canEqual(this)) return false;
        return true;
    }

    public Sum(Expression child, Enumeration.Value evalMode) {
        this.child = child;
        this.evalMode = evalMode;
        ExpectsInputTypes.$init$(this);
        UnaryLike.$init$(this);
        SupportQueryContext.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.SUM(), (List)Nil$.MODULE$);
    }

    public Sum(Expression child) {
        this(child, EvalMode$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

