/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AggregateWindowFunction;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NthValue$;
import org.apache.spark.sql.catalyst.expressions.OffsetWindowFunction;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression$;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExpressionDescription(usage="\n    _FUNC_(input[, offset]) - Returns the value of `input` at the row that is the `offset`th row\n      from beginning of the window frame. Offset starts at 1. If ignoreNulls=true, we will skip\n      nulls when finding the `offset`th row. Otherwise, every row counts for the `offset`. If\n      there is no such an `offset`th row (e.g., when the offset is 10, size of the window frame\n      is less than 10), null is returned.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b, 2) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t1\n       A2\t3\tNULL\n  ", arguments="\n    Arguments:\n      * input - the target column or expression that the function operates on.\n      * offset - a positive int literal to indicate the offset in the window frame. It starts\n          with 1.\n      * ignoreNulls - an optional specification that indicates the NthValue should skip null\n          values in the determination of which row to use.\n  ", since="3.1.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0005\tud\u0001\u0002\u00180\u0001rB\u0001\u0002\u001b\u0001\u0003\u0016\u0004%\t!\u001b\u0005\tU\u0002\u0011\t\u0012)A\u0005\u001b\"A1\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005m\u0001\tE\t\u0015!\u0003N\u0011!i\u0007A!f\u0001\n\u0003q\u0007\u0002\u0003:\u0001\u0005#\u0005\u000b\u0011B8\t\u000bM\u0004A\u0011\u0001;\t\u000bM\u0004A\u0011A=\t\u000bM\u0004A\u0011A?\t\u0015\u0005\r\u0001\u0001#b\u0001\n\u0003\n)\u0001\u0003\u0004\u0002\u000e\u0001!\t%\u001b\u0005\u0007\u0003\u001f\u0001A\u0011I5\t\u0013\u0005E\u0001A1A\u0005B\u0005M\u0001\u0002CA\u000e\u0001\u0001\u0006I!!\u0006\t\u000f\u0005u\u0001\u0001\"\u0011\u0002 !9\u0011Q\u0006\u0001\u0005B\u0005=\u0002bBA\u001f\u0001\u0011\u0005\u0013q\b\u0005\u000b\u0003\u001b\u0002\u0001R1A\u0005\n\u0005=\u0003BCA,\u0001!\u0015\r\u0011\"\u0003\u0002Z!Q\u0011\u0011\r\u0001\t\u0006\u0004%I!!\u0017\t\u0015\u0005\r\u0004\u0001#b\u0001\n\u0003\n)\u0007\u0003\u0006\u0002j\u0001A)\u0019!C!\u0003WB!\"a\u001c\u0001\u0011\u000b\u0007I\u0011IA9\u0011)\t)\b\u0001EC\u0002\u0013\u0005\u0013\u0011\f\u0005\b\u0003o\u0002A\u0011IA=\u0011\u0019!\u0004\u0001\"\u0011\u0002z!9\u00111\u0012\u0001\u0005R\u00055\u0005\"CAL\u0001\u0005\u0005I\u0011AAM\u0011%\t\t\u000bAI\u0001\n\u0003\t\u0019\u000bC\u0005\u0002:\u0002\t\n\u0011\"\u0001\u0002$\"I\u00111\u0018\u0001\u0012\u0002\u0013\u0005\u0011Q\u0018\u0005\n\u0003\u0003\u0004\u0011\u0011!C!\u0003\u0007D\u0011\"a5\u0001\u0003\u0003%\t!!6\t\u0013\u0005u\u0007!!A\u0005\u0002\u0005}\u0007\"CAv\u0001\u0005\u0005I\u0011IAw\u0011%\tY\u0010AA\u0001\n\u0003\ti\u0010C\u0005\u0003\u0002\u0001\t\t\u0011\"\u0011\u0003\u0004!I!q\u0001\u0001\u0002\u0002\u0013\u0005#\u0011B\u0004\n\u0005gy\u0013\u0011!E\u0001\u0005k1\u0001BL\u0018\u0002\u0002#\u0005!q\u0007\u0005\u0007g\"\"\tAa\u0014\t\u0013\tE\u0003&!A\u0005F\tM\u0003\"\u0003B+Q\u0005\u0005I\u0011\u0011B,\u0011%\u0011y\u0006KA\u0001\n\u0003\u0013\t\u0007C\u0005\u0003t!\n\t\u0011\"\u0003\u0003v\tAa\n\u001e5WC2,XM\u0003\u00021c\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u00114'\u0001\u0005dCR\fG._:u\u0015\t!T'A\u0002tc2T!AN\u001c\u0002\u000bM\u0004\u0018M]6\u000b\u0005aJ\u0014AB1qC\u000eDWMC\u0001;\u0003\ry'oZ\u0002\u0001'!\u0001Q(\u0011#H!Zc\u0006C\u0001 @\u001b\u0005y\u0013B\u0001!0\u0005]\tum\u001a:fO\u0006$XmV5oI><h)\u001e8di&|g\u000e\u0005\u0002?\u0005&\u00111i\f\u0002\u0015\u001f\u001a47/\u001a;XS:$wn\u001e$v]\u000e$\u0018n\u001c8\u0011\u0005y*\u0015B\u0001$0\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bc\u0001%L\u001b6\t\u0011J\u0003\u0002Kc\u0005)AO]3fg&\u0011A*\u0013\u0002\u000b\u0005&t\u0017M]=MS.,\u0007C\u0001 O\u0013\tyuF\u0001\u0006FqB\u0014Xm]:j_:\u0004\"!\u0015+\u000e\u0003IS!aU\u001a\u0002\r\u0015\u0014(o\u001c:t\u0013\t)&KA\bRk\u0016\u0014\u00180\u0012:s_J\u001c()Y:f!\t9&,D\u0001Y\u0015\u0005I\u0016!B:dC2\f\u0017BA.Y\u0005\u001d\u0001&o\u001c3vGR\u0004\"!X3\u000f\u0005y\u001bgBA0c\u001b\u0005\u0001'BA1<\u0003\u0019a$o\\8u}%\t\u0011,\u0003\u0002e1\u00069\u0001/Y2lC\u001e,\u0017B\u00014h\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t!\u0007,A\u0003j]B,H/F\u0001N\u0003\u0019Ig\u000e];uA\u00051qN\u001a4tKR\fqa\u001c4gg\u0016$\b%A\u0006jO:|'/\u001a(vY2\u001cX#A8\u0011\u0005]\u0003\u0018BA9Y\u0005\u001d\u0011un\u001c7fC:\fA\"[4o_J,g*\u001e7mg\u0002\na\u0001P5oSRtD\u0003B;wob\u0004\"A\u0010\u0001\t\u000b!<\u0001\u0019A'\t\u000b-<\u0001\u0019A'\t\u000b5<\u0001\u0019A8\u0015\tUT8\u0010 \u0005\u0006Q\"\u0001\r!\u0014\u0005\u0006W\"\u0001\r!\u0014\u0005\u0006[\"\u0001\r!\u0014\u000b\u0005kz\f\t\u0001C\u0003\u0000\u0013\u0001\u0007Q*A\u0003dQ&dG\rC\u0003l\u0013\u0001\u0007Q*A\u0004eK\u001a\fW\u000f\u001c;\u0016\u0005\u0005\u001d\u0001c\u0001 \u0002\n%\u0019\u00111B\u0018\u0003\u000f1KG/\u001a:bY\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u0003\u00151'/Y7f+\t\t)\u0002E\u0002?\u0003/I1!!\u00070\u0005-9\u0016N\u001c3po\u001a\u0013\u0018-\\3\u0002\r\u0019\u0014\u0018-\\3!\u0003!!\u0017\r^1UsB,WCAA\u0011!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014g\u0005)A/\u001f9fg&!\u00111FA\u0013\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\u0011\u0011\u0011\u0007\t\u0006;\u0006M\u0012qG\u0005\u0004\u0003k9'aA*fcB!\u00111EA\u001d\u0013\u0011\tY$!\n\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA!!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$c\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002L\u0005\u0015#a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0013=4gm]3u-\u0006dWCAA)!\r9\u00161K\u0005\u0004\u0003+B&\u0001\u0002'p]\u001e\faA]3tk2$XCAA.!\rq\u0014QL\u0005\u0004\u0003?z#AE!uiJL'-\u001e;f%\u00164WM]3oG\u0016\fQaY8v]R\f1#Y4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN,\"!a\u001a\u0011\u000bu\u000b\u0019$a\u0017\u0002\u001b%t\u0017\u000e^5bYZ\u000bG.^3t+\t\ti\u0007E\u0003^\u0003g\t9!A\tva\u0012\fG/Z#yaJ,7o]5p]N,\"!a\u001d\u0011\tu\u000b\u0019$T\u0001\u0013KZ\fG.^1uK\u0016C\bO]3tg&|g.\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u001f\u0011\t\u0005u\u0014Q\u0011\b\u0005\u0003\u007f\n\t\t\u0005\u0002`1&\u0019\u00111\u0011-\u0002\rA\u0013X\rZ3g\u0013\u0011\t9)!#\u0003\rM#(/\u001b8h\u0015\r\t\u0019\tW\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$R!^AH\u0003'Ca!!%\u001c\u0001\u0004i\u0015a\u00028fo2+g\r\u001e\u0005\u0007\u0003+[\u0002\u0019A'\u0002\u00119,wOU5hQR\fAaY8qsR9Q/a'\u0002\u001e\u0006}\u0005b\u00025\u001d!\u0003\u0005\r!\u0014\u0005\bWr\u0001\n\u00111\u0001N\u0011\u001diG\u0004%AA\u0002=\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002&*\u001aQ*a*,\u0005\u0005%\u0006\u0003BAV\u0003kk!!!,\u000b\t\u0005=\u0016\u0011W\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a-Y\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\u000biKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005}&fA8\u0002(\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!2\u0011\t\u0005\u001d\u0017\u0011[\u0007\u0003\u0003\u0013TA!a3\u0002N\u0006!A.\u00198h\u0015\t\ty-\u0001\u0003kCZ\f\u0017\u0002BAD\u0003\u0013\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a6\u0011\u0007]\u000bI.C\u0002\u0002\\b\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!9\u0002hB\u0019q+a9\n\u0007\u0005\u0015\bLA\u0002B]fD\u0011\"!;#\u0003\u0003\u0005\r!a6\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u000f\u0005\u0004\u0002r\u0006]\u0018\u0011]\u0007\u0003\u0003gT1!!>Y\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003s\f\u0019P\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA8\u0002\u0000\"I\u0011\u0011\u001e\u0013\u0002\u0002\u0003\u0007\u0011\u0011]\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002F\n\u0015\u0001\"CAuK\u0005\u0005\t\u0019AAl\u0003\u0019)\u0017/^1mgR\u0019qNa\u0003\t\u0013\u0005%h%!AA\u0002\u0005\u0005\bf\u0006\u0001\u0003\u0010\tU!q\u0003B\u000e\u0005;\u0011\tCa\t\u0003(\t%\"Q\u0006B\u0018!\rq$\u0011C\u0005\u0004\u0005'y#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00053\t1\u0011\f\u0006!A\u0001\u0002sLR+O\u0007~C\u0013N\u001c9vinc\u0003e\u001c4gg\u0016$X,\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011wC2,X\rI8gA\u0001Lg\u000e];uA\u0002\nG\u000f\t;iK\u0002\u0012xn\u001e\u0011uQ\u0006$\b%[:!i\",\u0007\u0005Y8gMN,G\u000f\u0019;iAI|wO\u0003\u0011!A\u0001\u0002\u0003E\u001a:p[\u0002\u0012WmZ5o]&tw\rI8gAQDW\rI<j]\u0012|w\u000f\t4sC6,g\u0006I(gMN,G\u000fI:uCJ$8\u000fI1uAEr\u0003%\u00134!S\u001etwN]3Ok2d7/\u0010;sk\u0016d\u0003e^3!o&dG\u000eI:lSBT\u0001\u0005\t\u0011!A\u0001rW\u000f\u001c7tA]DWM\u001c\u0011gS:$\u0017N\\4!i\",\u0007\u0005Y8gMN,G\u000f\u0019;iAI|wO\f\u0011Pi\",'o^5tK2\u0002SM^3ss\u0002\u0012xn\u001e\u0011d_VtGo\u001d\u0011g_J\u0004C\u000f[3!A>4gm]3uA:\u0002\u0013J\u001a\u0006!A\u0001\u0002\u0003\u0005\t;iKJ,\u0007%[:!]>\u00043/^2iA\u0005t\u0007\u0005Y8gMN,G\u000f\u0019;iAI|w\u000f\t\u0015f]\u001dtC\u0006I<iK:\u0004C\u000f[3!_\u001a47/\u001a;!SN\u0004\u0013\u0007\r\u0017!g&TX\rI8gAQDW\rI<j]\u0012|w\u000f\t4sC6,'\u0002\t\u0011!A\u0001\u0002\u0013n\u001d\u0011mKN\u001c\b\u0005\u001e5b]\u0002\n\u0004'\u000b\u0017!]VdG\u000eI5tAI,G/\u001e:oK\u0012t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\b\u0002\u0003GS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\u0019\u0017!E2\u0002sLR+O\u0007~C#\r\f\u00113S\u0001ze+\u0012*!QA\u000b%\u000bV%U\u0013>s\u0005EQ-!C\u0002z%\u000bR#SA\tK\u0006EY\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u0015(\u0003F:C\u0006\t\u001a*Y\u0001Bs%Q\u0019(Y\u0001\n\u0014\u0006\f\u0011)O\u0005\u0013t\u0005\f\u00114S1\u0002\u0003fJ!2O1\u0002\u0013'\u000b\u0011uC\nD\u0013\r\f\u0011cSmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013)M\u00052\u0013ER\u0001\u0005\t\u0011!A\u0001\u0002\u0013)M\u00052\u0013ER\u0001\u0005\t\u0011!A\u0001\u0002\u0013)M\u00053\u0013ER\u0001\u0005\t\u0011!A\u0001\u0002\u0013IM\u00054\u00139+F\n\u0014\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0005K\t!1\u001b\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A%t\u0007/\u001e;![\u0001\"\b.\u001a\u0011uCJ<W\r\u001e\u0011d_2,XN\u001c\u0011pe\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011uQ\u0006$\b\u0005\u001e5fA\u0019,hn\u0019;j_:\u0004s\u000e]3sCR,7\u000fI8o])\u0001\u0003\u0005\t\u0011!A)\u0002sN\u001a4tKR\u0004S\u0006I1!a>\u001c\u0018\u000e^5wK\u0002Jg\u000e\u001e\u0011mSR,'/\u00197!i>\u0004\u0013N\u001c3jG\u0006$X\r\t;iK\u0002zgMZ:fi\u0002Jg\u000e\t;iK\u0002:\u0018N\u001c3po\u00022'/Y7f]\u0001JE\u000fI:uCJ$8O\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A]LG\u000f\u001b\u00112])\u0001\u0003\u0005\t\u0011!A)\u0002\u0013n\u001a8pe\u0016tU\u000f\u001c7tA5\u0002\u0013M\u001c\u0011paRLwN\\1mAM\u0004XmY5gS\u000e\fG/[8oAQD\u0017\r\u001e\u0011j]\u0012L7-\u0019;fg\u0002\"\b.\u001a\u0011Oi\"4\u0016\r\\;fAMDw.\u001e7eAM\\\u0017\u000e\u001d\u0011ok2d'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!m\u0006dW/Z:!S:\u0004C\u000f[3!I\u0016$XM]7j]\u0006$\u0018n\u001c8!_\u001a\u0004s\u000f[5dQ\u0002\u0012xn\u001e\u0011u_\u0002*8/\u001a\u0018\u000bA\u0001\nQa]5oG\u0016\f#Aa\u000b\u0002\u000bMr\u0013G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\tE\u0012\u0001D<j]\u0012|wo\u00184v]\u000e\u001c\u0018\u0001\u0003(uQZ\u000bG.^3\u0011\u0005yB3#\u0002\u0015\u0003:\t\u0015\u0003\u0003\u0003B\u001e\u0005\u0003jUj\\;\u000e\u0005\tu\"b\u0001B 1\u00069!/\u001e8uS6,\u0017\u0002\u0002B\"\u0005{\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\u00119E!\u0014\u000e\u0005\t%#\u0002\u0002B&\u0003\u001b\f!![8\n\u0007\u0019\u0014I\u0005\u0006\u0002\u00036\u0005AAo\\*ue&tw\r\u0006\u0002\u0002F\u0006)\u0011\r\u001d9msR9QO!\u0017\u0003\\\tu\u0003\"\u00025,\u0001\u0004i\u0005\"B6,\u0001\u0004i\u0005\"B7,\u0001\u0004y\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0005G\u0012y\u0007E\u0003X\u0005K\u0012I'C\u0002\u0003ha\u0013aa\u00149uS>t\u0007CB,\u0003l5ku.C\u0002\u0003na\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B9Y\u0005\u0005\t\u0019A;\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003xA!\u0011q\u0019B=\u0013\u0011\u0011Y(!3\u0003\r=\u0013'.Z2u\u0001")
public class NthValue
extends AggregateWindowFunction
implements OffsetWindowFunction,
ImplicitCastInputTypes,
BinaryLike<Expression>,
QueryErrorsBase {
    private Literal default;
    private long offsetVal;
    private AttributeReference result;
    private AttributeReference count;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Literal> initialValues;
    private Seq<Expression> updateExpressions;
    private AttributeReference evaluateExpression;
    private final Expression input;
    private final Expression offset;
    private final boolean ignoreNulls;
    private final WindowFrame frame;
    private transient Seq<Expression> children;
    private SpecifiedWindowFrame fakeFrame;
    private volatile int bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(NthValue x$0) {
        return NthValue$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Object>, NthValue> tupled() {
        return NthValue$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, NthValue>>> curried() {
        return NthValue$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    private SpecifiedWindowFrame fakeFrame$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.fakeFrame = OffsetWindowFunction.fakeFrame$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.fakeFrame;
    }

    @Override
    public SpecifiedWindowFrame fakeFrame() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.fakeFrame$lzycompute();
        }
        return this.fakeFrame;
    }

    @Override
    public Expression input() {
        return this.input;
    }

    @Override
    public Expression offset() {
        return this.offset;
    }

    @Override
    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    private Literal default$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 1) == 0) {
                this.default = Literal$.MODULE$.create(null, this.input().dataType());
                this.bitmap$0 |= 1;
            }
        }
        return this.default;
    }

    @Override
    public Literal default() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.default$lzycompute();
        }
        return this.default;
    }

    @Override
    public Expression left() {
        return this.input();
    }

    @Override
    public Expression right() {
        return this.offset();
    }

    @Override
    public WindowFrame frame() {
        return this.frame;
    }

    @Override
    public DataType dataType() {
        return this.input().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)AnyDataType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult check = ExpectsInputTypes.checkInputDataTypes$(this);
        if (check.isFailure()) {
            return check;
        }
        if (!this.offset().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)this.toSQLId("offset")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.offset().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.toSQLExpr(this.offset()))}))));
        }
        if (this.offsetVal() <= 0L) {
            return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"offset"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)("(0, " + Long.MAX_VALUE + "]")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)this.toSQLValue(BoxesRunTime.boxToLong((long)this.offsetVal()), (DataType)LongType$.MODULE$))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    private long offsetVal$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 2) == 0) {
                this.offsetVal = BoxesRunTime.unboxToInt((Object)this.offset().eval(this.offset().eval$default$1()));
                this.bitmap$0 |= 2;
            }
        }
        return this.offsetVal;
    }

    private long offsetVal() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.offsetVal$lzycompute();
        }
        return this.offsetVal;
    }

    private AttributeReference result$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "result";
                DataType x$2 = this.input().dataType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("result", x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("result", x$2, x$3, x$4);
                boolean x$7 = AttributeReference$.MODULE$.apply$default$7("result", x$2, x$3, x$4);
                this.result = new AttributeReference("result", x$2, x$3, x$4, x$5, x$6, x$7);
                this.bitmap$0 |= 4;
            }
        }
        return this.result;
    }

    private AttributeReference result() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.result$lzycompute();
        }
        return this.result;
    }

    private AttributeReference count$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 8) == 0) {
                String x$1 = "count";
                LongType$ x$2 = LongType$.MODULE$;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("count", (DataType)x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("count", (DataType)x$2, x$3, x$4);
                boolean x$7 = AttributeReference$.MODULE$.apply$default$7("count", (DataType)x$2, x$3, x$4);
                this.count = new AttributeReference("count", (DataType)x$2, x$3, x$4, x$5, x$6, x$7);
                this.bitmap$0 |= 8;
            }
        }
        return this.count;
    }

    private AttributeReference count() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.count$lzycompute();
        }
        return this.count;
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x10) == 0) {
                AttributeReference attributeReference = this.result();
                AttributeReference attributeReference2 = this.count();
                this.aggBufferAttributes = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.aggBufferAttributes$lzycompute();
        }
        return this.aggBufferAttributes;
    }

    private Seq<Literal> initialValues$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = new .colon.colon((Object)this.default(), (List)new .colon.colon((Object)Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L)), (List)Nil$.MODULE$));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    public Seq<Literal> initialValues() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.initialValues$lzycompute();
        }
        return this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.updateExpressions = this.ignoreNulls() ? new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.count()).$eq$eq$eq(package$expressions$.MODULE$.longToLiteral(this.offsetVal())))).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.input()).isNotNull()))), this.input(), this.result()), (List)new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.input()).isNull()), this.count(), package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L))), (List)Nil$.MODULE$)) : new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.count()).$eq$eq$eq(package$expressions$.MODULE$.longToLiteral(this.offsetVal()))), this.input(), this.result()), (List)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L)), (List)Nil$.MODULE$));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.updateExpressions$lzycompute();
        }
        return this.updateExpressions;
    }

    private AttributeReference evaluateExpression$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.evaluateExpression = this.result();
                this.bitmap$0 |= 0x80;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public AttributeReference evaluateExpression() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.evaluateExpression$lzycompute();
        }
        return this.evaluateExpression;
    }

    @Override
    public String prettyName() {
        return "nth_value";
    }

    @Override
    public String sql() {
        return this.prettyName() + "(" + this.input().sql() + ", " + this.offset().sql() + ")" + (this.ignoreNulls() ? " ignore nulls" : "");
    }

    @Override
    public NthValue withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public NthValue copy(Expression input, Expression offset, boolean ignoreNulls) {
        return new NthValue(input, offset, ignoreNulls);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.offset();
    }

    public boolean copy$default$3() {
        return this.ignoreNulls();
    }

    @Override
    public String productPrefix() {
        return "NthValue";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.input();
            }
            case 1: {
                return this.offset();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.ignoreNulls());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NthValue;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "input";
            }
            case 1: {
                return "offset";
            }
            case 2: {
                return "ignoreNulls";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NthValue)) return false;
        boolean bl = true;
        if (!bl) return false;
        NthValue nthValue = (NthValue)x$1;
        if (this.ignoreNulls() != nthValue.ignoreNulls()) return false;
        Expression expression = this.input();
        Expression expression2 = nthValue.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.offset();
        Expression expression4 = nthValue.offset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!nthValue.canEqual(this)) return false;
        return true;
    }

    public NthValue(Expression input, Expression offset, boolean ignoreNulls) {
        this.input = input;
        this.offset = offset;
        this.ignoreNulls = ignoreNulls;
        OffsetWindowFunction.$init$(this);
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.frame = UnspecifiedFrame$.MODULE$;
    }

    public NthValue(Expression input, Expression offset, Expression ignoreNulls) {
        this(input, offset, WindowExpression$.MODULE$.expressionToIngnoreNulls(ignoreNulls, "nth_value"));
    }

    public NthValue(Expression child, Expression offset) {
        this(child, offset, false);
    }
}

