/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual$;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is greater than or equal to `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       true\n      > SELECT 2.0 _FUNC_ '2.1';\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       false\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001\u0002\u000f\u001e\u0001*B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005I\u0001\tE\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015i\u0006\u0001\"\u0015_\u0011\u00151\u0007\u0001\"\u0015h\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u001dq\u0007!!A\u0005\u0002=DqA\u001d\u0001\u0012\u0002\u0013\u00051\u000fC\u0004\u007f\u0001E\u0005I\u0011A:\t\u0011}\u0004\u0011\u0011!C!\u0003\u0003A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0001\"CA\u0012\u0001\u0005\u0005I\u0011IA\u0013\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002:\u0001\t\t\u0011\"\u0011\u0002<!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0013\u0011I\u0004\n\u0003Wj\u0012\u0011!E\u0001\u0003[2\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011q\u000e\u0005\u0007\u0013Z!\t!a\"\t\u0013\u0005%e#!A\u0005F\u0005-\u0005\"CAG-\u0005\u0005I\u0011QAH\u0011%\t)JFA\u0001\n\u0003\u000b9\nC\u0005\u0002*Z\t\t\u0011\"\u0003\u0002,\n\u0011rI]3bi\u0016\u0014H\u000b[1o\u001fJ,\u0015/^1m\u0015\tqr$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0011\"\u0003!\u0019\u0017\r^1msN$(B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u00011\u0003\u0002\u0001,_U\u0002\"\u0001L\u0017\u000e\u0003uI!AL\u000f\u0003!\tKg.\u0019:z\u0007>l\u0007/\u0019:jg>t\u0007C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$a\u0002)s_\u0012,8\r\u001e\t\u0003myr!a\u000e\u001f\u000f\u0005aZT\"A\u001d\u000b\u0005iJ\u0013A\u0002\u001fs_>$h(C\u00013\u0013\ti\u0014'A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0002%\u0001D*fe&\fG.\u001b>bE2,'BA\u001f2\u0003\u0011aWM\u001a;\u0016\u0003\r\u0003\"\u0001\f#\n\u0005\u0015k\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDcA&M\u001bB\u0011A\u0006\u0001\u0005\u0006\u0003\u0016\u0001\ra\u0011\u0005\u0006\u000f\u0016\u0001\raQ\u0001\u000f]VdG.\u00138u_2,'/\u00198u+\u0005\u0001\u0006C\u0001\u0019R\u0013\t\u0011\u0016GA\u0004C_>dW-\u00198\u0002\rMLXNY8m+\u0005)\u0006C\u0001,[\u001d\t9\u0006\f\u0005\u00029c%\u0011\u0011,M\u0001\u0007!J,G-\u001a4\n\u0005mc&AB*ue&twM\u0003\u0002Zc\u0005aa.\u001e7m'\u00064W-\u0012<bYR\u0019qL\u00193\u0011\u0005A\u0002\u0017BA12\u0005\r\te.\u001f\u0005\u0006G\"\u0001\raX\u0001\u0007S:\u0004X\u000f^\u0019\t\u000b\u0015D\u0001\u0019A0\u0002\r%t\u0007/\u001e;3\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002LQ*DQ![\u0005A\u0002\r\u000bqA\\3x\u0019\u00164G\u000fC\u0003l\u0013\u0001\u00071)\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003=\u0011XM^3sg\u0016|\u0005/\u001a:b]\u0012\u001cH#A\u0016\u0002\t\r|\u0007/\u001f\u000b\u0004\u0017B\f\bbB!\f!\u0003\u0005\ra\u0011\u0005\b\u000f.\u0001\n\u00111\u0001D\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001e\u0016\u0003\u0007V\\\u0013A\u001e\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005m\f\u0014AC1o]>$\u0018\r^5p]&\u0011Q\u0010\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u000e\u0005!!.\u0019<b\u0013\rY\u0016qA\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003+\u00012\u0001MA\f\u0013\r\tI\"\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004?\u0006}\u0001\"CA\u0011!\u0005\u0005\t\u0019AA\u000b\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0005\t\u0006\u0003S\tycX\u0007\u0003\u0003WQ1!!\f2\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003c\tYC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001)\u00028!A\u0011\u0011\u0005\n\u0002\u0002\u0003\u0007q,\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u0002\u0003{A\u0011\"!\t\u0014\u0003\u0003\u0005\r!!\u0006\u0002\r\u0015\fX/\u00197t)\r\u0001\u00161\t\u0005\t\u0003C!\u0012\u0011!a\u0001?\":\u0002!a\u0012\u0002N\u0005=\u00131KA+\u00033\nY&a\u0018\u0002b\u0005\u0015\u0014q\r\t\u0004Y\u0005%\u0013bAA&;\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA)\u0003E+\u0007\u0010\u001d:2A}3UKT\"`A\u0015D\bO\u001d\u001a![\u0001\u0012V\r^;s]N\u0004CO];fA%4\u0007\u0005Y3yaJ\f\u0004\rI5tA\u001d\u0014X-\u0019;fe\u0002\"\b.\u00198!_J\u0004S-];bY\u0002\"x\u000e\t1fqB\u0014(\u0007\u0019\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA,\u0003\tM%\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011fqB\u0014\u0018\u0007\f\u0011fqB\u0014(\u0007I\u0017!i\",\u0007\u0005^<pA\u0015D\bO]3tg&|gn\u001d\u0011nkN$\bEY3!g\u0006lW\r\t;za\u0016\u0004sN\u001d\u0011dC:\u0004#-\u001a\u0011dCN$X\r\u001a\u0011u_\u0002\n\u0007eY8n[>t\u0007\u0005^=qK2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011b]\u0012\u0004S.^:uA\t,\u0007%\u0019\u0011usB,\u0007\u0005\u001e5bi\u0002\u001a\u0017M\u001c\u0011cK\u0002z'\u000fZ3sK\u0012t\u0003ER8sA\u0015D\u0018-\u001c9mK2\u0002S.\u00199!if\u0004X\rI5tA9|G\u000fI8sI\u0016\u0014\u0018M\u00197fY\u0001\u001ax\u000eI5u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%[:!]>$\be];qa>\u0014H/\u001a3/A\u0019{'\u000fI2p[BdW\r\u001f\u0011usB,7\u000fI:vG\"\u0004\u0013M\u001d:bs>\u001aHO];di2\u0002C\u000f[3!I\u0006$\u0018\r\t;za\u0016\u001c\be\u001c4!M&,G\u000eZ:![V\u001cHO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\t,\u0007e\u001c:eKJ\f'\r\\3/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0013Aa*\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAI\u0002sLR+O\u0007~\u0003\u0013g\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t\u001a/a\u0001zf)\u0016(D?\u0002:#GL\u0019(w)\u0001\u0003\u0005\t\u0011!A\u00012\u0017\r\\:f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\"xn\u00183bi\u0016DsE\r\u00191s5\u0002t'L\u001a1AA\"$(M\u001c;kI:\u0013\u0006I0G+:\u001bu\f\t;p?\u0012\fG/\u001a\u0015(eA\u0002\u0014(\f\u00198[M\u0002\u0004\u0005\r\u001b;c]RTGM\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAQ|w\fZ1uK\":#\u0007\r\u0019:[A:Tf\r\u0019!aQR\u0014g\u000e\u001e6e\u001dJ\u0003e\u0018$V\u001d\u000e{\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006\r\u001d.aE\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0019\fGn]3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAE\u0002sLR+O\u0007~\u0003c*\u0016'Mw)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\nQa]5oG\u0016\f#!a\u0019\u0002\u000bEr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005%\u0014a\u00049sK\u0012L7-\u0019;f?\u001a,hnY:\u0002%\u001d\u0013X-\u0019;feRC\u0017M\\(s\u000bF,\u0018\r\u001c\t\u0003YY\u0019RAFA9\u0003{\u0002r!a\u001d\u0002z\r\u001b5*\u0004\u0002\u0002v)\u0019\u0011qO\u0019\u0002\u000fI,h\u000e^5nK&!\u00111PA;\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*!\u00111QA\u0006\u0003\tIw.C\u0002@\u0003\u0003#\"!!\u001c\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0001\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b-\u000b\t*a%\t\u000b\u0005K\u0002\u0019A\"\t\u000b\u001dK\u0002\u0019A\"\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011TAS!\u0015\u0001\u00141TAP\u0013\r\ti*\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bA\n\tkQ\"\n\u0007\u0005\r\u0016G\u0001\u0004UkBdWM\r\u0005\t\u0003OS\u0012\u0011!a\u0001\u0017\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u00055\u0006\u0003BA\u0003\u0003_KA!!-\u0002\b\t1qJ\u00196fGR\u0004")
public class GreaterThanOrEqual
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(GreaterThanOrEqual x$0) {
        return GreaterThanOrEqual$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, GreaterThanOrEqual> tupled() {
        return GreaterThanOrEqual$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GreaterThanOrEqual>> curried() {
        return GreaterThanOrEqual$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public String symbol() {
        return ">=";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().gteq(input1, input2));
    }

    @Override
    public GreaterThanOrEqual withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public BinaryComparison reverseOperands() {
        return new LessThanOrEqual(this.right(), this.left());
    }

    public GreaterThanOrEqual copy(Expression left, Expression right) {
        return new GreaterThanOrEqual(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "GreaterThanOrEqual";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GreaterThanOrEqual;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GreaterThanOrEqual)) return false;
        boolean bl = true;
        if (!bl) return false;
        GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)x$1;
        Expression expression = this.left();
        Expression expression2 = greaterThanOrEqual.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = greaterThanOrEqual.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!greaterThanOrEqual.canEqual(this)) return false;
        return true;
    }

    public GreaterThanOrEqual(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

