/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualTo$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` equals `expr2`, or false otherwise.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       NULL\n      > SELECT NULL _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u000f\u001f\u0001.B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\"A\u0001\n\u0001BK\u0002\u0013\u00051\t\u0003\u0005J\u0001\tE\t\u0015!\u0003E\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015q\u0006\u0001\"\u0015`\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015!\b\u0001\"\u0015v\u0011\u0015Q\b\u0001\"\u0001|\u0011\u001da\b!!A\u0005\u0002uD\u0011\"!\u0001\u0001#\u0003%\t!a\u0001\t\u0013\u0005e\u0001!%A\u0005\u0002\u0005\r\u0001\"CA\u000e\u0001\u0005\u0005I\u0011IA\u000f\u0011%\ti\u0003AA\u0001\n\u0003\ty\u0003C\u0005\u00028\u0001\t\t\u0011\"\u0001\u0002:!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0013\u0011\t\u0005\n\u0003\u001f\u0002\u0011\u0011!C\u0001\u0003#B\u0011\"!\u0016\u0001\u0003\u0003%\t%a\u0016\t\u0013\u0005m\u0003!!A\u0005B\u0005us!CAD=\u0005\u0005\t\u0012AAE\r!ib$!A\t\u0002\u0005-\u0005B\u0002&\u0018\t\u0003\t\u0019\u000bC\u0005\u0002&^\t\t\u0011\"\u0012\u0002(\"I\u0011\u0011V\f\u0002\u0002\u0013\u0005\u00151\u0016\u0005\n\u0003c;\u0012\u0011!CA\u0003gC\u0011\"!2\u0018\u0003\u0003%I!a2\u0003\u000f\u0015\u000bX/\u00197U_*\u0011q\u0004I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\"E\u0005A1-\u0019;bYf\u001cHO\u0003\u0002$I\u0005\u00191/\u001d7\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001YA2\u0004CA\u0017/\u001b\u0005q\u0012BA\u0018\u001f\u0005A\u0011\u0015N\\1ss\u000e{W\u000e]1sSN|g\u000e\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$GA\u0004Qe>$Wo\u0019;\u0011\u0005]zdB\u0001\u001d>\u001d\tID(D\u0001;\u0015\tY$&\u0001\u0004=e>|GOP\u0005\u0002g%\u0011aHM\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0015I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002?e\u0005!A.\u001a4u+\u0005!\u0005CA\u0017F\u0013\t1eD\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002M\u001b:\u0003\"!\f\u0001\t\u000b\t+\u0001\u0019\u0001#\t\u000b!+\u0001\u0019\u0001#\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\t\u0011\u000b\u0005\u00022%&\u00111K\r\u0002\b\u0005>|G.Z1o\u0003\u0019\u0019\u00180\u001c2pYV\ta\u000b\u0005\u0002X7:\u0011\u0001,\u0017\t\u0003sIJ!A\u0017\u001a\u0002\rA\u0013X\rZ3g\u0013\taVL\u0001\u0004TiJLgn\u001a\u0006\u00035J\nAB\\;mYN\u000bg-Z#wC2$2\u0001Y2e!\t\t\u0014-\u0003\u0002ce\t\u0019\u0011I\\=\t\u000b\tC\u0001\u0019\u00011\t\u000b!C\u0001\u0019\u00011\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA4neB\u0011\u0001n[\u0007\u0002S*\u0011!NH\u0001\bG>$WmZ3o\u0013\ta\u0017N\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015q\u0017\u00021\u0001p\u0003\r\u0019G\u000f\u001f\t\u0003QBL!!]5\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")1/\u0003a\u0001O\u0006\u0011QM^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2\u0001\u0014<y\u0011\u00159(\u00021\u0001E\u0003\u001dqWm\u001e'fMRDQ!\u001f\u0006A\u0002\u0011\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0010e\u00164XM]:f\u001fB,'/\u00198egR\tA&\u0001\u0003d_BLHc\u0001'\u007f\u007f\"9!\t\u0004I\u0001\u0002\u0004!\u0005b\u0002%\r!\u0003\u0005\r\u0001R\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)AK\u0002E\u0003\u000fY#!!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003'\u0011\u0014AC1o]>$\u0018\r^5p]&!\u0011qCA\u0007\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0004\t\u0005\u0003C\tY#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0012\u0001\u00026bm\u0006L1\u0001XA\u0012\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u0004E\u00022\u0003gI1!!\u000e3\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\u0001\u00171\b\u0005\n\u0003{\t\u0012\u0011!a\u0001\u0003c\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\"!\u0015\t)%a\u0013a\u001b\t\t9EC\u0002\u0002JI\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti%a\u0012\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004#\u0006M\u0003\u0002CA\u001f'\u0005\u0005\t\u0019\u00011\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003?\tI\u0006C\u0005\u0002>Q\t\t\u00111\u0001\u00022\u00051Q-];bYN$2!UA0\u0011!\ti$FA\u0001\u0002\u0004\u0001\u0007f\u0006\u0001\u0002d\u0005%\u00141NA8\u0003c\n)(a\u001e\u0002|\u0005u\u0014\u0011QAB!\ri\u0013QM\u0005\u0004\u0003Or\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003[\n\u0001+\u001a=qeF\u0002sLR+O\u0007~\u0003S\r\u001f9se\u0001j\u0003EU3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011aKb\u0004(/\r1!KF,\u0018\r\\:!A\u0016D\bO\u001d\u001aaY\u0001z'\u000f\t4bYN,\u0007e\u001c;iKJ<\u0018n]3/\u0003%\t'oZ;nK:$8/\t\u0002\u0002t\u0005\u0011iF\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Kb\u0004(/\r\u0017!Kb\u0004(O\r\u0011.AQDW\r\t;x_\u0002*\u0007\u0010\u001d:fgNLwN\\:![V\u001cH\u000f\t2fAM\fW.\u001a\u0011usB,\u0007e\u001c:!G\u0006t\u0007EY3!G\u0006\u001cH/\u001a3!i>\u0004\u0013\rI2p[6|g\u000e\t;za\u0016d#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!C:$\u0007%\\;ti\u0002\u0012W\rI1!if\u0004X\r\t;iCR\u00043-\u00198!E\u0016\u0004So]3eA%t\u0007%Z9vC2LG/\u001f\u0011d_6\u0004\u0018M]5t_:t\u0003%T1qAQL\b/\u001a\u0011jg\u0002rw\u000e\u001e\u0011tkB\u0004xN\u001d;fI:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011G_J\u00043m\\7qY\u0016D\b\u0005^=qKN\u00043/^2iA\u0005\u0014(/Y=0gR\u0014Xo\u0019;-AQDW\r\t3bi\u0006\u0004C/\u001f9fg\u0002zg\r\t4jK2$7\u000fI7vgR\u0004#-\u001a\u0011pe\u0012,'/\u00192mK:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011P\u0001\u0002x)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003#\u0007I0G+:\u001bu\f\t\u001a<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!c\u0001zf)\u0016(D?\u0002:\u0013gJ\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011ueV,\u0007e\u0018$V\u001d\u000e{\u0006ET+M\u0019nR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002rU\u000b\u0014'!?\u001a+fjQ0!\u001dVcEj\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005}\u0014!B\u0019/a9\u0002\u0014!B4s_V\u0004\u0018EAAC\u0003=\u0001(/\u001a3jG\u0006$Xm\u00184v]\u000e\u001c\u0018aB#rk\u0006dGk\u001c\t\u0003[]\u0019RaFAG\u00033\u0003r!a$\u0002\u0016\u0012#E*\u0004\u0002\u0002\u0012*\u0019\u00111\u0013\u001a\u0002\u000fI,h\u000e^5nK&!\u0011qSAI\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*!\u0011qTA\u0014\u0003\tIw.C\u0002A\u0003;#\"!!#\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b1\u000bi+a,\t\u000b\tS\u0002\u0019\u0001#\t\u000b!S\u0002\u0019\u0001#\u0002\u000fUt\u0017\r\u001d9msR!\u0011QWAa!\u0015\t\u0014qWA^\u0013\r\tIL\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bE\ni\f\u0012#\n\u0007\u0005}&G\u0001\u0004UkBdWM\r\u0005\t\u0003\u0007\\\u0012\u0011!a\u0001\u0019\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005%\u0007\u0003BA\u0011\u0003\u0017LA!!4\u0002$\t1qJ\u00196fGR\u0004")
public class EqualTo
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualTo x$0) {
        return EqualTo$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualTo> tupled() {
        return EqualTo$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualTo>> curried() {
        return EqualTo$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public String symbol() {
        return "=";
    }

    @Override
    public Object nullSafeEval(Object left, Object right) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(left, right));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(c1, c2) -> ctx.genEqual(this.left().dataType(), (String)c1, (String)c2));
    }

    @Override
    public EqualTo withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public BinaryComparison reverseOperands() {
        return this;
    }

    public EqualTo copy(Expression left, Expression right) {
        return new EqualTo(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualTo";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualTo;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualTo)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualTo equalTo = (EqualTo)x$1;
        Expression expression = this.left();
        Expression expression2 = equalTo.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalTo.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalTo.canEqual(this)) return false;
        return true;
    }

    public EqualTo(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

