/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.ArrayTransform;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CheckOverflowInTableInsert;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetStructField$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays;
import org.apache.spark.sql.catalyst.expressions.MapKeys;
import org.apache.spark.sql.catalyst.expressions.MapValues;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.expressions.UnwrapUDT;
import org.apache.spark.sql.catalyst.expressions.VariableReference;
import org.apache.spark.sql.catalyst.expressions.objects.AssertNotNull;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$StoreAssignmentPolicy$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

public final class TableOutputResolver$
implements SQLConfHelper,
Logging {
    public static final TableOutputResolver$ MODULE$ = new TableOutputResolver$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        SQLConfHelper.$init$(MODULE$);
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public LogicalPlan resolveVariableOutputColumns(Seq<VariableReference> expected, LogicalPlan query, SQLConf conf) {
        Seq resolved2;
        if (expected.size() != query.output().size()) {
            throw new AnalysisException("ASSIGNMENT_ARITY_MISMATCH", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTarget"), (Object)Integer.toString(expected.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numExpr"), (Object)Integer.toString(query.output().size()))})));
        }
        Seq seq = resolved2 = (Seq)((IterableOps)query.output().zip(expected)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Cast cast;
                Attribute inputCol = (Attribute)tuple2._1();
                VariableReference expected = (VariableReference)tuple2._2();
                if (DataTypeUtils$.MODULE$.sameType(inputCol.dataType(), expected.dataType())) {
                    return inputCol;
                }
                Cast x$1 = cast = Cast$.MODULE$.apply((Expression)inputCol, expected.dataType(), (Option<String>)Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone()), true);
                String x$2 = expected.identifier().name();
                ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
            }
            throw new MatchError((Object)tuple2);
        });
        Seq<Attribute> seq2 = query.output();
        if (!(seq != null ? !seq.equals(seq2) : seq2 != null)) {
            return query;
        }
        return new Project((Seq<NamedExpression>)resolved2, query);
    }

    public LogicalPlan resolveOutputColumns(String tableName, Seq<Attribute> expected, LogicalPlan query, boolean byName, SQLConf conf, boolean supportColDefaultValue) {
        Seq<NamedExpression> resolved2;
        if (expected.size() < query.output().size()) {
            throw QueryCompilationErrors$.MODULE$.cannotWriteTooManyColumnsToTableError(tableName, (Seq<String>)((Seq)expected.map((Function1 & Serializable)x$1 -> x$1.name())), query.output());
        }
        ArrayBuffer errors = new ArrayBuffer();
        if (byName) {
            String x$12 = tableName;
            Seq<Attribute> x$22 = query.output();
            Seq<Attribute> x$32 = expected;
            SQLConf x$42 = conf;
            Function1 & Serializable x$52 = (Function1 & Serializable)x$2 -> {
                errors.$plus$eq((Object)x$2);
                return BoxedUnit.UNIT;
            };
            boolean x$6 = supportColDefaultValue;
            Seq<String> x$7 = this.reorderColumnsByName$default$6();
            v0 = this.reorderColumnsByName(x$12, x$22, x$32, x$42, (Function1<String, BoxedUnit>)x$52, x$7, x$6);
        } else {
            if (expected.size() > query.output().size()) {
                throw QueryCompilationErrors$.MODULE$.cannotWriteNotEnoughColumnsToTableError(tableName, (Seq<String>)((Seq)expected.map((Function1 & Serializable)x$3 -> x$3.name())), query.output());
            }
            v0 = resolved2 = this.resolveColumnsByPosition(tableName, query.output(), expected, conf, (Function1<String, BoxedUnit>)(Function1 & Serializable)x$4 -> {
                errors.$plus$eq((Object)x$4);
                return BoxedUnit.UNIT;
            }, this.resolveColumnsByPosition$default$6());
        }
        if (errors.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableCannotFindDataError(tableName, ((IterableOnceOps)((IterableOps)expected.map((Function1 & Serializable)x$5 -> x$5.name())).map((Function1 & Serializable)parts -> TypeUtils$.MODULE$.toSQLId((String)parts))).mkString(", "));
        }
        Seq<NamedExpression> seq = resolved2;
        Seq<Attribute> seq2 = query.output();
        if (!(seq != null ? !seq.equals(seq2) : seq2 != null)) {
            return query;
        }
        return new Project(resolved2, query);
    }

    public boolean resolveOutputColumns$default$6() {
        return false;
    }

    public Expression resolveUpdate(String tableName, Expression value, Attribute col, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        DataType colType;
        DataType valueType;
        Tuple2 tuple2 = new Tuple2((Object)value.dataType(), (Object)col.dataType());
        if (tuple2 != null && DataType$.MODULE$.equalsIgnoreCompatibleNullability(valueType = (DataType)tuple2._1(), colType = (DataType)tuple2._2())) {
            boolean canWriteExpr = this.canWrite(tableName, valueType, colType, true, conf, addError, colPath);
            if (canWriteExpr) {
                return this.checkNullability(value, col, conf, colPath);
            }
            return value;
        }
        if (tuple2 != null) {
            DataType valueType2 = (DataType)tuple2._1();
            DataType colType2 = (DataType)tuple2._2();
            if (valueType2 instanceof StructType) {
                StructType structType = (StructType)valueType2;
                if (colType2 instanceof StructType) {
                    StructType structType2 = (StructType)colType2;
                    Option<NamedExpression> resolvedValue = this.resolveStructType(tableName, value, structType, col, structType2, true, conf, addError, colPath);
                    return (Expression)resolvedValue.getOrElse((Function0 & Serializable)() -> value);
                }
            }
        }
        if (tuple2 != null) {
            DataType valueType3 = (DataType)tuple2._1();
            DataType colType3 = (DataType)tuple2._2();
            if (valueType3 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)valueType3;
                if (colType3 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)colType3;
                    Option<NamedExpression> resolvedValue = this.resolveArrayType(tableName, value, arrayType, col, arrayType2, true, conf, addError, colPath);
                    return (Expression)resolvedValue.getOrElse((Function0 & Serializable)() -> value);
                }
            }
        }
        if (tuple2 != null) {
            DataType valueType4 = (DataType)tuple2._1();
            DataType colType4 = (DataType)tuple2._2();
            if (valueType4 instanceof MapType) {
                MapType mapType = (MapType)valueType4;
                if (colType4 instanceof MapType) {
                    MapType mapType2 = (MapType)colType4;
                    Option<NamedExpression> resolvedValue = this.resolveMapType(tableName, value, mapType, col, mapType2, true, conf, addError, colPath);
                    return (Expression)resolvedValue.getOrElse((Function0 & Serializable)() -> value);
                }
            }
        }
        return this.checkUpdate(tableName, value, col, conf, addError, colPath);
    }

    private Expression checkUpdate(String tableName, Expression value, Attribute attr, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        boolean attrTypeHasCharVarchar = CharVarcharUtils$.MODULE$.hasCharVarchar(attr.dataType());
        DataType attrTypeWithoutCharVarchar = attrTypeHasCharVarchar ? CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(attr.dataType()) : attr.dataType();
        boolean canWriteValue = this.canWrite(tableName, value.dataType(), attrTypeWithoutCharVarchar, true, conf, addError, colPath);
        if (canWriteValue) {
            Expression exprWithStrLenCheck;
            Expression nullCheckedValue = this.checkNullability(value, attr, conf, colPath);
            Expression casted = this.cast(nullCheckedValue, attrTypeWithoutCharVarchar, conf, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted());
            Expression x$1 = exprWithStrLenCheck = conf.charVarcharAsString() || !attrTypeHasCharVarchar ? casted : CharVarcharUtils$.MODULE$.stringLengthCheck(casted, attr.dataType());
            String x$2 = attr.name();
            Some x$3 = new Some((Object)attr.metadata());
            ExprId x$4 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq<String> x$5 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            return new Alias(x$1, x$2, x$4, x$5, (Option<Metadata>)x$3, x$6);
        }
        return value;
    }

    private boolean canWrite(String tableName, DataType valueType, DataType expectedType, boolean byName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        boolean bl;
        Enumeration.Value value = conf.storeAssignmentPolicy();
        Enumeration.Value value2 = SQLConf$StoreAssignmentPolicy$.MODULE$.STRICT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
            Enumeration.Value value5 = value;
            bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        if (bl) {
            return DataTypeUtils$.MODULE$.canWrite(tableName, valueType, expectedType, byName, conf.resolver(), CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted(), conf.storeAssignmentPolicy(), addError);
        }
        return true;
    }

    private Seq<NamedExpression> reorderColumnsByName(String tableName, Seq<NamedExpression> inputCols, Seq<Attribute> expectedCols, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath, boolean fillDefaultValue) {
        HashSet matchedCols = HashSet$.MODULE$.empty();
        Seq reordered = (Seq)expectedCols.flatMap((Function1 & Serializable)expectedCol -> {
            NamedExpression namedExpression;
            Seq matched = (Seq)inputCols.filter((Function1 & Serializable)col -> BoxesRunTime.boxToBoolean((boolean)TableOutputResolver$.$anonfun$reorderColumnsByName$2(conf, expectedCol, col)));
            Seq newColPath = (Seq)colPath.$colon$plus((Object)expectedCol.name());
            if (matched.isEmpty()) {
                Option<NamedExpression> defaultExpr;
                Option<NamedExpression> option = defaultExpr = fillDefaultValue ? ResolveDefaultColumns$.MODULE$.getDefaultValueExprOrNullLit((Attribute)expectedCol, conf.useNullsForMissingDefaultColumnValues()) : None$.MODULE$;
                if (defaultExpr.isEmpty()) {
                    throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableCannotFindDataError(tableName, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper((Seq<String>)newColPath).quoted());
                }
                return defaultExpr;
            }
            if (matched.length() > 1) {
                throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableAmbiguousColumnNameError(tableName, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper((Seq<String>)newColPath).quoted());
            }
            matchedCols.$plus$eq((Object)((NamedExpression)matched.head()).name());
            String expectedName = expectedCol.name();
            NamedExpression namedExpression2 = (NamedExpression)matched.head();
            if (namedExpression2 instanceof Attribute) {
                Attribute attribute = (Attribute)namedExpression2;
                namedExpression = attribute.withName(expectedName);
            } else if (namedExpression2 instanceof Alias) {
                Alias alias = (Alias)namedExpression2;
                namedExpression = alias.withName(expectedName);
            } else {
                namedExpression = namedExpression2;
            }
            NamedExpression matchedCol = namedExpression;
            Attribute actualExpectedCol = expectedCol.withDataType((DataType)CharVarcharUtils$.MODULE$.getRawType(expectedCol.metadata()).getOrElse((Function0 & Serializable)() -> expectedCol.dataType()));
            Tuple2 tuple2 = new Tuple2((Object)((Expression)((Object)matchedCol)).dataType(), (Object)actualExpectedCol.dataType());
            if (tuple2 != null) {
                DataType matchedType = (DataType)tuple2._1();
                DataType expectedType = (DataType)tuple2._2();
                if (matchedType instanceof StructType) {
                    StructType structType = (StructType)matchedType;
                    if (expectedType instanceof StructType) {
                        StructType structType2 = (StructType)expectedType;
                        return MODULE$.resolveStructType(tableName, (Expression)((Object)matchedCol), structType, actualExpectedCol, structType2, true, conf, addError, (Seq<String>)newColPath);
                    }
                }
            }
            if (tuple2 != null) {
                DataType matchedType = (DataType)tuple2._1();
                DataType expectedType = (DataType)tuple2._2();
                if (matchedType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)matchedType;
                    if (expectedType instanceof ArrayType) {
                        ArrayType arrayType2 = (ArrayType)expectedType;
                        return MODULE$.resolveArrayType(tableName, (Expression)((Object)matchedCol), arrayType, actualExpectedCol, arrayType2, true, conf, addError, (Seq<String>)newColPath);
                    }
                }
            }
            if (tuple2 != null) {
                DataType matchedType = (DataType)tuple2._1();
                DataType expectedType = (DataType)tuple2._2();
                if (matchedType instanceof MapType) {
                    MapType mapType = (MapType)matchedType;
                    if (expectedType instanceof MapType) {
                        MapType mapType2 = (MapType)expectedType;
                        return MODULE$.resolveMapType(tableName, (Expression)((Object)matchedCol), mapType, actualExpectedCol, mapType2, true, conf, addError, (Seq<String>)newColPath);
                    }
                }
            }
            return MODULE$.checkField(tableName, actualExpectedCol, matchedCol, true, conf, addError, (Seq<String>)newColPath);
        });
        if (reordered.length() == expectedCols.length()) {
            if (matchedCols.size() < inputCols.length()) {
                String extraCols = ((IterableOnceOps)((IterableOps)inputCols.filterNot((Function1 & Serializable)col -> BoxesRunTime.boxToBoolean((boolean)matchedCols.contains((Object)col.name())))).map((Function1 & Serializable)col -> String.valueOf(TypeUtils$.MODULE$.toSQLId(col.name())))).mkString(", ");
                if (colPath.isEmpty()) {
                    throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableExtraColumnsError(tableName, extraCols);
                }
                throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableExtraStructFieldsError(tableName, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted(), extraCols);
            }
            return reordered;
        }
        return Nil$.MODULE$;
    }

    private Seq<String> reorderColumnsByName$default$6() {
        return Nil$.MODULE$;
    }

    private boolean reorderColumnsByName$default$7() {
        return false;
    }

    private Seq<NamedExpression> resolveColumnsByPosition(String tableName, Seq<NamedExpression> inputCols, Seq<Attribute> expectedCols, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        Seq actualExpectedCols = (Seq)expectedCols.map((Function1 & Serializable)attr -> attr.withDataType((DataType)CharVarcharUtils$.MODULE$.getRawType(attr.metadata()).getOrElse((Function0 & Serializable)() -> attr.dataType())));
        if (inputCols.size() > actualExpectedCols.size()) {
            String extraColsStr = ((IterableOnceOps)((IterableOps)inputCols.takeRight(inputCols.size() - actualExpectedCols.size())).map((Function1 & Serializable)col -> TypeUtils$.MODULE$.toSQLId(col.name()))).mkString(", ");
            if (colPath.isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.cannotWriteTooManyColumnsToTableError(tableName, (Seq<String>)((Seq)actualExpectedCols.map((Function1 & Serializable)x$6 -> x$6.name())), (Seq<Attribute>)((Seq)inputCols.map((Function1 & Serializable)x$7 -> x$7.toAttribute())));
            }
            throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableExtraStructFieldsError(tableName, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted(), extraColsStr);
        }
        if (inputCols.size() < actualExpectedCols.size()) {
            String missingColsStr = ((IterableOnceOps)((IterableOps)actualExpectedCols.takeRight(actualExpectedCols.size() - inputCols.size())).map((Function1 & Serializable)col -> TypeUtils$.MODULE$.toSQLId(col.name()))).mkString(", ");
            if (colPath.isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.cannotWriteNotEnoughColumnsToTableError(tableName, (Seq<String>)((Seq)actualExpectedCols.map((Function1 & Serializable)x$8 -> x$8.name())), (Seq<Attribute>)((Seq)inputCols.map((Function1 & Serializable)x$9 -> x$9.toAttribute())));
            }
            throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableStructMissingFieldsError(tableName, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted(), missingColsStr);
        }
        return (Seq)((IterableOps)inputCols.zip((IterableOnce)actualExpectedCols)).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                NamedExpression inputCol = (NamedExpression)tuple2._1();
                Attribute expectedCol = (Attribute)tuple2._2();
                Seq newColPath = (Seq)colPath.$colon$plus((Object)expectedCol.name());
                Tuple2 tuple22 = new Tuple2((Object)((Expression)((Object)inputCol)).dataType(), (Object)expectedCol.dataType());
                if (tuple22 != null) {
                    DataType inputType = (DataType)tuple22._1();
                    DataType expectedType = (DataType)tuple22._2();
                    if (inputType instanceof StructType) {
                        StructType structType = (StructType)inputType;
                        if (expectedType instanceof StructType) {
                            StructType structType2 = (StructType)expectedType;
                            return MODULE$.resolveStructType(tableName, (Expression)((Object)inputCol), structType, expectedCol, structType2, false, conf, addError, (Seq<String>)newColPath);
                        }
                    }
                }
                if (tuple22 != null) {
                    DataType inputType = (DataType)tuple22._1();
                    DataType expectedType = (DataType)tuple22._2();
                    if (inputType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)inputType;
                        if (expectedType instanceof ArrayType) {
                            ArrayType arrayType2 = (ArrayType)expectedType;
                            return MODULE$.resolveArrayType(tableName, (Expression)((Object)inputCol), arrayType, expectedCol, arrayType2, false, conf, addError, (Seq<String>)newColPath);
                        }
                    }
                }
                if (tuple22 != null) {
                    DataType inputType = (DataType)tuple22._1();
                    DataType expectedType = (DataType)tuple22._2();
                    if (inputType instanceof MapType) {
                        MapType mapType = (MapType)inputType;
                        if (expectedType instanceof MapType) {
                            MapType mapType2 = (MapType)expectedType;
                            return MODULE$.resolveMapType(tableName, (Expression)((Object)inputCol), mapType, expectedCol, mapType2, false, conf, addError, (Seq<String>)newColPath);
                        }
                    }
                }
                return MODULE$.checkField(tableName, expectedCol, inputCol, false, conf, addError, (Seq<String>)newColPath);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Seq<String> resolveColumnsByPosition$default$6() {
        return Nil$.MODULE$;
    }

    public Expression checkNullability(Expression input, Attribute expected, SQLConf conf, Seq<String> colPath) {
        if (this.requiresNullChecks(input, expected, conf)) {
            return new AssertNotNull(input, colPath);
        }
        return input;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean requiresNullChecks(Expression input, Attribute attr, SQLConf conf) {
        if (!input.nullable()) return false;
        if (attr.nullable()) return false;
        Enumeration.Value value = conf.storeAssignmentPolicy();
        Enumeration.Value value2 = SQLConf$StoreAssignmentPolicy$.MODULE$.LEGACY();
        if (value == null) {
            if (value2 == null) return false;
            return true;
        } else if (value.equals(value2)) return false;
        return true;
    }

    private Option<NamedExpression> resolveStructType(String tableName, Expression input, StructType inputType, Attribute expected, StructType expectedType, boolean byName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        Seq<NamedExpression> resolved2;
        Expression nullCheckedInput = this.checkNullability(input, expected, conf, colPath);
        Seq fields = (Seq)((IterableOps)inputType.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField f = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                GetStructField x$1 = new GetStructField(nullCheckedInput, i, (Option<String>)new Some((Object)f.name()));
                String x$2 = f.name();
                ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
            }
            throw new MatchError((Object)tuple2);
        });
        Seq<NamedExpression> seq = resolved2 = byName ? this.reorderColumnsByName(tableName, (Seq<NamedExpression>)fields, DataTypeUtils$.MODULE$.toAttributes(expectedType), conf, addError, colPath, this.reorderColumnsByName$default$7()) : this.resolveColumnsByPosition(tableName, (Seq<NamedExpression>)fields, DataTypeUtils$.MODULE$.toAttributes(expectedType), conf, addError, colPath);
        if (resolved2.length() == expectedType.length()) {
            Expression res;
            CreateNamedStruct struct = CreateStruct$.MODULE$.apply(resolved2);
            Expression x$7 = res = nullCheckedInput.nullable() ? new If(new IsNull(nullCheckedInput), new Literal(null, (DataType)struct.dataType()), struct) : struct;
            String x$8 = expected.name();
            ExprId x$9 = Alias$.MODULE$.apply$default$3(x$7, x$8);
            Seq<String> x$10 = Alias$.MODULE$.apply$default$4(x$7, x$8);
            Option<Metadata> x$11 = Alias$.MODULE$.apply$default$5(x$7, x$8);
            Seq<String> x$12 = Alias$.MODULE$.apply$default$6(x$7, x$8);
            return new Some((Object)new Alias(x$7, x$8, x$9, x$10, x$11, x$12));
        }
        return None$.MODULE$;
    }

    private Option<NamedExpression> resolveArrayType(String tableName, Expression input, ArrayType inputType, Attribute expected, ArrayType expectedType, boolean byName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        Seq<NamedExpression> res;
        Expression nullCheckedInput = this.checkNullability(input, expected, conf, colPath);
        NamedLambdaVariable param = new NamedLambdaVariable("element", inputType.elementType(), inputType.containsNull(), NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        String x$1 = "element";
        DataType x$2 = expectedType.elementType();
        boolean x$3 = expectedType.containsNull();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("element", x$2, x$3, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("element", x$2, x$3, x$4);
        boolean x$7 = AttributeReference$.MODULE$.apply$default$7("element", x$2, x$3, x$4);
        AttributeReference fakeAttr = new AttributeReference("element", x$2, x$3, x$4, x$5, x$6, x$7);
        Seq<NamedExpression> seq = res = byName ? this.reorderColumnsByName(tableName, (Seq<NamedExpression>)new .colon.colon((Object)param, (List)Nil$.MODULE$), (Seq<Attribute>)new .colon.colon((Object)fakeAttr, (List)Nil$.MODULE$), conf, addError, colPath, this.reorderColumnsByName$default$7()) : this.resolveColumnsByPosition(tableName, (Seq<NamedExpression>)new .colon.colon((Object)param, (List)Nil$.MODULE$), (Seq<Attribute>)new .colon.colon((Object)fakeAttr, (List)Nil$.MODULE$), conf, addError, colPath);
        if (res.length() == 1) {
            Object object = res.head();
            NamedLambdaVariable namedLambdaVariable = param;
            if (!(object != null ? !object.equals(namedLambdaVariable) : namedLambdaVariable != null)) {
                Expression x$8 = nullCheckedInput;
                String x$9 = expected.name();
                .colon.colon x$10 = new .colon.colon((Object)CharVarcharUtils$.MODULE$.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY(), (List)Nil$.MODULE$);
                ExprId x$11 = Alias$.MODULE$.apply$default$3(x$8, x$9);
                Seq<String> x$12 = Alias$.MODULE$.apply$default$4(x$8, x$9);
                Option<Metadata> x$13 = Alias$.MODULE$.apply$default$5(x$8, x$9);
                return new Some((Object)new Alias(x$8, x$9, x$11, x$12, x$13, (Seq<String>)x$10));
            }
            LambdaFunction func = new LambdaFunction((Expression)res.head(), (Seq<NamedExpression>)new .colon.colon((Object)param, (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3());
            ArrayTransform x$14 = new ArrayTransform(nullCheckedInput, func);
            String x$15 = expected.name();
            ExprId x$16 = Alias$.MODULE$.apply$default$3(x$14, x$15);
            Seq<String> x$17 = Alias$.MODULE$.apply$default$4(x$14, x$15);
            Option<Metadata> x$18 = Alias$.MODULE$.apply$default$5(x$14, x$15);
            Seq<String> x$19 = Alias$.MODULE$.apply$default$6(x$14, x$15);
            return new Some((Object)new Alias(x$14, x$15, x$16, x$17, x$18, x$19));
        }
        return None$.MODULE$;
    }

    private Option<NamedExpression> resolveMapType(String tableName, Expression input, MapType inputType, Attribute expected, MapType expectedType, boolean byName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        Seq<NamedExpression> resValue;
        Expression nullCheckedInput = this.checkNullability(input, expected, conf, colPath);
        NamedLambdaVariable keyParam = new NamedLambdaVariable("key", inputType.keyType(), false, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        String x$1 = "key";
        DataType x$2 = expectedType.keyType();
        boolean x$3 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("key", x$2, false, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("key", x$2, false, x$4);
        boolean x$7 = AttributeReference$.MODULE$.apply$default$7("key", x$2, false, x$4);
        AttributeReference fakeKeyAttr = new AttributeReference("key", x$2, false, x$4, x$5, x$6, x$7);
        Seq<NamedExpression> resKey = byName ? this.reorderColumnsByName(tableName, (Seq<NamedExpression>)new .colon.colon((Object)keyParam, (List)Nil$.MODULE$), (Seq<Attribute>)new .colon.colon((Object)fakeKeyAttr, (List)Nil$.MODULE$), conf, addError, colPath, this.reorderColumnsByName$default$7()) : this.resolveColumnsByPosition(tableName, (Seq<NamedExpression>)new .colon.colon((Object)keyParam, (List)Nil$.MODULE$), (Seq<Attribute>)new .colon.colon((Object)fakeKeyAttr, (List)Nil$.MODULE$), conf, addError, colPath);
        NamedLambdaVariable valueParam = new NamedLambdaVariable("value", inputType.valueType(), inputType.valueContainsNull(), NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        String x$8 = "value";
        DataType x$9 = expectedType.valueType();
        boolean x$10 = expectedType.valueContainsNull();
        Metadata x$11 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$12 = AttributeReference$.MODULE$.apply$default$5("value", x$9, x$10, x$11);
        Seq<String> x$13 = AttributeReference$.MODULE$.apply$default$6("value", x$9, x$10, x$11);
        boolean x$14 = AttributeReference$.MODULE$.apply$default$7("value", x$9, x$10, x$11);
        AttributeReference fakeValueAttr = new AttributeReference("value", x$9, x$10, x$11, x$12, x$13, x$14);
        Seq<NamedExpression> seq = resValue = byName ? this.reorderColumnsByName(tableName, (Seq<NamedExpression>)new .colon.colon((Object)valueParam, (List)Nil$.MODULE$), (Seq<Attribute>)new .colon.colon((Object)fakeValueAttr, (List)Nil$.MODULE$), conf, addError, colPath, this.reorderColumnsByName$default$7()) : this.resolveColumnsByPosition(tableName, (Seq<NamedExpression>)new .colon.colon((Object)valueParam, (List)Nil$.MODULE$), (Seq<Attribute>)new .colon.colon((Object)fakeValueAttr, (List)Nil$.MODULE$), conf, addError, colPath);
        if (resKey.length() == 1 && resValue.length() == 1) {
            Expression expression;
            Expression expression2;
            Object object = resKey.head();
            NamedLambdaVariable namedLambdaVariable = keyParam;
            if (!(object != null ? !object.equals(namedLambdaVariable) : namedLambdaVariable != null)) {
                Object object2 = resValue.head();
                NamedLambdaVariable namedLambdaVariable2 = valueParam;
                if (!(object2 != null ? !object2.equals(namedLambdaVariable2) : namedLambdaVariable2 != null)) {
                    Expression x$15 = nullCheckedInput;
                    String x$16 = expected.name();
                    .colon.colon x$17 = new .colon.colon((Object)CharVarcharUtils$.MODULE$.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY(), (List)Nil$.MODULE$);
                    ExprId x$18 = Alias$.MODULE$.apply$default$3(x$15, x$16);
                    Seq<String> x$19 = Alias$.MODULE$.apply$default$4(x$15, x$16);
                    Option<Metadata> x$20 = Alias$.MODULE$.apply$default$5(x$15, x$16);
                    return new Some((Object)new Alias(x$15, x$16, x$18, x$19, x$20, (Seq<String>)x$17));
                }
            }
            Object object3 = resKey.head();
            NamedLambdaVariable namedLambdaVariable3 = keyParam;
            if (object3 == null ? namedLambdaVariable3 != null : !object3.equals(namedLambdaVariable3)) {
                LambdaFunction keyFunc = new LambdaFunction((Expression)resKey.head(), (Seq<NamedExpression>)new .colon.colon((Object)keyParam, (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3());
                expression2 = new ArrayTransform(new MapKeys(nullCheckedInput), keyFunc);
            } else {
                expression2 = new MapKeys(nullCheckedInput);
            }
            MapKeys newKeys = expression2;
            Object object4 = resValue.head();
            NamedLambdaVariable namedLambdaVariable4 = valueParam;
            if (object4 == null ? namedLambdaVariable4 != null : !object4.equals(namedLambdaVariable4)) {
                LambdaFunction valueFunc = new LambdaFunction((Expression)resValue.head(), (Seq<NamedExpression>)new .colon.colon((Object)valueParam, (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3());
                expression = new ArrayTransform(new MapValues(nullCheckedInput), valueFunc);
            } else {
                expression = new MapValues(nullCheckedInput);
            }
            MapValues newValues = expression;
            MapFromArrays x$21 = new MapFromArrays(newKeys, newValues);
            String x$22 = expected.name();
            ExprId x$23 = Alias$.MODULE$.apply$default$3(x$21, x$22);
            Seq<String> x$24 = Alias$.MODULE$.apply$default$4(x$21, x$22);
            Option<Metadata> x$25 = Alias$.MODULE$.apply$default$5(x$21, x$22);
            Seq<String> x$26 = Alias$.MODULE$.apply$default$6(x$21, x$22);
            return new Some((Object)new Alias(x$21, x$22, x$23, x$24, x$25, x$26));
        }
        return None$.MODULE$;
    }

    public Expression checkCastOverflowInTableInsert(Cast cast, String columnName) {
        if (this.canCauseCastOverflow(cast)) {
            return new CheckOverflowInTableInsert(cast, columnName);
        }
        return cast;
    }

    public void suitableForByNameCheck(boolean byName, Seq<Attribute> expected, Seq<Attribute> queryOutput) {
        if (!byName && expected.size() == queryOutput.size() && expected.forall((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)queryOutput.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TableOutputResolver$.$anonfun$suitableForByNameCheck$2(e, p))))) && ((IterableOnceOps)expected.zip(queryOutput)).exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)TableOutputResolver$.$anonfun$suitableForByNameCheck$3(e)))) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The query columns and the table columns have same names but different orders. You can use INSERT [INTO | OVERWRITE] BY NAME to reorder the query columns to align with the table columns.");
            return;
        }
    }

    private boolean containsIntegralOrDecimalType(DataType dt) {
        DataType dataType;
        block4: {
            while (true) {
                if ((dataType = dt) instanceof IntegralType ? true : dataType instanceof DecimalType) {
                    return true;
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    dt = arrayType.elementType();
                    continue;
                }
                if (!(dataType instanceof MapType)) break block4;
                MapType mapType = (MapType)dataType;
                if (this.containsIntegralOrDecimalType(mapType.keyType())) break;
                dt = mapType.valueType();
            }
            return true;
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)sf -> BoxesRunTime.boxToBoolean((boolean)TableOutputResolver$.MODULE$.containsIntegralOrDecimalType(sf.dataType())));
        }
        return false;
    }

    private boolean canCauseCastOverflow(Cast cast) {
        return this.containsIntegralOrDecimalType(cast.dataType()) && !Cast$.MODULE$.canUpCast(cast.child().dataType(), cast.dataType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCompatible(Attribute tableAttr, NamedExpression queryExpr) {
        if (!DataTypeUtils$.MODULE$.sameType(tableAttr.dataType(), ((Expression)((Object)queryExpr)).dataType())) return false;
        String string = tableAttr.name();
        String string2 = queryExpr.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Metadata metadata = tableAttr.metadata();
        Metadata metadata2 = queryExpr.metadata();
        if (metadata == null) {
            if (metadata2 == null) return true;
            return false;
        } else {
            if (!metadata.equals(metadata2)) return false;
            return true;
        }
    }

    private Option<NamedExpression> checkField(String tableName, Attribute tableAttr, NamedExpression queryExpr, boolean byName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        LazyRef outputField$lzy = new LazyRef();
        boolean attrTypeHasCharVarchar = CharVarcharUtils$.MODULE$.hasCharVarchar(tableAttr.dataType());
        DataType attrTypeWithoutCharVarchar = attrTypeHasCharVarchar ? CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(tableAttr.dataType()) : tableAttr.dataType();
        boolean canWriteExpr = this.canWrite(tableName, ((Expression)((Object)queryExpr)).dataType(), attrTypeWithoutCharVarchar, byName, conf, addError, colPath);
        if (canWriteExpr) {
            return this.outputField$1(outputField$lzy, tableAttr, queryExpr, conf, colPath, attrTypeWithoutCharVarchar, attrTypeHasCharVarchar);
        }
        return None$.MODULE$;
    }

    private Expression unwrapUDT(Expression expr) {
        DataType dataType = expr.dataType();
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType et = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            NamedLambdaVariable param = new NamedLambdaVariable("element", et, containsNull, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
            LambdaFunction func = new LambdaFunction(this.unwrapUDT(param), (Seq<NamedExpression>)new .colon.colon((Object)param, (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3());
            return new ArrayTransform(expr, func);
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            NamedLambdaVariable keyParam = new NamedLambdaVariable("key", kt, false, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
            NamedLambdaVariable valueParam = new NamedLambdaVariable("value", vt, valueContainsNull, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
            LambdaFunction keyFunc = new LambdaFunction(this.unwrapUDT(keyParam), (Seq<NamedExpression>)new .colon.colon((Object)keyParam, (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3());
            LambdaFunction valueFunc = new LambdaFunction(this.unwrapUDT(valueParam), (Seq<NamedExpression>)new .colon.colon((Object)valueParam, (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3());
            ArrayTransform newKeys = new ArrayTransform(new MapKeys(expr), keyFunc);
            ArrayTransform newValues = new ArrayTransform(new MapValues(expr), valueFunc);
            return new MapFromArrays(newKeys, newValues);
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            IndexedSeq newFieldExprs = structType.indices().map((Function1 & Serializable)i -> TableOutputResolver$.MODULE$.unwrapUDT(new GetStructField(expr, BoxesRunTime.unboxToInt((Object)i), GetStructField$.MODULE$.apply$default$3())));
            CreateNamedStruct struct = new CreateNamedStruct((Seq<Expression>)((Seq)((IterableOps)structType.zip((IterableOnce)newFieldExprs)).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField field = (StructField)tuple2._1();
                    Expression newExpr = (Expression)tuple2._2();
                    return new .colon.colon((Object)Literal$.MODULE$.apply(field.name()), (List)new .colon.colon((Object)newExpr, (List)Nil$.MODULE$));
                }
                throw new MatchError((Object)tuple2);
            })));
            if (expr.nullable()) {
                return new If(new IsNull(expr), new Literal(null, (DataType)struct.dataType()), struct);
            }
            return struct;
        }
        if (dataType instanceof UserDefinedType) {
            return new UnwrapUDT(expr);
        }
        return expr;
    }

    private Expression cast(Expression expr, DataType expectedType, SQLConf conf, String colName) {
        Enumeration.Value value = conf.storeAssignmentPolicy();
        Enumeration.Value value2 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Cast cast = Cast$.MODULE$.apply(expr, expectedType, (Option<String>)Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone()), true);
            cast.setTagValue(Cast$.MODULE$.BY_TABLE_INSERTION(), BoxedUnit.UNIT);
            return this.checkCastOverflowInTableInsert(cast, colName);
        }
        Enumeration.Value value4 = SQLConf$StoreAssignmentPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return Cast$.MODULE$.apply(expr, expectedType, (Option<String>)Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone()), false);
        }
        return new Cast(expr, expectedType, (Option<String>)Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ boolean $anonfun$reorderColumnsByName$2(SQLConf conf$2, Attribute expectedCol$1, NamedExpression col) {
        return BoxesRunTime.unboxToBoolean((Object)conf$2.resolver().apply((Object)col.name(), (Object)expectedCol$1.name()));
    }

    public static final /* synthetic */ boolean $anonfun$suitableForByNameCheck$2(Attribute e$1, Attribute p) {
        return BoxesRunTime.unboxToBoolean((Object)MODULE$.conf().resolver().apply((Object)p.name(), (Object)e$1.name()));
    }

    public static final /* synthetic */ boolean $anonfun$suitableForByNameCheck$3(Tuple2 e) {
        return !BoxesRunTime.unboxToBoolean((Object)MODULE$.conf().resolver().apply((Object)((NamedExpression)e._1()).name(), (Object)((NamedExpression)e._2()).name()));
    }

    private final /* synthetic */ Some outputField$lzycompute$1(LazyRef outputField$lzy$1, Attribute tableAttr$1, NamedExpression queryExpr$1, SQLConf conf$4, Seq colPath$3, DataType attrTypeWithoutCharVarchar$1, boolean attrTypeHasCharVarchar$1) {
        Some some;
        LazyRef lazyRef = outputField$lzy$1;
        synchronized (lazyRef) {
            Some some2;
            if (outputField$lzy$1.initialized()) {
                some2 = (Some)outputField$lzy$1.value();
            } else {
                Some some3;
                if (this.isCompatible(tableAttr$1, queryExpr$1)) {
                    if (this.requiresNullChecks((Expression)((Object)queryExpr$1), tableAttr$1, conf$4)) {
                        AssertNotNull assertNotNull;
                        AssertNotNull x$1 = assertNotNull = new AssertNotNull((Expression)((Object)queryExpr$1), (Seq<String>)colPath$3);
                        String x$2 = tableAttr$1.name();
                        Some x$3 = new Some((Object)tableAttr$1.metadata());
                        ExprId x$4 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                        Seq<String> x$5 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                        Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                        Some some4 = new Some((Object)new Alias(x$1, x$2, x$4, x$5, (Option<Metadata>)x$3, x$6));
                        some3 = some4;
                    } else {
                        some3 = new Some((Object)queryExpr$1);
                    }
                } else {
                    Expression exprWithStrLenCheck;
                    Expression nullCheckedQueryExpr = this.checkNullability((Expression)((Object)queryExpr$1), tableAttr$1, conf$4, (Seq<String>)colPath$3);
                    Expression udtUnwrapped = this.unwrapUDT(nullCheckedQueryExpr);
                    Expression casted = this.cast(udtUnwrapped, attrTypeWithoutCharVarchar$1, conf$4, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper((Seq<String>)colPath$3).quoted());
                    Expression x$7 = exprWithStrLenCheck = conf$4.charVarcharAsString() || !attrTypeHasCharVarchar$1 ? casted : CharVarcharUtils$.MODULE$.stringLengthCheck(casted, tableAttr$1.dataType());
                    String x$8 = tableAttr$1.name();
                    Some x$9 = new Some((Object)tableAttr$1.metadata());
                    ExprId x$10 = Alias$.MODULE$.apply$default$3(x$7, x$8);
                    Seq<String> x$11 = Alias$.MODULE$.apply$default$4(x$7, x$8);
                    Seq<String> x$12 = Alias$.MODULE$.apply$default$6(x$7, x$8);
                    Some some5 = new Some((Object)new Alias(x$7, x$8, x$10, x$11, (Option<Metadata>)x$9, x$12));
                    some3 = some5;
                }
                some2 = (Some)outputField$lzy$1.initialize((Object)some3);
            }
            some = some2;
        }
        return some;
    }

    private final Some outputField$1(LazyRef outputField$lzy$1, Attribute tableAttr$1, NamedExpression queryExpr$1, SQLConf conf$4, Seq colPath$3, DataType attrTypeWithoutCharVarchar$1, boolean attrTypeHasCharVarchar$1) {
        if (outputField$lzy$1.initialized()) {
            return (Some)outputField$lzy$1.value();
        }
        return this.outputField$lzycompute$1(outputField$lzy$1, tableAttr$1, queryExpr$1, conf$4, colPath$3, attrTypeWithoutCharVarchar$1, attrTypeHasCharVarchar$1);
    }

    private TableOutputResolver$() {
    }
}

