/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class OrcFileOperator$
implements Logging {
    public static final OrcFileOperator$ MODULE$ = new OrcFileOperator$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<Reader> getFileReader(String basePath, Option<Configuration> config, boolean ignoreCorruptFiles) {
        Configuration conf = (Configuration)config.getOrElse((Function0 & Serializable)() -> new Configuration());
        Path hdfsPath = new Path(basePath);
        FileSystem fs = hdfsPath.getFileSystem(conf);
        return this.listOrcFiles(basePath, conf).iterator().map((Function1 & Serializable)path -> {
            Some some;
            try {
                some = new Some((Object)OrcFile.createReader((FileSystem)fs, (Path)path));
            }
            catch (IOException e) {
                if (ignoreCorruptFiles) {
                    MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Skipped the footer in the corrupted file: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, path)}))), (Throwable)e);
                    some = None$.MODULE$;
                }
                throw QueryExecutionErrors$.MODULE$.cannotReadFooterForFileError(path, (Exception)e);
            }
            Some reader = some;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(path), (Object)reader);
        }).collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Path, Option<Reader>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Some some;
                    Reader reader;
                    Path path = (Path)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some && OrcFileOperator$.MODULE$.org$apache$spark$sql$hive$orc$OrcFileOperator$$isWithNonEmptySchema$1(path, reader = (Reader)(some = (Some)option).value())) {
                        return (B1)reader;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Path, Option<Reader>> x1) {
                Tuple2<Path, Option<Reader>> tuple2 = x1;
                if (tuple2 != null) {
                    Some some;
                    Reader reader;
                    Path path = (Path)tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (option instanceof Some && OrcFileOperator$.MODULE$.org$apache$spark$sql$hive$orc$OrcFileOperator$$isWithNonEmptySchema$1(path, reader = (Reader)(some = (Some)option).value())) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public Option<Configuration> getFileReader$default$2() {
        return None$.MODULE$;
    }

    public boolean getFileReader$default$3() {
        return false;
    }

    public Option<StructType> readSchema(Seq<String> paths, Option<Configuration> conf, boolean ignoreCorruptFiles) {
        return paths.iterator().map((Function1 & Serializable)x$1 -> MODULE$.getFileReader((String)x$1, conf, ignoreCorruptFiles)).collectFirst((PartialFunction)new Serializable(paths){
            private static final long serialVersionUID = 0L;
            private final Seq paths$1;

            public final <A1 extends Option<Reader>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    Reader reader = (Reader)some.value();
                    StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
                    String schema = readerInspector.getTypeName();
                    OrcFileOperator$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Reading schema from file " + $this.paths$1 + ", got Hive schema string: " + schema);
                    return (B1)((StructType)CatalystSqlParser$.MODULE$.parseDataType(schema));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Option<Reader> x1) {
                Option<Reader> option = x1;
                return option instanceof Some;
            }
            {
                this.paths$1 = paths$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.hive.orc.OrcFileOperator$$anonfun$readSchema$2 java.lang.String )}, serializedLambda);
            }
        });
    }

    public Seq<StructType> readOrcSchemasInParallel(Seq<FileStatus> partFiles, Configuration conf, boolean ignoreCorruptFiles) {
        return (Seq)ThreadUtils$.MODULE$.parmap(partFiles, "readingOrcSchemas", 8, (Function1 & Serializable)currentFile -> {
            String file = currentFile.getPath().toString();
            return MODULE$.getFileReader(file, (Option<Configuration>)new Some((Object)conf), ignoreCorruptFiles).map((Function1 & Serializable)reader -> {
                StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
                String schema = readerInspector.getTypeName();
                MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Reading schema from file " + file + "., got Hive schema string: " + schema);
                return (StructType)CatalystSqlParser$.MODULE$.parseDataType(schema);
            });
        }).flatten(Predef$.MODULE$.$conforms());
    }

    public Option<StructObjectInspector> getObjectInspector(String path, Option<Configuration> conf) {
        return this.getFileReader(path, conf, this.getFileReader$default$3()).map((Function1 & Serializable)x$2 -> (StructObjectInspector)x$2.getObjectInspector());
    }

    public Seq<Path> listOrcFiles(String pathStr, Configuration conf) {
        Path origPath = new Path(pathStr);
        FileSystem fs = origPath.getFileSystem(conf);
        Seq paths = (Seq)((IterableOps)((IterableOps)((IterableOps)SparkHadoopUtil$.MODULE$.get().listLeafStatuses(fs, origPath).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isDirectory()))).map((Function1 & Serializable)x$4 -> x$4.getPath())).filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)OrcFileOperator$.$anonfun$listOrcFiles$3(x$5)))).filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)OrcFileOperator$.$anonfun$listOrcFiles$4(x$6)));
        return paths;
    }

    public final boolean org$apache$spark$sql$hive$orc$OrcFileOperator$$isWithNonEmptySchema$1(Path path, Reader reader) {
        StructObjectInspector structObjectInspector;
        ObjectInspector objectInspector = reader.getObjectInspector();
        if (objectInspector instanceof StructObjectInspector && (structObjectInspector = (StructObjectInspector)objectInspector).getAllStructFieldRefs().size() == 0) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ORC file ", " has empty schema, it probably contains no rows. "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)path)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to read another ORC file to figure out the schema."}))).log((Seq)Nil$.MODULE$))));
            return false;
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$listOrcFiles$3(Path x$5) {
        return x$5.getName().startsWith("_");
    }

    public static final /* synthetic */ boolean $anonfun$listOrcFiles$4(Path x$6) {
        return x$6.getName().startsWith(".");
    }

    private OrcFileOperator$() {
    }
}

