/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.connect.proto.AnalyzePlanRequest;
import org.apache.spark.connect.proto.AnalyzePlanResponse;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.RelationWrapper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.classic.Dataset$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.common.StorageLevelProtoConverter$;
import org.apache.spark.sql.connect.planner.SparkConnectPlanner;
import org.apache.spark.sql.connect.planner.SparkConnectPlanner$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.execution.CodegenMode$;
import org.apache.spark.sql.execution.CostMode$;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.sql.execution.ExtendedMode$;
import org.apache.spark.sql.execution.FormattedMode$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SimpleMode$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.ArrayImplicits$;
import org.slf4j.Logger;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0005\u00054Qa\u0002\u0005\u0001\u0015QA\u0001\"\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\u0006i\u0001!\t!\u000e\u0005\bs\u0001\u0011\r\u0011b\u0001;\u0011\u0019q\u0005\u0001)A\u0005w!)q\n\u0001C\u0001!\")\u0011\f\u0001C\u00015\nQ2\u000b]1sW\u000e{gN\\3di\u0006s\u0017\r\\={K\"\u000bg\u000e\u001a7fe*\u0011\u0011BC\u0001\bg\u0016\u0014h/[2f\u0015\tYA\"A\u0004d_:tWm\u0019;\u000b\u00055q\u0011aA:rY*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xmE\u0002\u0001+m\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u000f\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0011\u001e\u0005\u001daunZ4j]\u001e\f\u0001C]3ta>t7/Z(cg\u0016\u0014h/\u001a:\u0004\u0001A\u0019AeK\u0017\u000e\u0003\u0015R!AJ\u0014\u0002\tM$XO\u0019\u0006\u0003Q%\nAa\u001a:qG*\t!&\u0001\u0002j_&\u0011A&\n\u0002\u000f'R\u0014X-Y7PEN,'O^3s!\tq#'D\u00010\u0015\t\u0001\u0014'A\u0003qe>$xN\u0003\u0002\f\u001d%\u00111g\f\u0002\u0014\u0003:\fG.\u001f>f!2\fgNU3ta>t7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005YB\u0004CA\u001c\u0001\u001b\u0005A\u0001\"B\u0011\u0003\u0001\u0004\u0019\u0013!D<ji\"\u0014V\r\\1uS>t7/F\u0001<!\ra4I\u0012\b\u0003{\u0005\u0003\"AP\f\u000e\u0003}R!\u0001\u0011\u0012\u0002\rq\u0012xn\u001c;?\u0013\t\u0011u#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u00131aU3u\u0015\t\u0011u\u0003\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006A\u0011M\\1msNL7O\u0003\u0002L\u0019\u0005A1-\u0019;bYf\u001cH/\u0003\u0002N\u0011\ny!+\u001a7bi&|gn\u0016:baB,'/\u0001\bxSRD'+\u001a7bi&|gn\u001d\u0011\u0002\r!\fg\u000e\u001a7f)\t\tF\u000b\u0005\u0002\u0017%&\u00111k\u0006\u0002\u0005+:LG\u000fC\u0003V\u000b\u0001\u0007a+A\u0004sKF,Xm\u001d;\u0011\u00059:\u0016B\u0001-0\u0005I\te.\u00197zu\u0016\u0004F.\u00198SKF,Xm\u001d;\u0002\u000fA\u0014xnY3tgR\u0019Qf\u0017/\t\u000bU3\u0001\u0019\u0001,\t\u000bu3\u0001\u0019\u00010\u0002\u001bM,7o]5p]\"{G\u000eZ3s!\t9t,\u0003\u0002a\u0011\ti1+Z:tS>t\u0007j\u001c7eKJ\u0004")
public class SparkConnectAnalyzeHandler
implements Logging {
    private final StreamObserver<AnalyzePlanResponse> responseObserver;
    private final Set<RelationWrapper> withRelations;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Set<RelationWrapper> withRelations() {
        return this.withRelations;
    }

    public void handle(AnalyzePlanRequest request) {
        Some some;
        boolean bl = request.hasClientObservedServerSideSessionId();
        if (bl) {
            some = new Some((Object)request.getClientObservedServerSideSessionId());
        } else if (!bl) {
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        Some previousSessionId = some;
        SessionHolder sessionHolder = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(request.getUserContext().getUserId(), request.getSessionId(), (Option<String>)previousSessionId);
        sessionHolder.withSession((Function1 & Serializable)x$1 -> {
            SparkConnectAnalyzeHandler.$anonfun$handle$1(this, request, sessionHolder, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public AnalyzePlanResponse process(AnalyzePlanRequest request, SessionHolder sessionHolder) {
        LazyRef planner$lzy = new LazyRef();
        SparkSession session = sessionHolder.session();
        AnalyzePlanResponse.Builder builder = AnalyzePlanResponse.newBuilder();
        AnalyzePlanRequest.AnalyzeCase analyzeCase = request.getAnalyzeCase();
        if (AnalyzePlanRequest.AnalyzeCase.SCHEMA.equals(analyzeCase)) {
            StructType schema = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.transformRelation$1(request.getSchema().getPlan().getRoot(), planner$lzy, sessionHolder), this.withRelations()).schema();
            builder.setSchema(AnalyzePlanResponse.Schema.newBuilder().setSchema(DataTypeProtoConverter$.MODULE$.toConnectProtoType((DataType)schema)).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.EXPLAIN.equals(analyzeCase)) {
            String string;
            QueryExecution queryExecution = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.transformRelation$1(request.getExplain().getPlan().getRoot(), planner$lzy, sessionHolder), this.withRelations()).queryExecution();
            AnalyzePlanRequest.Explain.ExplainMode explainMode = request.getExplain().getExplainMode();
            if (AnalyzePlanRequest.Explain.ExplainMode.EXPLAIN_MODE_SIMPLE.equals(explainMode)) {
                string = queryExecution.explainString((ExplainMode)SimpleMode$.MODULE$);
            } else if (AnalyzePlanRequest.Explain.ExplainMode.EXPLAIN_MODE_EXTENDED.equals(explainMode)) {
                string = queryExecution.explainString((ExplainMode)ExtendedMode$.MODULE$);
            } else if (AnalyzePlanRequest.Explain.ExplainMode.EXPLAIN_MODE_CODEGEN.equals(explainMode)) {
                string = queryExecution.explainString((ExplainMode)CodegenMode$.MODULE$);
            } else if (AnalyzePlanRequest.Explain.ExplainMode.EXPLAIN_MODE_COST.equals(explainMode)) {
                string = queryExecution.explainString((ExplainMode)CostMode$.MODULE$);
            } else if (AnalyzePlanRequest.Explain.ExplainMode.EXPLAIN_MODE_FORMATTED.equals(explainMode)) {
                string = queryExecution.explainString((ExplainMode)FormattedMode$.MODULE$);
            } else {
                throw new UnsupportedOperationException("Unknown Explain Mode " + explainMode + "!");
            }
            String explainString = string;
            builder.setExplain(AnalyzePlanResponse.Explain.newBuilder().setExplainString(explainString).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.TREE_STRING.equals(analyzeCase)) {
            StructType schema = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.transformRelation$1(request.getTreeString().getPlan().getRoot(), planner$lzy, sessionHolder), this.withRelations()).schema();
            String treeString = request.getTreeString().hasLevel() ? schema.treeString(request.getTreeString().getLevel()) : schema.treeString();
            builder.setTreeString(AnalyzePlanResponse.TreeString.newBuilder().setTreeString(treeString).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.IS_LOCAL.equals(analyzeCase)) {
            boolean isLocal = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.transformRelation$1(request.getIsLocal().getPlan().getRoot(), planner$lzy, sessionHolder), this.withRelations()).isLocal();
            builder.setIsLocal(AnalyzePlanResponse.IsLocal.newBuilder().setIsLocal(isLocal).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.IS_STREAMING.equals(analyzeCase)) {
            boolean isStreaming = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.transformRelation$1(request.getIsStreaming().getPlan().getRoot(), planner$lzy, sessionHolder), this.withRelations()).isStreaming();
            builder.setIsStreaming(AnalyzePlanResponse.IsStreaming.newBuilder().setIsStreaming(isStreaming).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.INPUT_FILES.equals(analyzeCase)) {
            String[] inputFiles = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.transformRelation$1(request.getInputFiles().getPlan().getRoot(), planner$lzy, sessionHolder), this.withRelations()).inputFiles();
            builder.setInputFiles(AnalyzePlanResponse.InputFiles.newBuilder().addAllFiles(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)inputFiles).toImmutableArraySeq()).asJava()).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.SPARK_VERSION.equals(analyzeCase)) {
            builder.setSparkVersion(AnalyzePlanResponse.SparkVersion.newBuilder().setVersion(session.version()).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.DDL_PARSE.equals(analyzeCase)) {
            DataType schema = SparkConnectAnalyzeHandler.planner$1(planner$lzy, sessionHolder).parseDatatypeString(request.getDdlParse().getDdlString());
            builder.setDdlParse(AnalyzePlanResponse.DDLParse.newBuilder().setParsed(DataTypeProtoConverter$.MODULE$.toConnectProtoType(schema)).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.SAME_SEMANTICS.equals(analyzeCase)) {
            org.apache.spark.sql.classic.Dataset target = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.transformRelation$1(request.getSameSemantics().getTargetPlan().getRoot(), planner$lzy, sessionHolder), this.withRelations());
            org.apache.spark.sql.classic.Dataset other = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.transformRelation$1(request.getSameSemantics().getOtherPlan().getRoot(), planner$lzy, sessionHolder), this.withRelations());
            builder.setSameSemantics(AnalyzePlanResponse.SameSemantics.newBuilder().setResult(target.sameSemantics((Dataset)other)));
        } else if (AnalyzePlanRequest.AnalyzeCase.SEMANTIC_HASH.equals(analyzeCase)) {
            int semanticHash = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.transformRelation$1(request.getSemanticHash().getPlan().getRoot(), planner$lzy, sessionHolder), this.withRelations()).semanticHash();
            builder.setSemanticHash(AnalyzePlanResponse.SemanticHash.newBuilder().setResult(semanticHash));
        } else if (AnalyzePlanRequest.AnalyzeCase.PERSIST.equals(analyzeCase)) {
            org.apache.spark.sql.classic.Dataset target = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.transformRelation$1(request.getPersist().getRelation(), planner$lzy, sessionHolder), this.withRelations());
            org.apache.spark.sql.classic.Dataset dataset = request.getPersist().hasStorageLevel() ? target.persist(StorageLevelProtoConverter$.MODULE$.toStorageLevel(request.getPersist().getStorageLevel())) : target.persist();
            builder.setPersist(AnalyzePlanResponse.Persist.newBuilder().build());
        } else if (AnalyzePlanRequest.AnalyzeCase.UNPERSIST.equals(analyzeCase)) {
            org.apache.spark.sql.classic.Dataset target = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.transformRelation$1(request.getUnpersist().getRelation(), planner$lzy, sessionHolder), this.withRelations());
            org.apache.spark.sql.classic.Dataset dataset = request.getUnpersist().hasBlocking() ? target.unpersist(request.getUnpersist().getBlocking()) : target.unpersist();
            builder.setUnpersist(AnalyzePlanResponse.Unpersist.newBuilder().build());
        } else if (AnalyzePlanRequest.AnalyzeCase.GET_STORAGE_LEVEL.equals(analyzeCase)) {
            org.apache.spark.sql.classic.Dataset target = Dataset$.MODULE$.ofRows(session, SparkConnectAnalyzeHandler.transformRelation$1(request.getGetStorageLevel().getRelation(), planner$lzy, sessionHolder), this.withRelations());
            StorageLevel storageLevel = target.storageLevel();
            builder.setGetStorageLevel(AnalyzePlanResponse.GetStorageLevel.newBuilder().setStorageLevel(StorageLevelProtoConverter$.MODULE$.toConnectProtoType(storageLevel)).build());
        } else if (AnalyzePlanRequest.AnalyzeCase.JSON_TO_DDL.equals(analyzeCase)) {
            String ddl = ((StructType)DataType$.MODULE$.fromJson(request.getJsonToDdl().getJsonString())).toDDL();
            builder.setJsonToDdl(AnalyzePlanResponse.JsonToDDL.newBuilder().setDdlString(ddl).build());
        } else {
            throw new InvalidPlanInput("Unknown Analyze Method " + analyzeCase + "!", InvalidPlanInput$.MODULE$.apply$default$2());
        }
        builder.setSessionId(request.getSessionId()).setServerSideSessionId(sessionHolder.serverSessionId());
        return builder.build();
    }

    public static final /* synthetic */ void $anonfun$handle$1(SparkConnectAnalyzeHandler $this, AnalyzePlanRequest request$1, SessionHolder sessionHolder$1, SparkSession x$1) {
        AnalyzePlanResponse response = $this.process(request$1, sessionHolder$1);
        $this.responseObserver.onNext(response);
        $this.responseObserver.onCompleted();
    }

    private static final /* synthetic */ SparkConnectPlanner planner$lzycompute$1(LazyRef planner$lzy$1, SessionHolder sessionHolder$2) {
        SparkConnectPlanner sparkConnectPlanner;
        LazyRef lazyRef = planner$lzy$1;
        synchronized (lazyRef) {
            sparkConnectPlanner = planner$lzy$1.initialized() ? (SparkConnectPlanner)planner$lzy$1.value() : (SparkConnectPlanner)planner$lzy$1.initialize((Object)new SparkConnectPlanner(sessionHolder$2, SparkConnectPlanner$.MODULE$.$lessinit$greater$default$2()));
        }
        return sparkConnectPlanner;
    }

    private static final SparkConnectPlanner planner$1(LazyRef planner$lzy$1, SessionHolder sessionHolder$2) {
        if (planner$lzy$1.initialized()) {
            return (SparkConnectPlanner)planner$lzy$1.value();
        }
        return SparkConnectAnalyzeHandler.planner$lzycompute$1(planner$lzy$1, sessionHolder$2);
    }

    private static final LogicalPlan transformRelation$1(Relation rel, LazyRef planner$lzy$1, SessionHolder sessionHolder$2) {
        return SparkConnectAnalyzeHandler.planner$1(planner$lzy$1, sessionHolder$2).transformRelation(rel, true);
    }

    public SparkConnectAnalyzeHandler(StreamObserver<AnalyzePlanResponse> responseObserver) {
        this.responseObserver = responseObserver;
        Logging.$init$((Logging)this);
        this.withRelations = Predef$.MODULE$.Set().empty();
    }
}

