/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.JavaTypeInference$;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BinaryEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedBooleanEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedByteEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedDoubleEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedFloatEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedIntEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedLongEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedShortEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$DayTimeIntervalEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$LocalDateTimeEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$PrimitiveBooleanEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$PrimitiveByteEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$PrimitiveDoubleEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$PrimitiveFloatEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$PrimitiveIntEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$PrimitiveLongEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$PrimitiveShortEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$ProductEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$StringEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$YearMonthIntervalEncoder$;
import org.apache.spark.sql.catalyst.encoders.Codec;
import org.apache.spark.sql.catalyst.encoders.JavaSerializationCodec$;
import org.apache.spark.sql.catalyst.encoders.KryoSerializationCodec$;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.reflect.package$;
import scala.runtime.ScalaRunTime$;

public final class Encoders$ {
    public static final Encoders$ MODULE$ = new Encoders$();

    public Encoder<Boolean> BOOLEAN() {
        return AgnosticEncoders$BoxedBooleanEncoder$.MODULE$;
    }

    public Encoder<Byte> BYTE() {
        return AgnosticEncoders$BoxedByteEncoder$.MODULE$;
    }

    public Encoder<Short> SHORT() {
        return AgnosticEncoders$BoxedShortEncoder$.MODULE$;
    }

    public Encoder<Integer> INT() {
        return AgnosticEncoders$BoxedIntEncoder$.MODULE$;
    }

    public Encoder<Long> LONG() {
        return AgnosticEncoders$BoxedLongEncoder$.MODULE$;
    }

    public Encoder<Float> FLOAT() {
        return AgnosticEncoders$BoxedFloatEncoder$.MODULE$;
    }

    public Encoder<Double> DOUBLE() {
        return AgnosticEncoders$BoxedDoubleEncoder$.MODULE$;
    }

    public Encoder<String> CHAR(int length) {
        return new AgnosticEncoders.CharEncoder(length);
    }

    public Encoder<String> VARCHAR(int length) {
        return new AgnosticEncoders.VarcharEncoder(length);
    }

    public Encoder<String> STRING() {
        return AgnosticEncoders$StringEncoder$.MODULE$;
    }

    public Encoder<BigDecimal> DECIMAL() {
        return AgnosticEncoders$.MODULE$.DEFAULT_JAVA_DECIMAL_ENCODER();
    }

    public Encoder<Date> DATE() {
        return AgnosticEncoders$.MODULE$.STRICT_DATE_ENCODER();
    }

    public Encoder<LocalDate> LOCALDATE() {
        return AgnosticEncoders$.MODULE$.STRICT_LOCAL_DATE_ENCODER();
    }

    public Encoder<LocalDateTime> LOCALDATETIME() {
        return AgnosticEncoders$LocalDateTimeEncoder$.MODULE$;
    }

    public Encoder<Timestamp> TIMESTAMP() {
        return AgnosticEncoders$.MODULE$.STRICT_TIMESTAMP_ENCODER();
    }

    public Encoder<Instant> INSTANT() {
        return AgnosticEncoders$.MODULE$.STRICT_INSTANT_ENCODER();
    }

    public Encoder<byte[]> BINARY() {
        return AgnosticEncoders$BinaryEncoder$.MODULE$;
    }

    public Encoder<Duration> DURATION() {
        return AgnosticEncoders$DayTimeIntervalEncoder$.MODULE$;
    }

    public Encoder<Period> PERIOD() {
        return AgnosticEncoders$YearMonthIntervalEncoder$.MODULE$;
    }

    public <T> Encoder<T> bean(Class<T> beanClass) {
        return JavaTypeInference$.MODULE$.encoderFor(beanClass);
    }

    public Encoder<Row> row(StructType schema) {
        return RowEncoder$.MODULE$.encoderFor(schema);
    }

    public <T> Encoder<T> kryo(ClassTag<T> evidence$1) {
        return this.genericSerializer(KryoSerializationCodec$.MODULE$, false, evidence$1);
    }

    public <T> Encoder<T> kryo(boolean nullable, ClassTag<T> evidence$2) {
        return this.genericSerializer(KryoSerializationCodec$.MODULE$, nullable, evidence$2);
    }

    public <T> Encoder<T> kryo(Class<T> clazz) {
        return this.kryo(ClassTag$.MODULE$.apply(clazz));
    }

    public <T> Encoder<T> kryo(Class<T> clazz, boolean nullable) {
        return this.kryo(nullable, ClassTag$.MODULE$.apply(clazz));
    }

    public <T> Encoder<T> javaSerialization(ClassTag<T> evidence$3) {
        return this.genericSerializer(JavaSerializationCodec$.MODULE$, false, evidence$3);
    }

    public <T> Encoder<T> javaSerialization(boolean nullable, ClassTag<T> evidence$4) {
        return this.genericSerializer(JavaSerializationCodec$.MODULE$, nullable, evidence$4);
    }

    public <T> Encoder<T> javaSerialization(Class<T> clazz) {
        return this.javaSerialization(ClassTag$.MODULE$.apply(clazz));
    }

    public <T> Encoder<T> javaSerialization(Class<T> clazz, boolean nullable) {
        return this.javaSerialization(nullable, ClassTag$.MODULE$.apply(clazz));
    }

    private <T> void validatePublicClass(ClassTag<T> evidence$5) {
        if (!Modifier.isPublic(package$.MODULE$.classTag(evidence$5).runtimeClass().getModifiers())) {
            throw ExecutionErrors$.MODULE$.notPublicClassError(package$.MODULE$.classTag(evidence$5).runtimeClass().getName());
        }
    }

    private <T> Encoder<T> genericSerializer(Function0<Codec<Object, byte[]>> provider, boolean nullable, ClassTag<T> evidence$6) {
        if (package$.MODULE$.classTag(evidence$6).runtimeClass().isPrimitive()) {
            throw ExecutionErrors$.MODULE$.primitiveTypesNotSupportedError();
        }
        this.validatePublicClass(evidence$6);
        return new AgnosticEncoders.TransformingEncoder<Object, byte[]>(package$.MODULE$.classTag(evidence$6), AgnosticEncoders$BinaryEncoder$.MODULE$, provider, nullable);
    }

    public <T> Encoder<T> tupleEncoder(Seq<Encoder<?>> encoders) {
        return AgnosticEncoders$ProductEncoder$.MODULE$.tuple((Seq)encoders.map((Function1 & Serializable)x$1 -> AgnosticEncoders$.MODULE$.agnosticEncoderFor(x$1)), AgnosticEncoders$ProductEncoder$.MODULE$.tuple$default$2());
    }

    public <T1> Encoder<T1> tuple(Encoder<T1> e1) {
        return this.tupleEncoder((Seq<Encoder<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Encoder[]{e1}));
    }

    public <T1, T2> Encoder<Tuple2<T1, T2>> tuple(Encoder<T1> e1, Encoder<T2> e2) {
        return this.tupleEncoder((Seq<Encoder<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Encoder[]{e1, e2}));
    }

    public <T1, T2, T3> Encoder<Tuple3<T1, T2, T3>> tuple(Encoder<T1> e1, Encoder<T2> e2, Encoder<T3> e3) {
        return this.tupleEncoder((Seq<Encoder<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Encoder[]{e1, e2, e3}));
    }

    public <T1, T2, T3, T4> Encoder<Tuple4<T1, T2, T3, T4>> tuple(Encoder<T1> e1, Encoder<T2> e2, Encoder<T3> e3, Encoder<T4> e4) {
        return this.tupleEncoder((Seq<Encoder<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Encoder[]{e1, e2, e3, e4}));
    }

    public <T1, T2, T3, T4, T5> Encoder<Tuple5<T1, T2, T3, T4, T5>> tuple(Encoder<T1> e1, Encoder<T2> e2, Encoder<T3> e3, Encoder<T4> e4, Encoder<T5> e5) {
        return this.tupleEncoder((Seq<Encoder<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Encoder[]{e1, e2, e3, e4, e5}));
    }

    public <T extends Product> Encoder<T> product(TypeTags.TypeTag<T> evidence$7) {
        return ScalaReflection$.MODULE$.encoderFor(evidence$7);
    }

    public Encoder<Object> scalaInt() {
        return AgnosticEncoders$PrimitiveIntEncoder$.MODULE$;
    }

    public Encoder<Object> scalaLong() {
        return AgnosticEncoders$PrimitiveLongEncoder$.MODULE$;
    }

    public Encoder<Object> scalaDouble() {
        return AgnosticEncoders$PrimitiveDoubleEncoder$.MODULE$;
    }

    public Encoder<Object> scalaFloat() {
        return AgnosticEncoders$PrimitiveFloatEncoder$.MODULE$;
    }

    public Encoder<Object> scalaByte() {
        return AgnosticEncoders$PrimitiveByteEncoder$.MODULE$;
    }

    public Encoder<Object> scalaShort() {
        return AgnosticEncoders$PrimitiveShortEncoder$.MODULE$;
    }

    public Encoder<Object> scalaBoolean() {
        return AgnosticEncoders$PrimitiveBooleanEncoder$.MODULE$;
    }

    private Encoders$() {
    }
}

